/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.gui.Tools;
import org.languagetool.language.Contributor;

public class AboutDialog {
    private final ResourceBundle messages;
    private final Component parent;

    public AboutDialog(ResourceBundle messages, Component parent) {
        this.messages = messages;
        this.parent = parent;
    }

    public void show() {
        String aboutText = Tools.getLabel(this.messages.getString("guiMenuAbout"));
        JTextPane aboutPane = new JTextPane();
        aboutPane.setBackground(new Color(0, 0, 0, 0));
        aboutPane.setBorder(BorderFactory.createEmptyBorder());
        aboutPane.setContentType("text/html");
        aboutPane.setEditable(false);
        aboutPane.setOpaque(false);
        aboutPane.setText(String.format("<html><p>LanguageTool %s (%s)<br>Copyright (C) 2005-2018 the LanguageTool community and Daniel Naber<br>This software is licensed under the GNU Lesser General Public License.<br><a href=\"https://www.languagetool.org\">https://www.languagetool.org</a><br>Java max/total/free memory: %sMB, %sMB, %sMB</p><p>Maintainers or former maintainers of the language modules -<br>(*) means language is unmaintained in LanguageTool:</p><br></html>", "4.4", JLanguageTool.BUILD_DATE, Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        Tools.addHyperlinkListener(aboutPane);
        JTextPane maintainersPane = new JTextPane();
        maintainersPane.setBackground(new Color(0, 0, 0, 0));
        maintainersPane.setBorder(BorderFactory.createEmptyBorder());
        maintainersPane.setContentType("text/html");
        maintainersPane.setEditable(false);
        maintainersPane.setOpaque(false);
        maintainersPane.setText(this.getMaintainers());
        int prefWidth = Math.max(520, maintainersPane.getPreferredSize().width);
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
        maxHeight = Math.min(maintainersPane.getPreferredSize().height, maxHeight);
        maintainersPane.setPreferredSize(new Dimension(prefWidth, maxHeight));
        JScrollPane scrollPane = new JScrollPane(maintainersPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(aboutPane);
        panel.add(scrollPane);
        JOptionPane.showMessageDialog(this.parent, panel, aboutText, 1);
    }

    private String getMaintainers() {
        TreeMap<String, Language> list = new TreeMap<String, Language>();
        for (Language lang : Languages.get()) {
            if (lang.isVariant() || lang.getMaintainers() == null) continue;
            list.put(this.messages.getString(lang.getShortCode()), lang);
        }
        StringBuilder str = new StringBuilder();
        str.append("<table border=0 cellspacing=0 cellpadding=0>");
        for (Map.Entry entry : list.entrySet()) {
            str.append("<tr valign=\"top\"><td>");
            str.append((String)entry.getKey());
            if (((Language)entry.getValue()).getMaintainedState() == LanguageMaintainedState.LookingForNewMaintainer) {
                str.append("(*)");
            }
            str.append(":</td>");
            str.append("<td>&nbsp;</td>");
            str.append("<td>");
            int i = 0;
            Contributor[] maintainers = ((Language)list.get(entry.getKey())).getMaintainers();
            if (maintainers != null) {
                for (Contributor contributor : maintainers) {
                    if (i > 0) {
                        str.append(", ");
                        if (i % 3 == 0) {
                            str.append("<br>");
                        }
                    }
                    str.append(contributor.getName());
                    ++i;
                }
            }
            str.append("</td></tr>");
        }
        str.append("</table>");
        return str.toString();
    }
}

