/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.codegen.CodeWriter;
import jadx.core.codegen.MethodGen;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import java.io.File;
import java.util.HashSet;
import java.util.List;

public class DotGraphVisitor
extends AbstractVisitor {
    private static final String NL = "\\l";
    private static final boolean PRINT_DOMINATORS = false;
    private final boolean useRegions;
    private final boolean rawInsn;

    public static DotGraphVisitor dump() {
        return new DotGraphVisitor(false, false);
    }

    public static DotGraphVisitor dumpRaw() {
        return new DotGraphVisitor(false, true);
    }

    public static DotGraphVisitor dumpRegions() {
        return new DotGraphVisitor(true, false);
    }

    public static DotGraphVisitor dumpRawRegions() {
        return new DotGraphVisitor(true, true);
    }

    private DotGraphVisitor(boolean useRegions, boolean rawInsn) {
        this.useRegions = useRegions;
        this.rawInsn = rawInsn;
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        File outRootDir = mth.root().getArgs().getOutDir();
        new DumpDotGraph(outRootDir).process(mth);
    }

    public void save(File dir, MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        new DumpDotGraph(dir).process(mth);
    }

    private class DumpDotGraph {
        private final CodeWriter dot = new CodeWriter();
        private final CodeWriter conn = new CodeWriter();
        private final File dir;

        public DumpDotGraph(File dir) {
            this.dir = dir;
        }

        public void process(MethodNode mth) {
            this.dot.startLine("digraph \"CFG for");
            this.dot.add(this.escape(mth.getParentClass() + "." + mth.getMethodInfo().getShortId()));
            this.dot.add("\" {");
            if (DotGraphVisitor.this.useRegions) {
                if (mth.getRegion() == null) {
                    return;
                }
                this.processMethodRegion(mth);
            } else {
                for (BlockNode block : mth.getBasicBlocks()) {
                    this.processBlock(mth, block, false);
                }
            }
            this.dot.startLine("MethodNode[shape=record,label=\"{");
            this.dot.add(this.escape(mth.getAccessFlags().makeString()));
            this.dot.add(this.escape(mth.getReturnType() + " " + mth.getParentClass() + "." + mth.getName() + "(" + Utils.listToString(mth.getArguments(true)) + ") "));
            String attrs = this.attributesString(mth);
            if (!attrs.isEmpty()) {
                this.dot.add(" | ").add(attrs);
            }
            this.dot.add("}\"];");
            this.dot.startLine("MethodNode -> ").add(this.makeName(mth.getEnterBlock())).add(';');
            this.dot.add(this.conn.toString());
            this.dot.startLine('}');
            this.dot.startLine();
            String fileName = StringUtils.escape(mth.getMethodInfo().getShortId()) + (DotGraphVisitor.this.useRegions ? ".regions" : "") + (DotGraphVisitor.this.rawInsn ? ".raw" : "") + ".dot";
            this.dot.save(this.dir, mth.getParentClass().getClassInfo().getFullPath() + "_graphs", fileName);
        }

        private void processMethodRegion(MethodNode mth) {
            this.processRegion(mth, mth.getRegion());
            for (ExceptionHandler h : mth.getExceptionHandlers()) {
                if (h.getHandlerRegion() == null) continue;
                this.processRegion(mth, h.getHandlerRegion());
            }
            HashSet<IBlock> regionsBlocks = new HashSet<IBlock>(mth.getBasicBlocks().size());
            RegionUtils.getAllRegionBlocks(mth.getRegion(), regionsBlocks);
            for (ExceptionHandler handler : mth.getExceptionHandlers()) {
                IContainer handlerRegion = handler.getHandlerRegion();
                if (handlerRegion == null) continue;
                RegionUtils.getAllRegionBlocks(handlerRegion, regionsBlocks);
            }
            for (BlockNode block : mth.getBasicBlocks()) {
                if (regionsBlocks.contains(block)) continue;
                this.processBlock(mth, block, true);
            }
        }

        private void processRegion(MethodNode mth, IContainer region) {
            if (region instanceof IRegion) {
                IRegion r = (IRegion)region;
                this.dot.startLine("subgraph " + this.makeName(region) + " {");
                this.dot.startLine("label = \"").add(r.toString());
                String attrs = this.attributesString(r);
                if (!attrs.isEmpty()) {
                    this.dot.add(" | ").add(attrs);
                }
                this.dot.add("\";");
                this.dot.startLine("node [shape=record,color=blue];");
                for (IContainer c : r.getSubBlocks()) {
                    this.processRegion(mth, c);
                }
                this.dot.startLine('}');
            } else if (region instanceof BlockNode) {
                this.processBlock(mth, (BlockNode)region, false);
            } else if (region instanceof IBlock) {
                this.processIBlock(mth, (IBlock)region, false);
            }
        }

        private void processBlock(MethodNode mth, BlockNode block, boolean error) {
            String insns;
            String attrs = this.attributesString(block);
            this.dot.startLine(this.makeName(block));
            this.dot.add(" [shape=record,");
            if (error) {
                this.dot.add("color=red,");
            }
            this.dot.add("label=\"{");
            this.dot.add(String.valueOf(block.getId())).add("\\:\\ ");
            this.dot.add(InsnUtils.formatOffset(block.getStartOffset()));
            if (!attrs.isEmpty()) {
                this.dot.add('|').add(attrs);
            }
            if (!(insns = this.insertInsns(mth, block)).isEmpty()) {
                this.dot.add('|').add(insns);
            }
            this.dot.add("}\"];");
            BlockNode falsePath = null;
            List<InsnNode> list = block.getInstructions();
            if (!list.isEmpty() && list.get(0).getType() == InsnType.IF) {
                falsePath = ((IfNode)list.get(0)).getElseBlock();
            }
            for (BlockNode next : block.getSuccessors()) {
                String style = next == falsePath ? "[style=dashed]" : "";
                this.addEdge(block, next, style);
            }
        }

        private void processIBlock(MethodNode mth, IBlock block, boolean error) {
            String insns;
            String attrs = this.attributesString(block);
            this.dot.startLine(this.makeName(block));
            this.dot.add(" [shape=record,");
            if (error) {
                this.dot.add("color=red,");
            }
            this.dot.add("label=\"{");
            if (!attrs.isEmpty()) {
                this.dot.add(attrs);
            }
            if (!(insns = this.insertInsns(mth, block)).isEmpty()) {
                this.dot.add('|').add(insns);
            }
            this.dot.add("}\"];");
        }

        private void addEdge(BlockNode from, BlockNode to, String style) {
            this.conn.startLine(this.makeName(from)).add(" -> ").add(this.makeName(to));
            this.conn.add(style);
            this.conn.add(';');
        }

        private String attributesString(IAttributeNode block) {
            StringBuilder attrs = new StringBuilder();
            for (String attr : block.getAttributesStringsList()) {
                attrs.append(this.escape(attr)).append(DotGraphVisitor.NL);
            }
            return attrs.toString();
        }

        private String makeName(IContainer c) {
            String name = c instanceof BlockNode ? "Node_" + ((BlockNode)c).getId() : (c instanceof IBlock ? "Node_" + c.getClass().getSimpleName() + "_" + c.hashCode() : "cluster_" + c.getClass().getSimpleName() + "_" + c.hashCode());
            return name;
        }

        private String insertInsns(MethodNode mth, IBlock block) {
            if (DotGraphVisitor.this.rawInsn) {
                StringBuilder str = new StringBuilder();
                for (InsnNode insn : block.getInstructions()) {
                    str.append(this.escape(insn + " " + insn.getAttributesString()));
                    str.append(DotGraphVisitor.NL);
                }
                return str.toString();
            }
            CodeWriter code = new CodeWriter();
            List<InsnNode> instructions = block.getInstructions();
            MethodGen.addFallbackInsns(code, mth, instructions.toArray(new InsnNode[0]), false);
            String str = this.escape(code.newLine().toString());
            if (str.startsWith(DotGraphVisitor.NL)) {
                str = str.substring(DotGraphVisitor.NL.length());
            }
            return str;
        }

        private String escape(String string) {
            return string.replace("\\", "").replace("/", "\\/").replace(">", "\\>").replace("<", "\\<").replace("{", "\\{").replace("}", "\\}").replace("\"", "\\\"").replace("-", "\\-").replace("|", "\\|").replace("\n", DotGraphVisitor.NL);
        }
    }
}

