#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger-web
version: 1.14.1
id: hledger-web-1.14.1-GkI2cWuWqDgBtecrDcgrPw
key: hledger-web-1.14.1-GkI2cWuWqDgBtecrDcgrPw
license: GPL-3.0-only
maintainer: Simon Michael <simon@joyful.com>
author: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Web interface for the hledger accounting tool
description:
    This is hledger'\''s web interface.
    It provides a more user-friendly and collaborative UI than the
    command-line or curses-style interfaces.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance
abi: e29c4c3de86d35084b3166f77912434d
exposed: True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Json Hledger.Web.Main
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common
hidden-modules: Paths_hledger_web
import-dirs: /usr/lib/ghc-8.6.4/site-local/hledger-web-1.14.1
library-dirs: /usr/lib/ghc-8.6.4/site-local/hledger-web-1.14.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger-web
hs-libraries: HShledger-web-1.14.1-GkI2cWuWqDgBtecrDcgrPw
depends:
    Decimal-0.5.1-HbE7jjGKIya5lM4gHWrRW6
    aeson-1.4.2.0-QHLwhPMHVB663aXnGqoMq base-4.12.0.0
    blaze-html-0.9.1.1-A8LR7w4yS96GtRVO7i7OSl
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    case-insensitive-1.2.0.11-F6T6GvbsLJXGLQlCHITWZu
    clientsession-0.9.1.2-38NHrIsylOx2AXJejwSg9m
    cmdargs-0.10.20-HFOpHQTj4XE8aEWjoI1u1
    conduit-1.3.1.1-DBoWDvZgddMAQw9hEqn0dn
    conduit-extra-1.3.1.1-7ZxQ6ZiVjNd8QNBRTp16o containers-0.6.0.1
    data-default-0.7.1.1-3C0tdSCD1lzIk8WkrvBOoZ directory-1.3.3.0
    filepath-1.4.2.1 hjsmin-0.2.0.2-EavLvoT0jfd25LMHcIIpPL
    hledger-1.14.2-H726qvmREPeBzPDWHdFXEj
    hledger-lib-1.14.1-Ist7qQN3gJrJFEYZZ9dwqC
    http-client-0.6.2-LkdikXUur819X7odXhCFpW
    http-conduit-2.3.6.1-43XVo3zLGlTrnqepG7I3G
    http-types-0.12.3-IdIFkPvozmRFdXetXaEgxE
    json-0.9.3-GMBm0GlRjL45CY2W2ruX29
    megaparsec-7.0.4-1MZB8g6cytp9p69U9RRMNX mtl-2.2.2
    shakespeare-2.0.20-HGOdh5b05246nnepQx2QOU template-haskell-2.14.0.0
    text-1.2.3.1 time-1.8.0.2 transformers-0.5.6.2
    wai-3.2.2-6o6QSnPVpAu2Kn1dd7YFx6
    wai-extra-3.0.25-IsDgUnfuYTiFWiwcMNkzYY
    wai-handler-launch-3.0.2.4-9riCmND3moW848vF7SytbH
    warp-3.2.26-Bx7WYgZjkZlGA81w8oh8Il
    yaml-0.11.0.0-4zycI8uHbweAy6lJfUYfy5
    yesod-1.6.0-AoQ8iStplbNEYvnwFWwOdL
    yesod-core-1.6.13-HZkRl6TdT8bFjdIb5k63N
    yesod-form-1.6.4-6d0tgzV8q1BJUT4JArqqrw
    yesod-static-1.6.0.1-9jUjLxKKOYuBHcXyNdPQIf
haddock-interfaces: /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html: /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

