#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: semigroupoids
version: 5.3.2
id: semigroupoids-5.3.2-lJuIn7iVWXJJzZoPYyt6n
key: semigroupoids-5.3.2-lJuIn7iVWXJJzZoPYyt6n
license: BSD-3-Clause
copyright: Copyright (C) 2011-2015 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
author: Edward A. Kmett
stability: provisional
homepage: http://github.com/ekmett/semigroupoids
synopsis: Semigroupoids: Category sans id
description:
    Provides a wide array of (semi)groupoids and operations for working with them.
    .
    A '\''Semigroupoid'\'' is a '\''Category'\'' without the requirement of identity arrows for every object in the category.
    .
    A '\''Category'\'' is any '\''Semigroupoid'\'' for which the Yoneda lemma holds.
    .
    When working with comonads you often have the @\<*\>@ portion of an @Applicative@, but
    not the @pure@. This was captured in Uustalu and Vene'\''s \"Essence of Dataflow Programming\"
    in the form of the @ComonadZip@ class in the days before @Applicative@. Apply provides a weaker invariant, but for the comonads used for data flow programming (found in the streams package), this invariant is preserved. Applicative function composition forms a semigroupoid.
    .
    Similarly many structures are nearly a comonad, but not quite, for instance lists provide a reasonable '\''extend'\'' operation in the form of '\''tails'\'', but do not always contain a value.
    .
    Ideally the following relationships would hold:
    .
    > Foldable ----> Traversable <--- Functor ------> Alt ---------> Plus           Semigroupoid
    >      |               |            |                              |                  |
    >      v               v            v                              v                  v
    > Foldable1 ---> Traversable1     Apply --------> Applicative -> Alternative      Category
    >                                   |               |              |                  |
    >                                   v               v              v                  v
    >                                 Bind ---------> Monad -------> MonadPlus          Arrow
    >
    .
    Apply, Bind, and Extend (not shown) give rise the Static, Kleisli and Cokleisli semigroupoids respectively.
    .
    This lets us remove many of the restrictions from various monad transformers
    as in many cases the binding operation or @\<*\>@ operation does not require them.
    .
    Finally, to work with these weaker structures it is beneficial to have containers
    that can provide stronger guarantees about their contents, so versions of '\''Traversable'\''
    and '\''Foldable'\'' that can be folded with just a '\''Semigroup'\'' are added.
category: Control, Comonads
abi: 3db80ed2294b6072179f50ccb62041fe
exposed: True
exposed-modules:
    Data.Bifunctor.Apply Data.Functor.Alt Data.Functor.Apply
    Data.Functor.Bind Data.Functor.Bind.Class Data.Functor.Bind.Trans
    Data.Functor.Extend Data.Functor.Plus Data.Groupoid
    Data.Isomorphism Data.Semigroup.Bifoldable
    Data.Semigroup.Bitraversable Data.Semigroup.Foldable
    Data.Semigroup.Foldable.Class Data.Semigroup.Traversable
    Data.Semigroup.Traversable.Class Data.Semigroupoid
    Data.Semigroupoid.Dual Data.Semigroupoid.Ob
    Data.Semigroupoid.Static Data.Traversable.Instances
import-dirs: /usr/lib/ghc-8.6.4/site-local/semigroupoids-5.3.2
library-dirs: /usr/lib/ghc-8.6.4/site-local/semigroupoids-5.3.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/semigroupoids-5.3.2
hs-libraries: HSsemigroupoids-5.3.2-lJuIn7iVWXJJzZoPYyt6n
depends:
    base-4.12.0.0 base-orphans-0.8-3qkwKrVzBSN1odhlyV1Iin
    bifunctors-5.5.3-Cz8QKXqmq1rD1aXJCOzAke
    comonad-5.0.4-3U3AOBIOmSp8ZoIXbLLva1 containers-0.6.0.1
    contravariant-1.5-6YjeCNapF4KLECQA4h7stV
    distributive-0.6-ITkLPttcYbr1PPqTIrNyJS
    hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP template-haskell-2.14.0.0
    transformers-0.5.6.2
    transformers-compat-0.6.2-IT1pgM4Lod5B9rerVXsOk7
    unordered-containers-0.2.10.0-5bnYBnE7Vkj9Kd62fWith8
haddock-interfaces: /usr/share/doc/haskell-semigroupoids/html/semigroupoids.haddock
haddock-html: /usr/share/doc/haskell-semigroupoids/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

