/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.build.BuildStateRegistry;

public class DefaultProjectFinder
implements ProjectFinder {
    private final BuildStateRegistry buildStateRegistry;
    private final Supplier<ProjectInternal> baseProjectSupplier;

    public DefaultProjectFinder(BuildStateRegistry buildStateRegistry, Supplier<ProjectInternal> baseProjectSupplier) {
        this.buildStateRegistry = buildStateRegistry;
        this.baseProjectSupplier = baseProjectSupplier;
    }

    @Override
    public ProjectInternal getProject(String path) {
        return this.baseProjectSupplier.get().project(path);
    }

    @Override
    public ProjectInternal findProject(String path) {
        return this.baseProjectSupplier.get().findProject(path);
    }

    @Override
    @Nullable
    public ProjectInternal findProject(BuildIdentifier build, String path) {
        if (build.isCurrentBuild()) {
            return this.findProject(path);
        }
        GradleInternal gradle = this.buildStateRegistry.getIncludedBuild(build).getConfiguredBuild();
        return gradle.getRootProject().findProject(path);
    }
}

