#############################################################################
##
#W  orbitlengths.g              GAP4 Package `RCWA'               Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of orbit
##  lengths of finite groups on shortest respected partitions.
##
##  The list 'orbitlengths' below satisfies
##
##  orbitlengths[i] = AsSortedList(List(Orbits(grps[i],
##                                             RespectedPartition(grps[i])),
##                                      Length))
##
##  for all i in [1..52394] such that grps[i] is finite.
##
#############################################################################

local  orbitlengthsset, orbitlengthspos;

orbitlengthsset :=
[fail,[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
 2,2,2,2,3,3,3,3,4,4],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,
 4,6,6,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
 4,4,4,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,
 4,5,5,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,
 8,10],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,5,5,
 7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,4,4,4,6,6,
 10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,
 3,4,4,4,4,4,4],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,6,6,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,5,
 5,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,9,9,10],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,
 4,4,4,4],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,
 5,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,6,6,
 10],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,
 4,5,5,5,5],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,6,6,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,5,5,5,5,
 7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
 4,4,4,4],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,
 7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,5,5,
 6,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,
 5,5],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,8,9,9],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,5,6,6,12],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,6,6,6,8,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,8,8,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,6,6,6,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,5,5,6,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,
 12],[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,
 8,10],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,6,6,8,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,6,6,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,5,5,6,6,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,5,5,6,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,5,5,6,6,6,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,5,5,8],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,
 4,6,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,4,5,5,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,7,7,7,7],
[1,1,1,1,1,1,1,1,1,1,1,1,2,2,4,4,4,4,4,4,5,5,
 10],[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,4,4,
 4,4,6,6],
[1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,4,5,5],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,
 3,4,4,5,5,5,5,5,6,6,6,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
 4,5,5,5,5,6,6,6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,4,
 5,5,5,6,6,6,6,7,7,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,4,4,
 4,5,5,5,6,6,6,7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,4,5,9,
 9,10,10,10,10,10,11,11,11,11,12],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,4,
 4,5,5,5,5,6,6,6,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,
 4,4,5,5,5,5,5,6,6,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,5,
 5,6,6,6,7,8,9,9,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,
 5,5,6,6,6,7,7,9,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,5,5,5,6,
 7,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,5,5,6,6,
 6,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,
 4,4,4,4,4,5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,
 4,4,4,4,4,5,5,5,5],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,
 4,4,4,4,5,5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,
 4,4,4,4,5,5,5,5,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,
 5,8,8,9,9,9,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,
 5,6,6,6,6,7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,6,7,
 7,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,5,5,6,
 6,6,7,7,7,8,8,9,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,5,5,5,6,
 6,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,5,6,6,6,
 7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,4,4,5,5,
 6,7,7,7,8,8,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,5,5,5,6,
 6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,
 4,4,4,4,4,4,5,5,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,
 4,4,4,4,4,4,4,5,5],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,
 4,4,4,5,5,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,6,
 6,6,7,7,7,8,12,13],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,6,7,
 7,8,9,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,5,5,
 6,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,6,6,
 6,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,5,6,
 6,6,6,7,7,7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,6,7,
 7,7,8,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,6,8,8,9,
 10],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,
 5,5,5,6,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,
 6,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,
 5,6,6,7,7,8,11,12],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,5,5,
 5,6,6,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,5,6,
 6,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,5,6,6,
 7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,5,5,6,
 8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,5,6,6,
 7,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,6,7,9,
 11],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,5,5,
 7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,
 5,5,6,6,6,7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,5,5,5,6,6,7,7,8,
 11,11],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,4,5,5,5,
 5,5,5,6,6,6,6,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,
 4,4,5,5,5,5,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,
 5,5,6,6,6,6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,4,5,6,
 6,7,8,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,4,5,5,5,
 7,7,7,9],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,5,6,6,
 6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,4,5,5,6,6,
 7,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,
 5,5,5,6,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,5,
 6,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,4,5,6,
 6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,
 6,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,5,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,6,8,8,9,10,
 11],[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,
 4,4,5,5,5,5,5,6,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,
 5,5,6,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,
 5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,8,8,8,
 8,10,10,13,15],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,7,7,7,8,
 9,10,10,11,12,13],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,
 5,5,5,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,4,4,5,5,6,7,7,7,7,
 10,11],
[1,1,1,1,1,1,1,1,1,2,2,2,2,2,4,5,5,6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,
 4,5,5,5,6,7,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,
 4,5,5,6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,6,6,
 6,6,8,8],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
 4,5,5,5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
 5,5,5,5,5,6,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,
 5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,
 5,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,6,6,
 6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,
 5,5,5,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,6,6],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,7,9,9,10,
 11,14,14,16,17,17,21,24],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,6,6,6,7,7,7,8,
 9,9,10,10,11,11],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,6,7,
 7,9,10],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,7,7,
 8,9,10,11,12],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,6,6,7,7,9,11,
 11,12,18,18,19,20,20,21],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,7,8,8,9,9,9,
 9,10,11,11,12,13,13,14,15,15,16],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,4,8,10,15,16,17,19]
,[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,5,5,7,13,16,17,
 20],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,6,8,8,10,11,11,17],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,7,7,9,11,
 11,12,18,18,19,20,20,21],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,6,7,9,11,
 12,12,13,13,14,15,15,16],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,6,6,8,8,9,
 9,10,10,12,12,12,13],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,4,6,6,9,10,12,13,15],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,5,6,6,7,8,15,16,19],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,7,8,8,9,10,10,11,13],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,5,7,9,10,12,16,18],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,4,6,6,8,11,13,13,17],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,5,5,6,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,5,6,6,9,9,9,10,14],
[1,1,1,1,1,1,1,1,1,2,2,2,2,3,4,6,6,7,9,9,10,11,13],
[1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,5,6,6,7,8,8,8,
 8,8,9,9,10,10,11],
[1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,5,6,6,7,8,9,12,15],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,
 4,4,4,5,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,
 4,4,4,4,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,
 5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,
 5,6,6,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,5,6,6],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,5,5,5,6,6,6,6,
 7,7,7,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,6,6,7,10,
 11,15,15,16],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,13,16,16,20],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,4,6,10,11,14,20,21]
,[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,7,7,7,
 7,7,7,8,8,9,9],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,6,6,7,8,10,
 10,10,11,12,15,15,16],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,5,7,9,9,9,
 9,10,10,11,11,11,11,12,12,12,14],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,9,10,10,11,
 11,11,12,13,13],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,6,6,7,8,10,
 10,10,11,11,12,12,13,15],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,6,6,6,6,7,7,
 9,9,10,10,10,10],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,6,6,6,6,7,7,
 7,7,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,6,6,8,8,8,9,
 10,10,10,11,11,11,12,12],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,7,7,7,14,16],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,5,6,7,8,8,9,12,15],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,6,7,7,8,
 8,8,8,10,10,13,15],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,6,6,6,6,7,7,
 8,8,11,11,11,12,13],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,6,8,8,18,18],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,7,8,
 9,9,10,10,12,12,13],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,4,6,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,5,5,7,7,7,11,
 11,12,12,12,13,14,14,15],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,7,7],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,6,7,9,12,17,20],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,7,8,9,10,12,12],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,5,7,9,9,10,10,11],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,4,6,8,8,10,10,11,12],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,5,5,7,8,9,10,13,16],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,7,8,9,9,11,12],
[1,1,1,1,1,1,1,1,1,2,2,2,3,3,4,6,6,7,8,9,12,15,18],
[1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,4,4,4,5,5,5,6,6,6,
 7,7,7,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,5,6,7,7,10,10,19,20],
[1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,5,6,7,9,10,10,10,18],
[1,1,1,1,1,1,1,1,1,2,2,2,3,4,4,6,6,7,7,8,8,9,13],
[1,1,1,1,1,1,1,1,1,2,2,2,4,4,4,4,5,5,5,6,6,6,6,7,
 7,7,8,9,9,10,10],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,5,5,6,6,6,
 6,7,7,7],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,4,5,6],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,4,5,6,6,7,
 9,9],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,5,5,6,6,6,7,
 7,8],[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,13,14,
 18,25,26],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,5,5,6,6,
 6,6,7,7,7,8],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,4,4,4,5,5,6,6,6,7,
 7,7],[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,5,5,6,6,6,
 7,7,7,8,8,9],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,8,8,8,9,
 10,12,12,13],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,5,6,7,7,8,8,
 8,10,10,12],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,7,7,8,8,9,
 9,10,10,11],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,7,8,8,8,9,
 9,9,9,10],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,8,8,9,16,17],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,4,5,6,7,7,12,12,16],
[1,1,1,1,1,1,1,1,1,2,2,3,3,3,4,5,5,5,5,6,7],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,4,5,6,6,7,
 7,7],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,4,4,5,5,5,6,6,
 7,7],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,4,5,6,6,6,7,9,9,
 9,9,10,10],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,4,5,5,6,7,8,9,9,9,
 9,10,10,11],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,6,9,9,11,13],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,4,6,7,7,7,7,8,9,14],
[1,1,1,1,1,1,1,1,1,2,2,3,3,4,7],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,4,4,4,4,5,6,6,7,
 9,9,9,10,10,11,12],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,4,4,5,5,5,5,6,6,7,
 7,8,8,8,8,10,11],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,5,7,10,12,14,17,18,
 24,25,26,27,27,29],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,6,6,7,7,11,11,12,14],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,4,7,8,10,11,12,15,16,
 16,17,18,19,24,26],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,5,6,7,7,9,12,16],
[1,1,1,1,1,1,1,1,1,2,2,3,4,4,5,5,6,7,8,11,12,12,14],
[1,1,1,1,1,1,1,1,1,2,2,3,4,5,6,6,6,6,7,8,8,10,11],
[1,1,1,1,1,1,1,1,1,2,2,4,4,5,5,5,5,5,5,6,6,6,6,6,
 7,10,10,11],
[1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,4,4,4,5,6,6,6,6,
 7,8],
[1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,4,4,4,4,4,4,5,5,5,
 5,5,5,6],
[1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,4,5,6,6,6,7,7,7,8,
 9,10,10,10],
[1,1,1,1,1,1,1,1,1,2,3,3,3,4,4,5,6,6,6,6,7,7,7,8,
 8,9,9,9],[1,1,1,1,1,1,1,1,1,2,3,3,4,4,5],
[1,1,1,1,1,1,1,1,1,2,3,3,4,6,9,11,14,14,15,18,28],
[1,1,1,1,1,1,1,1,1,2,3,4,4,4,4],
[1,1,1,1,1,1,1,1,1,2,3,4,4,4,4,4,5,5,5,5,6,6,7,8,
 8,8,9,9],
[1,1,1,1,1,1,1,1,1,2,3,4,4,4,5,5,5,5,5,5,6,6,6,6,
 7,12,12,14],
[1,1,1,1,1,1,1,1,1,2,3,4,4,4,5,7,8,13,15,18,28],
[1,1,1,1,1,1,1,1,1,2,3,4,4,5,6,7,8,9,11,14,17,18,21,
 23,24,25,26,27],
[1,1,1,1,1,1,1,1,1,2,3,4,4,5,7,13,15,18,22,22,26],
[1,1,1,1,1,1,1,1,1,2,3,4,4,8],
[1,1,1,1,1,1,1,1,1,2,3,4,5,5,9,10,11,12,12,12,12,12,
 13,13,15,16],
[1,1,1,1,1,1,1,1,1,2,3,4,5,6,7,7,8,8,9,10,10,10,11,
 13,13,15,18],[1,1,1,1,1,1,1,1,1,2,3,4,5,7],
[1,1,1,1,1,1,1,1,1,2,3,4,5,7,14,14,15,16,17,18,19],
[1,1,1,1,1,1,1,1,1,2,3,4,6,7,8,9,12,12,12,14,14],
[1,1,1,1,1,1,1,1,1,2,3,4,8,10,10,11,12,12,13,13,18],
[1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,5,5,6,6,7,8,10,14],
[1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,6,6,6,6,7,7,7,11],
[1,1,1,1,1,1,1,1,1,2,4,4,5,5,8,13,16,17,17,19,24],
[1,1,1,1,1,1,1,1,1,2,4,4,5,6,6,8,8,8,11,11,14,16,18,
 25,30,32],
[1,1,1,1,1,1,1,1,1,2,4,7,8,8,8,9,10,11,14,14,18],
[1,1,1,1,1,1,1,1,1,3,4,4,5,5],
[1,1,1,1,1,1,1,1,1,4,4,4,4,5],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,4,4,4,4,5,5,5,
 5,5,6,8,9,11],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,5,5,6,6,
 6,6,6,7,9,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,5,8,
 8,9,9,9,10,10,16,17],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,4,5,7,7,
 8,8,8,9,10,11,15,16],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,4,5,5,5,5,
 6,6,6,7,8,8,9],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,5,5,5,5,6,
 6,6,6,8,8,9,10,11],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,5,
 6,6,6,7,7,8,8,8],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,5,5,
 6,6,6,7,7,8,8,8],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,5,5,6,6,
 6,6,7,7,7,7,8],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,5,5,5,5,
 6,6,6,7,7,7,8],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,6,6,7,9,
 10,10,11,13],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,
 5,6,6,7,8,10],
[1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,4,4,5,5,5,5,6,8,
 8,9,9,9,10,10,10,11],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,
 5,5,6,6,7],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,
 5,5,5,5,6],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,
 5,5,5,5,6],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,4,6,6,7,7,
 7,7,7,7,8,8],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,7,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,4,4,4,4,4,5,5,5,5,
 6,6,7,9,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,6,7,7,9],
[1,1,1,1,1,1,2,2,2,2,2,2,2,3,7],
[1,1,1,1,1,1,2,2,2,2,2,2,2,5,5],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,5,5],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,
 5,5,6,6,6,7,7],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,5,6,6,
 6,6,7,7,7,7,8,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,
 6,7,7,8,8,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,5,
 5,6,6,6,6,6,7,8,9],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,5,5,6,
 6,7,7,8,8,8,9],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,4,5,
 5,5,5,6,7,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,5,5,
 5,5,6,6,7,8,9],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,
 6,6,6,6,7,7,8,10,11],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,
 5,6,6,7,7,7,8],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,6,
 6,6,6,9,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,4,4,4,4,6,6,6,6,6,
 6,6,6,7,7,7,7,9,9,10],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,5,7,7,9],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,4,4,5,5,6,6,
 6,6,6,7,7,7],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,4,4,5,6,6,6,6,6,
 6,7,7,8],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,4,5,5,5,7],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,5,6,6,6,6,7,7,8,8,
 9,9,9,10],[1,1,1,1,1,1,2,2,2,2,2,2,3,3,4,6,6,10]
,[1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,5,7,7,7],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,8,9,9,10,10,
 11,12,12,12,13,13,13,14,14,14,15,15,16,16],
[1,1,1,1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,9,9,9,10,10,
 10,11,13,14,15,15,16,16,17,17,18],
[1,1,1,1,1,1,2,2,2,2,2,2,3,4,5],
[1,1,1,1,1,1,2,2,2,2,2,2,4,4,4],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,6,7],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,5,6,7,7,11,13],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,10,11,12,12,12,
 12,12,13,14,14],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,4,5,6,11,16,22],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,5,5,6,6,7,7,8,8,
 8,8,9,9,10,10,11,11,11,11,11,11,12,12,12,12],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,6,7,8,8,9,9,9,
 10,10,10,10,11,11,11,11,11,12,12],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,4,5,6,6,7,8,8,10,10,
 10,11,11,11,11,11,12,12,12,12],
[1,1,1,1,1,1,2,2,2,2,2,3,3,3,6,6,6,6,6,6,6,6,7,7,
 7,7],[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4],
[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,4,4,5,5,5,6,6,8,9,
 9,9,10,10],
[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,5,5,7,8],
[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,6,6,8],
[1,1,1,1,1,1,2,2,2,2,2,3,3,4,4,6,7,7,9,10,11],
[1,1,1,1,1,1,2,2,2,2,2,3,3,6,6,8,8,10],
[1,1,1,1,1,1,2,2,2,2,2,3,3,8],
[1,1,1,1,1,1,2,2,2,2,2,3,4,4,4,4,5,5,5,5,6,6,6,6,
 7,7],[1,1,1,1,1,1,2,2,2,2,2,3,4,4,5,5,5,6,7],
[1,1,1,1,1,1,2,2,2,2,2,3,4,7],
[1,1,1,1,1,1,2,2,2,2,2,3,5,6],
[1,1,1,1,1,1,2,2,2,2,2,4,5,5],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,
 4,5,5,5,5,5,6],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,4,5,6,7],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,
 5,5,5,5,5,7,8],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,4,4,4,4,
 5,5,5,5,6,7,8],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,5,11,12,15,23],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,4,6,6,7,7,7,8,8,8,
 9,9,10,10,11],[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,6,6,6,6,7,
 7,8,8,8,9],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,5,5,6,6,6,6,6,
 6,7,7,7,8,9],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,6,6,6,6,7,7,7,
 8,9,9,10],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,5,9,12,17],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,7],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,6,8,9,10],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,5,8,11,12,15],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,4,6,6,6],
[1,1,1,1,1,1,2,2,2,2,3,3,3,3,4,6,7,7,7,8,8,10,10,
 11,15,16],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,4,5,6,6,7,7,7,
 7,7,8,8],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,6,6,6,6,9,9,
 9,9,10,10],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,5,7],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,5,6,6,6,7,8,8,8,
 8,8,9,9],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,4,7,7,8,10,11],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,5,6,6,6,7,7,8,
 8,9,10,10,11],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,5,7,7],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,6,8,9,10,10],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,4,5,6,8,10,10,14],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,5,5,5,6,7,8,8,9,9,
 9,10,14,15],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,5,5,6,7,8,10,14],
[1,1,1,1,1,1,2,2,2,2,3,3,3,4,6,7,7,7,7,7,8,8,8,8,
 10,11,12],[1,1,1,1,1,1,2,2,2,2,3,3,3,7],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,4,4,4,4,4,4,4,4,
 5,5,5,7,7,8],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,4,5,5,5,6,6,6,6,6,
 7,7],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,6,
 7,8,8,9],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,5,6,6,10,10,11],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,4,6,6,8,9,11,12],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,5,6,6,8,8,8,9,
 9,10,10,12,13,13,14,14,15],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,5,5,6,7,10,12],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,5,6,7,8,8,9,9],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,6,6,6,7,8,8,9],
[1,1,1,1,1,1,2,2,2,2,3,3,4,4,8,8,8,8],
[1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,5,6,6,7,8,9,9,10,10,
 11,11,12,12],
[1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7,7],
[1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,6,7,7,7,8,8],
[1,1,1,1,1,1,2,2,2,2,3,3,4,5,5,8,9,9],
[1,1,1,1,1,1,2,2,2,2,3,3,4,5,6,7,7,7,8,11,12],
[1,1,1,1,1,1,2,2,2,2,3,3,4,6],
[1,1,1,1,1,1,2,2,2,2,3,3,5,5],
[1,1,1,1,1,1,2,2,2,2,3,3,5,6,6,7,8,8,8,9,9],
[1,1,1,1,1,1,2,2,2,2,3,4,4,4,4,5,5,5,5,5,5,6,6,6,
 7,7,7,8],[1,1,1,1,1,1,2,2,2,2,3,4,4,5],
[1,1,1,1,1,1,2,2,2,2,4,4,6,7,7,9,9],
[1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,6,6,
 7,7,9],
[1,1,1,1,1,1,2,2,2,3,3,3,3,3,4,4,4,5,6,6,7,7,9,10,
 10,11,14,15],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,6,7,
 7,8],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5,5,6,6,7,7,
 8,9,10],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,7,7,
 7,9],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,5,5,5,6,7,7,8,8,
 8,9,10,11],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,5,6,6,7,7,8],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,4,6,7,8,8,10,12],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,6,6,7,7,7],
[1,1,1,1,1,1,2,2,2,3,3,3,3,4,5,5,7,7,7,8,9],
[1,1,1,1,1,1,2,2,2,3,3,3,3,6],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,4,5,5,5,5,6,
 6,7],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,5,6,6,
 6,7],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,5,5,5,6,6,6,
 6,7,7,8],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,4,5,6,6,6,6,6,7,7,
 7,7],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,5,6,7,7,7,12],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,4,6,6,7,7,7,9],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,5,5,5,6,6,7,8,8,9,
 10,10,12,13],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,5,6,7,7],
[1,1,1,1,1,1,2,2,2,3,3,3,4,4,6,6,6,7,8,8,8],
[1,1,1,1,1,1,2,2,2,3,3,3,4,5],
[1,1,1,1,1,1,2,2,2,3,3,3,4,5,5,5,6,6,6,7,10],
[1,1,1,1,1,1,2,2,2,3,3,3,4,5,6,7,7,8,9,9,9],
[1,1,1,1,1,1,2,2,2,3,3,3,4,6,6,6,6,8,10,10,11],
[1,1,1,1,1,1,2,2,2,3,3,3,6,8,9],
[1,1,1,1,1,1,2,2,2,3,3,3,7,7,8],
[1,1,1,1,1,1,2,2,2,3,3,3,8,9],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,4,4,4,5,5,5,7,7,
 8,8,8,9],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,4,6,7,7,7,12],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,4,5,5,6,6,6,7,8,9,10,
 11,12],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,5,6,6,6,6,8,9,
 12,14],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,6,6,7,8,8,9,
 9,10,10,11],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,5,5,6,8,9,12],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,6,6,7,8,8,10],
[1,1,1,1,1,1,2,2,2,3,3,4,4,4,5,8,8,8,9,11,11],
[1,1,1,1,1,1,2,2,2,3,3,4,4,5,5,6,6,7,7,8,10],
[1,1,1,1,1,1,2,2,2,3,3,4,5,5,5,6,6,6,6,7,7],
[1,1,1,1,1,1,2,2,2,3,3,5,6,6,6],
[1,1,1,1,1,1,2,2,2,3,3,5,6,12],
[1,1,1,1,1,1,2,2,2,3,3,5,7,11],
[1,1,1,1,1,1,2,2,2,3,3,5,9,12],
[1,1,1,1,1,1,2,2,2,3,3,5,10,11],
[1,1,1,1,1,1,2,2,2,3,3,5,11,12],
[1,1,1,1,1,1,2,2,2,3,3,8,8,9],
[1,1,1,1,1,1,2,2,2,3,3,8,9,10],
[1,1,1,1,1,1,2,2,2,3,3,9,11],
[1,1,1,1,1,1,2,2,2,3,4,4,5,5,5,5,6,7,7,7,9],
[1,1,1,1,1,1,2,2,2,3,4,4,5,6,6],
[1,1,1,1,1,1,2,2,2,3,4,4,8,8,11],
[1,1,1,1,1,1,2,2,2,3,4,5,5,5,6],
[1,1,1,1,1,1,2,2,2,3,4,5,5,6,6,6,7],
[1,1,1,1,1,1,2,2,2,3,4,5,5,7,8],
[1,1,1,1,1,1,2,2,2,3,4,6,8,11],
[1,1,1,1,1,1,2,2,2,3,4,7,7,11],
[1,1,1,1,1,1,2,2,2,3,4,8,8,9],
[1,1,1,1,1,1,2,2,2,3,4,9,10,10,15,16],
[1,1,1,1,1,1,2,2,2,3,5,5,5,7,7],
[1,1,1,1,1,1,2,2,2,3,5,7,7,10],
[1,1,1,1,1,1,2,2,2,3,5,7,8,9],
[1,1,1,1,1,1,2,2,2,3,6,6,7,7],
[1,1,1,1,1,1,2,2,2,4,4,5,5,5,5,5,5,10],
[1,1,1,1,1,1,2,2,2,4,4,5,7,8],
[1,1,1,1,1,1,2,2,2,4,4,8,9,9,14],
[1,1,1,1,1,1,2,2,2,4,6,6,10,11,11],
[1,1,1,1,1,1,2,2,3,3,3,3,3,3,4,4,4,6,8],
[1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,4,5,6,6],
[1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,6,7,8],
[1,1,1,1,1,1,2,2,3,3,3,3,4,4],
[1,1,1,1,1,1,2,2,3,3,3,3,4,4,5,5,5,5,5,5],
[1,1,1,1,1,1,2,2,3,3,3,3,5,8,9],
[1,1,1,1,1,1,2,2,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,8,
 8,11,12],[1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,5,8],
[1,1,1,1,1,1,2,2,3,3,3,4,4,4,5,5,6,7],
[1,1,1,1,1,1,2,2,3,3,3,4,4,5,5,6,6,7,8,8,8],
[1,1,1,1,1,1,2,2,3,3,3,4,4,6,6],
[1,1,1,1,1,1,2,2,3,3,3,4,4,6,7],
[1,1,1,1,1,1,2,2,3,3,3,4,4,7,8],
[1,1,1,1,1,1,2,2,3,3,3,4,5,5,6],
[1,1,1,1,1,1,2,2,3,3,3,4,5,5,6,7,9,15,15],
[1,1,1,1,1,1,2,2,3,3,3,4,5,7,7,8,9,13,13],
[1,1,1,1,1,1,2,2,3,3,3,4,7,7],
[1,1,1,1,1,1,2,2,3,3,3,4,8,9],
[1,1,1,1,1,1,2,2,3,3,3,4,10,11],
[1,1,1,1,1,1,2,2,3,3,3,4,10,17,18,20,21],
[1,1,1,1,1,1,2,2,3,3,3,4,15,16,17,17,18],
[1,1,1,1,1,1,2,2,3,3,3,5,6,7],
[1,1,1,1,1,1,2,2,3,3,3,5,7,8],
[1,1,1,1,1,1,2,2,3,3,4,4,4,5,5],
[1,1,1,1,1,1,2,2,3,3,4,4,4,5,6],
[1,1,1,1,1,1,2,2,3,3,4,4,4,5,6,6,6,6,6,7,8],
[1,1,1,1,1,1,2,2,3,3,4,4,5,5,6,7,7],
[1,1,1,1,1,1,2,2,3,3,4,4,5,9],
[1,1,1,1,1,1,2,2,3,3,4,4,6,7],
[1,1,1,1,1,1,2,2,3,3,4,4,6,8],
[1,1,1,1,1,1,2,2,3,3,4,5,5,7,7],
[1,1,1,1,1,1,2,2,3,3,4,5,5,8],
[1,1,1,1,1,1,2,2,3,3,4,5,5,9],
[1,1,1,1,1,1,2,2,3,3,4,5,6,6],
[1,1,1,1,1,1,2,2,3,3,4,5,6,6,7,8,10,12,13],
[1,1,1,1,1,1,2,2,3,3,4,5,6,7],
[1,1,1,1,1,1,2,2,3,3,4,5,6,8,8,10,10,11,11],
[1,1,1,1,1,1,2,2,3,3,4,5,6,8,9,9,11,12],
[1,1,1,1,1,1,2,2,3,3,4,5,9,10],
[1,1,1,1,1,1,2,2,3,3,4,5,11,12,16,17],
[1,1,1,1,1,1,2,2,3,3,4,6,8,8,9,15],
[1,1,1,1,1,1,2,2,3,3,4,7,7,9,10,14,15],
[1,1,1,1,1,1,2,2,3,3,4,8,10],
[1,1,1,1,1,1,2,2,3,3,5,5,6,6,7,7],
[1,1,1,1,1,1,2,2,3,3,5,5,6,7],
[1,1,1,1,1,1,2,2,3,3,5,5,6,9],
[1,1,1,1,1,1,2,2,3,3,5,6,6,7,8,16,17],
[1,1,1,1,1,1,2,2,3,3,6,6,6,10],
[1,1,1,1,1,1,2,2,3,3,6,7,7,8],
[1,1,1,1,1,1,2,2,3,3,7,8,8,9,11,12],
[1,1,1,1,1,1,2,2,3,3,9,12,13,13,14,26],
[1,1,1,1,1,1,2,2,3,3,12],
[1,1,1,1,1,1,2,2,3,4,4,4,4,4,5],
[1,1,1,1,1,1,2,2,3,4,4,4,6,6],
[1,1,1,1,1,1,2,2,3,4,4,4,6,7],
[1,1,1,1,1,1,2,2,3,4,4,5,5,7,7,9,10,12],
[1,1,1,1,1,1,2,2,3,4,4,5,5,8],
[1,1,1,1,1,1,2,2,3,4,4,5,6,6],
[1,1,1,1,1,1,2,2,3,4,4,5,6,7,13,15],
[1,1,1,1,1,1,2,2,3,4,4,5,6,8],
[1,1,1,1,1,1,2,2,3,4,4,5,6,9],
[1,1,1,1,1,1,2,2,3,4,4,5,7,7,7,8,9,10],
[1,1,1,1,1,1,2,2,3,4,4,5,7,8],
[1,1,1,1,1,1,2,2,3,4,4,10,12,14,14,15,15],
[1,1,1,1,1,1,2,2,3,4,5,5,5,6,6,8],
[1,1,1,1,1,1,2,2,3,4,5,5,6,6],
[1,1,1,1,1,1,2,2,3,4,5,5,6,6,6,7],
[1,1,1,1,1,1,2,2,3,4,5,5,7,9,9,15,16],
[1,1,1,1,1,1,2,2,3,4,5,6,6,7,7,8,9,9,10],
[1,1,1,1,1,1,2,2,3,4,5,6,8,9,10,12],
[1,1,1,1,1,1,2,2,3,4,5,6,8,10,13,16],
[1,1,1,1,1,1,2,2,3,4,5,6,12,16,20,23],
[1,1,1,1,1,1,2,2,3,4,5,7,10,12,16,20,21],
[1,1,1,1,1,1,2,2,3,4,7,9,10,20,24,24],
[1,1,1,1,1,1,2,2,3,5,5,5,7,7,8,16,17],
[1,1,1,1,1,1,2,2,3,5,5,6,6,7,8],
[1,1,1,1,1,1,2,2,3,5,6,6,7,7,8,14],
[1,1,1,1,1,1,2,2,3,5,6,6,9,9,11,14,16,18,19],
[1,1,1,1,1,1,2,2,3,5,6,7,8,9,9,10],
[1,1,1,1,1,1,2,2,3,5,6,8,8,9,10,10],
[1,1,1,1,1,1,2,2,3,5,7,10,12,17],
[1,1,1,1,1,1,2,2,3,5,8,9,10,15],
[1,1,1,1,1,1,2,2,3,6,8,10,12,15,18,26],
[1,1,1,1,1,1,2,2,3,6,9],
[1,1,1,1,1,1,2,2,4,4,4,4,5,6,7,7,7,9,9],
[1,1,1,1,1,1,2,2,4,4,4,4,6,6,7,7],
[1,1,1,1,1,1,2,2,4,4,4,5,6,7],
[1,1,1,1,1,1,2,2,4,4,5,5,5,5,6,6,10],
[1,1,1,1,1,1,2,2,4,5,5,5,6,7,13,14],
[1,1,1,1,1,1,2,2,4,5,8,8,10,11],
[1,1,1,1,1,1,2,2,4,5,8,8,10,12,16,18],
[1,1,1,1,1,1,2,2,4,6,7,8,8,9],
[1,1,1,1,1,1,2,2,5,5,5,8,10,13],
[1,1,1,1,1,1,2,2,5,5,6,7,8,11],
[1,1,1,1,1,1,2,2,6,6,6],
[1,1,1,1,1,1,2,3,3,3,3,3,3,3,4,4,4,4,4,5],
[1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,4,4,5,6],
[1,1,1,1,1,1,2,3,3,3,3,3,4,4,4,9,10],
[1,1,1,1,1,1,2,3,3,3,3,3,4,5,7],
[1,1,1,1,1,1,2,3,3,3,3,4,4],
[1,1,1,1,1,1,2,3,3,3,3,4,4,4,4,4,6,8],
[1,1,1,1,1,1,2,3,3,3,3,4,4,4,5,11,12,14,15],
[1,1,1,1,1,1,2,3,3,3,3,4,4,4,6],
[1,1,1,1,1,1,2,3,3,3,3,4,4,5,6,8,9,9,10],
[1,1,1,1,1,1,2,3,3,3,3,4,9,10],
[1,1,1,1,1,1,2,3,3,3,4,4,5,6,6,8,8,9,9],
[1,1,1,1,1,1,2,3,3,3,4,4,6,6],
[1,1,1,1,1,1,2,3,3,3,4,5,5,6],
[1,1,1,1,1,1,2,3,3,3,4,5,5,10,11,11,12],
[1,1,1,1,1,1,2,3,3,3,4,5,6,14,15,19,19],
[1,1,1,1,1,1,2,3,3,3,4,5,7,8],
[1,1,1,1,1,1,2,3,3,3,4,5,9,13,14,16,19],
[1,1,1,1,1,1,2,3,3,3,4,6,6,7],
[1,1,1,1,1,1,2,3,3,4,4,4,5,8],
[1,1,1,1,1,1,2,3,3,4,4,4,11,11,16],
[1,1,1,1,1,1,2,3,3,4,4,5],
[1,1,1,1,1,1,2,3,3,4,4,5,5,5],
[1,1,1,1,1,1,2,3,3,4,4,5,5,6],
[1,1,1,1,1,1,2,3,3,4,4,5,11,11,15],
[1,1,1,1,1,1,2,3,3,4,4,6],
[1,1,1,1,1,1,2,3,3,4,4,7,7,10,11,14],
[1,1,1,1,1,1,2,3,3,4,5,5,6,9,10,10,11],
[1,1,1,1,1,1,2,3,3,4,7],
[1,1,1,1,1,1,2,3,3,11,11,12],
[1,1,1,1,1,1,2,3,4,4,4,4],
[1,1,1,1,1,1,2,3,4,4,4,5,5,5],
[1,1,1,1,1,1,2,3,4,4,6],[1,1,1,1,1,1,2,3,4,4,6,6],
[1,1,1,1,1,1,2,3,4,4,8],
[1,1,1,1,1,1,2,3,4,5,5,5,6,7,8,12,13],
[1,1,1,1,1,1,2,3,4,5,6,7,9,10],
[1,1,1,1,1,1,2,3,4,5,7],
[1,1,1,1,1,1,2,3,4,6,6,6,6,7,7,7,7,7,7,8,8],
[1,1,1,1,1,1,2,3,4,6,6,8,8,11,12,13,13,26],
[1,1,1,1,1,1,2,3,5,5,6,6,6,6,10,13],
[1,1,1,1,1,1,2,3,7,7],
[1,1,1,1,1,1,2,3,8,11,12,15,16,16,16,24],
[1,1,1,1,1,1,2,3,10,10],
[1,1,1,1,1,1,2,4,4,4,6,7,7,10,10],
[1,1,1,1,1,1,2,4,4,4,7],
[1,1,1,1,1,1,2,4,4,5,5,6,6,10,12],
[1,1,1,1,1,1,2,4,4,5,5,7,7,8],
[1,1,1,1,1,1,2,4,4,5,6],
[1,1,1,1,1,1,2,4,4,5,6,7,7,8,15],
[1,1,1,1,1,1,2,4,4,5,8,9,11,16],
[1,1,1,1,1,1,2,4,4,6,7,7,8,8,12],
[1,1,1,1,1,1,2,4,5,5,10],
[1,1,1,1,1,1,2,4,5,6,6,6,7,8,9,9,10],
[1,1,1,1,1,1,2,4,5,6,8,9,10,14],
[1,1,1,1,1,1,2,4,5,10,11],[1,1,1,1,1,1,2,4,6,7],
[1,1,1,1,1,1,2,4,6,7,9],[1,1,1,1,1,1,2,4,6,9,10],
[1,1,1,1,1,1,2,4,6,10,11],[1,1,1,1,1,1,2,4,10,10],
[1,1,1,1,1,1,2,5,5,5,9],[1,1,1,1,1,1,2,5,5,9,10],
[1,1,1,1,1,1,2,5,6,8,10],[1,1,1,1,1,1,2,5,6,9,9],
[1,1,1,1,1,1,2,5,6,9,10],[1,1,1,1,1,1,2,5,6,10,10],
[1,1,1,1,1,1,2,5,7,9,9],[1,1,1,1,1,1,2,5,9,10],
[1,1,1,1,1,1,2,6,9,9],
[1,1,1,1,1,1,2,7,7,9,9,10,10],
[1,1,1,1,1,1,3,3,3,3,3,3,4,5,5,6,8,8],
[1,1,1,1,1,1,3,3,3,3,3,3,4,5,5,8,9,14,14,15],
[1,1,1,1,1,1,3,3,3,3,4,4,4,5,5,14,15,15],
[1,1,1,1,1,1,3,3,3,3,4,4,5,5,6,6,7,12,12,13],
[1,1,1,1,1,1,3,3,3,4,4,4,5,7,7,8,8,8,9],
[1,1,1,1,1,1,3,3,3,4,4,5,5,6,7,7,8,9,9],
[1,1,1,1,1,1,3,3,4,4,4,4],
[1,1,1,1,1,1,3,3,4,4,4,4,4,5,5,5,6,7,9],
[1,1,1,1,1,1,3,3,4,4,4,4,5,5,5,5,6,7,8],
[1,1,1,1,1,1,3,3,4,4,4,5,5,6,6,7,7],
[1,1,1,1,1,1,3,3,4,4,5],
[1,1,1,1,1,1,3,3,4,4,10,10,20],
[1,1,1,1,1,1,3,3,4,7,8,8,8,9,13,13,14],
[1,1,1,1,1,1,3,3,4,8,11],[1,1,1,1,1,1,3,3,5,5,11],
[1,1,1,1,1,1,3,3,5,8],[1,1,1,1,1,1,3,4,4,4,4],
[1,1,1,1,1,1,3,4,4,4,4,4,4,5,5,5,5,8,8],
[1,1,1,1,1,1,3,4,4,4,4,4,4,7,7,8,8,8,8],
[1,1,1,1,1,1,3,4,4,4,4,5,5,6,6,7,7,7,8],
[1,1,1,1,1,1,3,4,4,4,5,10,10,20,21,24],
[1,1,1,1,1,1,3,4,4,5,5,5,5,7,7,8,10],
[1,1,1,1,1,1,3,4,4,5,5,5,15,16,16,26],
[1,1,1,1,1,1,3,4,4,5,7,7,7,8,8,9,10],
[1,1,1,1,1,1,3,4,4,5,10],[1,1,1,1,1,1,3,4,4,7,7],
[1,1,1,1,1,1,3,4,4,7,8,8,12,14,15,16,19,19,20],
[1,1,1,1,1,1,3,4,4,8],[1,1,1,1,1,1,3,4,5,7],
[1,1,1,1,1,1,3,4,5,8,10],
[1,1,1,1,1,1,3,4,5,11,12,12,14,15,16,17],
[1,1,1,1,1,1,3,4,5,14,16,17,18,19,19,20],
[1,1,1,1,1,1,3,5,5,7,7],
[1,1,1,1,1,1,4,4,4,4,4,4,6,7,7,7,7,9,9],
[1,1,1,1,1,1,4,4,4,4,6],[1,1,1,1,1,1,4,4,4,7],
[1,1,1,1,1,1,4,4,4,7,9],
[1,1,1,1,1,1,4,4,5,5,6,6,8,9,9,10,10,10,10,11,11,11,
 11,12,12,12,12,12,12,13,13,13,13,14,14,14,15,15,16],
[1,1,1,1,1,1,4,4,5,6,6,7,8,8,15,15,16],
[1,1,1,1,1,1,4,4,5,6,7],
[1,1,1,1,1,1,4,5,5,5,6,7,8,13,19,19],
[1,1,1,1,1,1,4,5,5,8,8,9,10,11,11,14],
[1,1,1,1,1,1,4,5,6,6,8,8,13,14,17,17,18],
[1,1,1,1,1,1,4,5,8,8,8,9,9,12],
[1,1,1,1,1,1,4,6,6,6,7,7,8,8,15,15,16],
[1,1,1,1,1,1,4,8,8,9,10,10,10,10,12,12,13],
[1,1,1,1,1,1,5,5,5,5,9,9,13,13,20],
[1,1,1,1,1,1,5,5,5,5,9,9,17,17,20],
[1,1,1,1,1,1,5,6,10,11,11,12,12,12],
[1,1,1,1,1,1,5,7,9,10,10,11,15,16,19],
[1,1,1,1,1,1,6,8,8,10,10,11,11,12,13,13,14],
[1,1,1,1,2,3,3,3,5],[1,1,1,1,2,3,3,4,4],
[1,1,1,1,2,3,3,4,4,6],[1,1,1,1,2,3,3,4,7],
[1,1,1,1,2,3,4,4,9],[1,1,1,1,2,3,4,7],
[1,1,1,1,2,3,5,6],[1,1,1,1,2,3,5,10],
[1,1,1,1,2,3,7,10],[1,1,1,1,2,4,4,6,6],
[1,1,1,1,2,4,7,10],[1,1,1,1,2,4,7,10,11],
[1,1,1,1,2,4,10],[1,1,1,1,2,6,7,8],
[1,1,1,1,2,7,7],[1,1,1,1,3,3,4,4,4,4],
[1,1,1,1,3,3,4,4,5],[1,1,1,1,3,3,5,5],
[1,1,1,1,3,4,4,4,7],[1,1,1,1,3,4,4,5],
[1,1,1,1,3,4,4,5,6],[1,1,1,1,3,4,5,8],
[1,1,1,1,3,5,7,7],[1,1,1,1,4,4,4,4,6],
[1,1,1,1,4,4,5,7,8],[1,1,1,1,4,4,5,8],
[1,1,1,1,4,4,7,8],[1,1,1,1,4,4,8],
[1,1,1,1,4,5,8,8,9],[1,1,1,1,5,5,8,9,9],
[1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,6,6,6,7,
 7,8,8,9,9,10],
[1,1,1,2,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,4,5,5,5,6,
 6,6,6,7,7,7,8,8,9,9,9,10],
[1,1,1,2,2,2,2,2,2,2,2,3,3,4],
[1,1,1,2,2,2,2,2,2,2,3,3,3,4,4,4,4,4,5,5,5,5,5,6,
 6,6,6,7],[1,1,1,2,2,2,2,2,2,2,4,4],
[1,1,1,2,2,2,2,2,2,2,4,4,4,4,6,10],
[1,1,1,2,2,2,2,2,2,2,6,6],
[1,1,1,2,2,2,2,2,2,3,3,3,3],
[1,1,1,2,2,2,2,2,2,3,3,3,3,5,5,6,6,7,7],
[1,1,1,2,2,2,2,2,2,3,3,3,4,4,5,6,7],
[1,1,1,2,2,2,2,2,2,3,3,4],
[1,1,1,2,2,2,2,2,2,3,3,4,4],
[1,1,1,2,2,2,2,2,2,3,3,4,4,4,6,6],
[1,1,1,2,2,2,2,2,2,3,3,4,5,7,7,9],
[1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8],
[1,1,1,2,2,2,2,2,2,3,3,5,6,7,7,8,10,10,11],
[1,1,1,2,2,2,2,2,2,3,3,6],
[1,1,1,2,2,2,2,2,2,3,3,6,6,6,7,7,7,9,10],
[1,1,1,2,2,2,2,2,2,3,3,6,7,7,8,9],
[1,1,1,2,2,2,2,2,2,3,4,4,4,4,5,6,6,7,9],
[1,1,1,2,2,2,2,2,2,3,4,5,6,6,7,7,8,9,10],
[1,1,1,2,2,2,2,2,2,3,4,5,6,7,8,9],
[1,1,1,2,2,2,2,2,2,3,4,6,6,6,9,10],
[1,1,1,2,2,2,2,2,2,4,4,4,4,4,4,6,6],
[1,1,1,2,2,2,2,2,2,4,4,6],[1,1,1,2,2,2,2,2,2,4,6],
[1,1,1,2,2,2,2,2,2,5,5],
[1,1,1,2,2,2,2,2,3,3,3,3,4,4,4,5,5,6,8],
[1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,5,6,7],
[1,1,1,2,2,2,2,2,3,3,3,3,4,4,5,5,6,7,7],
[1,1,1,2,2,2,2,2,3,3,3,3,4,5,5,6,6,6,6],
[1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,5,5],
[1,1,1,2,2,2,2,2,3,3,3,4,4,4,4,5,5,5,6],
[1,1,1,2,2,2,2,2,3,3,4,4],
[1,1,1,2,2,2,2,2,3,3,4,4,4,4,4,6,6,6,8],
[1,1,1,2,2,2,2,2,3,3,4,6,6,6,6,6,7,7,7,7,7,7,8,8],
[1,1,1,2,2,2,2,2,3,3,4,6,6,10],
[1,1,1,2,2,2,2,2,3,4,5],[1,1,1,2,2,2,2,2,3,4,5,5],
[1,1,1,2,2,2,2,2,3,4,5,5,5,6,6,6,6,7,7,8,8,8,8,10],
[1,1,1,2,2,2,2,2,3,4,5,6],[1,1,1,2,2,2,2,2,3,5,9],
[1,1,1,2,2,2,2,2,4,4,4,4],
[1,1,1,2,2,2,2,2,4,4,4,5],[1,1,1,2,2,2,2,2,4,4,6],
[1,1,1,2,2,2,2,2,4,4,9],[1,1,1,2,2,2,2,2,4,5,5],
[1,1,1,2,2,2,2,2,4,7,9],[1,1,1,2,2,2,2,2,5,6,7],
[1,1,1,2,2,2,2,2,5,7],[1,1,1,2,2,2,2,2,6,6],
[1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,5,5,5,9],
[1,1,1,2,2,2,2,3,3,3,3,4],
[1,1,1,2,2,2,2,3,3,3,3,4,5,6,6,7,7,8,9,9,9,10,11,12],
[1,1,1,2,2,2,2,3,3,3,3,4,6,7,8,12,13],
[1,1,1,2,2,2,2,3,3,3,3,5,6,6,12],
[1,1,1,2,2,2,2,3,3,3,3,5,6,8,8,9,10],
[1,1,1,2,2,2,2,3,3,3,3,5,7,7,12],
[1,1,1,2,2,2,2,3,3,3,3,6,6,6,11],
[1,1,1,2,2,2,2,3,3,3,3,8,9,10],
[1,1,1,2,2,2,2,3,3,3,4,4,4,4,5,5,5,5,7],
[1,1,1,2,2,2,2,3,3,3,4,4,5,5,6,6,7,8],
[1,1,1,2,2,2,2,3,3,3,4,4,8,8,9,11,11],
[1,1,1,2,2,2,2,3,3,3,4,5,5,5,6,6,6,7],
[1,1,1,2,2,2,2,3,3,3,4,5,6,6,7,12,13],
[1,1,1,2,2,2,2,3,3,3,4,7,8,9],
[1,1,1,2,2,2,2,3,3,3,4,8,9,9],
[1,1,1,2,2,2,2,3,3,3,5,7,8,8],
[1,1,1,2,2,2,2,3,3,3,5,14,14,15],
[1,1,1,2,2,2,2,3,3,3,6,6,7,13],
[1,1,1,2,2,2,2,3,3,4,4],[1,1,1,2,2,2,2,3,3,4,4,4],
[1,1,1,2,2,2,2,3,3,4,4,4,5,5,5,6,6,6,6,6,7,7,7,8,
 8,9],[1,1,1,2,2,2,2,3,3,4,4,6,7,7],
[1,1,1,2,2,2,2,3,3,4,4,7,8,8],
[1,1,1,2,2,2,2,3,3,4,6],
[1,1,1,2,2,2,2,3,3,4,6,6,12],
[1,1,1,2,2,2,2,3,3,4,8],[1,1,1,2,2,2,2,3,3,5,5],
[1,1,1,2,2,2,2,3,3,5,5,5,5,6,6,6,6,6,6,6,6],
[1,1,1,2,2,2,2,3,3,5,5,6,6,6,7],
[1,1,1,2,2,2,2,3,3,5,6,6,7,7,8],
[1,1,1,2,2,2,2,3,3,5,6,6,7,11],
[1,1,1,2,2,2,2,3,3,5,6,8,8,10],
[1,1,1,2,2,2,2,3,3,5,7,8,8,9],
[1,1,1,2,2,2,2,3,3,6,8],
[1,1,1,2,2,2,2,3,3,6,8,8,8,11],
[1,1,1,2,2,2,2,3,3,7,7,7,8,10],
[1,1,1,2,2,2,2,3,4,4,4,4,5,5,5,6,6,6,7,7,7,8,8,9],
[1,1,1,2,2,2,2,3,4,5,5,5,6,6,7],
[1,1,1,2,2,2,2,3,4,5,6,8,8,9],
[1,1,1,2,2,2,2,3,4,5,7,7,7,10],
[1,1,1,2,2,2,2,3,4,5,8],
[1,1,1,2,2,2,2,3,4,6,6,6,7,9],
[1,1,1,2,2,2,2,3,4,6,7],[1,1,1,2,2,2,2,3,4,7],
[1,1,1,2,2,2,2,3,4,7,8],
[1,1,1,2,2,2,2,3,5,5,5,6,6,7],
[1,1,1,2,2,2,2,3,5,6],
[1,1,1,2,2,2,2,3,5,6,8,8,8,9],
[1,1,1,2,2,2,2,3,5,7,7,7,8,8],
[1,1,1,2,2,2,2,4,4,4,4],[1,1,1,2,2,2,2,4,4,4,6,6],
[1,1,1,2,2,2,2,4,4,6],[1,1,1,2,2,2,2,4,5,5],
[1,1,1,2,2,2,2,4,5,5,5,6,6,6],
[1,1,1,2,2,2,2,4,5,5,7,7,7,8],
[1,1,1,2,2,2,2,4,5,6,6,6,7,7],
[1,1,1,2,2,2,2,4,5,10,14,18,21,22],
[1,1,1,2,2,2,2,5,5,6,8,9,9],
[1,1,1,2,2,2,2,5,6,17,18],
[1,1,1,2,2,2,3,3,3,3,3,4,4,5,5,5,6,6,6],
[1,1,1,2,2,2,3,3,3,3,3,6],
[1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,6],
[1,1,1,2,2,2,3,3,3,3,4,4,4,4,5,5],
[1,1,1,2,2,2,3,3,3,3,4,4,4,4,6,6],
[1,1,1,2,2,2,3,3,3,3,4,4,5,6,7],
[1,1,1,2,2,2,3,3,3,3,4,4,6,6,6],
[1,1,1,2,2,2,3,3,3,3,4,5],
[1,1,1,2,2,2,3,3,3,4,4,4,4,4,5,5,5,5,6,7,7,7,8,8],
[1,1,1,2,2,2,3,3,3,4,4,4,4,4,5,5,5,7,7,8,9,10],
[1,1,1,2,2,2,3,3,3,4,4,4,4,5,5,6,6,6,6],
[1,1,1,2,2,2,3,3,3,4,4,4,4,6,8,11,13],
[1,1,1,2,2,2,3,3,3,4,4,4,4,7,7,10,13],
[1,1,1,2,2,2,3,3,3,4,4,4,5,5,6,7],
[1,1,1,2,2,2,3,3,3,4,4,4,5,5,7],
[1,1,1,2,2,2,3,3,3,4,4,4,7,7,7,8,11],
[1,1,1,2,2,2,3,3,3,4,4,5,7,7,7,7,10],
[1,1,1,2,2,2,3,3,3,4,5,5,6,6,7,8,10],
[1,1,1,2,2,2,3,3,3,4,8],
[1,1,1,2,2,2,3,3,3,5,5,6,6,6,7,8],
[1,1,1,2,2,2,3,3,3,5,5,6,6,7,8,8],
[1,1,1,2,2,2,3,3,4,4,4],
[1,1,1,2,2,2,3,3,4,4,4,4,4,4,5,6,7,7,8],
[1,1,1,2,2,2,3,3,4,4,4,4,4,5,7,8],
[1,1,1,2,2,2,3,3,4,4,4,4,5,5,6],
[1,1,1,2,2,2,3,3,4,4,5,5,6,6,6,10,11],
[1,1,1,2,2,2,3,3,4,4,5,5,6,6,7,10,10],
[1,1,1,2,2,2,3,3,4,4,6],[1,1,1,2,2,2,3,3,4,6],
[1,1,1,2,2,2,3,3,4,6,6],
[1,1,1,2,2,2,3,4,4,4,4,5,7,7,8,8],
[1,1,1,2,2,2,3,4,4,4,5],[1,1,1,2,2,2,3,4,4,5],
[1,1,1,2,2,2,3,4,4,5,5],[1,1,1,2,2,2,3,4,4,5,6],
[1,1,1,2,2,2,3,5,11,11],[1,1,1,2,2,2,3,8,10,11],
[1,1,1,2,2,2,4,4,4,4],[1,1,1,2,2,2,4,4,5,6,7,10],
[1,1,1,2,2,2,4,5,5,6,8,8],
[1,1,1,2,2,2,4,5,8,9,10,14,16],
[1,1,1,2,2,2,4,6,6,10],
[1,1,1,2,2,2,4,9,9,10,13,14,14],
[1,1,1,2,2,2,5,6,8,8],[1,1,1,2,2,2,6,10,10],
[1,1,1,2,2,3,3,3,3,3,3,4,4,4,4,4,4],
[1,1,1,2,2,3,3,3,3,4,4],
[1,1,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4],
[1,1,1,2,2,3,3,3,3,4,4,4,4,5,8],
[1,1,1,2,2,3,3,3,3,4,4,5,5,6,7],
[1,1,1,2,2,3,3,3,3,4,5,5,5,7],
[1,1,1,2,2,3,3,3,4,4,4,4,4,5,7],
[1,1,1,2,2,3,3,3,4,4,4,8,9,9,9,10,10],
[1,1,1,2,2,3,3,3,4,4,5,6],
[1,1,1,2,2,3,3,3,4,4,6,7,7,8],
[1,1,1,2,2,3,3,3,4,5,5,7,7,8],
[1,1,1,2,2,3,3,3,4,5,6,6,8],
[1,1,1,2,2,3,3,3,4,5,9,10,13,19],
[1,1,1,2,2,3,3,3,4,5,10],
[1,1,1,2,2,3,3,3,4,5,10,12,13,16],
[1,1,1,2,2,3,3,3,4,7,10],
[1,1,1,2,2,3,3,3,4,8,11,16,17,18],
[1,1,1,2,2,3,3,3,5,6,9],[1,1,1,2,2,3,3,3,6,10],
[1,1,1,2,2,3,3,4,4,4],[1,1,1,2,2,3,3,4,4,4,4],
[1,1,1,2,2,3,3,4,4,4,4,5,5,9],
[1,1,1,2,2,3,3,4,4,4,5,6],
[1,1,1,2,2,3,3,4,4,4,6,6,8],
[1,1,1,2,2,3,3,4,4,5,5,5,5,5,7,8],
[1,1,1,2,2,3,3,4,4,5,5,5,5,7],
[1,1,1,2,2,3,3,4,4,5,5,6,6,7],
[1,1,1,2,2,3,3,4,4,5,5,8,8,8],
[1,1,1,2,2,3,3,4,4,5,7,7,13],
[1,1,1,2,2,3,3,4,4,5,8,10,11,16],
[1,1,1,2,2,3,3,4,4,5,9,9,15,17],
[1,1,1,2,2,3,3,4,4,5,9,10,12,14],
[1,1,1,2,2,3,3,4,4,5,10],[1,1,1,2,2,3,3,4,4,6,10],
[1,1,1,2,2,3,3,4,5,5,6,6],
[1,1,1,2,2,3,3,4,5,5,6,6,6],
[1,1,1,2,2,3,3,4,5,5,6,7,8,11,13],
[1,1,1,2,2,3,3,4,5,6,6,6,7,13,13],
[1,1,1,2,2,3,3,4,5,6,7],[1,1,1,2,2,3,3,4,5,6,8],
[1,1,1,2,2,3,3,4,5,7,7,9,10,10,11,11,12],
[1,1,1,2,2,3,3,4,5,8],
[1,1,1,2,2,3,3,4,5,8,9,9,11,13],
[1,1,1,2,2,3,3,4,6,6,7],[1,1,1,2,2,3,3,4,6,6,8],
[1,1,1,2,2,3,3,4,6,7,8,8,9,10,10,11,11],
[1,1,1,2,2,3,3,4,6,7,12,16,17,17,18,24,28,29],
[1,1,1,2,2,3,3,4,6,9],[1,1,1,2,2,3,3,4,7,10],
[1,1,1,2,2,3,3,4,8,9],[1,1,1,2,2,3,3,4,8,10],
[1,1,1,2,2,3,3,4,8,10,10,11,12,13],
[1,1,1,2,2,3,3,4,9,9],
[1,1,1,2,2,3,3,4,9,10,11,13,14,16],
[1,1,1,2,2,3,3,4,11,11],
[1,1,1,2,2,3,3,5,5,5,5,5,6,8],
[1,1,1,2,2,3,3,5,5,6,6],[1,1,1,2,2,3,3,5,5,6,7],
[1,1,1,2,2,3,3,5,6,6,7],[1,1,1,2,2,3,3,5,6,11,12],
[1,1,1,2,2,3,3,5,8,8],[1,1,1,2,2,3,3,6,6,7],
[1,1,1,2,2,3,3,6,11,12],[1,1,1,2,2,3,3,8,10,11,12],
[1,1,1,2,2,3,3,12,12,13,13,14,15,15,15],
[1,1,1,2,2,3,4,4,4,4,5,5,5,5,6,7,7],
[1,1,1,2,2,3,4,4,4,5,5,5,5,8],
[1,1,1,2,2,3,4,4,4,5,5,5,6,6,6,8],
[1,1,1,2,2,3,4,4,4,5,5,5,6,7],
[1,1,1,2,2,3,4,4,5,5,8],
[1,1,1,2,2,3,4,4,5,6,7,10,12,12],
[1,1,1,2,2,3,4,4,5,9,10],
[1,1,1,2,2,3,4,4,6,6,7,9,11,13],
[1,1,1,2,2,3,4,4,6,8,9,9,10,11],
[1,1,1,2,2,3,4,4,6,10,11],
[1,1,1,2,2,3,4,4,6,10,11,12,12,15],
[1,1,1,2,2,3,4,4,7,8,9,10,11,18],
[1,1,1,2,2,3,4,4,8,8],[1,1,1,2,2,3,4,4,8,8,11],
[1,1,1,2,2,3,4,4,8,10,11,11,11,15],
[1,1,1,2,2,3,4,5,5,5,5,5,6,6,6,6,8,8,9,9,9,9],
[1,1,1,2,2,3,4,5,5,6,6],
[1,1,1,2,2,3,4,5,5,6,7,7,7,8,9],
[1,1,1,2,2,3,4,5,5,7,8],
[1,1,1,2,2,3,4,5,5,9,9,21,22],
[1,1,1,2,2,3,4,5,5,9,10],
[1,1,1,2,2,3,4,5,5,9,12,13,30,31],
[1,1,1,2,2,3,4,5,6,6,6,7,8,8,8],
[1,1,1,2,2,3,4,5,6,6,7,9,10,12],
[1,1,1,2,2,3,4,5,6,8,9],
[1,1,1,2,2,3,4,5,6,9,10,13],
[1,1,1,2,2,3,4,5,7,13,17,21,22],
[1,1,1,2,2,3,4,5,9,10],[1,1,1,2,2,3,4,6,6,6],
[1,1,1,2,2,3,4,6,6,7,8,8,10,11],
[1,1,1,2,2,3,4,6,7,8,8,9,10,16],
[1,1,1,2,2,3,4,6,8,9],[1,1,1,2,2,3,4,6,11,11],
[1,1,1,2,2,3,4,7,7,11],[1,1,1,2,2,3,4,7,8,9,10],
[1,1,1,2,2,3,4,7,9],[1,1,1,2,2,3,4,7,9,10,11],
[1,1,1,2,2,3,4,8,8,8,8,8,9,10],
[1,1,1,2,2,3,5,5,5,6,6,8],[1,1,1,2,2,3,5,5,5,7,7],
[1,1,1,2,2,3,5,5,6,8,11],[1,1,1,2,2,3,5,6,6,7],
[1,1,1,2,2,3,5,6,6,8,8,9,10,12,12],
[1,1,1,2,2,3,5,6,7,7,7,7,11,12],
[1,1,1,2,2,3,5,6,7,9,9,11,11],[1,1,1,2,2,3,5,6,9],
[1,1,1,2,2,3,5,7,8,8,9,9,9,10],
[1,1,1,2,2,3,5,7,8,9],[1,1,1,2,2,3,5,7,8,10,13,16],
[1,1,1,2,2,3,5,7,8,10,15,18],
[1,1,1,2,2,3,5,7,8,11,12,15],
[1,1,1,2,2,3,5,7,10,10,11],[1,1,1,2,2,3,5,7,10,11],
[1,1,1,2,2,3,5,7,10,11,12,15],
[1,1,1,2,2,3,5,9,10,10,11,11,12,13],
[1,1,1,2,2,3,6,6,9,13,23,27],
[1,1,1,2,2,3,6,7,8,9,10,16],
[1,1,1,2,2,4,4,4,4,4,4,5,5,7],
[1,1,1,2,2,4,4,4,5,5,6],[1,1,1,2,2,4,4,4,6,6,7,7],
[1,1,1,2,2,4,4,5,5,5,6],[1,1,1,2,2,4,4,5,6,7,8],
[1,1,1,2,2,4,4,6,6,8],
[1,1,1,2,2,4,4,6,7,8,10,11,12],[1,1,1,2,2,4,4,7,8],
[1,1,1,2,2,4,4,7,13,14,15,16,18],
[1,1,1,2,2,4,5,5,6,7],[1,1,1,2,2,4,5,5,8,11,19,21],
[1,1,1,2,2,4,5,6,6,6],
[1,1,1,2,2,4,5,6,6,7,7,8,9,10],
[1,1,1,2,2,4,5,6,7,7,8],[1,1,1,2,2,4,5,6,7,7,9,12]
,[1,1,1,2,2,4,6,6,12],
[1,1,1,2,2,4,6,6,18,18,29,30],[1,1,1,2,2,4,8,8,8],
[1,1,1,2,3,3,3,3,3,5,5],[1,1,1,2,3,3,3,3,4,4,5,5],
[1,1,1,2,3,3,3,3,4,4,5,5,10],
[1,1,1,2,3,3,3,3,5,5,6,6,6],
[1,1,1,2,3,3,3,4,4,5,5,6,7,10,14,15],
[1,1,1,2,3,3,3,4,4,5,5,6,7,11,13,14],
[1,1,1,2,3,3,3,4,4,5,6,6,6,7,7,7,8,9,9,9,10,10],
[1,1,1,2,3,3,3,4,4,5,8],
[1,1,1,2,3,3,3,4,4,6,6,7,7,7,8,10,11],
[1,1,1,2,3,3,3,4,5,5,8],
[1,1,1,2,3,3,3,4,5,6,7,8,8,10,15],
[1,1,1,2,3,3,3,4,5,9],[1,1,1,2,3,3,3,4,6,6],
[1,1,1,2,3,3,3,4,6,6,7],[1,1,1,2,3,3,3,5,5,8],
[1,1,1,2,3,3,3,6],[1,1,1,2,3,3,4,4,4,5,5,5,6,8,9],
[1,1,1,2,3,3,4,4,4,5,5,6,6,7,8],
[1,1,1,2,3,3,4,4,4,5,7],[1,1,1,2,3,3,4,4,5,5,7],
[1,1,1,2,3,3,4,4,5,6,6],[1,1,1,2,3,3,4,4,5,8],
[1,1,1,2,3,3,4,4,8,10],[1,1,1,2,3,3,4,5,5,5],
[1,1,1,2,3,3,4,5,5,6,7,8,10,10],
[1,1,1,2,3,3,4,5,5,7,7],[1,1,1,2,3,3,4,5,7,9],
[1,1,1,2,3,3,4,6,7,7],[1,1,1,2,3,3,4,6,7,8],
[1,1,1,2,3,3,5,5,6,10,11,11,12,13],
[1,1,1,2,3,3,5,6,6,7],
[1,1,1,2,3,3,5,6,8,12,13,14,15,18,19],
[1,1,1,2,3,3,5,7,7],
[1,1,1,2,3,3,5,9,9,10,10,11,13,13,14,14,18,18],
[1,1,1,2,3,3,6,6,7,10,11,12],[1,1,1,2,3,3,6,7,7,8],
[1,1,1,2,3,3,8,9,10,11],[1,1,1,2,3,3,9],
[1,1,1,2,3,4],[1,1,1,2,3,4,4,4,5,5,6,8,10,10],
[1,1,1,2,3,4,4,4,8,8,11,11,11,11],
[1,1,1,2,3,4,4,4,10],
[1,1,1,2,3,4,4,5,5,5,6,9,12,12],
[1,1,1,2,3,4,4,5,7,7,8,8,9,14],
[1,1,1,2,3,4,5,6,6,6,7,7,8,11],
[1,1,1,2,3,4,6,6,6,7,9,15],[1,1,1,2,3,4,6,6,7,7,8]
,[1,1,1,2,3,4,7,7,7,7,8,8,9,11],
[1,1,1,2,3,5,5,5,5,6],[1,1,1,2,3,5,5,6,6],
[1,1,1,2,3,5,6,6,8,9],[1,1,1,2,3,5,6,7,7,8],
[1,1,1,2,3,5,6,7,9,9,9,12,21],[1,1,1,2,3,6,6],
[1,1,1,2,3,12],[1,1,1,2,4,4,4,5,5,6,7,8,8,8],
[1,1,1,2,4,4,5,5,5,5,6,6],[1,1,1,2,4,4,5,5,7],
[1,1,1,2,4,4,12],[1,1,1,2,4,5,5,5,6],
[1,1,1,2,4,5,5,7,11,12,13,16],
[1,1,1,2,4,5,6,6,6,6,7,8,8,11],[1,1,1,2,4,8,8],
[1,1,1,2,4,16],[1,1,1,2,5,5],
[1,1,1,2,5,5,6,6,6,6,6,6,7,7],
[1,1,1,2,5,5,6,6,7,7,13,17],[1,1,1,2,6,6,6,12],
[1,1,1,2,6,6,18],[1,1,1,2,6,9],[1,1,1,2,7],
[1,1,1,2,10],[1,1,1,3],
[1,1,1,3,3,3,3,3,3,4,4,4,4,5,5,10],
[1,1,1,3,3,3,3,4,5,11,12,16,16,17],
[1,1,1,3,3,3,3,7,8,8,9,12,13],[1,1,1,3,3,3,4,4],
[1,1,1,3,3,3,5,5,6,8,9],[1,1,1,3,3,3,6,6,8,11,11],
[1,1,1,3,3,3,8],[1,1,1,3,3,4,4,4,5,5,6,10,10],
[1,1,1,3,3,4,4,4,5,10,11,16,16,18],
[1,1,1,3,3,4,4,4,5,11,12,14,14,16],
[1,1,1,3,3,4,4,4,11,11,12,12,13,14],
[1,1,1,3,3,4,4,7,8,9,9,13,15,16],
[1,1,1,3,3,4,5,6,8,13],[1,1,1,3,3,4,6,7,7,10,11],
[1,1,1,3,3,4,6,7,8,8,9,9,10,11],[1,1,1,3,3,4,7],
[1,1,1,3,3,4,7,7,7,7,16],
[1,1,1,3,3,4,7,7,9,9,10,13],[1,1,1,3,3,4,7,9],
[1,1,1,3,3,4,11,13,13,14,14,17,17,18],
[1,1,1,3,3,5,5,6,10,10,10,11,11,12],
[1,1,1,3,3,5,5,8,8,10],[1,1,1,3,3,5,6],
[1,1,1,3,3,5,6,7,7,8,10,17],
[1,1,1,3,3,5,6,9,11,14,16,17,17,18],[1,1,1,3,3,8,8],
[1,1,1,3,4,4,5,5],[1,1,1,3,4,4,6],
[1,1,1,3,4,4,6,6],[1,1,1,3,4,4,6,7,8,9,10],
[1,1,1,3,4,4,12],[1,1,1,3,4,5,5,6,8,11],
[1,1,1,3,4,5,5,8,8,9],[1,1,1,3,4,6,8],
[1,1,1,3,4,7,9,12],[1,1,1,3,4,7,10,10,17],
[1,1,1,3,4,7,12],[1,1,1,3,4,10],
[1,1,1,3,5,6,6,6,8,12,16,17,26,27],[1,1,1,3,5,7,7],
[1,1,1,3,6,8,9,10,10,11,15,17],[1,1,1,3,7,7],
[1,1,1,3,7,8,9,10,11,11,11],[1,1,1,3,7,10],
[1,1,1,4,4,4,4,5],[1,1,1,4,4,4,4,7,7,7,7,10],
[1,1,1,4,4,5,5,6],[1,1,1,4,4,5,6,7,7,7,8,13,13,14],
[1,1,1,4,4,5,6,7,7,8,8,12,12,13],
[1,1,1,4,4,6,6,10,10,10,10,10,11,11],
[1,1,1,4,4,6,7],[1,1,1,4,4,6,7,7,8,8,8,8,8,10],
[1,1,1,4,4,6,9],[1,1,1,4,4,7,7],[1,1,1,4,4,9],
[1,1,1,4,5],[1,1,1,4,5,5,5,5],[1,1,1,4,5,5,10],
[1,1,1,4,5,6,6,7,9,9,10,10,10,18],
[1,1,1,4,5,8,9,16],
[1,1,1,4,6,6,6,6,7,9,10,10,10,11],
[1,1,1,4,6,6,7,8,10,10,11,11,14,19],[1,1,1,4,6,6,8],
[1,1,1,4,6,7],[1,1,1,4,6,8,8,16],
[1,1,1,4,7,7,8,8,9,9,9,9,14,16],[1,1,1,4,13,17],
[1,1,1,5,5,5,9],[1,1,1,5,6,6,7,7,9,9,10,10,14,17],
[1,1,1,5,7],[1,1,1,6,6],[1,1,1,6,9,9],
[1,1,1,8,8,8,9,9],[1,1,1,9,9,14,14,32,34],
[1,1,1,13,13],[1,1,2,2,2,2,2],[1,1,2,2,2,2,2,2,6],
[1,1,2,2,2,2,3,3,4],[1,1,2,2,2,2,3,3,4,4],
[1,1,2,2,2,2,3,3,4,4,4],[1,1,2,2,2,2,3,3,6],
[1,1,2,2,2,2,3,4,5],[1,1,2,2,2,2,3,7],
[1,1,2,2,2,3,3,4,4],[1,1,2,2,2,3,3,4,4,4],
[1,1,2,2,2,3,3,6],[1,1,2,2,2,3,4,4,5],
[1,1,2,2,2,4],[1,1,2,2,2,4,4,4],
[1,1,2,2,2,4,4,4,4],[1,1,2,2,2,4,4,6,8],
[1,1,2,2,2,4,4,8],[1,1,2,2,2,5,7],
[1,1,2,2,2,6,6],[1,1,2,2,3,3],[1,1,2,2,3,3,4,4],
[1,1,2,2,3,3,4,4,4],[1,1,2,2,3,3,4,5,7],
[1,1,2,2,3,3,4,6],[1,1,2,2,3,3,4,6,8],
[1,1,2,2,3,3,4,7],[1,1,2,2,3,3,4,8],
[1,1,2,2,3,3,5,6],[1,1,2,2,3,3,8],[1,1,2,2,3,4],
[1,1,2,2,3,4,4,4,6],[1,1,2,2,3,4,4,5,5],
[1,1,2,2,3,4,4,6],[1,1,2,2,3,4,4,6,7],
[1,1,2,2,3,4,4,7],[1,1,2,2,3,4,5,6],
[1,1,2,2,3,5,6],[1,1,2,2,4,4,4,4,10],
[1,1,2,2,4,4,5,5],[1,1,2,2,4,5],[1,1,2,2,4,5,5],
[1,1,2,2,5,5],[1,1,2,2,5,7,7],[1,1,2,2,6],
[1,1,2,3,3,3,5,5,9],[1,1,2,3,3,4],
[1,1,2,3,3,4,4,4,8],[1,1,2,3,3,4,6],
[1,1,2,3,3,5],[1,1,2,3,3,6],[1,1,2,3,4,4],
[1,1,2,3,4,4,5,5],[1,1,2,3,4,4,6,6,9],
[1,1,2,3,4,5,5],[1,1,2,3,4,7],[1,1,2,3,5],
[1,1,2,3,6],[1,1,2,3,8],[1,1,2,4,4],
[1,1,2,4,4,5],[1,1,2,4,4,5,6,6,7],[1,1,2,4,7],
[1,1,2,5,6],[1,1,2,5,7],[1,1,2,5,8],[1,1,2,6],
[1,1,2,6,6],[1,1,2,8],[1,1,3],[1,1,3,3,3,4],
[1,1,3,3,3,5],[1,1,3,3,4],[1,1,3,3,4,4],
[1,1,3,3,4,4,4],[1,1,3,3,4,4,5,6],[1,1,3,3,7],
[1,1,3,4,4],[1,1,3,4,4,5],[1,1,3,4,4,6],
[1,1,3,4,6],[1,1,3,5],[1,1,3,5,5],[1,1,3,5,7],
[1,1,3,5,8],[1,1,3,6],[1,1,3,6,7],[1,1,3,7],
[1,1,3,7,8],[1,1,3,7,14],[1,1,3,8],[1,1,4],
[1,1,4,4,5],[1,1,4,4,8],[1,1,4,5],[1,1,4,5,6],
[1,1,4,5,6,9,10],[1,1,4,5,7],[1,1,4,5,7,8,9],
[1,1,4,5,8],[1,1,4,6],[1,1,4,6,8],[1,1,4,6,9],
[1,1,4,7,7],[1,1,4,7,8],[1,1,4,8],[1,1,4,9],
[1,1,4,9,10],[1,1,5],[1,1,5,5],[1,1,5,6],
[1,1,5,8],[1,1,5,8,9],[1,1,5,9],[1,1,5,9,9],
[1,1,5,10],[1,1,6],[1,1,7,7],[1,1,7,8],[1,1,8],
[1,1,8,9],[1,1,9],[1,1,9,12],[1,1,10],[1,1,12],
[1,2,2],[1,2,2,2,2,3,3,3,4],[1,2,2,2,2,6],
[1,2,2,2,3,3],[1,2,2,2,3,3,5,6],[1,2,2,2,3,5],
[1,2,2,2,3,5,5,6],[1,2,2,2,4],[1,2,2,2,4,4,4,6],
[1,2,2,2,4,5],[1,2,2,2,8],[1,2,2,3,3],
[1,2,2,3,3,3,4,4],[1,2,2,3,3,3,4,5],
[1,2,2,3,3,4],[1,2,2,3,3,6],[1,2,2,3,3,6,6],
[1,2,2,3,4],[1,2,2,3,4,4],[1,2,2,3,4,5],
[1,2,2,3,5],[1,2,2,3,7],[1,2,2,4],[1,2,2,4,4],
[1,2,2,4,5],[1,2,2,4,6],[1,2,2,4,7],
[1,2,2,4,7,8,9,11],[1,2,2,5],[1,2,2,5,5],
[1,2,2,5,7],[1,2,2,6],[1,2,2,6,7],
[1,2,2,6,7,8,11],[1,2,2,7],[1,2,2,10],[1,2,3],
[1,2,3,3,3],[1,2,3,3,4],[1,2,3,3,4,4,4,4],
[1,2,3,3,4,5,7],[1,2,3,3,5,6,6],
[1,2,3,3,5,6,6,8],[1,2,3,3,6],[1,2,3,3,7,7,8],
[1,2,3,4],[1,2,3,4,4],[1,2,3,4,4,5,6],
[1,2,3,4,5],[1,2,3,4,5,6],[1,2,3,4,5,7,7],
[1,2,3,4,5,7,10],[1,2,3,4,6],[1,2,3,4,6,6,7],
[1,2,3,4,6,7,8],[1,2,3,5],[1,2,3,5,5],
[1,2,3,5,6],[1,2,3,6],[1,2,4],[1,2,4,4],
[1,2,4,4,4],[1,2,4,4,5],[1,2,4,4,5,6,6,7],
[1,2,4,4,5,6,6,7,7],[1,2,4,4,5,6,7],
[1,2,4,4,5,7,8,9],[1,2,4,4,5,8,8],[1,2,4,4,6],
[1,2,4,5],[1,2,4,5,5],[1,2,4,6],[1,2,4,6,8],
[1,2,4,6,9],[1,2,4,6,10],[1,2,4,8],[1,2,4,10],
[1,2,5],[1,2,5,5],[1,2,5,5,6,6,6,7],[1,2,5,7],
[1,2,5,7,10],[1,2,5,9],[1,2,5,10,11],[1,2,6],
[1,2,6,6],[1,2,7],[1,2,7,7,8],[1,2,8],[1,2,9],
[1,3],[1,3,3],[1,3,3,4],[1,3,3,4,4],
[1,3,3,4,4,4],[1,3,3,4,4,4,5,6],[1,3,3,4,4,5],
[1,3,3,4,4,7,8],[1,3,3,4,5,6,7],[1,3,3,5],
[1,3,3,5,5],[1,3,3,5,7],[1,3,3,5,9],[1,3,3,6,9],
[1,3,3,8],[1,3,4],[1,3,4,4],[1,3,4,4,5,5,5,6],
[1,3,4,4,5,6,6],[1,3,4,4,8],[1,3,4,5],
[1,3,4,5,5],[1,3,4,5,9],[1,3,4,6,9],[1,3,4,7],
[1,3,5],[1,3,5,5],[1,3,5,5,8],[1,3,5,6],
[1,3,5,6,8],[1,3,5,7],[1,3,5,8],[1,3,5,10],
[1,3,6],[1,3,6,8],[1,3,6,8,9],[1,3,7],
[1,3,7,7,8],[1,3,7,8],[1,3,8],[1,4],[1,4,4,4,7],
[1,4,4,5],[1,4,4,5,6],[1,4,4,7],[1,4,4,8,10],
[1,4,4,10,10],[1,4,5],[1,4,5,5],[1,4,5,6,7],
[1,4,5,7],[1,4,5,7,10],[1,4,5,10,11],[1,4,6],
[1,4,6,6],[1,4,7],[1,4,8],[1,4,9],[1,4,10],
[1,4,10,10,14],[1,5],[1,5,5],[1,5,5,6],[1,5,6],
[1,5,6,9],[1,5,7],[1,5,7,7],[1,5,7,9],
[1,5,7,10,10,12],[1,5,9],[1,5,11],[1,6],[1,6,6],
[1,6,6,8,10],[1,6,7],[1,6,7,7],[1,6,12],[1,7,7],
[1,7,8,10,10],[1,7,9],[1,8],[1,8,9],[1,8,11],
[1,9],[1,9,9],[1,9,10],[1,10],[1,10,10],[1,12],
[2,2],[2,2,2],[2,2,2,2,2,2],
[2,2,2,2,2,2,2,2,2,4,4,4],
[2,2,2,2,2,2,3,3,4,6,6,9,9,11],
[2,2,2,2,2,2,3,3,5,6,8,11,11,15],
[2,2,2,2,2,2,3,4,4,5,5,5,6,8,9,11],
[2,2,2,2,2,2,3,4,5,8,9,12,12,13],
[2,2,2,2,2,2,3,4,5,9,9,11,11,12],
[2,2,2,2,2,2,3,4,7,7,8,9,10,10],
[2,2,2,2,2,2,3,4,9,9,10,10,11,11],
[2,2,2,2,2,2,3,6,6,6,7,7,7,9],[2,2,2,2,2,2,4,4],
[2,2,2,2,2,2,6,6,6],
[2,2,2,2,2,3,4,4,4,5,5,6,7,7,7,8],
[2,2,2,2,2,3,4,4,4,5,6,7,7,9,10,10],
[2,2,2,2,2,3,4,4,5,7,7,7,8,14],
[2,2,2,2,2,3,4,5,5,6,6,6,7,11],
[2,2,2,2,2,3,4,5,6,6,6,7,7,12],
[2,2,2,2,2,4,4,4,5,5,5,5,6,6,7,7],
[2,2,2,2,2,4,4,4,5,5,6,7,7,7,8,8],
[2,2,2,2,2,4,4,6],[2,2,2,2,2,4,4,6,6,8,10],
[2,2,2,2,2,4,6],[2,2,2,2,3,3],
[2,2,2,2,3,4,4,4,5,6,7,7,8,8],
[2,2,2,2,3,4,4,5,6,7,7,7,9,10],
[2,2,2,2,3,5,5,6,6,8,11,11,13],
[2,2,2,2,3,5,5,10,11,11],
[2,2,2,2,3,6,7,7,7,10,10,11,11,11,12],
[2,2,2,2,3,6,7,8,8,9,9,10,10,10,11],
[2,2,2,2,3,7,7,7,8,8,9,9,10],[2,2,2,2,3,7,7,10],
[2,2,2,2,3,7,8,10,10,11],[2,2,2,2,4],
[2,2,2,2,4,4,4],[2,2,2,2,4,4,4,4],
[2,2,2,2,4,4,4,4,4,5,5,5,7,7],
[2,2,2,2,4,4,4,4,5,5,7,8,8,9],
[2,2,2,2,4,4,4,5,5,5,5,6,6,6,7,7],
[2,2,2,2,4,4,4,5,5,6,6,7,7,7,7,7,8,8],
[2,2,2,2,4,4,4,6,6,8,8],[2,2,2,2,4,4,8],
[2,2,2,2,4,6,6,8],[2,2,2,2,4,8],
[2,2,2,2,5,5,6,7,8,8],[2,2,2,2,6,6],
[2,2,2,2,6,6,6],[2,2,2,3,3,3,3,5,5,6,6],
[2,2,2,3,3,3,3,5,8,9],[2,2,2,3,3,3,5,6,6,8],
[2,2,2,3,3,4,5,5],[2,2,2,3,4],[2,2,2,3,4,5,5,7],
[2,2,2,3,5,5,6,6],[2,2,2,4,4,4,4,4,4],
[2,2,2,4,4,4,4,6],[2,2,2,4,4,4,6],
[2,2,2,4,4,4,6,6],[2,2,2,4,4,6],
[2,2,2,4,4,6,6,6],[2,2,2,4,6,6],[2,2,2,4,6,6,8],
[2,2,2,6],[2,2,3],[2,2,3,3],[2,2,3,3,3],
[2,2,3,3,3,3,4,5],[2,2,3,3,3,3,5,6,8,9,14],
[2,2,3,3,3,4],[2,2,3,3,3,4,4,5],[2,2,3,3,4],
[2,2,3,3,4,4,4,5],[2,2,3,3,5,6,8,9,14,15,15],
[2,2,3,3,5,6,11,12,14,15,15],[2,2,3,3,7,7,8],
[2,2,3,4],[2,2,3,4,4],
[2,2,3,4,4,4,4,8,8,8,8,9,11,11,12],
[2,2,3,4,4,4,5,7,7,8,8,8,11,11,12],[2,2,3,4,4,5],
[2,2,3,4,4,5,5,10],[2,2,3,4,4,5,6],
[2,2,3,5,6,7,8],[2,2,3,5,6,8,8,9,9],
[2,2,3,5,7,14],[2,2,3,5,9],[2,2,3,5,11,11],
[2,2,3,6,6,7,8,8,10],[2,2,3,7,9,10],[2,2,3,7,11],
[2,2,3,8,10],[2,2,3,8,10,11],[2,2,4],[2,2,4,4],
[2,2,4,4,4],[2,2,4,4,4,4],[2,2,4,4,4,4,4],
[2,2,4,4,4,4,4,4],[2,2,4,4,4,6,6,8,12],
[2,2,4,4,5,5,5,5,5,6,7,7,8],[2,2,4,4,5,5,5,8],
[2,2,4,4,6],[2,2,4,4,8],[2,2,4,5],
[2,2,4,5,5,5,5,8,8,9],[2,2,4,6,6,10],[2,2,4,6,8],
[2,2,4,8],[2,2,5],[2,2,5,6,6],[2,2,5,6,8,8],
[2,2,6],[2,2,6,6],[2,2,8],[2,2,10,16],[2,3],
[2,3,3],[2,3,3,3],[2,3,3,3,3,5,5,6,6,8,8],
[2,3,3,4],[2,3,3,4,5],[2,3,3,4,5,5,8],
[2,3,3,4,7,8],[2,3,3,5],[2,3,3,5,6],
[2,3,3,5,6,10,11],[2,3,3,6],[2,3,3,6,6],[2,3,4],
[2,3,4,4],[2,3,4,4,5],[2,3,4,5,11],[2,3,4,6],
[2,3,4,8],[2,3,5],[2,3,5,5],[2,3,5,5,5,8,12],
[2,3,5,5,6,6],[2,3,5,5,10],[2,3,5,6],
[2,3,5,7,10,11],[2,3,5,8],[2,3,6],[2,3,7],
[2,3,7,7,8,8],[2,3,7,8],[2,3,7,10],[2,3,8],
[2,4],[2,4,4],[2,4,4,4],[2,4,4,5,5,6,6,8,8],
[2,4,4,6],[2,4,4,6,6,8],[2,4,4,7,7],[2,4,5],
[2,4,5,5],[2,4,5,5,5,9],[2,4,5,6],[2,4,5,6,6,7],
[2,4,5,6,8,9],[2,4,6],[2,4,6,6],[2,4,6,6,12],
[2,4,7],[2,4,7,7,10],[2,4,8],[2,4,8,8,8],[2,5],
[2,5,5,5,5,6,6,6,12],[2,5,5,5,5,9,9],[2,5,5,5,8],
[2,5,5,5,8,9],[2,5,5,6],[2,5,5,6,7,8],[2,5,5,7],
[2,5,6],[2,5,6,9],[2,5,7],[2,5,7,8],[2,5,8],
[2,5,8,9],[2,5,10],[2,6],[2,6,6],[2,6,6,16],
[2,6,7],[2,6,7,8],[2,6,12],[2,7,7,9],[2,8],
[2,8,8],[2,8,11],[2,8,14],[2,10],[3],[3,3],
[3,3,3,4],[3,3,3,4,4],[3,3,3,6],[3,3,4],
[3,3,4,4],[3,3,4,4,4,5],[3,3,4,5],[3,3,5],
[3,3,5,5],[3,3,5,6],[3,3,6],[3,3,6,6,8],
[3,3,9],[3,4],[3,4,4],[3,4,4,5],[3,4,5],
[3,4,6],[3,4,7,7],[3,4,7,8],[3,4,8],[3,5],
[3,5,5],[3,5,5,6],[3,5,6],[3,5,6,8],
[3,5,6,9,12],[3,5,7],[3,5,8,8],[3,6],[3,6,6],
[3,6,7],[3,7],[3,7,8],[3,7,10],[3,7,12],[3,9],
[3,12],[4],[4,4],[4,4,4],[4,4,4,4],[4,4,4,5,7],
[4,4,4,8],[4,4,4,8,8,8,12],[4,4,5],[4,4,5,5,7],
[4,4,6],[4,4,12],[4,5],[4,5,5],[4,5,5,6,6],
[4,5,5,7],[4,5,5,8],[4,5,5,9],[4,5,6],
[4,5,6,7],[4,5,6,8],[4,5,7,8],[4,5,11],[4,6],
[4,6,7],[4,6,12],[4,7],[4,8],[4,8,8],[4,9],
[4,12,28,28],[4,16],[5],[5,5],[5,5,6],[5,5,7],
[5,5,10],[5,6],[5,7,7],[5,7,10],[5,7,13],[5,8],
[5,8,10],[6],[6,6],[6,6,6,12],[6,6,18],[6,7,10],
[6,8],[6,9],[6,9,9],[6,11],[6,24],[7,8],
[7,8,10],[7,9],[7,9,11],[8],[8,10],[9],[10],
[12],[20],[30]];

orbitlengthspos :=
[1691,1691,1507,1675,1675,1,1507,1675,1,1675,1,1,1471,1471,
1567,1471,1567,1577,1471,1567,1577,1528,1562,1691,1691,1562,
1691,1691,1,1,1562,1562,1691,1,1691,1,1,1,1,1,1562,1562,1,
1562,1,1691,1,1691,1,1,1705,1705,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1691,1507,1675,1675,1,1507,1675,1,1675,1,1,1471,
1471,1567,1471,1567,1577,1471,1567,1577,1528,1562,1562,1562,
1562,1562,1562,1,1,1691,1691,1691,1705,1691,1,1,1,1,1,1562,
1691,1,1691,1,1691,1705,1691,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1692,1709,1709,1,1692,1709,1,1709,1,1,1693,
1693,1694,1693,1694,1700,1693,1694,1700,1711,1691,1691,1691,
1691,1691,1691,1,1,1691,1691,1691,1,1691,1,1,1,1,1,1691,
1691,1,1691,1,1691,1,1691,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1649,1649,1,1413,1649,1,1649,1,1,1425,1425,1509,
1425,1509,1509,1425,1509,1509,1459,1415,1507,1507,1415,1507,
1507,1,1,1507,1507,1507,1652,1507,1652,1652,1,1,1,1415,1507,
1,1507,1,1507,1652,1507,1,1,1652,1652,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1649,1,1649,1649,1,1649,1,1,1654,1654,1659,
1654,1659,1679,1654,1659,1679,1710,1651,1675,1675,1651,1675,
1675,1,1,1675,1675,1709,1,1709,1,1,1,1,1,1651,1675,1,1675,
1,1709,1,1709,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1649,1649,1,1649,1,1,1654,1654,1659,1654,1659,1679,1654,
1659,1679,1710,1651,1675,1675,1651,1675,1675,1,1,1675,1675,
1709,1,1709,1,1,1,1,1,1651,1675,1,1675,1,1709,1,1709,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1649,1,1649,1,1,1425,1425,1509,1425,1509,1509,1425,
1509,1509,1459,1415,1507,1507,1415,1507,1507,1,1,1507,1507,
1507,1652,1507,1652,1652,1,1,1,1415,1507,1,1507,1,1507,1652,
1507,1,1,1652,1652,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1649,1,1,1654,1654,1659,1654,1659,1679,1654,1659,1679,1710,
1651,1675,1675,1651,1675,1675,1,1,1675,1675,1709,1,1709,1,1,
1,1,1,1651,1675,1,1675,1,1709,1,1709,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1654,1654,
1659,1654,1659,1679,1654,1659,1679,1710,1651,1675,1675,1651,
1675,1675,1,1,1675,1675,1709,1,1709,1,1,1,1,1,1651,1675,1,
1675,1,1709,1,1709,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1563,1563,1525,1671,1671,1525,
1604,1604,1604,1416,1471,1471,1416,1471,1471,1,1,1471,1471,
1475,1,1475,1655,1655,1,1,1,1416,1471,1,1471,1,1475,1,1475,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1563,1563,1563,
1563,1525,1671,1671,1604,1416,1471,1471,1416,1471,1471,1,1,
1471,1471,1475,1655,1475,1,1,1,1,1,1416,1471,1,1471,1,1475,
1655,1475,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1671,
1671,1671,1604,1708,1708,1708,1468,1567,1567,1468,1567,1567,1,
1,1567,1567,1599,1,1599,1,1,1,1,1,1468,1567,1,1567,1,1599,
1,1599,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1563,
1671,1563,1563,1563,1604,1416,1471,1471,1416,1471,1471,1,1,
1471,1471,1475,1,1475,1,1,1,1,1,1416,1471,1,1471,1,1475,1,
1475,1,1,1655,1655,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1671,
1671,1671,1671,1708,1468,1567,1567,1468,1567,1567,1,1,1567,
1567,1599,1,1599,1,1,1,1,1,1468,1567,1,1567,1,1599,1,1599,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1604,1708,1708,
1604,1468,1577,1577,1468,1577,1577,1,1,1577,1577,1581,1678,
1581,1,1,1,1,1,1468,1577,1,1577,1,1581,1678,1581,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1563,1671,1604,1416,1471,
1471,1416,1471,1471,1,1,1471,1471,1475,1,1475,1655,1655,1,1,
1,1416,1471,1,1471,1,1475,1,1475,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1671,1708,1468,1567,1567,1468,1567,1567,1,
1,1567,1567,1599,1,1599,1,1,1,1,1,1468,1567,1,1567,1,1599,
1,1599,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1604,
1468,1577,1577,1468,1577,1577,1,1,1577,1577,1581,1,1581,1,1,
1,1,1,1468,1577,1,1577,1,1581,1,1581,1,1,1678,1678,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1426,1528,1528,1426,1528,1528,1,
1,1528,1528,1519,1,1519,1,1,1,1,1,1426,1528,1,1528,1,1519,
1,1519,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1562,
1562,1414,1562,1562,1,1,1562,1562,1562,1650,1562,1650,1650,1,
1,1,1414,1562,1,1562,1,1562,1650,1562,1,1,1650,1650,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1562,1562,1562,1562,1,1,1691,
1691,1691,1705,1691,1,1,1,1,1,1562,1691,1,1691,1,1691,1705,
1691,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1562,1562,
1562,1,1,1691,1691,1691,1705,1691,1,1,1,1,1,1562,1691,1,
1691,1,1691,1705,1691,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1562,1562,1,1,1562,1562,1562,1650,1562,1650,1650,1,1,
1,1414,1562,1,1562,1,1562,1650,1562,1,1,1650,1650,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1562,1,1,1691,1691,1691,1705,1691,
1,1,1,1,1,1562,1691,1,1691,1,1691,1705,1691,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1691,1691,1691,1705,1691,
1,1,1,1,1,1562,1691,1,1691,1,1691,1705,1691,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1562,1691,1,1691,1,1,1,1,1,
1562,1562,1,1562,1,1691,1,1691,1,1,1705,1705,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1691,1,1691,1,1,1,1,1,1562,1562,1,
1562,1,1691,1,1691,1,1,1705,1705,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1562,1705,1705,1,1,1,1562,1691,1,1691,1,1562,1,
1562,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1650,1,1,1,1,1,1650,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1705,1705,1,1,1,1562,1691,1,1691,1,1562,1,
1562,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1650,1,1,
1,1650,1,1,1,1,1705,1,1705,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1650,1,1,1,1,1705,1,1705,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1562,
1,1562,1,1562,1650,1562,1,1,1650,1650,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1562,1,1691,1,1691,1,1,1705,1705,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1691,1,1691,1,1,1705,1705,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1562,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1650,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1609,1621,1621,1647,
1,1621,1647,1,1709,1,1,1613,1613,1641,1613,1641,1697,1613,
1641,1697,1648,1610,1610,1610,1691,1691,1691,1,1,1610,1691,
1691,1,1691,1,1,1,1,1,1610,1610,1,1691,1,1691,1,1691,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1621,1621,1647,1,
1621,1647,1,1709,1,1,1613,1613,1641,1613,1641,1697,1613,1641,
1697,1648,1610,1610,1610,1691,1691,1691,1,1,1610,1691,1691,1,
1691,1,1,1,1,1,1610,1610,1,1691,1,1691,1,1691,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1333,1333,1,1507,1379,1695,
1379,1646,1,261,261,424,261,424,416,261,424,416,347,1129,
1333,1333,1251,1218,1218,1,1,1129,1251,1218,1,1218,1,1,1,1,
1,1251,1251,1378,1507,1,1333,1378,1333,1,1,1619,1619,1,1636,
1,1,1,1,1,1,1,1,1495,1,1,1495,1,1333,1,1333,1333,1646,
1527,1,1,261,261,424,261,424,416,261,424,416,347,1129,1251,
1251,1333,1218,1218,1,1,1129,1333,1218,1,1218,1,1,1,1,1,
1333,1333,1,1476,1636,1268,1,1268,1619,1619,1,1,1,1,1,1,1,
1,1,1,1,1,1,1495,1,1495,1,1,1379,1675,1,1379,1,1,1035,
1035,1042,1035,1042,1080,1035,1042,1080,1051,1326,1360,1360,
1360,1410,1410,1,1,1326,1360,1410,1,1410,1,1,1,1,1,1627,
1627,1658,1651,1682,1627,1658,1627,1701,1701,1,1,1,1,1,1,1,
1,1,1,1,1,1656,1656,1,1370,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1333,1,1379,1,1,261,261,424,261,424,416,261,424,416,347,
1129,1333,1333,1251,1218,1218,1378,1,1129,1251,1218,1,1218,1,
1378,1,1,1,1251,1251,1,1507,1,1333,1,1333,1,1,1619,1619,1,
1636,1,1,1,1495,1,1,1,1,1,1495,1,1,1,1,1379,1,1,1035,
1035,1042,1035,1042,1080,1035,1042,1080,1051,1326,1627,1627,
1627,1377,1377,1658,1,1326,1627,1377,1,1377,1,1658,1,1,1,
1360,1360,1,1651,1,1410,1,1410,1,1,1,1,1,1682,1,1,1,1656,
1,1,1,1,1,1370,1,1656,1,1,1,1,1,1073,1,1,1,1,1,1,1,1,
1352,1,1,1,1,1,1,1,1352,1,1,1,1,1,1,1,1,1,1,1,1642,1,
1,1,1642,1,1,1,1,1,1,1,1,1,1,1704,1,1,1,1,1,1,1,1,1,
1,1,354,354,418,354,418,297,354,418,297,419,1153,1323,1323,
1379,1177,1177,1382,1,1153,1379,1177,1,1177,1,1382,1,1,1,
1379,1379,1382,1476,1670,1323,1382,1323,1645,1645,1605,1605,1,
1,1,1,1,1536,1,1,1,1,1536,1,1,1,1,1,1,1,1,1059,1,1,1,
1,1,1,1352,1,1,1,1,1,1642,1,1352,1,1,1,1,1,1642,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1704,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1158,1158,1248,1201,1201,1248,1277,1171,
1171,673,784,784,784,1081,1081,1053,1,673,784,1081,1,1081,1,
1053,1,1,1,784,784,1063,1449,1481,795,1063,795,1,1,1,1,1,
1532,1,1,1,669,1,1,1,1,666,666,1,666,1,1158,1158,1158,
1263,1248,1201,1201,1282,673,784,784,784,1081,1081,1,1,673,
784,1081,1,1081,1,1,1,1,1,784,784,1063,1449,1,795,1063,795,
1467,1467,1,1,1,1,1,1,1,1,1,1,1,1,666,669,1,669,1,1201,
1372,1201,1277,1220,1314,1220,823,985,985,985,1092,1092,1,1,
823,985,1092,1,1092,1,1,1,1,1,985,985,1,1470,1497,994,1,
994,1588,1588,1,1,1,1,1,1,1,1,1,1,1,1,701,754,1,754,1,
1158,1201,1158,1158,1263,1282,673,784,784,784,1081,1081,1053,
1,673,784,1081,1,1081,1,1053,1,1,1,784,784,1053,1449,1532,
795,1053,795,1,1,1467,1467,1,1481,1,1,1,669,1,1,1,1,669,
1,1,1,1,1201,1201,1372,1201,1327,823,985,985,985,1092,1092,
1,1,823,985,1092,1,1092,1,1,1,1,1,985,985,1087,1470,1,994,
1087,994,1554,1554,1554,1554,1,1497,1,1,1,1,1,1,1,1,754,1,
1,1,1,1171,1314,1259,1171,814,1021,1021,1021,1020,1020,1076,
1,814,1021,1020,1,1020,1,1076,1,1,1,1021,1021,1076,1448,
1501,1011,1076,1011,1552,1552,1585,1585,1,1501,1,1,1,1,1,1,
1,1,785,738,1,738,1,1158,1201,1171,673,784,784,784,1081,
1081,1063,1,673,784,1081,1,1081,1,1063,1,1,1,784,784,1,
1449,1,795,1,795,1,1,1,1,1,1481,1,1,1,666,1,1,1,1,1,
669,1,669,1,1201,1220,823,985,985,985,1092,1092,1087,1,823,
985,1092,1,1092,1,1087,1,1,1,985,985,1,1470,1,994,1,994,1,
1,1588,1588,1,1583,1,1,1,754,1,1,1,1,1,1,1,1,1,1171,814,
1021,1021,1021,1020,1020,1098,1,814,1021,1020,1,1020,1,1098,
1,1,1,1021,1021,1098,1448,1565,1011,1098,1011,1585,1585,1552,
1552,1,1,1,1,1,738,1,1,1,1,738,1,1,1,1,767,932,932,932,
1097,1097,1,1,767,932,1097,1,1097,1,1,1,1,1,932,932,1078,
1474,1,863,1078,863,1,1,1,1,1,1,1,1,1,1,1,1,1,1,705,1,
1,1,1,1270,1270,1270,1364,1364,1325,1,1234,1270,1364,1,1364,
1,1325,1,1,1,1270,1270,1325,1414,1530,1270,1325,1270,1529,
1529,1529,1529,1,1530,1,1,1,1237,1,1,1,1,1237,1237,1,1237,
1,1270,1384,1384,1384,1,1,1270,1384,1384,1,1384,1,1,1,1,1,
1610,1610,1624,1562,1632,1562,1624,1562,1632,1632,1,1,1,1,1,
1,1,1,1,1,1,1,1543,1543,1,1,1,1384,1384,1384,1,1,1270,
1384,1384,1,1384,1,1,1,1,1,1610,1610,1624,1562,1632,1562,
1624,1562,1632,1632,1,1,1,1,1,1,1,1,1,1,1,1,1543,1543,1,
1,1,1384,1384,1,1,1270,1270,1384,1,1384,1,1,1,1,1,1562,
1562,1624,1562,1632,1610,1624,1610,1,1,1632,1632,1,1,1,1,1,
1,1,1,1,1,1543,1543,1,1,1,1364,1395,1,1364,1384,1364,1,
1364,1,1395,1,1,1,1384,1384,1395,1562,1597,1384,1395,1384,
1680,1680,1680,1680,1,1597,1,1,1,1312,1,1,1,1,1305,1305,1,
1312,1,1395,1,1364,1384,1364,1,1364,1,1395,1,1,1,1384,1384,
1395,1562,1597,1384,1395,1384,1680,1680,1680,1680,1,1597,1,1,
1,1312,1,1,1,1,1305,1305,1,1312,1,1,1325,1,1395,1,1395,1,
1324,1,1,1,1624,1624,1649,1649,1681,1624,1649,1624,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1626,1626,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1270,1364,1,1364,1,1325,1,1,1,1270,1270,1325,1414,
1530,1270,1325,1270,1529,1529,1529,1529,1,1530,1,1,1,1237,1,
1,1,1,1237,1237,1,1237,1,1384,1,1384,1,1,1,1,1,1562,1562,
1624,1562,1632,1610,1624,1610,1,1,1632,1632,1,1,1,1,1,1,1,
1,1,1,1543,1543,1,1,1,1,1364,1,1395,1,1,1,1384,1384,1395,
1562,1597,1384,1395,1384,1680,1680,1680,1680,1,1597,1,1,1,
1312,1,1,1,1,1305,1305,1,1312,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1395,
1,1,1,1384,1384,1395,1562,1597,1384,1395,1384,1680,1680,1680,
1680,1,1597,1,1,1,1312,1,1,1,1,1305,1305,1,1312,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1624,1624,1649,1649,1681,1624,1649,1624,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1626,1626,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1270,1,1562,1,1384,1,1384,1,1,1632,1632,1,1632,1,1,1,
1543,1,1,1,1,1,1,1,1543,1,1,1562,1,1384,1,1384,1,1,1632,
1632,1,1632,1,1,1,1543,1,1,1,1,1,1,1,1543,1,1649,1,1,
1324,1,1,1,1,1,1,1681,1,1,1,1626,1,1,1,1,1,1,1,1626,1,
1,1562,1649,1562,1597,1597,1597,1597,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1270,1632,1632,1,1,1,1632,1,1,1,1537,1,1,1,1,1,1,
1,1537,1,1,1,1,1,1,1,1681,1,1,1,1626,1,1,1,1,1,1,1,
1626,1,1632,1632,1,1,1,1632,1,1,1,1537,1,1,1,1,1,1,1,
1537,1,1529,1680,1680,1,1,1,1,1,1591,1,1,1,1,1,1591,1,1,
1,1680,1680,1,1,1,1,1,1591,1,1,1,1,1,1591,1,1,1,1529,1,
1,1,1,1,1,1,1,1,1,1,1591,1,1591,1,1,1,1,1,1,1,1,1,1,
1,1,1591,1,1591,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1656,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1656,1,1,1,1,1,1,1,1,1,1621,1621,1647,1,1621,
1647,1,1709,1,1,1613,1613,1641,1613,1641,1697,1613,1641,1697,
1648,1610,1610,1610,1691,1691,1691,1,1,1610,1691,1691,1,1691,
1,1,1,1,1,1610,1610,1,1691,1,1691,1,1691,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1333,1333,1,1507,1379,1,1379,1,
1,261,261,424,261,424,416,261,424,416,347,1251,1129,1251,
1251,1251,1507,1,1,1333,1218,1218,1619,1333,1378,1,1,1636,1,
1129,1333,1,1218,1,1218,1619,1333,1,1378,1,1,1,1,1,1,1,1,
1,1,1495,1,1,1,1,1,1495,1333,1,1333,1333,1,1527,1,1646,
261,261,424,261,424,416,261,424,416,347,1333,1129,1333,1333,
1333,1476,1619,1619,1251,1218,1218,1,1268,1,1,1,1,1,1129,
1251,1,1218,1,1218,1,1268,1,1,1,1,1,1,1636,1,1495,1,1,1,
1,1,1,1,1,1,1495,1,1379,1675,1,1379,1,1,1035,1035,1042,
1035,1042,1080,1035,1042,1080,1051,1360,1326,1360,1627,1627,
1651,1,1,1627,1377,1377,1,1410,1658,1,1,1682,1,1326,1627,1,
1377,1,1377,1,1410,1,1658,1,1,1,1,1,1,1656,1,1,1,1656,1,
1,1,1,1,1370,1646,1,1,1,1,1,1,1059,1,1,1,1,1,1,1,1,1,
1352,1,1,1,1,1,1,1,1,1,1,1,1642,1,1,1,1,1352,1,1,1,1,
1,1,1,1,1642,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1704,
1333,1,1379,1,1695,261,261,424,261,424,416,261,424,416,347,
1251,1129,1251,1251,1251,1507,1,1,1333,1218,1218,1619,1333,1,
1,1378,1636,1,1129,1333,1,1218,1,1218,1619,1333,1,1,1,1378,
1,1,1,1,1495,1,1495,1,1,1,1,1,1,1,1,1,1379,1,1,1035,
1035,1042,1035,1042,1080,1035,1042,1080,1051,1627,1326,1627,
1360,1360,1651,1701,1701,1360,1410,1410,1,1627,1,1,1658,1,1,
1326,1360,1,1410,1,1410,1,1627,1,1,1,1658,1,1,1682,1,1370,
1,1656,1,1,1,1,1,1,1,1656,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,354,354,
418,354,418,297,354,418,297,419,1379,1153,1379,1379,1379,1476,
1645,1645,1323,1177,1177,1605,1323,1382,1,1382,1,1,1153,1323,
1,1177,1,1177,1605,1323,1,1382,1,1382,1,1,1670,1,1,1,1536,
1,1536,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1073,1,1,1,1,1,
1,1,1352,1,1,1,1,1,1,1,1,1,1,1,1,1,1642,1,1,1352,1,1,
1,1,1,1,1,1,1,1,1642,1,1,1,1,1,1,1,1,1704,1,1,1,1,1,
1,1158,1158,1248,1201,1201,1248,1277,1171,1171,784,673,784,
784,784,1449,1,1,784,1081,1081,1,795,1063,1,1,1481,1,673,
784,1,1081,1,1081,1,795,1,1063,1,1,1,1,1,1,669,1,1,1,
666,1,1,1,1,1,669,1158,1158,1158,1263,1248,1201,1201,1282,
784,673,784,784,784,1449,1,1,784,1081,1081,1467,795,1053,1,
1053,1481,1,673,784,1,1081,1,1081,1467,795,1,1053,1,1053,1,
1,1532,1,1,1,669,1,669,1,1,1,1,1,1,1201,1372,1201,1277,
1220,1314,1220,985,823,985,985,985,1470,1,1,985,1092,1092,
1588,994,1087,1,1,1583,1,823,985,1,1092,1,1092,1588,994,1,
1087,1,1,1,1,1,1,1,1,1,1,754,1,1,1,1,1,1,1158,1201,
1158,1158,1263,1282,784,673,784,784,784,1449,1467,1467,784,
1081,1081,1,795,1,1,1063,1,1,673,784,1,1081,1,1081,1,795,
1,1,1,1063,1,1,1,1,669,1,666,1,1,1,1,1,1,1,669,1201,
1201,1372,1201,1327,985,823,985,985,985,1470,1554,1554,985,
1092,1092,1554,994,1,1,1087,1497,1,823,985,1,1092,1,1092,
1554,994,1,1,1,1087,1,1,1,1,1,1,754,1,1,1,1,1,1,1,1,
1171,1314,1259,1171,1021,814,1021,1021,1021,1448,1585,1585,
1021,1020,1020,1552,1011,1098,1,1098,1,1,814,1021,1,1020,1,
1020,1552,1011,1,1098,1,1098,1,1,1565,1,1,1,738,1,738,1,1,
1,1,1,1,1158,1201,1171,784,673,784,784,784,1449,1,1,784,
1081,1081,1,795,1053,1,1063,1532,1,673,784,1,1081,1,1081,1,
795,1,1053,1,1063,1,1,1481,1,666,1,666,1,669,1,1,1,1,1,
666,1201,1220,985,823,985,985,985,1470,1588,1588,985,1092,
1092,1,994,1,1,1,1,1,823,985,1,1092,1,1092,1,994,1,1,1,
1,1,1,1497,1,754,1,701,1,1,1,1,1,1,1,754,1171,1021,814,
1021,1021,1021,1448,1552,1552,1021,1020,1020,1585,1011,1076,1,
1076,1501,1,814,1021,1,1020,1,1020,1585,1011,1,1076,1,1076,
1,1,1501,1,738,1,785,1,1,1,1,1,1,1,738,932,767,932,932,
932,1474,1,1,932,1097,1097,1,863,1,1,1078,1,1,767,932,1,
1097,1,1097,1,863,1,1,1,1078,1,1,1,1,1,1,705,1,1,1,1,1,
1,1,1,1270,1270,1562,1562,1562,1,1,1610,1384,1384,1632,1384,
1624,1,1,1632,1,1270,1610,1,1384,1,1384,1632,1384,1,1624,1,
1,1,1,1,1,1543,1,1,1,1543,1,1,1,1,1,1,1270,1270,1270,
1414,1529,1529,1270,1364,1364,1529,1270,1325,1,1325,1530,1,
1234,1270,1,1364,1,1364,1529,1270,1,1325,1,1325,1,1,1530,1,
1237,1,1237,1,1237,1,1,1,1,1,1237,1562,1562,1562,1,1,1610,
1384,1384,1632,1384,1624,1,1,1632,1,1270,1610,1,1384,1,1384,
1632,1384,1,1624,1,1,1,1,1,1,1543,1,1,1,1543,1,1,1,1,1,
1,1270,1562,1,1,1384,1384,1384,1632,1610,1,1,1624,1,1,1270,
1384,1,1384,1,1384,1632,1610,1,1,1,1624,1,1,1632,1,1,1,
1543,1,1,1,1,1,1,1,1543,1562,1,1,1384,1384,1384,1632,1610,
1,1,1624,1,1,1270,1384,1,1384,1,1384,1632,1610,1,1,1,1624,
1,1,1632,1,1,1,1543,1,1,1,1,1,1,1,1543,1597,1597,1562,
1562,1562,1597,1562,1649,1,1649,1,1,1414,1562,1,1562,1,1562,
1597,1562,1,1649,1,1649,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1529,1632,1680,1680,1680,1632,1,1,1,1,1,1529,1632,1,1680,1,
1680,1680,1632,1,1,1,1,1,1,1,1,1,1,1,1,1591,1,1,1,1,1,
1591,1632,1680,1680,1680,1632,1,1,1,1,1,1529,1632,1,1680,1,
1680,1680,1632,1,1,1,1,1,1,1,1,1,1,1,1,1591,1,1,1,1,1,
1591,1384,1384,1,1562,1,1,1624,1,1,1270,1270,1,1384,1,1384,
1,1562,1,1,1,1624,1,1,1632,1,1,1,1543,1,1,1,1,1,1,1,
1543,1364,1680,1384,1395,1,1395,1597,1,1364,1384,1,1364,1,
1364,1680,1384,1,1395,1,1395,1,1,1597,1,1312,1,1305,1,1312,
1,1,1,1,1,1305,1680,1384,1395,1,1395,1597,1,1364,1384,1,
1364,1,1364,1680,1384,1,1395,1,1395,1,1,1597,1,1312,1,1305,
1,1312,1,1,1,1,1,1305,1,1,1,1,1,1,1529,1,1,1680,1,1680,
1529,1,1,1,1,1,1,1,1,1,1591,1,1,1,1,1,1,1,1,1,1591,
1624,1,1,1632,1,1270,1562,1,1384,1,1384,1,1270,1,1624,1,1,
1,1,1,1,1537,1,1,1,1537,1,1,1,1,1,1,1,1649,1,1,1325,1,
1,1395,1,1395,1,1624,1,1324,1,1649,1,1,1681,1,1,1,1626,1,
1,1,1,1,1,1,1626,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1681,1,1325,1624,1,1395,1,
1395,1,1,1,1649,1,1324,1,1,1,1,1626,1,1,1,1626,1,1,1,1,
1,1,1,1530,1,1,1597,1,1597,1,1632,1,1,1,1681,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1270,1,1364,1,1364,1529,1270,1,
1325,1,1325,1,1,1530,1,1237,1,1237,1,1237,1,1,1,1,1,1237,
1,1384,1,1384,1,1562,1,1,1,1624,1,1,1632,1,1,1,1543,1,1,
1,1,1,1,1,1543,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1364,1680,1384,1,1395,1,1395,1,1,1597,1,
1312,1,1305,1,1312,1,1,1,1,1,1305,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1680,1384,1,1395,1,1395,1,1,
1597,1,1312,1,1305,1,1312,1,1,1,1,1,1305,1,1,1,1,1,1,1,
1,1,1591,1,1,1,1,1,1,1,1,1,1591,1,1624,1,1,1,1,1,1,
1537,1,1,1,1537,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1649,1,1,1681,1,1,1,1626,1,1,1,1,1,1,1,
1626,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1626,1,
1,1,1626,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1656,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1656,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1363,1363,1,1692,
1379,1,1379,1,1,585,585,594,585,594,558,585,594,558,596,
1333,1333,1181,1209,1387,1209,1,1,1333,1387,1575,1403,1387,
1690,1,1,1,1,1333,1181,1690,1209,1,1387,1,1209,1403,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1363,1,1363,1363,1,1608,
1,1,585,585,594,585,594,558,585,594,558,596,1333,1333,1181,
1232,1379,1232,1,1,1333,1379,1651,1,1379,1,1,1,1,1,1333,
1181,1,1232,1,1379,1,1232,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1394,1379,1507,1394,1379,1640,1640,849,849,678,
849,678,775,849,678,775,845,1548,1548,1256,1377,1542,1377,1,
1618,1322,1318,1525,1,1318,1561,1,1,1400,1580,1322,1256,1561,
1377,1400,1542,1,1377,1,1,1618,1,1602,1639,1639,1556,1380,
1342,1342,1321,1380,1556,1380,1380,1321,1342,1342,1,1640,1640,
1,1,1,1,1,1066,1,1056,1,1,1039,1,1099,1,1,1349,1,1660,1,
1,1671,1,1404,1675,1,1404,1,1,1,1,1,1,1349,1,1,1,1660,1,
1,1,1,1671,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1363,1,
1379,1,1,585,585,594,585,594,558,585,594,558,596,1333,1333,
1181,1209,1387,1209,1,1403,1333,1387,1575,1,1387,1,1690,1690,
1,1,1333,1181,1,1209,1,1387,1,1209,1,1,1403,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1640,1379,1394,1394,849,849,678,849,
678,775,849,678,775,845,1322,1322,1256,1377,1318,1377,1,1,
1548,1542,1525,1618,1542,1,1561,1561,1639,1602,1548,1256,1,
1377,1639,1318,1,1377,1618,1,1,1,1580,1400,1400,1321,1342,
1380,1380,1556,1342,1321,1342,1342,1556,1380,1380,1,1,1,1,
1108,1067,1,1047,1,1,1039,1,1094,1,1,1349,1,1707,1,1,1,1,
1404,1675,1,1404,1,1,1,1,1,1,1349,1,1,1,1707,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,560,560,507,560,
507,343,560,507,343,584,1387,1387,1168,1168,1387,1168,1,1401,
1387,1387,1651,1401,1387,1684,1684,1684,1,1676,1387,1168,1684,
1168,1,1387,1,1168,1401,1,1401,1,1676,1,1,1,1,1,1,1551,1,
1551,1,1,1,1,1,1640,1,1,1039,1,1056,1,1,1066,1,1099,1,1,
1349,1,1404,1,1,1,1,1660,1675,1671,1660,1,1,1,1,1,1,1349,
1,1,1,1404,1,1,1671,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1039,1108,1047,1,1,1067,1,1094,1,1,1349,1,1404,1,
1,1,1,1707,1675,1,1707,1,1,1,1,1,1,1349,1,1,1,1404,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1191,1191,1338,
1171,1171,1338,1295,1215,1215,962,962,823,1092,1019,1092,1,1,
962,1019,1510,1065,1019,1558,1,1,1,1,962,823,1558,1092,1,
1019,1,1092,1065,1,1,1,1,1,1,1,622,1,1,1,1,1,1,622,1,
622,622,1191,1191,1191,1309,1338,1171,1171,1348,962,962,823,
1092,1019,1092,1,1,962,1019,1510,1071,1019,1586,1,1,1,1,962,
823,1586,1092,1,1019,1,1092,1071,1,1,1,1,1,1,1,1,1,1,1,
622,1,622,1,1,1,1,1171,1248,1171,1295,1158,1255,1158,810,
810,673,1091,778,1091,1,1,810,778,1434,1053,778,1467,1,1,
1048,1435,810,673,1467,1091,1048,778,1,1091,1053,1,1,1,1435,
1040,1040,726,593,602,602,695,592,726,592,593,674,593,593,
1191,1171,1191,1191,1309,1348,962,962,823,1092,1019,1092,1,
1071,962,1019,1510,1,1019,1,1586,1586,1,1,962,823,1,1092,1,
1019,1,1092,1,1,1071,1,1,1,1,1,1,622,622,1,1,1,1,1,1,1,
1,1171,1171,1248,1171,1277,810,810,673,1091,778,1091,1,1063,
810,778,1434,1063,778,1,1,1,1064,1454,810,673,1,1091,1064,
778,1,1091,1063,1,1063,1,1454,1064,1064,695,602,593,593,726,
593,726,593,602,695,602,602,1215,1255,1269,1215,951,951,716,
1024,922,1024,1,1072,951,922,1436,1072,922,1503,1504,1504,1,
1,951,716,1503,1024,1,922,1,1024,1072,1,1072,1,1,1,1,719,
1,1,1,719,1,1,1,1,786,1,1,1191,1171,1215,962,962,823,1092,
1019,1092,1,1065,962,1019,1510,1,1019,1,1558,1558,1,1,962,
823,1,1092,1,1019,1,1092,1,1,1065,1,1,1,1,1,622,1,1,1,1,
1,1,622,1,622,622,1171,1158,810,810,673,1091,778,1091,1,
1053,810,778,1434,1,778,1,1467,1467,1040,1435,810,673,1,1091,
1040,778,1,1091,1,1,1053,1,1435,1048,1048,674,593,592,592,
726,602,695,602,593,726,593,593,1215,951,951,716,1024,922,
1024,1,1072,951,922,1436,1072,922,1504,1503,1503,1,1,951,716,
1504,1024,1,922,1,1024,1072,1,1072,1,1,1,1,786,1,1,1,1,1,
719,1,1,719,1,1,1003,1003,823,1106,974,1106,1,1,1003,974,
1510,1,974,1574,1574,1574,1070,1512,1003,823,1574,1106,1070,
974,1,1106,1,1,1,1,1512,1070,1070,889,606,628,628,807,628,
807,628,606,889,606,606,1270,1270,1384,1384,1384,1,1,1610,
1562,1562,1624,1562,1632,1,1,1643,1,1610,1270,1632,1384,1643,
1384,1,1384,1624,1,1,1,1650,1,1,1,1350,1,1,1611,1350,1,
1350,1350,1611,1,1,1270,1384,1384,1384,1,1,1610,1562,1562,
1624,1562,1632,1,1,1643,1,1610,1270,1632,1384,1643,1384,1,
1384,1624,1,1,1,1650,1,1,1,1350,1,1,1611,1350,1,1350,1350,
1611,1,1,1364,1270,1364,1,1325,1270,1270,1414,1325,1270,1529,
1529,1529,1357,1506,1270,1234,1529,1364,1357,1270,1,1364,1325,
1,1325,1,1506,1357,1357,1245,1186,1186,1186,1245,1186,1245,
1186,1186,1245,1186,1186,1384,1364,1,1395,1384,1384,1562,1395,
1384,1680,1680,1680,1,1597,1384,1364,1680,1364,1,1384,1,1364,
1395,1,1395,1,1597,1,1,1312,1,1,1,1312,1,1312,1,1,1312,1,
1,1384,1,1,1562,1610,1562,1624,1610,1,1632,1632,1675,1675,
1562,1270,1,1384,1675,1270,1,1384,1624,1,1,1,1597,1407,1407,
1372,1372,1389,1389,1569,1372,1372,1372,1372,1569,1389,1389,1,
1395,1384,1384,1562,1395,1384,1680,1680,1680,1,1597,1384,1364,
1680,1364,1,1384,1,1364,1395,1,1395,1,1597,1,1,1312,1,1,1,
1312,1,1312,1,1,1312,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1624,1624,1649,1649,1624,1,1,1,1677,1,1624,1325,1,1395,1677,
1,1,1395,1649,1,1324,1,1671,1,1,1,1378,1,1,1651,1378,1,
1378,1378,1633,1408,1408,1384,1562,1,1384,1,1632,1632,1,1650,
1270,1270,1,1384,1,1562,1,1384,1,1,1624,1,1,1643,1643,1611,
1,1350,1350,1,1,1611,1,1,1,1350,1350,1562,1,1270,1632,1,1,
1407,1597,1384,1270,1632,1384,1407,1610,1,1384,1,1,1624,1,
1675,1675,1675,1569,1389,1372,1372,1372,1389,1569,1389,1389,
1372,1372,1372,1649,1562,1597,1597,1597,1671,1,1562,1414,1597,
1562,1671,1562,1,1562,1649,1,1649,1,1,1671,1671,1,1564,1564,
1564,1,1564,1,1564,1564,1,1564,1564,1,1,1,1,1,1671,1,1325,
1,1395,1,1624,1,1395,1324,1,1649,1,1,1677,1677,1633,1408,
1378,1378,1,1,1651,1,1408,1,1378,1378,1632,1,1,1407,1597,
1384,1270,1632,1384,1407,1610,1,1384,1,1,1624,1,1675,1675,
1675,1569,1389,1372,1372,1372,1389,1569,1389,1389,1372,1372,
1372,1680,1680,1,1696,1,1529,1529,1680,1,1,1,1680,1,1,1,1,
1,1703,1703,1634,1,1683,1683,1,1,1634,1,1,1,1683,1683,1529,
1703,1,1632,1529,1680,1680,1703,1632,1,1680,1,1,1,1,1696,1,
1,1,1683,1,1,1634,1683,1,1683,1683,1634,1,1,1703,1,1632,
1529,1680,1680,1703,1632,1,1680,1,1,1,1,1696,1,1,1,1683,1,
1,1634,1683,1,1683,1683,1634,1,1,1675,1,1357,1,1,1357,1675,
1,1,1,1,1677,1,1,1,1,1629,1,1,1,1,1,1629,1,1,1,1,1,
1650,1506,1696,1597,1675,1675,1,1597,1671,1,1,1,1,1,1,1,
1576,1,1,1,1576,1,1576,1576,1,1,1,1270,1,1384,1,1562,1,
1384,1,1,1624,1,1,1643,1643,1611,1,1350,1350,1,1,1611,1,1,
1,1350,1350,1529,1364,1357,1270,1,1364,1325,1,1325,1,1506,
1357,1357,1245,1186,1186,1186,1245,1186,1245,1186,1186,1245,
1186,1186,1680,1,1,1,1680,1,1,1,1,1,1703,1703,1634,1,1683,
1683,1,1,1634,1,1,1,1683,1683,1,1384,1,1364,1395,1,1395,1,
1597,1,1,1312,1,1,1,1312,1,1312,1,1,1312,1,1,1675,1,1,1,
1,1677,1,1,1,1,1629,1,1,1,1,1,1629,1,1,1,1,1,1,1384,
1624,1,1,1,1597,1407,1407,1372,1372,1389,1389,1569,1372,1372,
1372,1372,1569,1389,1389,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1395,1,1395,1,1597,1,1,1312,1,1,1,1312,1,1312,
1,1,1312,1,1,1,1649,1,1,1677,1677,1633,1408,1378,1378,1,1,
1651,1,1408,1,1378,1378,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1671,1,1,1,1378,1,1,1651,1378,1,1378,1378,1633,1408,
1408,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1675,1675,1,1,1576,
1576,1,1,1,1,1,1,1576,1576,1357,1,1,1,1,1629,1,1,1,1,
1629,1,1,1,1,1,1,1629,1,1,1,1,1629,1,1,1372,1,1,1,1549,
1556,1549,1372,1,1,1,1,1,1,1380,1549,1380,1186,1,1,1,1186,
1372,1,1,1,1,1549,1380,1380,1372,1,1,1,1,1549,1380,1380,1,
1,1,1,1556,1549,1549,1372,1186,1380,1,1,1,1372,1549,1,1,1,
1380,1,1,1,1,1,1,1372,1372,1186,1324,1,1649,1649,1680,1649,
1,1,1038,1038,1062,1038,1062,1089,1038,1062,1089,1016,1181,
1181,1357,1181,1340,1209,1,1,1181,1357,1209,1,1407,1,1,1,1,
1,1181,1340,1374,1209,1,1292,1,1196,1,1374,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1625,1625,1625,1,1649,1649,1680,1649,1,1,
1038,1038,1062,1038,1062,1089,1038,1062,1089,1016,1181,1181,
1357,1181,1340,1209,1,1,1181,1357,1209,1,1407,1,1,1,1,1,
1181,1340,1374,1209,1,1292,1,1196,1,1374,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1625,1625,1625,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1649,
1,1649,1,1,1425,1425,1509,1425,1509,1509,1425,1509,1509,1459,
1415,1507,1507,1415,1507,1507,1,1,1507,1507,1507,1652,1507,
1652,1652,1,1,1,1415,1507,1,1507,1,1507,1652,1507,1,1,1652,
1652,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1324,1680,1,1062,
1062,1050,1062,1050,1057,1062,1050,1057,1031,1181,1209,1340,
1181,1357,1181,1,1,1209,1340,1196,1368,1292,1,1368,1,1,1,
1181,1357,1,1181,1,1407,1,1209,1355,1,1,1368,1,1,1,1,1,1,
1,1,1625,1625,1625,1,1,1,1,1,1,1,1,1488,1,1496,1,1,1,
1500,1,1545,1534,1,1549,1534,1,1,1,1,1587,1549,1572,1593,
1546,1630,1,1,1,1,1,1595,1523,1555,1,1594,1587,1547,1,1688,
1607,1667,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1680,1,1062,
1062,1050,1062,1050,1057,1062,1050,1057,1031,1181,1209,1340,
1181,1357,1181,1,1,1209,1340,1196,1368,1292,1,1368,1,1,1,
1181,1357,1,1181,1,1407,1,1209,1355,1,1,1368,1,1,1,1,1,1,
1,1,1625,1625,1625,1,1,1,1,1,1488,1,1,1535,1500,1498,1,
1524,1573,1503,1534,1,1,1534,1549,1,1,1,1555,1595,1547,1,
1594,1665,1499,1,1,1,1,1549,1,1587,1,1546,1601,1572,1523,
1669,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
637,637,1112,655,655,1112,1130,641,641,2,19,308,2,308,22,1,
1,19,308,16,181,276,182,185,1,586,1,2,308,1,22,1,276,1,7,
87,87,211,1,1,588,1,1,1,1,1,1,246,250,241,1,246,241,252,
637,637,637,1123,1112,655,655,1117,2,19,308,2,308,22,1,1,
19,308,16,185,276,211,1,1,1,1,2,308,87,22,1,276,182,7,1,
1,1,1,1,1,1,1,1,1,1,1,250,1,246,1,241,252,1,655,1183,
655,1130,663,1157,663,19,42,516,19,516,41,1,1,42,516,29,
231,446,199,1,1,1,1,19,516,1,41,1,446,1,24,1,208,1,1,1,
1,1,1,1,1,1,1,322,1,291,1,291,335,383,637,655,637,637,
1123,1117,2,19,308,2,308,22,1,1,19,308,16,1,276,1,1,1,1,
1,2,308,1,22,1,276,211,7,107,1,195,196,1,1,1,1,1,1,1,1,
1,252,250,1,252,1,250,655,655,1183,655,1138,19,42,516,19,
516,41,1,1,42,516,29,1,446,1,1,1,1,1,19,516,208,41,1,
446,199,24,175,176,200,205,1,1,1,1,1,1,1,1,1,383,322,1,
335,383,1,641,1157,1138,641,13,40,427,13,427,28,1,1,40,427,
10,162,373,1,1,1,1,1,13,427,132,28,1,373,168,18,133,1,
172,209,1,635,1,1,1,1,1,1,321,1,367,1,357,336,1,637,655,
641,2,19,308,2,308,22,1,1,19,308,16,1,276,195,196,1,588,
1,2,308,1,22,1,276,1,7,1,107,1,181,1,586,1,1,1,1,1,1,
252,241,1,1,1,250,246,655,663,19,42,516,19,516,41,1,1,42,
516,29,1,446,200,205,1,1,1,19,516,176,41,1,446,1,24,1,1,
230,207,1,1,1,1,1,1,1,1,383,335,1,1,383,1,322,641,13,40,
427,13,427,28,1,1,40,427,10,1,373,172,209,1,635,1,13,427,
1,28,1,373,1,18,173,1,158,170,1,1,1,1,1,1,1,1,1,336,
321,1,336,1,321,3,23,404,3,404,26,1,1,23,404,15,1,278,1,
1,1,534,1,3,404,1,26,1,278,1,8,1,1,1,149,1,534,1,1,1,
1,1,1,254,257,279,1,273,257,254,1000,1000,1110,1000,1000,1,
1,1129,1129,1000,1160,1000,1179,1179,1,1330,1,1110,1129,1151,
1129,1,1000,1160,1000,1243,1243,1182,1182,1,1330,1,1,1,1,1,
1,1235,1,1235,1,1235,1235,1,1000,1000,1000,1168,1,1,1181,
1090,1090,1282,1165,1204,1,1,1351,1,1129,1181,1176,1090,1,
1090,1282,1165,1176,1204,1,1,1,1,1,1,1,1,1,1,1242,1,1247,
1,1247,1,1242,1000,1168,1000,1,1,1181,1371,1165,1172,1371,
1296,1,1,1,1,1129,1181,1286,1090,1,1165,1172,1090,1176,1204,
1,1,1,1,1,1,1,1,1,1,1,1,1161,1,1531,1294,1294,1000,1000,
1,1,1000,1000,1122,1179,1122,1182,1182,1,1,1,1110,1000,1243,
1000,1,1122,1179,1122,1151,1,1160,1160,1,1,1,1,1,1,1,1,1,
1235,1235,1,1235,1,1235,1000,1,1,1090,1181,1090,1189,1165,1,
1204,1,1,1,1129,1371,1176,1181,1,1371,1189,1165,1286,1213,
1213,1286,1,1,1,1,1,1,1,1,1294,1294,1531,1,1161,1,1,1,1,
1090,1181,1165,1105,1090,1,1296,1,1,1,1129,1090,1286,1181,1,
1165,1105,1090,1286,1213,1286,1213,1,1351,1,1,1,1,1,1,1,
1242,1247,1,1247,1242,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1000,1090,1,1090,1,1,1,1,1,1000,
1000,1204,1168,1,1165,1204,1165,1,1,1282,1282,1,1351,1,1,1,
1,1,1,1,1247,1242,1,1,1242,1247,1090,1,1371,1,1,1,1,1,
1000,1168,1204,1000,1,1165,1296,1165,1,1174,1172,1172,1,1,1,
1,1,1,1,1,1,1161,1,1,1294,1294,1531,1,1000,1104,1104,1,
1367,1,1000,1165,1,1165,1,1000,1,1122,1197,1260,1197,1266,1,
1367,1,1,1,1,1,1,1246,1,1240,1,1,1246,1240,1,1,1,1,1,1,
1182,1204,1345,1296,1,1,1182,1,1403,1359,1520,1,1,1662,1,1,
1,1,1,1,1,1299,1,1,1,1485,1341,1171,1171,1,1210,1,1000,
1165,1,1165,1,1122,1,1000,1197,1260,1266,1197,1,1575,1,1,1,
1,1,1,1163,1152,1152,1,1289,1489,1289,1182,1,1,1,1160,1213,
1213,1286,1,1185,1347,1255,1,1378,1347,1520,1,1392,1,1,1,1,
1,1,1,1329,1466,1,1207,1300,1,1,1,1,1160,1286,1213,1213,1,
1185,1520,1255,1,1345,1,1,1,1,1,1,1,1,1,1,1,1,1284,1,
1341,1,1485,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1330,1,1657,1351,1,1575,1397,1367,1,
1,1579,1402,1,1,1,1,1,1,1,1,1,1354,1354,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1000,1,1000,1,1000,1182,1000,1,1151,1179,1179,1,1330,1,1,1,
1,1,1,1235,1235,1,1,1,1235,1235,1213,1000,1,1371,1,1090,
1174,1,1189,1189,1,1,1,1,1,1,1,1,1294,1531,1294,1,1,1,
1161,1213,1,1,1378,1,1,1317,1,1359,1,1376,1,1,1,1,1,1,
1483,1313,1,1,1,1287,1,1,1090,1,1090,1,1,1105,1105,1,1,1,
1,1,1,1,1,1242,1247,1,1,1242,1,1247,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1000,1195,1173,1,1195,1,
1210,1,1,1,1,1,1,1489,1289,1289,1,1152,1163,1152,1,1358,1,
1347,1,1,1,1,1,1,1,1,1,1329,1466,1,1,1300,1,1205,1195,
1173,1195,1,1,1367,1,1,1,1,1,1,1246,1240,1,1,1240,1246,1,
1,1197,1197,1,1,1,1,1,1,1,1,1267,1278,1,1,1,1313,1483,
1213,1213,1,1,1,1,1,1,1,1,1,1483,1313,1,1267,1,1287,1182,
1,1,1,1,1,1,1,1,1466,1,1329,1,1285,1207,1300,1,1,1,1,1,
1,1,1,1284,1,1,1,1485,1341,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1354,1,1354,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1294,1294,1,1,1,1,1289,1,1,1,1,1,1,1,1,1,1,1,1294,1289,
1294,1,1649,1649,1680,1649,1,1,1038,1038,1062,1038,1062,1089,
1038,1062,1089,1016,1181,1181,1357,1181,1340,1209,1,1,1181,
1357,1209,1,1407,1,1,1,1,1,1181,1340,1374,1209,1,1292,1,
1196,1,1374,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1625,1625,1625,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1324,1,1649,1,1680,1038,1038,1062,
1038,1062,1089,1038,1062,1089,1016,1181,1181,1340,1181,1357,
1209,1374,1,1181,1340,1209,1,1292,1,1,1374,1,1,1181,1357,1,
1209,1,1407,1,1196,1,1,1,1,1,1,1,1625,1625,1,1,1,1,1,1,
1625,1,1,1,1,1649,1,1680,1038,1038,1062,1038,1062,1089,1038,
1062,1089,1016,1181,1181,1340,1181,1357,1209,1374,1,1181,1340,
1209,1,1292,1,1,1374,1,1,1181,1357,1,1209,1,1407,1,1196,1,
1,1,1,1,1,1,1625,1625,1,1,1,1,1,1,1625,1,1,1,1,1,1,1,
1496,1500,1488,1,1,1,1,1,1545,1555,1,1549,1587,1595,1,1593,
1587,1534,1549,1555,1,1546,1,1,1667,1,1,1,1,1499,1572,1,
1594,1,1559,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1448,1448,1472,1448,1472,1448,1448,1472,1448,1472,1507,1447,
1507,1507,1507,1447,1566,1566,1447,1507,1476,1,1507,1,1,1566,
1,1,1507,1507,1566,1447,1,1507,1,1476,1566,1566,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1488,1,1496,1,
1,1,1500,1,1545,1,1534,1,1587,1549,1572,1,1,1,1595,1555,1,
1594,1,1,1499,1,1,1555,1549,1667,1,1,1546,1,1559,1587,1593,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,637,637,1112,655,
655,1112,1130,641,641,19,2,308,19,308,16,1,1,2,308,22,1,
276,1,1,1,1,1,19,308,196,16,586,276,1,6,1,181,1,1,1,1,
1,1,252,1,1,1,1,1,1,241,241,246,250,637,637,637,1123,1112,
655,655,1117,19,2,308,19,308,16,1,211,2,308,22,1,276,1,1,
185,1,1,19,308,181,16,1,276,1,6,182,185,1,1,586,1,588,
250,1,1,1,1,1,1,1,252,246,250,1,655,1183,655,1130,663,
1157,663,42,19,516,42,516,29,1,1,19,516,41,1,446,1,1,1,1,
1,42,516,207,29,623,446,1,39,1,231,1,1,623,1,1,1,383,1,
1,1,1,1,1,335,291,322,1,637,655,637,637,1123,1117,19,2,
308,19,308,16,185,182,2,308,22,1,276,1,1,181,1,586,19,308,
185,16,588,276,1,6,211,1,1,1,1,1,1,246,250,1,1,1,1,1,1,
1,250,1,252,655,655,1183,655,1138,42,19,516,42,516,29,1,
199,19,516,41,1,446,1,1,231,1,1,42,516,231,29,597,446,1,
39,199,1,1,1,1,1,597,322,1,1,1,1,1,1,1,383,322,1,383,
641,1157,1138,641,40,13,427,40,427,10,1,1,13,427,28,1,373,
1,1,162,1,1,40,427,169,10,1,373,1,31,168,162,1,1,1,1,
629,321,1,1,1,1,1,1,1,336,367,321,1,637,655,641,19,2,308,
19,308,16,181,1,2,308,22,1,276,1,1,196,1,1,19,308,1,16,
1,276,1,6,1,1,1,1,1,1,586,241,246,1,1,1,1,1,1,250,1,
252,241,655,663,42,19,516,42,516,29,231,1,19,516,41,1,446,
1,1,207,1,623,42,516,1,29,1,446,1,39,1,1,1,1,1,1,623,
291,322,1,1,1,1,1,1,1,1,383,335,641,40,13,427,40,427,10,
162,168,13,427,28,1,373,1,1,169,1,1,40,427,162,10,629,373,
1,31,1,1,1,1,1,1,1,367,321,1,1,1,1,1,1,1,321,1,336,23,
3,404,23,404,15,1,1,3,404,26,1,278,1,1,183,1,538,23,404,
183,15,534,278,1,12,1,1,1,1,538,1,534,279,254,1,1,1,1,1,
1,257,279,254,257,1000,1000,1181,1090,1090,1,1,1129,1181,
1090,1,1090,1,1,1,1,1,1181,1181,1,1153,1351,1032,1,1032,
1282,1282,1,1,1365,1,1,1,1247,1,1,1,1,1,1,1242,1247,1242,
1,1000,1000,1000,1122,1182,1182,1110,1000,1000,1,1122,1,1,
1179,1,1,1129,1129,1160,1000,1330,1000,1,1122,1179,1179,1,1,
1330,1,1330,1,1235,1,1,1,1,1,1,1235,1235,1,1235,1090,1181,
1090,1,1,1129,1371,1181,1,1371,1,1,1,1,1,1181,1181,1286,
1032,1,1153,1,1032,1189,1189,1,1,1651,1,1,1,1161,1,1,1,1,
1,1,1,1531,1294,1294,1000,1090,1,1204,1000,1000,1168,1,1165,
1,1,1282,1,1351,1181,1090,1282,1090,1365,1165,1,1181,1204,1,
1,1,1351,1,1365,1242,1,1,1,1,1,1,1,1247,1242,1,1247,1090,
1204,1,1000,1168,1000,1,1165,1,1,1189,1,1,1181,1371,1172,
1165,1651,1371,1,1181,1296,1,1,1,1,1,1212,1294,1294,1,1,1,
1,1,1,1531,1,1,1161,1104,1104,1000,1165,1165,1,1000,1,1,1,
1,1367,1153,1032,1266,1153,1361,1153,1,1032,1,1,1,1,1361,1,
1,1246,1,1,1,1,1,1,1,1240,1240,1246,1,1182,1179,1,1296,1,
1171,1,1,1,1,1,1282,1189,1,1,1402,1,1,1167,1346,1,1,1,
1662,1,1,1,1,1,1,1,1,1,1,1299,1485,1,1341,1179,1296,1,1,
1171,1,1,1,1,1,1282,1189,1,1,1579,1,1,1167,1516,1346,1,1,
1,1,1,1,1329,1,1,1,1,1,1,1466,1285,1298,1205,1000,1000,1,
1000,1,1,1160,1,1330,1000,1000,1179,1122,1330,1122,1,1122,
1182,1182,1,1,1,1,1330,1235,1,1,1,1,1,1,1,1235,1,1235,
1235,1000,1,1371,1,1,1172,1,1,1090,1181,1189,1090,1212,1165,
1,1181,1,1204,1,1,1,1,1651,1,1,1,1,1,1,1,1,1161,1294,
1294,1531,1,1090,1,1,1105,1,1,1090,1181,1105,1165,1365,1090,
1,1181,1,1296,1,1,1,1,1365,1,1242,1,1,1,1,1,1,1247,1,
1242,1247,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1210,1032,1153,1195,
1153,1198,1153,1,1032,1,1,1,1,1381,1,1381,1163,1152,1,1,1,
1,1,1,1152,1289,1489,1289,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1286,1226,1266,1,1195,1,1226,1,1,1,1,1,1,1,1,1299,1,1,1,
1,1,1,1,1341,1485,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1365,1651,1,1361,1381,1381,1,
1343,1,1662,1,1,1,1,1,1,1354,1,1,1,1,1,1,1354,1,1,1,
1000,1,1090,1,1090,1,1032,1,1,1,1,1,1,1351,1247,1242,1,1,
1,1,1,1,1,1,1247,1242,1,1090,1,1371,1,1032,1,1,1,1,1,1,
1,1531,1294,1,1,1,1,1,1,1294,1,1161,1,1,1,1,1,1226,1,1,
1,1,1,1,1,1341,1485,1,1,1,1,1,1,1,1,1299,1,1,1000,1,
1032,1104,1104,1,1,1367,1,1361,1240,1246,1,1,1,1,1,1,1,
1246,1,1240,1381,1,1,1,1,1,1,1,1,1,1354,1354,1,1,1,1,1,
1,1,1,1,1,1,1032,1171,1171,1,1,1210,1,1198,1289,1489,1,1,
1,1,1,1,1289,1163,1152,1152,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1167,1167,1,1,1343,1,1,1238,1238,1,1,1,1,
1,1,1,1238,1238,1,1182,1,1,1,1,1579,1285,1298,1,1,1,1,1,
1,1205,1,1329,1466,1,1,1,1,1402,1485,1,1,1,1,1,1,1,1341,
1,1,1299,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1381,1,1,1,1,1,1,1,1,1,1,1354,
1354,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1354,1354,1,1294,1,1,1,1,1,1,1289,1,1,1,1,1,1,1,1,1,
1294,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1294,
1289,1294,1680,1691,1691,1680,1,1,1,1,1092,1,1092,1109,1101,
1102,1,1024,1,1,1380,1,1386,1,1,1304,1,1380,1,1,1412,1304,
1,1,1,1,1229,1386,1,1,1,1309,1310,1,1,1409,1316,1,1,1,1,
1,1,1,1,1,1,1,1,1,1661,1661,1661,1649,1,1324,1,1,1062,
1062,1050,1062,1050,1057,1062,1050,1057,1031,1181,1209,1357,
1181,1340,1181,1,1355,1209,1357,1196,1,1407,1368,1,1,1,1,
1181,1340,1,1181,1,1292,1368,1209,1,1,1368,1,1,1,1,1,1,
1625,1625,1625,1,1,1,1,1,1,1,1691,1649,1691,1691,1509,1509,
1425,1509,1425,1457,1509,1425,1457,1509,1507,1507,1506,1507,
1506,1507,1,1576,1507,1506,1507,1,1597,1,1,1,1597,1597,1507,
1506,1,1507,1597,1597,1,1507,1576,1,1,1,1597,1597,1597,1563,
1563,1563,1563,1563,1563,1563,1563,1563,1563,1563,1563,1,1,1,
1,1,1102,1,1092,1,1,1102,1,1025,1229,1,1380,1,1386,1,1,1,
1,1380,1,1,1412,1411,1,1,1,1,1,1386,1304,1,1,1309,1,1,1,
1310,1,1,1,1,1,1,1,1661,1661,1661,1,1,1,1,1,1,1,1,1,
1062,1062,1050,1062,1050,1057,1062,1050,1057,1031,1181,1209,
1357,1181,1340,1181,1,1355,1209,1357,1196,1,1407,1368,1,1,1,
1,1181,1340,1,1181,1,1292,1368,1209,1,1,1368,1,1,1,1,1,1,
1625,1625,1625,1,1,1,1,1,1,1,1609,1,1,1613,1698,1623,1,1,
1641,1,1697,1,1,1640,1692,1640,1,1,1,1,1640,1692,1,1707,1,
1,1,1,1,1,1640,1,1,1,1640,1697,1692,1692,1697,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1613,1698,1623,1,1,1641,1,
1697,1,1,1640,1692,1640,1,1,1,1,1640,1692,1,1707,1,1,1,1,
1,1,1640,1,1,1,1640,1697,1692,1692,1697,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1187,1187,1328,1164,1164,1328,1249,1206,
1206,515,515,965,515,824,520,1,1,515,965,520,1,1107,803,1,
1,632,1,515,824,802,520,632,781,792,517,1,793,1,1,1,1,1,
1,618,1,1,1,618,1,1,1,968,968,1,1187,1187,1187,1328,1328,
1164,1164,1291,515,515,965,515,824,520,1,1,515,965,520,1,
1107,1,1,1,1,1,515,824,793,520,1,781,803,517,1,789,1,1,1,
1,1,1,1,1,1,1,1,1,618,618,968,1,1,1164,1236,1164,1249,
1160,1253,1160,323,323,768,323,676,316,1,1,323,768,316,1,
1029,693,1,1,566,566,323,676,696,316,566,736,696,319,564,
717,1,1,1463,1462,1462,546,542,791,791,782,542,546,542,542,
783,782,791,1187,1164,1187,1187,1328,1291,515,515,965,515,824,
520,1,803,515,965,520,1,1107,1,1,1,1,632,515,824,789,520,
631,781,1,517,633,1,788,1,1,1,1,618,1,1,1,1,1,618,1,1,
1,1,1,1164,1164,1236,1164,1244,323,323,768,323,676,316,1,
693,323,768,316,1,1029,1,1,1,566,566,323,676,717,316,575,
736,693,319,568,694,694,1,1461,1463,1462,542,546,791,782,791,
546,542,542,542,782,791,791,1206,1253,1328,1206,428,428,857,
428,739,420,1,794,428,857,420,1,1107,794,1,1,1,1,428,739,
722,420,1,801,728,422,1,1,1,1,1,1487,1486,1,1,1,1,1,1,1,
608,608,902,1,1,1187,1164,1206,515,515,965,515,824,520,1,
792,515,965,520,1,1107,788,1,1,631,1,515,824,1,520,1,781,
1,517,1,887,792,1,1,1,1,1,618,1,1,1,618,1,1,1,1,1,968,
1164,1160,323,323,768,323,676,316,1,696,323,768,316,1,1029,
694,1,1,575,566,323,676,694,316,575,736,1,319,1,1,717,1,
1463,1461,1463,542,542,782,783,791,542,542,546,546,791,791,
782,1206,428,428,857,428,739,420,1,728,428,857,420,1,1107,1,
1,1,1,1,428,739,1,420,1,801,794,422,1,730,720,1,1,1,1,
608,1,1,829,1,1,608,1,1,1,1,1,484,484,949,484,841,486,1,
796,484,949,486,1,1030,797,1,1,574,583,484,841,846,486,582,
736,796,463,1,1,1,1,1584,1550,1539,570,555,925,927,925,555,
570,570,570,927,925,925,1190,1190,1326,1294,1294,1,1,1326,
1175,1228,1,1228,1344,1,1,1372,1,1326,1478,1344,1326,1372,
1294,1507,1294,1396,1533,1,1,1622,1,1,1,1340,1,1,1184,1340,
1,1340,1340,1,1184,1,1190,1294,1294,1326,1,1,1326,1190,1190,
1,1228,1344,1,1,1372,1,1326,1478,1344,1294,1372,1294,1533,
1326,1387,1507,1,1,1,1,1,1,1340,1,1,1184,1340,1,1340,1340,
1,1,1184,1190,1256,1190,1,1289,1175,1395,1175,1,1395,1265,1,
1,1214,1214,1175,1256,1265,1190,1214,1256,1289,1190,1,1289,
1289,1,1597,1632,1632,1194,1194,1349,1349,1318,1194,1194,1194,
1194,1318,1349,1349,1294,1190,1,1344,1190,1190,1326,1,1228,1,
1,1,1,1372,1326,1294,1533,1294,1372,1478,1344,1326,1387,1,
1507,1,1622,1,1622,1340,1,1,1184,1,1,1340,1340,1340,1184,1,
1,1294,1,1,1294,1256,1294,1,1318,1,1,1,1395,1395,1478,1529,
1531,1478,1562,1529,1531,1478,1569,1543,1543,1,1541,1541,1541,
1364,1364,1273,1273,1273,1364,1364,1529,1529,1273,1273,1273,1,
1312,1228,1175,1326,1,1228,1,1,1,1,1372,1326,1294,1533,1326,
1372,1478,1312,1294,1396,1,1533,1,1,1622,1,1340,1,1184,1,1,
1,1340,1340,1340,1184,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1344,1265,1,1,1322,1,1,1,1399,1,1533,1531,1617,1533,1570,
1543,1543,1507,1598,1617,1618,1,1,1,1,1,1372,1,1,1288,1372,
1,1543,1543,1332,1332,1301,1190,1294,1,1228,1,1,1,1,1372,
1294,1294,1507,1326,1372,1478,1344,1326,1389,1389,1533,1,1,
1622,1,1340,1,1,1184,1,1,1340,1340,1340,1,1184,1,1190,1,
1395,1289,1,1,1214,1214,1190,1256,1289,1190,1214,1256,1265,
1175,1,1289,1289,1,1632,1632,1597,1194,1194,1349,1318,1349,
1194,1194,1194,1194,1349,1349,1318,1,1228,1312,1,1,1372,1,
1294,1478,1312,1326,1372,1294,1533,1326,1389,1533,1389,1,1,1,
1622,1,1340,1184,1,1,1340,1,1340,1340,1,1,1184,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1322,1,1,1233,1233,1228,1318,1322,1228,1233,1318,1322,
1228,1,1322,1322,1,1705,1705,1705,1230,1230,1404,1404,1404,
1230,1230,1230,1230,1404,1404,1404,1,1,1,1399,1507,1543,1543,
1533,1570,1531,1617,1533,1592,1658,1617,1,1,1637,1637,1372,1,
1,1288,1,1,1372,1543,1543,1301,1331,1331,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1395,1372,1395,1570,1372,1395,1562,1399,1372,1405,1,1570,1,
1,1,1,1384,1,1,1,1,1,1384,1384,1384,1,1,1,1372,1562,1399,
1372,1395,1395,1570,1372,1405,1570,1,1,1,1,1,1,1384,1,1,1,
1384,1,1384,1384,1,1,1,1294,1,1190,1,1294,1,1228,1,1344,
1344,1,1,1,1622,1340,1340,1184,1,1,1340,1340,1,1,1,1,1184,
1543,1294,1395,1529,1,1294,1377,1,1531,1,1541,1541,1541,1529,
1364,1273,1273,1273,1364,1529,1364,1364,1273,1273,1273,1,1,1,
1658,1,1,1617,1,1,1,1,1,1372,1543,1331,1331,1301,1543,1372,
1,1,1,1,1288,1,1294,1,1190,1,1312,1312,1,1,1,1,1340,1340,
1,1,1184,1340,1340,1,1,1,1,1184,1395,1,1,1,1399,1399,1,1,
1,1,1384,1384,1,1,1,1384,1384,1,1,1,1,1,1543,1294,1377,
1531,1,1,1541,1541,1541,1364,1529,1250,1250,1250,1529,1364,
1364,1364,1250,1250,1250,1,1,1,1617,1,1,1,1,1543,1372,1288,
1,1,1372,1543,1,1,1331,1331,1301,1,1344,1344,1,1622,1,1,
1340,1340,1,1,1184,1340,1340,1,1,1,1184,1,1389,1389,1,1,1,
1,1398,1398,1,1,1,1398,1398,1,1,1,1,1,1543,1,1,1,1637,
1543,1,1301,1331,1332,1,1543,1372,1372,1,1,1,1,1637,1,1,1,
1543,1,1,1,1543,1,1372,1372,1332,1301,1331,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1632,1705,1,1,1685,1,1,1,1,1,1,1,1,
1685,1632,1,1,1,1,1685,1,1,1,1,1,1,1685,1,1,1,1,1685,1,
1,1,1,1,1685,1,1364,1,1,1,1364,1178,1364,1364,1,1,1,1,1,
1,1178,1364,1364,1364,1,1,1,1349,1349,1,1,1,1,1614,1563,
1614,1404,1,1,1,1,1614,1614,1563,1,1,1,1,1563,1614,1614,
1364,1364,1364,1,1,1,1364,1364,1,1,1,1178,1,1,1,1,1,1,
1349,1404,1349,1,1,1680,1,1,1,1535,1524,1,1500,1573,1488,1,
1498,1503,1,1555,1549,1534,1595,1587,1669,1523,1,1549,1547,1,
1546,1499,1665,1,1,1,1534,1,1,1,1,1594,1,1572,1,1,1,1601,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1609,1,1,1,1,1698,1641,
1,1623,1,1,1613,1,1697,1,1,1640,1692,1640,1,1697,1692,1,
1640,1692,1,1640,1,1,1,1,1,1,1640,1,1,1,1707,1,1692,1,1,
1,1697,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1698,
1641,1,1623,1,1,1613,1,1697,1,1,1640,1692,1640,1,1697,1692,
1,1640,1692,1,1640,1,1,1,1,1,1,1640,1,1,1,1707,1,1692,1,
1,1,1697,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1571,
1505,1,1,1535,1502,1,1488,1504,1,1572,1549,1587,1,1534,1668,
1,1,1549,1559,1,1546,1,1664,1,1,1,1555,1595,1,1,1,1594,
1702,1555,1560,1606,1606,1560,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1221,
1221,1,1,523,1,523,1027,549,1,799,1,1,549,1,1,799,1,1,1,
1,525,1004,1049,1,1,1,1,1,553,972,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1492,1513,1,1,1319,1,1373,1171,1336,1171,1,1,905,
496,833,478,1,1,1,905,1,1,934,687,1,1,1,1,508,833,1,1,1,
815,1,1,1,954,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1352,1,1314,1,496,905,1,833,1,1,687,1,905,478,1,934,1,
1,1,1,1,460,833,1058,1,1,815,912,1,470,943,776,491,1,1,1,
1,1,1,1,1,1,1,1,1,1,1458,1,1216,1343,1,1216,1,567,996,
567,1,521,1,1,1,996,521,1,1,1,1,1,1,1,541,986,1075,1,1,
950,952,528,531,1022,819,529,1,1,1,1,1,1,1,1,1,1,1,1,
1513,1491,1,1,1,1216,1,454,1,435,924,492,611,686,1,906,461,
1,940,683,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1444,1442,1221,1171,1,469,926,489,827,1,
626,688,1,926,1,1,920,684,1,1,1,1,1,827,1037,1,1,816,1,
1,1,1,1,493,1,1,1,1,1,1,1,1,1,1,1,1,1,1441,1446,1,1,
483,935,494,1,434,1,681,1,936,456,1,1,681,634,1,1,1,466,
838,1,1,1,817,1,439,502,942,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1443,1,1,818,1,900,411,1,679,1,818,1,1,821,680,1,
1,1,1,1,900,1,1,1,702,850,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1445,1445,1445,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1385,1385,1352,1366,1366,1,1219,1219,1,1194,1303,
1,1,1,1,1352,1627,1326,1,1,1,1,1,1362,1642,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1617,1,1589,1219,1349,1219,1,1279,1,1395,
1194,1,1395,1262,1,1,1,1,1194,1349,1,1,1,1256,1279,1,1199,
1360,1262,1,1,1,1,1,1,1,1,1,1,1,1,1,1624,1582,1582,1385,
1219,1,1303,1,1,1352,1,1194,1366,1366,1,1,1,1,1,1685,1,1,
1590,1398,1352,1,1,1600,1362,1,1,1,1,1,1,1,1,1,1,1,1,
1589,1,1617,1,1389,1,1,1349,1,1,1318,1,1389,1,1,1,1627,
1660,1685,1,1,1660,1671,1627,1631,1675,1675,1631,1,1,1,1,1,
1,1,1,1,1,1,1,1,1633,1,1227,1303,1,1194,1,1,1,1,1355,1,
1,1,1352,1385,1638,1,1,1590,1398,1385,1356,1393,1600,1393,1,
1,1,1,1,1,1,1,1,1,1,1,1589,1617,1,1366,1,1,1355,1,1199,
1368,1,1,1,1,1,1,1658,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1663,1,1663,1,1262,1,1,1262,1,1368,1,1,1,
1517,1563,1658,1,1,1625,1625,1533,1521,1578,1671,1540,1,1,1,
1,1,1,1,1,1,1,1,1,1,1553,1553,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1219,1,1395,1279,1,1,1,1,1,1318,1398,1,1,1318,1320,1194,1,
1,1320,1199,1,1,1,1,1,1,1,1,1,1,1,1,1582,1582,1624,1,1,
1303,1227,1,1,1,1377,1627,1398,1,1,1377,1578,1352,1381,1674,
1381,1356,1,1,1,1,1,1,1,1,1,1,1,1,1,1617,1589,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1262,1199,1,1,1,1219,1349,1360,1,1,1318,1320,1219,
1224,1389,1320,1224,1,1,1,1,1,1,1,1,1,1,1,1,1582,1624,
1582,1366,1,1,1,1533,1627,1627,1,1,1548,1621,1517,1540,1642,
1557,1521,1,1,1,1,1,1,1,1,1,1,1,1,1553,1553,1,1,1,1,1,
1666,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1663,1,1663,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1377,1,1219,1,
1289,1379,1220,1,1,1,1,1,1,1,1,1,1,1,1,1,1589,1617,1627,
1,1,1660,1,1385,1,1,1671,1389,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1633,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1686,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1625,1,1380,1674,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1628,1596,
1596,1,1,1,1627,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1687,1687,
1220,1389,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1617,1589,1,1,
1381,1224,1,1,1,1,1,1,1,1,1,1,1,1,1,1603,1620,1675,1393,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1638,1,1,1,1,1,1,1,1,1,
1,1,1,1,1642,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1620,1603,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1582,1582,1582,1,1649,1,1680,1038,1038,1062,1038,1062,
1089,1038,1062,1089,1016,1181,1181,1340,1181,1357,1209,1374,1,
1181,1340,1209,1,1292,1,1,1374,1,1,1181,1357,1,1209,1,1407,
1,1196,1,1,1,1,1,1,1,1625,1625,1,1,1,1,1,1,1625,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1062,1062,1050,1062,1050,1057,1062,
1050,1057,1031,1181,1209,1357,1181,1340,1181,1,1355,1209,1357,
1196,1,1407,1368,1,1,1,1,1181,1340,1,1181,1,1292,1368,1209,
1,1,1368,1,1,1,1,1,1,1625,1625,1625,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1496,1500,1488,1,1,1,1,1,1545,1,1587,1595,1534,
1549,1555,1688,1,1,1,1572,1607,1594,1,1630,1523,1,1,1534,
1549,1,1,1,1546,1667,1547,1,1,1593,1587,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,637,637,1112,655,655,1112,1130,641,641,2,19,
308,2,308,22,107,1,19,308,16,1,276,196,195,1,586,1,2,308,
1,22,1,276,181,7,1,1,1,1,1,588,1,1,250,252,1,241,1,1,1,
246,1,1,1,637,637,637,1123,1112,655,655,1117,2,19,308,2,
308,22,1,107,19,308,16,195,276,1,1,1,1,1,2,308,1,22,1,
276,196,7,1,1,1,211,1,1,1,252,1,1,250,252,1,1,1,250,1,
1,1,655,1183,655,1130,663,1157,663,19,42,516,19,516,41,1,1,
42,516,29,230,446,205,200,176,1,1,19,516,1,41,1,446,207,
24,1,1,1,1,1,1,1,383,1,383,1,335,1,1,1,322,1,1,1,637,
655,637,637,1123,1117,2,19,308,2,308,22,1,1,19,308,16,1,
276,1,211,87,1,1,2,308,1,22,1,276,1,7,1,1,185,182,1,1,
1,241,252,250,246,1,1,1,1,1,1,1,1,655,655,1183,655,1138,
19,42,516,19,516,41,176,175,42,516,29,200,446,1,1,208,1,1,
19,516,1,41,1,446,205,24,1,1,1,199,1,1,1,335,383,1,322,
383,1,1,1,1,1,1,1,641,1157,1138,641,13,40,427,13,427,28,
1,173,40,427,10,158,373,209,172,1,1,1,13,427,1,28,1,373,
170,18,1,1,1,1,1,635,1,336,1,1,321,336,1,1,1,321,1,1,1,
637,655,641,2,19,308,2,308,22,87,87,19,308,16,211,276,185,
182,1,588,1,2,308,1,22,1,276,1,7,1,1,181,1,1,586,1,246,
241,246,241,250,1,1,1,252,1,1,1,655,663,19,42,516,19,516,
41,208,1,42,516,29,1,446,1,199,1,1,1,19,516,1,41,1,446,
1,24,1,1,231,1,1,1,1,291,335,322,291,1,1,1,1,383,1,1,1,
641,13,40,427,13,427,28,1,133,40,427,10,172,373,1,1,132,
635,1,13,427,1,28,1,373,209,18,1,1,162,168,1,1,1,357,336,
321,367,1,1,1,1,1,1,1,1,3,23,404,3,404,26,1,1,23,404,
15,1,278,1,1,1,534,1,3,404,1,26,1,278,149,8,1,1,1,1,1,
534,1,273,257,254,279,257,1,1,1,254,1,1,1,1000,1000,1110,
1000,1000,1151,1,1129,1129,1000,1179,1000,1160,1160,1,1330,1,
1110,1129,1,1129,1,1000,1179,1000,1,1,1182,1182,1,1330,1,1,
1235,1235,1,1235,1,1,1,1235,1,1,1,1000,1000,1000,1168,1,1,
1181,1090,1090,1282,1165,1,1,1204,1351,1,1129,1181,1,1090,1,
1090,1282,1165,1,1,1,1204,1,1,1,1,1242,1,1242,1247,1,1,1,
1247,1,1,1,1000,1168,1000,1,1174,1181,1371,1165,1189,1371,
1286,1213,1213,1,1,1129,1181,1,1090,1,1165,1189,1090,1,1,
1204,1,1,1,1,1,1,1294,1294,1531,1,1,1,1161,1,1,1,1000,
1000,1,1151,1000,1000,1122,1160,1122,1182,1182,1243,1,1,1110,
1000,1,1000,1,1122,1160,1122,1,1,1179,1179,1,1,1,1235,1,1,
1235,1235,1,1,1,1235,1,1,1,1000,1174,1,1090,1181,1090,1172,
1165,1,1,1204,1,1,1129,1371,1,1181,1,1371,1172,1165,1,1,1,
1296,1,1,1,1294,1294,1,1,1161,1,1,1,1531,1,1,1,1,1,1090,
1181,1165,1105,1090,1213,1286,1213,1,1,1129,1090,1,1181,1,
1165,1105,1090,1,1,1296,1,1,1351,1,1242,1,1242,1,1247,1,1,
1,1247,1,1,1,1,1204,1213,1260,1213,1173,1345,1378,1317,1,1,
1243,1204,1,1213,1,1260,1213,1173,1,1,1359,1,1,1,1,1267,1,
1,1313,1483,1,1,1,1287,1,1,1,1176,1286,1197,1197,1195,1,1,
1,1,1,1243,1176,1,1286,1,1197,1197,1195,1,1,1403,1358,1,1,
1,1,1313,1267,1,1278,1,1,1,1483,1,1,1,1000,1090,1,1090,1,
1204,1176,1,1,1000,1000,1,1168,1,1165,1,1165,1,1,1282,1282,
1,1351,1,1247,1,1242,1247,1,1,1,1,1242,1,1,1,1090,1213,
1371,1204,1,1176,1,1,1000,1168,1,1000,1,1165,1286,1165,1,1,
1189,1189,1,1,1,1161,1,1294,1531,1294,1,1,1,1,1,1,1,1197,
1000,1104,1104,1,1367,1,1000,1165,1,1165,1,1000,1266,1122,1,
1,1,1,1,1367,1,1,1246,1246,1240,1,1,1,1,1240,1,1,1,1,1,
1347,1,1,1,1182,1,1,1286,1,1266,1182,1195,1,1,1520,1347,1,
1579,1,1285,1207,1466,1329,1,1,1,1,1300,1,1,1,1185,1185,1,
1210,1,1000,1165,1,1165,1,1122,1195,1000,1,1,1,1,1,1575,1,
1152,1163,1489,1289,1289,1,1,1,1152,1,1,1,1182,1213,1,1,
1179,1,1,1296,1,1171,1,1255,1,1,1,1520,1,1,1,1341,1,1,
1284,1,1,1,1,1485,1,1,1,1213,1392,1,1179,1296,1,1,1,1171,
1520,1255,1,1,1,1347,1,1,1,1207,1300,1,1466,1329,1,1,1,1,
1,1,1,1376,1,1151,1286,1,1286,1,1,1359,1,1,1,1345,1378,1,
1657,1,1,1287,1483,1,1313,1,1,1,1,1,1,1,1,1330,1,1,1351,
1,1575,1,1367,1,1,1662,1,1,1,1,1354,1,1,1,1,1,1,1,1354,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1000,1,1000,1,1000,1182,1000,1,1,1160,1160,1,
1330,1,1235,1235,1235,1235,1,1,1,1,1,1,1,1,1,1000,1,1371,
1,1090,1,1,1172,1172,1,1,1,1531,1294,1,1161,1,1,1,1,1294,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1090,1213,1090,1,1,1105,1105,1,1,1,1247,1242,1,1247,
1242,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1197,1000,1,1,1,1,1,1210,1,1289,1489,1163,
1152,1152,1,1,1,1289,1,1,1,1,1,1,1,1,1,1402,1,1485,1341,
1284,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1367,1,1240,1246,1246,
1,1240,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1182,1,1,1,
1,1485,1,1,1299,1,1,1,1341,1,1,1,1,1397,1,1300,1,1329,1,
1466,1,1,1,1205,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1354,1354,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1294,1,1,1,1,1,1,1289,1,1,1,1,1,1,1,1,1,1294,1,1,1,
1294,1294,1,1,1,1,1,1,1,1289,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1698,1641,1,1623,1,1,1613,1,1697,1,1,1640,1692,1640,1,
1697,1692,1,1640,1692,1,1640,1,1,1,1,1,1,1640,1,1,1,1707,
1,1692,1,1,1,1697,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1680,
1,1062,1062,1050,1062,1050,1057,1062,1050,1057,1031,1181,1209,
1340,1181,1357,1181,1,1,1209,1340,1196,1368,1292,1,1368,1,1,
1,1181,1357,1,1181,1,1407,1,1209,1355,1,1,1368,1,1,1,1,1,
1,1,1,1625,1625,1625,1,1,1,1,1691,1101,1,1102,1,1092,1,1,
1092,1109,1024,1229,1,1386,1,1380,1,1409,1,1,1386,1,1316,
1309,1,1304,1,1,1,1,1380,1,1,1,1412,1,1,1304,1,1,1310,1,
1,1,1661,1661,1,1,1,1,1,1,1661,1,1,1,1,1,1102,1,1092,1,
1,1102,1,1025,1,1,1386,1,1380,1,1310,1,1,1386,1,1,1309,1,
1411,1304,1,1,1229,1380,1,1,1,1412,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1661,1661,1661,1,1,1,1,1187,1187,1328,1164,1164,
1328,1249,1206,1206,515,515,824,515,965,520,887,1,515,824,
520,792,781,1,788,1,1,1,515,965,1,520,1,1107,1,517,792,1,
1,1,1,631,1,1,1,618,1,1,1,1,1,968,1,618,1,1187,1187,
1187,1328,1328,1164,1164,1291,515,515,824,515,965,520,1,633,
515,824,520,788,781,1,1,789,1,1,515,965,1,520,1,1107,1,
517,803,1,1,1,632,1,631,1,1,1,1,618,1,1,1,1,618,1,1,
1164,1236,1164,1249,1160,1253,1160,323,323,676,323,768,316,1,
1,323,676,316,717,736,1,694,694,1461,1463,323,768,1,316,
1463,1029,1,319,696,1,1,1,566,575,575,791,791,542,546,542,
782,791,783,782,542,542,546,1187,1164,1187,1187,1328,1291,515,
515,824,515,965,520,789,1,515,824,520,1,781,1,1,793,1,1,
515,965,1,520,1,1107,1,517,1,1,1,803,1,1,1,968,1,1,618,
1,1,1,1,1,1,1,618,1164,1164,1236,1164,1244,323,323,676,323,
768,316,694,568,323,676,316,694,736,1,1,717,1463,1461,323,
768,1,316,1462,1029,1,319,693,1,1,693,566,566,575,782,791,
546,542,542,791,791,782,791,542,546,542,1206,1253,1328,1206,
428,428,739,428,857,420,730,1,428,739,420,720,801,1,1,1,1,
1,428,857,1,420,1,1107,1,422,728,1,1,794,1,1,1,1,1,1,1,
608,1,1,829,1,608,1,1,1187,1164,1206,515,515,824,515,965,
520,793,1,515,824,520,1,781,1,803,802,1,1,515,965,1,520,1,
1107,1,517,1,1,1,792,1,632,632,968,968,618,1,1,1,1,1,1,
1,618,1,1164,1160,323,323,676,323,768,316,717,564,323,676,
316,1,736,1,693,696,1462,1463,323,768,1,316,1462,1029,1,319,
1,1,1,696,566,566,566,783,782,542,542,546,791,782,791,791,
546,542,542,1206,428,428,739,428,857,420,1,1,428,739,420,1,
801,1,794,722,1487,1,428,857,1,420,1486,1107,1,422,794,1,1,
728,1,1,1,902,1,1,608,1,1,1,1,1,1,1,608,484,484,841,484,
949,486,1,1,484,841,486,1,736,1,797,846,1550,1584,484,949,
1,486,1539,1030,1,463,796,1,1,796,583,574,582,927,925,555,
570,570,925,925,927,925,570,555,570,1294,1294,1326,1190,1190,
1344,1,1326,1478,1294,1344,1294,1,1507,1,1,1,1326,1175,1,
1326,1622,1228,1,1228,1533,1,1,1,1372,1372,1,1,1,1340,1,
1340,1184,1,1,1184,1340,1340,1,1294,1190,1190,1326,1389,1389,
1326,1294,1294,1533,1478,1,1,1507,1622,1,1326,1175,1,1228,1,
1228,1,1326,1344,1,1,1344,1372,1,1372,1,1184,1,1340,1340,1,
1,1184,1,1340,1,1340,1294,1256,1294,1,1377,1478,1529,1478,
1531,1529,1,1543,1543,1541,1541,1478,1256,1,1294,1541,1318,1,
1294,1531,1,1,1,1562,1395,1395,1273,1273,1364,1364,1529,1273,
1273,1273,1273,1529,1364,1364,1190,1294,1,1387,1294,1294,1326,
1507,1478,1,1,1533,1,1622,1326,1190,1,1190,1622,1228,1,1326,
1344,1,1,1344,1372,1,1372,1184,1,1,1340,1340,1,1,1184,1,
1340,1,1340,1190,1289,1,1190,1256,1190,1289,1256,1,1289,1289,
1632,1632,1175,1395,1,1175,1597,1395,1,1175,1265,1,1,1265,
1214,1214,1214,1349,1349,1194,1194,1194,1349,1349,1318,1318,
1194,1194,1194,1312,1,1294,1478,1326,1312,1294,1,1533,1,1,1,
1326,1190,1,1326,1,1228,1,1190,1533,1,1,1,1372,1372,1,1,1,
1340,1,1340,1,1184,1,1184,1340,1340,1,1389,1507,1543,1533,
1543,1531,1,1658,1617,1,1,1533,1289,1,1,1637,1322,1,1344,
1617,1,1,1,1570,1,1399,1,1,1,1372,1543,1301,1332,1331,1,
1543,1,1372,1387,1569,1389,1389,1377,1,1592,1,1,1,1396,1,1,
1396,1,1,1,1,1598,1,1,1,1405,1405,1,1,1,1398,1,1398,1,1,
1,1,1398,1398,1,1294,1190,1,1294,1,1344,1344,1,1,1190,1190,
1,1326,1,1228,1,1326,1,1,1,1533,1,1372,1372,1,1,1340,1340,
1,1,1184,1,1184,1,1340,1340,1294,1543,1529,1,1,1531,1541,
1541,1294,1256,1,1294,1541,1318,1,1478,1,1,1,1531,1395,1395,
1562,1273,1273,1364,1529,1364,1273,1273,1273,1273,1364,1364,
1529,1389,1294,1,1312,1312,1,1,1228,1175,1,1326,1622,1228,1,
1326,1,1,1,1533,1,1372,1372,1,1,1340,1340,1,1184,1,1,1184,
1,1340,1340,1,1,1617,1,1,1637,1,1289,1,1533,1,1322,1,1344,
1618,1,1,1617,1,1570,1399,1332,1301,1543,1372,1,1,1,1,1331,
1,1543,1372,1,1531,1,1541,1541,1294,1256,1,1478,1541,1318,1,
1294,1543,1,1,1543,1395,1562,1395,1250,1250,1529,1364,1364,
1250,1250,1250,1250,1364,1529,1364,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1543,1637,1,
1344,1265,1,1,1637,1322,1,1533,1,1,1,1617,1399,1,1570,1301,
1331,1,1543,1372,1,1,1288,1331,1372,1,1543,1,1,1344,1265,1,
1533,1,1322,1,1,1617,1,1,1658,1399,1570,1,1,1,1543,1,1372,
1331,1301,1331,1288,1372,1543,1,1632,1,1632,1,1622,1632,1705,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1685,1,1685,1,1,1,1622,
1597,1,1,1705,1705,1,1622,1,1,1,1,1,1,1,1,1,1,1,1,1685,
1,1,1685,1,1,1,1190,1,1294,1,1228,1,1294,1,1,1,1507,1,
1372,1372,1,1184,1340,1340,1,1,1184,1,1,1,1340,1340,1,1190,
1632,1395,1,1190,1289,1,1,1289,1214,1214,1214,1318,1349,1194,
1194,1194,1349,1318,1349,1349,1194,1194,1194,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1228,1,1294,1312,
1,1,1312,1372,1,1372,1184,1,1,1340,1340,1184,1,1,1,1340,1,
1340,1705,1,1,1,1,1,1,1,1,1,1,1685,1,1,1,1,1685,1,1,1,
1,1,1,1228,1322,1,1,1322,1233,1233,1233,1404,1404,1230,1230,
1230,1404,1404,1404,1404,1230,1230,1230,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1507,1,1,1,1372,1372,1,1,1184,
1340,1,1340,1,1184,1,1,1340,1340,1,1,1,1543,1,1399,1570,
1332,1332,1372,1543,1,1,1288,1,1301,1,1372,1543,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1570,1399,1,1331,1331,1372,1,1543,1288,1,1,1301,1543,
1372,1,1395,1395,1,1,1384,1384,1,1,1,1,1,1,1384,1384,1395,
1,1,1,1384,1384,1,1,1,1,1384,1,1384,1,1,1384,1,1384,1,1,
1,1,1384,1384,1,1349,1,1,1,1614,1563,1614,1404,1,1,1,1,1,
1,1563,1614,1614,1349,1,1,1,1364,1364,1,1,1,1,1364,1178,
1364,1364,1,1,1,1,1364,1364,1178,1,1,1,1,1178,1364,1364,
1349,1349,1614,1,1,1,1404,1614,1,1,1,1563,1,1,1,1,1,1,
1364,1364,1364,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1223,1223,1,1,1,1,1315,435,1,906,1,1,1,1,1,488,
913,487,497,937,1046,1,1,1,1,1,933,686,457,1,774,929,440,
1,908,1,1,1,1,1,1,1,1,1444,1440,1,1,1,1,1,1,1,1,1352,
1,1,1220,1,1220,489,1,926,1,827,1,1,1,498,926,459,510,920,
1052,1,607,1,1,1,827,688,1,1,816,931,1,1,1007,1,1,1,1,1,
1,1,1,1441,1,1,1,1,1,1,1,1,1223,1,1,1,1,1315,454,1,1,
488,933,1,497,929,1,913,457,1,1,1,1,616,1,1,1,1,683,487,
1,774,1,1,1,1,960,1,1,1,1,1,1,1440,1,1,1,1,1,1,1,1,1,
1,1,1352,1,1259,1,1,987,554,964,1,1,1028,554,987,1,1,997,
1,1,1,1,1,1,964,800,1,1,946,1028,540,1,958,1,625,1,1,1,
1,1,1518,1,1518,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1220,469,1,926,498,827,1,510,
931,1,926,1,1,920,1037,1,615,1,1,1,827,684,459,1,816,1,1,
1,1,1,605,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,499,1,959,1,1018,1,1,
1,1,959,1,1,961,1077,1,1,1,1,1,1018,790,1,1,742,1,490,1,
1,1,556,1,1,1,1,1,1494,1514,1494,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1352,1194,1219,1362,1219,1326,1,1,1,1,1,1627,1303,
1352,1,1377,1642,1377,1,1,1405,1405,1,1,1,1,1,1589,1,1617,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1318,1,1,1,1194,1395,1194,1199,1395,1,1,1,1,1,1,1349,
1262,1219,1,1318,1360,1219,1,1279,1398,1,1,1,1,1,1,1582,
1582,1624,1,1,1,1,1,1,1,1,1,1,1289,1219,1219,1352,1220,
1194,1,1,1,1,1,1,1385,1517,1385,1,1590,1389,1352,1,1,1692,
1,1,1,1,1,1,1,1589,1617,1,1,1,1,1,1,1,1,1,1,1385,1349,
1385,1389,1349,1,1,1,1,1,1,1660,1563,1627,1,1660,1685,1627,
1,1701,1701,1666,1,1,1,1,1,1,1,1633,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1220,1224,1356,1224,1199,1,1,
1,1,1,1,1389,1521,1393,1,1596,1393,1362,1,1,1699,1,1,1,1,
1,1,1,1603,1620,1,1,1,1,1,1,1,1389,1389,1393,1393,1360,1,
1,1,1,1,1,1685,1578,1685,1,1689,1689,1642,1,1,1,1,1,1,1,
1,1,1,1,1638,1,1,1,1,1,1,1,1219,1385,1,1,1,1,1,1,1,1,
1,1533,1352,1,1590,1289,1,1,1,1672,1,1,1,1,1,1,1617,1589,
1,1,1,1,1,1,1,1,1,1224,1395,1360,1,1199,1,1,1,1349,1262,
1,1,1256,1389,1194,1,1320,1,1199,1,1,1,1,1,1582,1624,1582,
1,1,1,1,1,1,1,1393,1219,1398,1,1227,1,1,1,1627,1303,1,1,
1,1685,1352,1,1578,1,1355,1,1,1,1,1,1589,1617,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1540,1356,1,1596,1,1,1,1,1673,1,
1,1,1,1,1,1620,1603,1,1,1,1,1,1,1,1,1398,1,1,1,1,1,
1318,1279,1194,1,1318,1,1,1,1320,1379,1,1,1,1,1,1,1624,
1582,1582,1,1,1,1,1,1,1,1,1,1,1,1,1627,1627,1638,1,1674,
1,1674,1,1,1706,1706,1,1,1,1,1,1686,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1666,1366,1355,1,1380,1,1366,1,1,1406,1,
1,1,1,1,1,1663,1,1663,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1627,
1385,1,1660,1,1,1,1,1692,1,1,1,1,1,1,1633,1,1,1,1,1,1,
1,1,1,1,1,1,1642,1366,1,1621,1,1368,1,1,1,1,1,1,1553,
1553,1,1,1,1,1,1,1,1,1,1393,1219,1,1398,1303,1227,1,1,1,
1,1,1,1617,1589,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1689,1377,1,1643,1,1380,1,1,1,1,
1,1596,1628,1596,1,1,1,1,1,1,1,1,1,1,1699,1,1,1,1,1,1,
1638,1,1,1,1,1,1,1,1,1,1,1398,1398,1,1,1,1,1,1,1617,1,
1589,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1701,1,1,1,1,1,1,1687,1687,1,1,1,1,1,1,1,1,1405,1,
1,1,1,1,1,1644,1,1,1,1,1,1,1,1,1,1,1,1,1,1663,1,1663,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1582,1582,1,1,1,1,
1,1,1,1582,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1502,1,1,1571,1,1488,
1,1505,1535,1504,1555,1,1595,1587,1549,1,1606,1560,1572,1,
1559,1606,1594,1664,1,1,1,1,1,1549,1,1534,1,1546,1560,1555,
1,1668,1,1702,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,663,663,1150,642,642,1150,1157,655,655,38,11,427,38,427,
13,193,1,11,427,32,140,345,1,138,1,1,1,38,427,159,13,1,
345,140,30,1,148,1,1,1,1,1,1,1,357,1,352,314,366,352,1,
1,1,1,663,663,663,1120,1150,642,642,1127,38,11,427,38,427,
13,1,192,11,427,32,138,345,1,1,1,1,630,38,427,148,13,1,
345,1,30,171,1,1,1,1,1,627,1,1,1,366,357,366,1,314,1,1,
1,1,642,1183,642,1157,650,1130,650,36,34,421,36,421,5,1,1,
34,421,25,177,406,137,1,131,1,1,36,421,125,5,1,406,135,37,
127,1,1,1,1,1,1,1,1,299,293,277,1,293,1,1,1,1,1,663,
642,663,663,1120,1127,38,11,427,38,427,13,1,171,11,427,32,
1,345,1,1,148,1,1,38,427,1,13,627,345,1,30,192,1,138,1,
630,1,1,1,1,366,314,1,1,357,366,1,1,1,1,642,642,1183,642,
1150,36,34,421,36,421,5,131,1,34,421,25,1,406,1,1,1,1,1,
36,421,1,5,1,406,137,37,1,131,1,137,1,1,1,1,1,293,1,299,
293,299,1,1,1,1,1,655,1130,1112,655,20,14,305,20,305,2,72,
94,14,305,4,83,284,94,82,75,1,1,20,305,84,2,1,284,71,21,
82,75,82,94,1,1,587,1,1,1,245,238,245,1,251,1,1,1,1,663,
642,655,38,11,427,38,427,13,148,1,11,427,32,1,345,138,1,
159,1,1,38,427,1,13,1,345,1,30,1,193,140,140,1,1,1,1,1,
314,352,366,357,352,1,1,1,1,1,642,650,36,34,421,36,421,5,
1,127,34,421,25,1,406,1,137,125,1,1,36,421,131,5,1,406,1,
37,1,1,177,135,1,1,1,1,1,1,1,293,299,277,293,1,1,1,1,
655,20,14,305,20,305,2,75,82,14,305,4,82,284,82,94,84,1,
1,20,305,75,2,587,284,94,21,94,72,83,71,1,1,1,1,1,245,
251,1,1,238,245,1,1,1,1,35,17,495,35,495,9,1,1,17,495,
27,1,295,134,134,167,1,565,35,495,167,9,563,295,126,33,1,
1,1,126,565,1,563,1,1,300,327,294,300,294,327,1,1,1,1,
1090,1090,1181,1000,1000,1189,1,1153,1181,1032,1,1032,1,1189,
1,1,1,1181,1181,1189,1129,1365,1090,1189,1090,1286,1286,1202,
1202,1351,1,1,1,1,1247,1,1242,1242,1,1247,1,1,1,1,1090,
1090,1090,1122,1193,1193,1153,1032,1032,1264,1153,1171,1,1171,
1,1,1153,1165,1,1000,1361,1000,1264,1165,1,1171,1,1171,1361,
1,1367,1,1,1,1246,1240,1246,1,1240,1,1,1,1,1000,1181,1000,
1,1189,1165,1371,1181,1172,1371,1286,1202,1202,1,1212,1181,
1168,1286,1000,1,1165,1174,1000,1172,1,1189,1,1651,1,1,1,1,
1294,1294,1531,1,1161,1,1,1,1,1,1090,1000,1,1172,1090,1090,
1181,1189,1165,1202,1202,1286,1,1365,1181,1000,1286,1000,1351,
1165,1,1168,1172,1,1189,1,1365,1,1351,1,1,1,1242,1247,1,
1247,1242,1,1,1,1,1000,1172,1,1032,1181,1032,1174,1153,1,
1189,1,1,1,1181,1371,1189,1129,1651,1371,1172,1181,1286,1202,
1202,1286,1,1,1,1,1,1161,1,1,1294,1294,1531,1,1,1,1,1026,
1026,1000,1129,1122,1026,1000,1159,1239,1159,1,1330,1129,1000,
1239,1110,1330,1122,1026,1000,1239,1159,1239,1159,1330,1,1,1,
1,1235,1,1235,1,1235,1235,1,1,1,1,1193,1171,1202,1282,1202,
1185,1308,1382,1337,1,1369,1286,1,1521,1159,1,1264,1159,1174,
1308,1,1337,1,1568,1,1383,1,1,1,1276,1464,1,1275,1261,1,1,
1,1,1,1286,1176,1176,1,1,1337,1,1,1,1286,1172,1337,1239,
1653,1193,1193,1189,1526,1308,1401,1337,1,1,1,1,1,1281,1,1,
1297,1,1480,1,1,1,1,1090,1032,1,1000,1,1171,1,1,1361,1090,
1090,1171,1122,1367,1153,1171,1165,1193,1193,1264,1264,1,1,
1361,1,1,1246,1240,1,1,1240,1246,1,1,1,1,1032,1202,1371,
1189,1,1189,1,1,1000,1181,1,1000,1,1153,1286,1181,1,1172,
1174,1172,1,1,1651,1,1,1294,1531,1294,1161,1,1,1,1,1,1,
1176,1032,1033,1033,1033,1,1,1032,1181,1033,1122,1343,1032,
1282,1181,1176,1282,1176,1282,1,1,1343,1,1,1238,1238,1,1238,
1,1238,1,1,1,1,1,1,1308,1,1,1,1202,1189,1308,1239,1375,
1264,1202,1172,1401,1337,1526,1308,1,1,1,1,1,1480,1297,1,1,
1,1281,1,1,1,1,1,1171,1,1,1198,1090,1165,1171,1122,1210,
1153,1185,1090,1193,1264,1264,1193,1381,1,1381,1,1,1489,1289,
1289,1152,1152,1163,1,1,1,1,1202,1159,1,1,1189,1202,1202,
1239,1653,1171,1308,1286,1337,1382,1308,1521,1,1,1,1,1,1281,
1,1,1,1297,1480,1,1,1,1,1202,1,1,1,1286,1159,1159,1,1,
1521,1286,1,1308,1,1308,1,1,1653,1,1,1,1480,1297,1281,1,1,
1,1,1,1,1,1,1189,1286,1202,1239,1369,1171,1337,1202,1337,
1521,1308,1382,1383,1,1,1,1,1464,1,1276,1261,1,1274,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1351,1651,1383,1330,1381,1381,1653,1365,1,1568,1,
1375,1,1,1,1,1,1,1,1,1354,1,1354,1,1,1,1,1090,1,1000,1,
1032,1202,1090,1,1189,1,1189,1,1,1365,1,1,1242,1247,1,1247,
1242,1,1,1,1,1,1202,1000,1,1371,1,1000,1189,1,1172,1174,
1212,1,1,1,1,1,1,1161,1294,1531,1294,1,1,1,1,1159,1,1,
1382,1202,1,1337,1,1337,1,1,1369,1,1,1261,1274,1,1464,1276,
1,1,1,1,1,1,1000,1159,1000,1026,1026,1026,1026,1330,1,1330,
1,1,1,1235,1235,1235,1235,1,1,1,1,1,1381,1,1,1,1383,1,1,
1,1,1,1,1,1,1,1,1354,1354,1,1,1,1,1,1193,1090,1,1185,1,
1185,1198,1,1210,1,1,1152,1163,1152,1489,1289,1289,1,1,1,1,
1,1337,1,1308,1,1375,1,1,1,1,1,1,1281,1297,1480,1,1,1,1,
1,1189,1174,1172,1,1365,1,1,1,1,1242,1,1247,1242,1247,1,1,
1,1,1,1193,1176,1193,1,1,1653,1,1,1297,1480,1,1281,1,1,1,
1,1,1,1202,1159,1369,1,1,1,1,1,1261,1275,1,1464,1276,1,1,
1,1,1202,1,1,1375,1,1,1,1281,1,1480,1,1297,1,1,1,1,1653,
1,1,1,1,1297,1,1480,1,1281,1,1,1,1,1,1,1381,1,1,1354,
1354,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1354,1,1354,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1294,1294,1,1,1,1,1,1,1,1289,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1294,1294,1,1,1,1,1289,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1613,1698,1623,1,1,1641,1,1697,1,
1,1640,1692,1640,1,1,1,1,1640,1692,1,1707,1,1,1,1,1,1,
1640,1,1,1,1640,1697,1692,1692,1697,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1373,1216,1216,1,1,1,435,906,
1,1,1,454,924,461,1,1,1,683,1,1,1,1,1,1,492,1,940,1,1,
686,611,1,1,1,1,1,1,1444,1,1,1,1,1,1,1442,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1221,1352,1221,1,1171,1343,1171,1,1,827,489,926,1,1,1,469,
827,1,1,816,1,684,1037,1,1,1,926,1,1,1,920,493,1,688,626,
1,1,1,1,1,1,1441,1,1,1,1,1,1,1446,1,1,1,1,1221,1,1,1,
1,525,1,1004,523,1,1,972,553,523,1027,549,1,1,1,799,1049,
1,1,1,1,1,549,1,1,1,1,799,1,1,1,1,1,1,1492,1513,1,1,1,
1,1,1,1,1,1,1,1,1,1319,1,1314,460,1,833,1,905,1,943,470,
496,833,478,776,815,1,1,1058,1,1,1,905,1,1,1,934,491,1,
687,1,1,912,1,1,1,1,1458,1,1,1,1,1,1,1,1,1,1,1,1336,1,
1,466,1,838,494,936,1,942,502,483,1,456,1,817,634,681,1,1,
1,1,935,1,434,1,1,1,439,681,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1443,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1171,508,1,833,496,905,1,954,1,1,833,1,1,
815,1,687,1,1,1,1,905,1,478,1,934,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1216,541,1,986,567,996,1,1022,531,
567,1,521,819,950,1,1,1075,1,1,1,996,1,521,1,1,529,528,1,
1,1,952,1,1,1,1513,1491,1,1,1,1,1,1,1,1,1,1,1,1,900,1,
818,1,1,1,1,900,1,1,702,1,680,1,1,1,1,818,1,411,1,821,
1,1,679,1,1,850,1,1,1,1445,1445,1,1,1,1,1,1,1445,1,1,1,
1,1,1,1,1,1289,1,1352,1627,1377,1379,1377,1,1533,1,1,1,1,
1194,1,1352,1,1219,1220,1219,1517,1,1,1,1,1,1,1,1589,1,1,
1,1,1,1,1617,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1318,1,1,1,1627,1660,1627,1671,1660,1666,1627,1627,1,
1,1,1349,1,1385,1,1349,1389,1385,1563,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1633,1,1,1,1,1,1,1,1385,1385,1352,1600,1590,
1366,1366,1685,1,1,1,1219,1,1219,1,1194,1362,1352,1303,1,1,
1398,1,1,1,1589,1,1,1,1,1,1,1,1617,1,1,1,1,1,1,1219,
1349,1219,1320,1318,1,1279,1398,1,1,1,1395,1,1194,1,1395,
1199,1194,1262,1,1,1320,1,1,1,1582,1582,1,1,1,1,1,1,1624,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1642,1675,1674,
1675,1674,1,1642,1,1,1,1,1360,1,1393,1,1389,1393,1389,1578,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1638,1,1,1,1362,1631,1381,
1381,1380,1,1540,1,1,1,1,1199,1,1356,1,1224,1224,1220,1521,
1,1,1,1,1,1,1,1603,1,1,1,1,1,1,1620,1,1,1,1385,1219,1,
1,1,1303,1326,1,1,1,1,1,1352,1,1194,1,1,1366,1366,1,1,1,
1,1,1617,1,1,1,1,1,1,1,1589,1,1,1,1,1675,1660,1389,1,
1685,1,1,1,1349,1,1,1,1318,1631,1627,1,1389,1,1671,1,1,1,
1,1633,1,1,1,1,1,1,1,1,1,1,1381,1377,1227,1303,1398,1,1,
1,1194,1,1,1,1,1356,1352,1,1355,1,1578,1,1,1,1,1617,1,1,
1,1,1,1,1589,1,1,1,1,1,1557,1,1,1,1,1262,1,1600,1,1320,
1,1,1671,1,1,1627,1,1,1,1642,1,1,1,1,1,1,1,1,1,1,1,1,
1548,1,1,1,1,1256,1,1590,1,1318,1,1,1625,1,1,1625,1,1,1,
1628,1596,1,1,1,1,1,1,1596,1,1,1,1366,1,1,1,1,1,1,1355,
1,1199,1,1,1368,1,1,1,1,1,1,1663,1,1,1,1,1,1,1,1663,1,
1,1,1627,1,1,1,1262,1,1,1,1262,1521,1517,1,1368,1,1621,1,
1,1,1553,1553,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1638,1,
1360,1,1,1658,1658,1,1,1,1,1,1,1,1,1,1,1,1,1,1686,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1219,1,1395,1,1,1279,1,1,1279,1,1,1,
1624,1582,1,1,1,1,1,1,1582,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1393,1385,1303,1227,1,
1398,1,1,1,1589,1617,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1224,1219,1262,1199,1,
1320,1,1,1,1582,1624,1,1,1,1,1,1,1582,1,1,1,1,1540,1,1,
1,1,1,1,1620,1603,1,1,1,1,1,1,1,1,1,1,1533,1,1,1,1,1,
1,1617,1589,1,1,1,1,1,1,1,1,1,1,1366,1,1625,1,1,1,1,
1553,1,1,1,1,1,1,1553,1,1,1,1,1,1,1,1,1663,1,1,1,1,1,
1,1,1663,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1687,1,1,1,1,1,1,1687,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1582,1,1,1,1,1,1,1582,1,1,1,1,1,1,1,1,1,1582,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1223,1223,1,1,1,1,1315,1,1,1,488,913,487,1,1,1,
933,457,960,774,1,1,683,1,1,454,1,616,1,1,1,1,1,929,497,
1,1,1,1,1,1,1,1,1,1,1440,1,1,1,1,1,1,1,1352,1,1,1220,
1,1220,1,1,827,498,926,459,1,1,1,827,1,1,816,1,1037,684,
1,1,469,926,615,1,1,920,605,1,931,510,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1223,1,1,1,1,1315,1,488,933,1,913,
457,908,1,1,1,487,1,774,1,1046,686,1,1,435,906,1,1,1,937,
1,440,1,1,497,929,1,1,1,1,1,1,1,1,1,1440,1444,1,1,1,1,
1,1,1352,1,1259,1,554,964,554,987,1,958,1,1,964,1,1,946,
1,1,800,1,1,1,987,1,1,1,997,625,540,1028,1,1,1028,1,1,1,
1,1,1,1,1,1518,1518,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1220,1,498,827,1,926,1,1007,1,
1,827,459,1,816,1,1052,688,1,1,489,926,607,1,1,920,1,1,1,
1,510,931,1,1,1,1,1,1,1,1,1,1,1441,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1018,1,959,1,1,
1,1,1018,1,1,742,1,1077,790,1,1,499,959,1,1,1,961,556,
490,1,1,1,1,1,1,1,1,1,1,1,1,1494,1494,1514,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1219,1219,1352,
1,1,1,1385,1385,1672,1590,1,1,1533,1,1,1352,1194,1,1,1,1,
1,1,1389,1220,1,1289,1,1,1,1,1,1,1,1,1617,1,1589,1,1,1,
1,1385,1349,1385,1,1,1,1660,1627,1692,1660,1,1627,1627,1,1,
1627,1349,1666,1,1,1318,1,1,1685,1389,1,1,1,1,1,1,1,1,1,
1,1633,1,1,1,1,1,1,1219,1385,1,1,1,1,1352,1692,1590,1,1,
1517,1,1,1,1,1,1,1,1194,1,1352,1289,1,1220,1389,1,1,1,1,
1,1,1,1,1,1617,1589,1,1,1,1,1,1320,1,1,1349,1,1,1256,1,
1360,1262,1,1,1194,1395,1199,1,1,1395,1199,1194,1389,1224,
1224,1389,1,1,1,1,1,1,1,1,1582,1582,1624,1,1,1,1,1398,1,
1,1627,1,1303,1,1,1638,1,1,1,1352,1219,1355,1,1,1194,1227,
1219,1685,1393,1356,1393,1,1,1,1,1,1,1,1,1,1589,1617,1,1,
1,1,1,1,1701,1578,1701,1643,1,1,1621,1,1,1,1279,1,1,1,
1320,1,1398,1,1,1,1,1,1,1,1,1,1,1,1,1687,1,1687,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1385,1701,1660,1,1,1563,1,1,1,1318,1,1,1,1349,1666,1627,1,
1,1389,1685,1,1,1,1,1,1,1,1,1,1633,1,1,1,1,1,1,1,1,
1398,1303,1,1,1219,1194,1227,1,1,1219,1355,1352,1393,1356,
1393,1685,1,1,1,1,1,1,1,1,1589,1,1617,1,1,1,1,1,1,1706,
1,1,1,1405,1398,1406,1,1,1379,1405,1398,1,1699,1673,1699,1,
1,1,1,1,1,1,1,1,1,1644,1,1,1,1,1,1674,1,1,1,1377,1318,
1380,1,1,1318,1380,1377,1689,1596,1596,1689,1,1,1,1,1,1,1,
1,1596,1596,1628,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1627,1,1,1326,1,1,
1,1,1398,1706,1674,1,1,1,1,1,1,1,1,1,1,1,1,1686,1,1,1,
1,1,1,1,1,1303,1262,1366,1,1,1279,1368,1366,1578,1521,1540,
1642,1,1,1,1,1,1,1,1,1,1553,1553,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1219,1405,1377,1,1,1362,1642,1,1,1,1,1,1,1,1,1589,
1617,1,1,1,1,1,1,1,1,1395,1,1219,1,1,1199,1360,1,1,1,1,
1,1,1,1,1582,1624,1582,1,1,1,1,1,1,1,1,1366,1,1,1,1,1,
1,1,1,1,1,1,1,1663,1663,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1360,1199,1,1,1,1,1,1,1,1,
1,1,1624,1582,1582,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1663,1663,1,1,1,1,1,1642,1362,1,1,1,1,1,1,1,1,1,1,1617,
1589,1,1,1,1,1,1,1393,1689,1,1,1,1,1,1,1,1,1,1638,1,1,
1,1,1,1224,1393,1,1,1,1,1,1,1,1,1,1620,1603,1,1,1,1,1,
1,1,1,1,1,1,1,1,1620,1,1603,1,1,1,1,1,1,1,1,1,1,1,1,
1638,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1582,1582,1,1,1,1,
1582,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1178,1364,1364,1364,
1529,1364,1364,1364,519,519,651,519,651,659,1,1,519,651,659,
660,640,647,1,1,665,1,519,651,1,659,1,640,1,471,1,660,1,
1,1,1,1,1,1,1,1,604,604,1,1,604,1,604,1,1364,1364,1364,
1529,1364,1364,1364,519,519,651,519,651,659,1,1,519,651,659,
660,640,647,1,1,665,1,519,651,1,659,1,640,1,471,1,660,1,
1,1,1,1,1,1,1,1,604,604,1,1,604,1,604,1,1364,1364,1529,
1529,1529,1529,668,668,1114,668,1114,1131,1140,1,668,1114,
1131,1,1114,1,1140,1,1,1,668,1114,1143,1131,1,1114,1134,672,
1134,1,1140,1,1,1,1,1,1,1,1,1,1,1,667,1,667,1,1,1178,
1364,1529,1364,1364,591,591,638,591,638,639,657,1,591,638,
639,646,656,1,1,1,1,1,591,638,649,639,1,656,643,503,643,
646,657,1,1,664,1,1,1,1,1,603,603,1,604,603,604,603,1,
1364,1529,1364,1364,591,591,638,591,638,639,657,1,591,638,
639,646,656,1,1,1,1,1,591,638,649,639,1,656,643,503,643,
646,657,1,1,664,1,1,1,1,1,603,603,1,604,603,604,603,1,
1529,1364,1364,668,668,1114,668,1114,1131,1134,1,668,1114,
1131,1134,1114,1143,1143,1,1,1,668,1114,1,1131,1,1114,1,672,
1,1134,1134,1,1,1,1,1,667,667,1,667,667,667,1,667,1,667,
667,1364,1364,677,677,1113,677,1113,1131,1125,1,677,1113,1131,
1,1124,1132,1141,1,1154,1,677,1113,1132,1131,1154,1124,1,690,
1,1,1125,1,1,1147,1,1,697,697,1,700,700,697,700,700,700,
700,697,1178,539,539,654,539,654,652,1,1,539,654,652,1,638,
649,658,1,1,1,539,654,643,652,664,638,661,503,661,1,1,1,1,
1,1,1,589,589,1,1,1,589,590,1,590,1,589,539,539,654,539,
654,652,1,1,539,654,652,1,638,649,658,1,1,1,539,654,643,
652,664,638,661,503,661,1,1,1,1,1,1,1,589,589,1,1,1,589,
590,1,590,1,589,186,186,255,544,544,432,1,673,311,535,830,
535,830,431,1,724,1,255,311,403,292,747,201,430,201,706,706,
1,1,1,826,1,1,67,56,1,48,49,1,46,45,49,46,1,186,186,186,
292,1,1,255,544,544,706,292,403,1,1,747,1,673,311,830,535,
724,535,706,258,830,430,1,1,1,1,1,1,56,1,1,49,46,1,49,
48,48,1,57,544,382,544,1,1,311,1079,423,449,1079,811,1,1,
501,1,311,823,811,548,501,349,865,548,449,865,1,1,1,1,1,1,
187,1,1,777,174,1,174,150,777,504,504,186,544,1,1,186,186,
292,430,292,547,547,1,1,1,255,544,709,544,755,292,830,682,
405,1,518,1,1,1,1,1,1,1,1,46,1,57,48,49,45,1,66,544,1,
1,544,382,544,865,798,1,408,1,1,1,311,1079,477,423,1473,
1079,449,333,811,621,621,1,1,1,1,1,1,1,1,174,504,504,777,
777,150,1,1,578,1,535,423,823,572,535,1,811,1,1,1,292,548,
806,823,753,365,572,548,806,1,842,1,1,890,1,1,1,112,1,78,
1,109,78,73,73,69,1,1,518,621,842,621,537,1013,1053,1,1,1,
737,981,1470,1085,901,804,1085,969,948,1,1,1,1,1,1,1,1,1,
1,269,1,1,372,356,263,1,203,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
186,544,1,535,1,380,1,1,1,186,186,444,292,723,292,405,258,
1,1,737,1,1,826,1,1,1,57,1,1,1,66,45,46,1,45,67,544,
621,1079,397,1,1,1,1,544,382,947,544,512,798,811,333,1,395,
981,1,1,1,1,1,1,504,1,504,1,1,150,174,1,1,822,1,535,577,
1,1,757,1,535,423,577,823,772,535,806,298,1085,806,1085,1,
1,890,1,1,112,109,1,1,69,1,73,78,1,86,110,1,1,938,1,1,
1,1,395,1,806,886,758,1,398,1065,885,1470,1,1,1451,1,1,
225,264,1,1,1,368,290,286,1,239,163,903,485,1,509,1,201,
349,381,365,1,298,401,201,1,758,804,1,1,1469,1,1,122,780,
1,1,104,121,1,1,481,729,481,547,1,1,1,444,617,617,806,
1418,451,881,711,1,1063,896,1,1,1014,1,1,1,320,1,1,1,161,
240,249,1,1,1,1,1,1,844,806,1074,1074,875,880,1460,707,1,
856,1,1,1,1,1,1,1,1,1,154,289,1,310,344,157,1,267,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,723,1,1418,766,1,1456,1,748,886,1,1429,1,1,1,1,1,
1,1,1,1,1,909,867,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,186,1,544,1,535,1,201,1,
405,963,1,1,828,1,1,57,66,1,1,45,67,1,1,1,48,56,617,544,
1,1079,1,548,395,1,545,1,1,550,1,1,504,1,1,1,1,822,1,
504,1,150,187,1074,1,1,1063,1,1,881,1,1,1,1023,1,1,270,
386,1,1,240,178,1,1,1,326,332,1,535,1085,548,569,569,1,1,
1,1,1,1,109,1,1,69,86,110,1,1,86,1,113,1,1,1,1,1,1100,
1,1,1,1,1,859,1,1,1,867,859,1,1,1,1,1,1,201,861,455,1,
1,1,1,1,1,780,121,1,104,729,481,481,1,1,1,100,1,885,1,1,
1,1,1,1,1,160,358,1,290,152,266,1,1,286,330,224,1,835,
458,1,1,843,1,1,68,68,1,1,50,58,1,1,47,51,1,1,1085,1,1,
1095,1,1,1,160,1,1,290,358,1,221,1,152,266,621,1,1,1,1,
1,1,225,1,286,1,264,152,165,290,1,368,1,1,1,1,1,306,1,1,
356,269,1,1,1,372,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,967,1,1,1,1,
970,1,979,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,618,824,787,504,1,1,1,1,504,1,1,1,1,787,618,
824,1,1,1,1,1,1,1,1,1,1,1,1,1,745,787,504,1,745,1,1,1,
481,787,1,1,1,1,1,1,1,1,1,1,1,481,504,1364,1364,1364,
1529,1364,1364,1364,519,519,651,519,651,659,1,1,519,651,659,
660,640,647,1,1,665,1,519,651,1,659,1,640,1,471,1,660,1,
1,1,1,1,1,1,1,1,604,604,1,1,604,1,604,1,1178,1364,1364,
1364,1364,1529,519,519,651,519,651,659,1,647,519,651,659,1,
640,1,1,660,1,665,519,651,660,659,1,640,647,471,647,1,1,
647,665,1,1,604,1,1,604,1,1,1,604,1,604,1,1,1364,1364,
1364,1364,1529,519,519,651,519,651,659,1,647,519,651,659,1,
640,1,1,660,1,665,519,651,660,659,1,640,647,471,647,1,1,
647,665,1,1,604,1,1,604,1,1,1,604,1,604,1,1,1529,1529,
1529,1529,699,699,1119,699,1119,1115,1,1126,699,1119,1115,
1148,1119,1126,1,1148,1,1,699,1119,1145,1115,1,1119,1135,710,
1135,1148,1,1126,1,1,1,667,1,1,667,667,667,1,667,667,667,
667,1,1364,1364,1529,668,668,1114,668,1114,1131,1,1134,668,
1114,1131,1140,1114,1140,1,1143,1,1,668,1114,1,1131,1,1114,
1,672,1,1140,1,1134,1,1,1,667,1,1,667,1,1,1,1,1,1,1,1,
1178,1364,591,591,638,591,638,639,1,662,591,638,639,1,656,
657,1,644,1,1,591,638,646,639,1,656,1,503,1,1,1,662,1,1,
664,552,1,1,552,1,1,1,603,1,603,1,1,1364,591,591,638,591,
638,639,1,662,591,638,639,1,656,657,1,644,1,1,591,638,646,
639,1,656,1,503,1,1,1,662,1,1,664,552,1,1,552,1,1,1,603,
1,603,1,1,677,677,1121,677,1121,1131,1,1140,677,1121,1131,1,
1113,1134,1,1134,1170,1162,677,1121,1140,1131,1,1113,1141,690,
1141,1,1,1140,1162,1,1156,671,1,1,671,675,675,1,685,675,
685,675,1,186,186,255,544,544,1,1,673,311,535,844,535,963,
1,1,755,1,255,311,405,292,1,201,444,201,709,704,1,1,755,1,
1,1,1,1,1,66,67,1,45,57,48,56,1,186,186,186,292,1,1,255,
544,544,704,292,432,1,431,723,1,673,311,830,535,1,535,709,
258,830,431,1,432,724,1,826,1,1,1,56,67,56,1,48,66,49,1,
1,544,382,544,1,1,311,1079,423,476,1079,842,1,1,512,1,311,
823,811,548,1,349,947,548,477,855,1,1,1473,1,1,1,1,1,1,
822,187,1,150,1,777,1,1,186,544,1,432,186,186,292,431,292,
1,1,704,1,723,255,544,706,544,1,292,830,682,403,1,1,963,
747,1,828,56,1,1,67,56,1,1,49,67,46,1,1,544,1,1,544,382,
544,855,798,1,1,855,1,1,311,1079,449,423,1,1079,477,333,
811,1,1,842,501,1,550,1,1,1,187,187,1,1,777,822,174,1,1,
1,578,535,423,823,569,535,1088,1,1088,1,766,292,548,806,823,
1,365,577,548,806,1088,1,1088,753,1,1,112,1,1,1,113,1,1,
73,110,78,112,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,963,842,1088,
1088,971,1,1,1,1103,1,737,545,948,842,1,609,609,524,1470,
1008,1,1,901,1,1,1,1,1,1,426,202,1,263,307,372,387,1,186,
544,1,535,1,1,844,1,755,186,186,430,292,1,292,403,258,547,
547,1,737,1,1,828,67,1,1,66,1,1,1,46,56,1,57,1,544,1,
1079,1,1,476,1,512,544,382,865,544,1,798,811,333,1,408,1,
545,1,1,1511,187,1,1,822,1,1,1,174,187,504,504,1,1088,535,
578,1,569,766,1,535,423,572,823,1,535,806,298,1,811,1,842,
1,1,888,1,1,1,113,1,112,1,78,113,1,109,1,1,1,1,1,1,941,
547,408,856,811,1,751,547,1,1071,919,1,957,1,1,1093,385,1,
1,151,1,1,1,289,1,1,267,1,971,1,1,1,1,201,349,401,365,1,
298,381,201,609,751,1,609,1069,1,1069,122,1,1,505,505,122,
1,1,100,1,780,1,1,1088,1,1103,518,621,621,842,1,537,896,
743,1013,1053,1,1510,1,1,1002,202,1,1,426,1,1,1,269,306,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,941,1,380,806,1,811,1,1,876,1,1,1,1,1053,
1,1,1,1,1,1,1,151,385,1,1,1,157,268,1,1,747,1,1,757,1,
1456,1,735,1,1,1,1,1,1,1,904,1,1,1,1,1,1,862,858,1,1,
1,724,1473,1,772,1,1,1423,1,917,1422,1,1,1,1,1,1,1,1,1,
1,904,1,1,904,1,1,1,186,1,544,1,535,547,201,1,380,1,518,
1,1,826,66,1,1,57,1,57,1,1,1,1,66,1,621,544,1,1079,1,
548,397,1,1,981,1,1,550,822,1,1,1,1,504,1,504,1,1,1,1,
1,1,1,1063,1,1,938,1,1,1,1,993,160,1,1,1,225,264,1,1,1,
1,368,1,1,535,1,548,577,1,1,1,757,1,888,113,1,1,110,112,
109,1,1,1,69,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,609,201,903,485,1,462,509,1,543,505,1,1,100,
122,780,1,1,505,104,121,1,1,884,1,1,1,1,1,1,270,1,1,1,
320,161,1,1,1,1,1,1,438,839,1,1,734,1,1,58,1,1,1,58,68,
1,1,1,1,68,1,547,1,609,1,1,1438,386,1,1,270,1,320,1,1,
1,1,161,1,1,1088,1,1,1009,268,1,1,385,1,1,1,154,1,289,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1431,1,1,1,1,1,1,
307,426,1,1,233,263,202,1,1,1069,1,1,1,859,1,1,1,1,1,1,
909,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,978,1,1,1,1,
970,978,1,1,1,1,1,824,1,787,505,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,505,1,1,1,1,787,824,1,1,1,1,1,
618,824,1,1,504,824,1,1,1,1,1,1,1,1,618,1,1,1,1,1,1,
504,1,1,1364,1178,1364,1364,1529,1364,591,591,638,591,638,
639,1,1,591,638,639,1,656,1,657,646,1,1,591,638,644,639,
664,656,662,503,662,1,1,1,1,1,1,603,1,1,603,1,1,1,552,1,
552,1,1,1364,1529,1529,1529,1529,737,737,1112,737,1112,1131,
1,1,737,1112,1131,1134,1138,1,1,1134,1146,1146,737,1112,1140,
1131,1146,1138,1143,708,1143,1134,1,1,1146,1146,1128,841,814,
814,841,841,841,814,841,841,841,841,814,1364,1364,1529,1364,
591,591,638,591,638,639,1,1,591,638,639,1,656,1,657,646,1,
1,591,638,644,639,664,656,662,503,662,1,1,1,1,1,1,603,1,
1,603,1,1,1,552,1,552,1,1,1364,1529,1364,677,677,1113,677,
1113,1131,1,1,677,1113,1131,1125,1124,1141,1132,1132,1147,1,
677,1113,1,1131,1,1124,1,690,1,1125,1,1,1,1154,1154,700,
700,700,700,697,697,700,1,697,1,697,700,1364,1178,619,619,
636,619,636,645,1,1,619,636,645,1,653,1,1,660,648,663,619,
636,660,645,648,653,1,514,1,1,1,1,663,648,648,570,620,620,
570,620,620,620,570,620,570,620,620,1364,798,798,1118,798,
1118,1116,1,1,798,1118,1116,1142,1133,1148,1145,1137,1162,1,
798,1118,1136,1116,1156,1133,1144,767,1144,1142,1,1,1,1,1170,
689,700,700,689,1,1,700,698,1,698,1,700,619,619,636,619,
636,645,1,1,619,636,645,1,653,1,1,660,648,663,619,636,660,
645,648,653,1,514,1,1,1,1,663,648,648,570,620,620,570,620,
620,620,570,620,570,620,620,217,217,423,535,535,1,1,823,292,
559,982,559,891,1,1,848,1,423,292,479,365,733,226,1,226,
806,842,1,1,1,1,1,1,143,1,1,91,106,1,65,97,65,103,1,217,
217,217,382,1,1,423,535,535,842,382,485,1,1,847,1,823,292,
866,559,740,559,806,349,866,506,1,1,740,1,1,1,1,1,1,106,
103,1,65,91,65,1,144,535,260,535,1,1,292,977,282,425,977,
709,1,1,450,407,292,673,704,535,407,311,844,535,379,963,1,
1,1436,1041,1041,180,180,601,601,703,145,180,118,145,692,595,
595,217,535,1,1,217,217,382,506,382,614,614,811,1,771,423,
535,806,535,1,382,866,744,479,1,1,1,733,1,763,1,1,1,143,
103,1,144,65,106,65,1,1,535,1,1,535,260,535,963,718,1,443,
830,1050,1050,292,977,379,282,1436,977,379,259,704,1,1,1,
407,412,412,601,601,180,180,145,595,595,692,703,118,145,180,
1,1,559,282,741,579,559,1068,760,1068,1,763,365,535,762,744,
749,353,580,535,762,1,1,1,749,763,1,115,1,115,1,1,1,117,
1,81,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,217,535,1,559,1,442,879,1,1,217,217,1,382,771,
382,479,349,624,624,1,1,1,732,733,143,1,144,1,1,1,1,65,
103,1,97,143,535,1,977,472,1,393,450,407,535,260,844,535,
407,718,704,259,1,522,1,1,1062,1062,1436,180,180,595,736,
595,145,180,118,145,595,595,736,1,559,1,576,1,1,1,559,282,
580,741,1,559,762,298,1,808,1,1,1,731,1,1,115,117,111,1,
1,1,1,1,1,77,116,1,1,911,1,1,1,624,522,957,808,1,842,
624,530,1053,1,1,1,1,1433,1,445,232,334,219,1,1,1,346,388,
1,274,218,945,394,1,468,414,226,311,452,353,414,423,452,226,
1,842,1,1,1072,1472,1072,166,166,841,620,620,136,166,108,
136,613,809,613,614,1068,1,1,417,547,547,760,1421,396,1,713,
893,1087,1,1,1,1,836,210,1,376,392,1,1,1,1,247,216,329,
389,1,991,1,879,706,1060,1060,834,860,1460,714,1,1,1,1,1,
1,1,1,390,1,1,188,341,1,285,340,1,1,271,1,1,442,706,598,
751,1,447,938,598,856,1470,1,1,1036,1,1,1,371,1,1,1,337,
1,287,315,1,248,1,1050,847,1050,1453,1,1050,1509,1083,831,1,
1,1,1,1,1,1,1010,1,1,1,1,1,1,990,992,1,1,1,740,1436,1,
1,1062,1062,1,1,1,1427,1,1,1,1,1,1,928,1,1,1,1,1,1,1,
1,1,1,217,1,535,1,559,624,226,1,533,1,1,1,733,732,1,144,
1,144,1,97,143,1,1,1,91,1,547,535,1050,977,1,535,433,1,1,
1,407,412,412,736,595,180,180,145,595,736,595,595,118,145,
180,1060,1,1,1,598,1,998,1,1,1,1,852,197,272,377,402,229,
1,1,1,1,1,318,370,1,559,1,535,581,579,1,1,725,1,756,111,
117,1,116,1,77,116,1,1,53,1,111,1062,1,1,1,1086,1,1,1,1,
1,874,955,1,1,1,918,899,1,1,1,1,1,1,226,854,1,1,1,414,
409,409,620,841,166,166,136,809,613,613,620,108,136,166,1,
921,1,1,1,930,898,1,272,197,384,1,325,198,1,1,1,296,351,
227,400,975,1,1,750,750,1,93,93,93,1,1,1,93,1,1,1,63,1,
624,1,1,1,1045,1,377,402,197,272,1,325,384,1,222,1,198,1,
1,1,864,1,956,334,1,232,445,388,1,334,213,1,346,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1062,1072,1,1,874,955,1,1,1,1,1,1,1,928,1041,1,
1,1,1,871,1,1,1,1,1,1,928,1,1,1,1,1,1,1,1,1,1,928,1,
601,1,1,1,809,546,764,620,1,1,1,1,1,1,542,841,764,595,1,
1,1,601,595,1,1,1,1,764,542,841,620,1,1,1,1,764,809,546,
1,1,1,1,542,764,805,595,595,764,1,1,1,613,805,1,1,1,542,
1,1,1,1,1,1,595,613,595,1364,1364,1364,1364,1529,519,519,
651,519,651,659,1,647,519,651,659,1,640,1,1,660,1,665,519,
651,660,659,1,640,647,471,647,1,1,647,665,1,1,604,1,1,604,
1,1,1,604,1,604,1,1,1364,1364,1529,1364,591,591,638,591,
638,639,1,1,591,638,639,1,656,1,657,646,1,1,591,638,644,
639,664,656,662,503,662,1,1,1,1,1,1,603,1,1,603,1,1,1,
552,1,552,1,1,1178,1364,1364,519,519,651,519,651,659,660,1,
519,651,659,1,640,1,647,1,1,1,519,651,1,659,1,640,1,471,
1,1,660,1,1,665,1,1,604,604,1,1,1,604,1,1,1,1,604,1364,
1364,519,519,651,519,651,659,660,1,519,651,659,1,640,1,647,
1,1,1,519,651,1,659,1,640,1,471,1,1,660,1,1,665,1,1,604,
604,1,1,1,604,1,1,1,1,604,1529,699,699,1119,699,1119,1115,
1148,1135,699,1119,1115,1,1119,1,1126,1145,1,1,699,1119,1148,
1115,1,1119,1126,710,1126,1,1148,1135,1,1,1,667,667,667,667,
1,1,667,667,1,667,1,667,677,677,1121,677,1121,1131,1,1141,
677,1121,1131,1,1113,1,1134,1140,1,1162,677,1121,1134,1131,
1156,1113,1140,690,1140,1,1,1141,1162,1170,1,685,675,675,685,
1,1,675,671,1,671,1,675,186,186,255,544,544,380,1,673,311,
535,1,535,1,518,1,1,1,255,311,380,292,826,201,518,201,737,
1,547,547,724,747,1,1,66,57,1,1,1,1,57,1,66,1,1,186,186,
186,292,547,547,255,544,544,1,292,1,1,430,1,1,673,311,844,
535,828,535,737,258,963,1,1,403,755,1,1,1,57,1,46,1,1,1,
66,1,67,1,56,544,382,544,1,397,311,1079,423,1,1079,1,621,
621,1,1,311,823,806,548,550,349,981,548,545,1,408,1,1473,1,
1,1,1,504,504,1,1,1,1,1,822,1,1,186,544,1,403,186,186,
292,1,292,1,1,706,1,747,255,544,704,544,828,292,963,682,
432,1,431,830,723,1,1,46,1,1,49,1,1,56,67,1,56,1,67,544,
408,1,544,382,544,1,798,1,1,865,1,1,311,1079,476,423,1511,
1079,545,333,842,1,1,811,512,1,1,504,504,1,174,1,1,1,822,
1,187,1,187,1,577,535,423,823,1,535,1,842,1,1,757,292,548,
811,823,888,365,1,548,842,1,811,1,772,757,1,69,1,109,1,1,
1,112,110,1,113,1,1,547,431,1,811,1,485,1,1053,938,1,1,
704,855,1,1088,1009,751,1088,839,1008,1,919,1,1422,1,1,289,
1,1,154,1,1,1,385,1,268,1,1,830,811,1,1,903,1,1013,1,1,
1,709,477,1,806,1438,609,609,438,1470,1,1071,884,917,1,1,1,
161,320,1,1,1,1,270,1,386,1,1,186,544,1,535,1,432,830,1,
724,186,186,431,292,826,292,432,258,1,1,704,709,1,723,1,49,
1,56,48,1,1,67,56,1,1,1,66,544,1,1079,1,1,449,1,501,544,
382,855,544,550,798,842,333,1,1,855,477,1,1,1,174,1,1,777,
1,1,187,187,1,1,1,822,1,535,1,578,572,1,1,535,423,569,
823,888,535,842,298,1088,1,1088,806,1,766,1,1,109,112,78,1,
1,1,113,1,1,1,113,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,537,1,1,509,201,
349,1,365,543,298,462,201,609,1,751,609,1,1456,1,104,121,
780,1,1,1,122,100,1,505,1,505,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,621,1,1,963,
842,1088,1088,1002,971,1510,743,1,1,1,896,1103,1,1,1,1,1,
269,1,1,1,426,1,202,1,306,1,1,405,811,1,806,993,401,1,1,
948,1,856,1063,1,1,1,1,368,264,1,1,1,225,1,1,160,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,755,1473,1,753,1069,1069,1431,734,901,1,1,1,1,1,1,1,
909,1,1,1,1,1,859,1,1,1,1,186,1,544,1,535,1,201,1,1,
844,444,1,755,1,48,56,67,45,1,1,66,1,1,1,1,57,1,544,1,
1079,1,548,1,1,476,947,1,512,1,777,1,187,150,1,1,822,1,1,
1,1,1,1088,1,1,1053,1,1,1,1,876,1,941,1,157,268,385,1,1,
1,151,1,1,1,1,1,1,535,1088,548,578,1,569,577,766,1,1,78,
112,1,73,1,1,113,1,1,112,1,110,1069,1,1,1,1,1093,1,1,1,
1,970,978,1,1,1,1,978,1,1,1,1,1,609,201,971,1,1,381,1,
1,1,1,780,122,1,1,1,505,505,1,122,1,100,1,1,1,957,1,1,
1,1,263,202,426,1,1,1,307,1,1,1,1,233,524,1,1,1,1,735,
1,1,68,68,1,1,1,58,1,1,58,1,1,1,1088,609,1,1103,1,372,
387,202,263,1,1,426,1,1,1,1,307,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,547,941,1,1,1,267,1,289,1,1,1,151,1,385,1,
1,1423,1,1,1,1,161,1,1,1,320,1,1,270,1,1,1,1,1,1,904,
1,1,1,1,1,1,1,1,904,1,1,1,1,862,1,1,1,1,1,904,1,858,
1,1,1,1,1,1,1,1,1,1,1,1,504,1,1,1,1,618,787,1,1,1,1,
1,1,1,1,824,824,1,1,1,1,504,1,1,1,1,1,824,1,824,1,1,1,
1,1,787,1,618,1,1,1,1,1,1,1,1,1,1,1,1,1,505,1,1,1,1,
1,1,1,1,1,1,1,1,505,1,1364,1529,1364,1364,591,591,638,591,
638,639,657,1,591,638,639,646,656,1,1,1,1,1,591,638,649,
639,1,656,643,503,643,646,657,1,1,664,1,1,1,1,1,603,603,
1,604,603,604,603,1,1364,1178,1364,591,591,638,591,638,639,
646,643,591,638,639,657,656,1,1,649,664,1,591,638,1,639,1,
656,1,503,1,657,646,643,1,1,1,604,603,603,604,1,1,603,1,
1,1,1,603,1364,1529,737,737,1112,737,1112,1131,1134,1143,737,
1112,1131,1,1138,1,1,1140,1146,1146,737,1112,1134,1131,1128,
1138,1,708,1,1,1134,1143,1146,1146,1146,841,841,841,841,814,
814,841,841,814,841,814,841,1364,591,591,638,591,638,639,646,
643,591,638,639,657,656,1,1,649,664,1,591,638,1,639,1,656,
1,503,1,657,646,643,1,1,1,604,603,603,604,1,1,603,1,1,1,
1,603,737,737,1120,737,1120,1131,1,1132,737,1120,1131,1,1123,
1,1,1125,1146,1128,737,1120,1125,1131,1146,1123,1132,708,1132,
1,1,1132,1128,1146,1146,809,805,805,809,805,805,805,809,805,
809,805,805,217,217,423,535,535,442,1,823,292,559,879,559,1,
1,1,1,1,423,292,533,365,1,226,417,226,811,811,614,614,848,
733,1,1,1,144,1,1,143,1,97,144,91,1,1,217,217,217,382,
614,614,423,535,535,811,382,1,1,506,771,1,823,292,982,559,
763,559,811,349,891,1,1,485,848,1,732,1,144,1,103,143,1,1,
91,1,106,1,1,535,260,535,1,472,292,977,282,393,977,1,1,1,
407,450,292,673,737,535,412,311,830,535,393,830,443,1,1448,
1062,1062,145,180,595,595,736,180,180,145,180,703,601,601,
217,535,1,485,217,217,382,1,382,1,1,842,1,847,423,535,842,
535,733,382,891,744,485,1,1,891,847,1,733,103,1,1,106,1,1,
1,106,143,103,1,143,535,443,1,535,260,535,830,718,1,1,963,
1050,1050,292,977,425,282,1436,977,393,259,709,1,1,709,450,
407,412,595,595,180,145,180,601,601,703,736,145,180,180,576,
1,559,282,741,1,559,1,1,1,1,1,365,535,804,744,1,353,573,
535,1,1068,760,1068,832,725,1,1,1,117,1,111,1,115,81,116,
1,115,1,614,1,1,760,1,394,1,1,911,1,991,811,830,1470,1068,
851,811,1068,837,1,1,923,1,1452,1,1,341,1,1,188,1,1,390,
337,371,248,1,190,891,709,1068,1068,945,1,1,1,1,1,811,393,
1012,1,1420,557,557,1,1455,1,1063,907,1006,1,1,1,1,376,1,
392,210,1,1,275,342,378,1,217,535,1,559,1,1,982,1,848,217,
217,506,382,732,382,485,349,614,614,811,811,1,771,763,106,1,
1,91,1,1,143,103,1,1,144,1,535,1,977,1,1,425,407,450,535,
260,963,535,412,718,709,259,1,443,830,393,1050,1050,1436,145,
180,601,703,601,180,180,145,180,595,595,736,1068,559,1,1,
579,763,1,559,282,579,741,756,559,1,298,1068,760,1068,1,1,
763,756,1,117,115,1,1,115,1,1,111,1,117,111,1,1,1,1,1,1,
614,443,1,760,1,811,614,1,1063,923,1455,1,1,1419,1044,337,
1,1,1,1,1,371,341,390,1,271,191,1,1,1,414,468,226,311,
537,353,409,423,474,226,557,811,811,557,1098,1472,1098,136,
166,841,620,620,166,166,136,166,620,841,620,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,533,737,610,804,956,537,896,610,1012,1470,1,
1087,1,1428,1,1,1,334,1,219,445,232,374,1,214,334,1,1050,
733,1062,1428,725,1062,1472,1055,1,1,1,1419,853,1,1,1,1,1,
1,1,1,1,928,871,899,1,1,1,848,1448,1,832,1098,1098,1439,
831,1006,1452,1,1005,1,1,1,1,1,1,1,1,1010,1,988,1,1,1,1,
217,1,535,1,559,614,226,1,442,879,417,1,1,1,91,1,143,97,
1,144,1,1,1,1,1,144,1,535,1062,977,1,535,472,1,393,830,
450,407,412,703,601,180,145,180,595,736,595,601,145,180,180,
1,1,1,1087,610,1,911,1,896,1,1,956,214,334,445,374,232,
334,219,1,1,1,1,1,1,559,1068,535,1,576,1,573,1,1,1,1,
115,1,81,115,117,111,1,1,1,1,116,1098,1,1,1,1,1044,1,1,
1,1,918,874,1,1,1,882,928,1,1,1,1,1,557,226,945,394,1,
474,468,414,409,620,841,166,136,166,841,620,620,620,136,166,
166,1,907,1,1,1,1005,853,1,1,210,392,1,376,1,275,1,1,329,
389,234,1,837,1,1,831,1,1,1,93,93,1,93,93,93,1,1,1,93,
1,614,1068,557,1,1,1420,342,378,210,1,1,376,392,1,1,1,1,
275,1,1068,991,1,851,248,1,1,337,390,1,1,188,190,341,1,
371,614,1,1,1,1,271,1,341,371,1,1,1,191,337,1,390,1439,
1055,1,329,389,1,1,275,392,376,1,234,1,210,1,1050,1098,1,
1,1010,988,1,1,1,1,1,1,1,1,1062,1,1,1,871,928,1,1,1,1,
1,1,899,1,1,882,1,928,1,1,1,1,918,874,1,595,1,1,1,809,
542,736,620,1,1,1,1,1,1,546,841,809,601,1,1,1,595,601,1,
1,1,1,809,546,841,620,1,1,1,1,736,809,542,1,1,1,1,542,
841,841,601,595,841,1,1,1,620,841,1,1,1,542,1,1,1,1,1,1,
595,620,601,1364,1364,1178,539,539,654,539,654,652,1,661,539,
654,652,1,638,658,649,643,1,1,539,654,1,652,1,638,1,503,1,
1,1,661,1,1,664,590,1,1,590,589,589,1,1,589,1,589,1,1529,
1364,798,798,1118,798,1118,1116,1142,1144,798,1118,1116,1,
1133,1145,1148,1136,1,1,798,1118,1137,1116,1170,1133,1,767,1,
1,1142,1144,1,1162,1156,698,1,1,698,700,700,1,689,700,689,
700,1,1364,841,841,1131,841,1131,1111,1146,1146,841,1131,1111,
1146,1131,1146,1146,1128,1,1,841,1131,1128,1111,1,1131,1146,
814,1146,1146,1146,1146,1,1,1,667,1,1,667,1,1,1,667,1,667,
1,1,539,539,654,539,654,652,1,661,539,654,652,1,638,658,
649,643,1,1,539,654,1,652,1,638,1,503,1,1,1,661,1,1,664,
590,1,1,590,589,589,1,1,589,1,589,1,236,236,423,542,542,
453,1,814,375,546,812,546,1,453,1,1,1,423,375,453,311,773,
235,453,235,805,805,620,620,1,773,1,1,1,1,1,64,61,1,141,
88,101,90,1,236,236,236,311,620,620,423,542,542,805,423,536,
1,473,1,1,814,375,820,546,752,546,805,350,812,473,1,536,1,
1,944,1,1,1,90,61,90,1,101,64,95,1,1,542,349,542,1,527,
375,1061,292,448,1061,809,612,612,1,1,375,716,761,542,1,375,
813,542,448,1,448,1,1,1069,1069,184,1,1,1,727,1,1,156,120,
779,1,1,236,542,1,536,236,236,311,473,423,620,620,805,1,1,
423,542,805,542,765,423,812,716,453,1,453,1,1,1,877,90,1,
1,61,90,1,1,95,61,142,1,1,542,448,1,542,349,542,1,769,1,
448,1,1,1,375,1061,441,292,1456,1061,448,302,761,612,612,
809,1,511,1,1,1,1,1,1,1,1,779,727,155,184,1,575,566,546,
292,670,566,546,999,703,999,1,1,311,542,703,670,746,311,575,
542,703,999,703,999,1,746,1,44,1,1,1,44,1,1,54,43,55,44,
1,620,453,612,703,612,453,915,1076,840,1,1,805,1,1459,977,
1,805,977,1,869,1,869,1,1,1,1084,312,1,1,124,243,1,1,1,
1,262,1,1,1,809,999,999,1,1,915,1,1,1,841,527,883,736,
1430,620,620,526,1472,983,1072,976,1,894,1,1,1,1,1,1,1,1,
304,265,339,360,1,236,542,1,546,1,453,812,1,1,236,236,453,
311,759,423,453,350,612,612,805,841,1,759,877,61,1,1,64,1,
1,1,142,90,1,88,1,542,612,1061,527,1,448,1,1,542,349,813,
542,1,769,761,302,1,448,1,527,1,1,1469,1,1,1,727,1,184,1,
155,1,475,475,1,999,546,566,575,566,1,1,546,292,566,670,
721,546,703,283,977,703,977,736,1,721,825,1,1,1,44,1,44,1,
55,44,1,43,1,1,1,840,1,1,1,612,448,869,703,892,805,612,
436,1072,869,1457,883,1,1417,1,1,1,1,123,1,1,1,355,324,1,
242,1,1,453,1,1,1,235,375,473,311,513,423,453,235,620,805,
805,620,1,1473,1,1,1,1,1,1,1,1,179,146,1,777,1,620,999,
1,1,536,613,613,736,1430,536,915,770,973,1098,973,1509,1,
894,1,1,1,1,1,1,1,1,304,265,1,360,1,612,1,1,1,764,1015,
1015,1,812,1459,715,1,869,1,973,1,1,1450,1,1,1,243,124,
312,1,288,281,130,1,1,1,1,473,764,600,703,916,453,840,600,
840,1457,869,1098,1,1424,1,1,1,1,1,123,1,1,359,313,139,
244,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,236,1,542,1,546,612,235,1,473,1,536,1,
765,944,64,1,1,88,1,88,1,1,1,1,64,1,613,542,1,1061,1,
542,448,1,448,939,1,1,1,727,1,1,120,184,475,1,475,1,212,
120,1,1015,1,1,1076,600,1,869,1,983,1,868,1017,1,1,1,324,
206,244,1,1,1,1,1,1,1,546,977,542,575,566,575,566,1,1,
825,44,1,1,43,44,43,1,1,1,55,1,1,1,1,1,1,1054,1,1,1,1,
1,1,1,1,1,1,862,1,1,1,1,1,1,620,235,1,453,1,536,1,500,
561,1,1,1,146,1,777,1,1,1,1,105,1,1,869,1,869,1,1,1,1,
243,1,1,1,312,129,1,1,1,369,280,1,436,1,436,1,1,1,1,59,
1,1,1,59,1,1,1,1,89,1,1,612,977,620,1,1,1450,1,1,1,243,
1,312,1,1,204,1,129,1,612,999,1,1,995,244,1,1,1,324,1,1,
1,119,355,1,1,620,1,1,1001,1,1,1,312,1,243,1,1,128,1,1,
1,1,1096,1,360,1,1,1,265,1,1,1,1,304,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1069,1,1,1,867,1,1,1,1,1,859,1,1,1,1,
1,1,966,1,1,1,1,978,967,1,1,1,1,1,1,1,787,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,787,
1,1,1,1,1,1,608,745,1,1,475,745,1,1,1,1,1,1,1,1,608,1,
1,1,1,1,1,475,1,1,1364,1364,519,519,651,519,651,659,660,1,
519,651,659,1,640,1,647,1,1,1,519,651,1,659,1,640,1,471,
1,1,660,1,1,665,1,1,604,604,1,1,1,604,1,1,1,1,604,1364,
591,591,638,591,638,639,646,643,591,638,639,657,656,1,1,649,
664,1,591,638,1,639,1,656,1,503,1,657,646,643,1,1,1,604,
603,603,604,1,1,603,1,1,1,1,603,539,539,654,539,654,652,1,
661,539,654,652,1,638,658,649,643,1,1,539,654,1,652,1,638,
1,503,1,1,1,661,1,1,664,590,1,1,590,589,589,1,1,589,1,
589,1,186,186,255,544,544,405,1,673,311,535,963,535,844,444,
1,828,1,255,311,1,292,1,201,1,201,1,737,1,1,1,723,1,1,
48,45,1,67,66,1,1,56,1,57,1,186,186,186,292,1,1,255,544,
544,737,292,380,1,444,826,1,673,311,1,535,1,535,1,258,1,
518,1,405,1,1,723,1,45,1,45,66,57,1,1,67,1,1,46,544,382,
544,1,395,311,1079,423,545,1079,806,617,617,550,1,311,823,1,
548,1,349,1,548,1,981,395,1,1,1,1,1,150,1,1,822,1,1,1,
187,1,504,504,186,544,1,405,186,186,292,518,292,547,547,709,
1,1,255,544,1,544,1,292,1,682,1,1,430,830,1,1,755,45,1,
1,48,57,1,46,1,66,1,1,49,544,395,1,544,382,544,981,798,1,
397,947,1,1,311,1079,1,423,1,1079,1,333,1,621,621,811,1,1,
512,1,1,1,150,1,504,504,1,822,1,1,174,569,569,535,423,823,
1,535,1074,806,1074,1,1,292,548,1,823,1,365,1,548,1,1085,
806,1085,1,766,1,86,1,86,1,110,1,69,1,113,1,109,1,1,430,
621,806,621,455,856,1063,881,1,1,706,865,1,1,1,758,1,835,
1,1,885,1,1,1,1,290,1,1,152,264,225,286,1,368,1,1,165,
830,811,1085,1085,861,1,1,1,1095,1,706,449,1,806,1,1,1,1,
1,948,1065,885,1,886,1,1,152,290,1,358,160,1,1,266,1,1,
221,186,544,1,535,1,403,830,1,1,186,186,1,292,1,292,1,258,
1,1,706,706,1,747,724,48,1,46,49,1,1,49,1,57,1,56,48,
544,621,1079,408,1,477,1,1,544,382,1,544,1,798,1,333,1,1,
865,449,1,1,1473,150,1,504,777,504,1,174,1,1,1,1,777,1085,
535,1,577,577,890,1,535,423,1,823,1,535,1,298,1,842,1,806,
1,757,772,1,86,69,73,1,109,1,1,110,1,112,78,1,1,896,1,1,
1,1,1,1,842,1,804,1,458,1,1,1470,1,1,1429,1100,372,1,269,
1,1,1,356,1,1,1,306,1,880,451,1,1,1,201,349,1,365,1,298,
1,201,1,804,758,1,1,1456,1,1,1,729,481,481,121,104,1,100,
1,780,1,547,1074,1,1,431,1,1,811,1,485,1,707,1,1053,938,
1460,1,1,875,157,1,289,310,1,1,154,1,267,1,1,344,617,1014,
1,830,811,1,1,1,903,1,711,1,1013,1,881,1,1,1418,1,1,1,
240,161,320,1,1,1,1,1,249,1023,1,403,811,1,806,1,381,1,1,
1,1470,1,1063,1,1418,1,1,326,240,1,178,386,1,1,332,1,270,
1,1,826,1,1,890,1,1469,1,843,1,1,1451,1,1,1,1,970,1,1,
1,1,1,967,1,979,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,186,1,544,1,535,1,201,1,432,
830,430,1,724,747,49,46,49,46,1,56,48,1,1,1,67,45,1,544,
1,1079,1,548,1,1,449,865,1,501,501,777,504,174,174,1,1,
777,1,504,1,187,150,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,535,1,548,1,578,572,572,1,1,753,73,
69,1,78,109,112,78,1,1,1,1,73,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,201,1,537,1,401,1,509,1,481,
729,104,1,121,780,1,1,481,1,122,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,969,398,1,1,748,1,47,51,50,1,58,
68,1,1,1,1,68,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,621,1085,1,1,901,263,1,1,372,1,1,269,1,203,1,1,356,1,
1,1,886,1,239,1,290,368,264,1,1,163,1,225,286,1,1,1,286,
330,152,1,266,358,290,1,224,1,160,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,867,909,1,1,1,1,1,1,1,1,1,867,1,
859,1,1,1,1,1,859,1,1,1,1,1,787,1,1,481,1,1,1,1,1,1,
618,745,1,504,1,1,1,1,504,1,1,1,1,1,618,745,481,1,1,1,
1,1,787,1,1,1,1,1,1,824,787,504,1,824,1,1,1,1,787,1,1,
1,1,1,1,1,1,1,1,1,1,504,1364,591,591,638,591,638,639,1,
662,591,638,639,1,656,657,1,644,1,1,591,638,646,639,1,656,
1,503,1,1,1,662,1,1,664,552,1,1,552,1,1,1,603,1,603,1,
1,619,619,636,619,636,645,1,1,619,636,645,1,653,1,1,660,
648,663,619,636,660,645,648,653,1,514,1,1,1,1,663,648,648,
570,620,620,570,620,620,620,570,620,570,620,620,217,217,423,
535,535,533,1,823,292,559,1,559,879,417,1,733,1,423,292,
442,365,732,226,1,226,1,1,624,624,740,847,1,1,91,97,1,143,
1,1,144,1,1,144,1,217,217,217,382,624,624,423,535,535,1,
382,442,1,1,732,1,823,292,879,559,733,559,1,349,1,1,1,479,
1,1,771,1,97,1,65,1,144,1,1,143,143,1,103,535,260,535,1,
433,292,977,282,1,977,706,547,547,412,407,292,673,706,535,
412,311,1,535,1,1,522,1,1436,1050,1050,118,145,595,595,736,
180,145,180,180,736,595,595,217,535,1,479,217,217,382,1,382,
614,614,806,1,733,423,535,811,535,763,382,1,744,1,1,506,
866,771,1,1,65,1,1,65,144,1,103,143,1,1,1,106,535,522,1,
535,260,535,1,718,1,472,844,1062,1062,292,977,393,282,1436,
977,1,259,1,1,1,704,407,450,407,595,595,145,118,180,595,
595,736,736,180,180,145,579,581,559,282,741,1,559,1060,760,
1060,1,725,365,535,751,744,756,353,1,535,1,1,808,1,1,1,1,
53,1,77,1,116,1,1,116,111,111,117,1,624,506,1,808,1,1,1,
1087,998,1,864,842,963,1470,1,956,842,1,975,1,1,1,1,1427,
1,1086,346,1,1,213,334,232,388,445,1,334,1,1,866,704,1,1,
854,1,893,1,1045,1,806,379,856,762,1,1,1,400,1,1,1053,921,
1,1,1,1,198,325,1,384,197,1,272,1,377,402,222,217,535,1,
559,1,485,866,1,740,217,217,1,382,1,382,1,349,1,1,842,806,
1,847,740,65,1,103,65,1,1,106,1,144,1,1,91,535,1,977,443,
1,379,412,407,535,260,830,535,412,718,1,259,1,1,963,379,
1050,1050,1436,118,145,595,692,595,180,145,180,180,601,601,
703,1,559,576,1,580,731,1,559,282,1,741,1,559,1,298,1,1,
1,762,1,1,1,1,77,1,1,1,117,1,111,116,1,115,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,860,396,1,409,414,226,311,447,353,409,423,1,226,1,
1,842,1,1062,1509,1062,108,136,809,613,613,166,136,166,166,
620,841,620,614,1060,1,1,1,1,1,760,1,394,1,714,1,1,911,
1460,1,991,834,1,1,341,285,1,1,188,1,271,1,390,340,547,1,
1,891,709,1068,1068,836,945,1,713,1,1,1,1,1,1,1421,216,
329,1,1,1,376,1,392,389,210,1,247,1,1,479,704,598,762,852,
452,1,598,1,1,957,1,1,1453,1,1,318,1,1,1,377,229,402,370,
197,272,1,1062,1,1041,1,763,1041,1472,1,750,1,1,1433,898,1,
1,1,1,1,1,1,1,1,871,1,928,1,1,1,1,1436,1036,749,1072,
1072,1,750,1,1,1,930,1,1,1,1,1,1,1,1,874,1,955,928,1,1,
1,217,1,535,1,559,1,226,1,1,982,1,1,848,733,65,103,106,
65,1,1,91,1,1,1,143,97,1,535,1041,977,1,535,1,1,425,844,
407,450,407,692,595,145,118,180,601,703,601,595,180,180,145,
1068,1,1,1,598,1,1,1,938,1,1,1,1,248,337,287,1,1,1,1,1,
1,371,315,1,559,1,535,1,1,579,580,763,1,749,1,1,1,1,117,
115,1,1,1,115,1,81,1072,1,1,1,1,1,1,1,1,1,1,928,1,1,1,
1,1,1,1,1,1,1,1,226,1,1,1,452,414,468,414,613,809,136,
108,166,841,620,620,613,166,166,136,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,530,1,1,831,1,1,63,1,1,93,93,
1,1,1,93,93,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,624,1,1,1,1,274,1,
346,1,334,1,219,218,445,232,388,1,1083,1,296,351,198,1,1,
384,325,1,227,272,197,1,1050,1062,1,1,1,1,1,1,1,1,1,1,
928,1,1050,1,1,1,990,1,1,1,1,1,1010,1,992,1,1,918,1,899,
1,1,1,1,874,955,1,595,1,1,1,764,542,764,613,1,1,1,1,1,
1,542,764,809,595,1,1,1,595,595,1,1,1,1,809,542,764,613,
1,1,1,1,764,764,542,1,1,1,1,546,841,805,595,601,841,1,1,
1,620,805,1,1,1,546,1,1,1,1,1,1,601,620,595,539,539,654,
539,654,652,1,1,539,654,652,1,638,649,658,1,1,1,539,654,
643,652,664,638,661,503,661,1,1,1,1,1,1,1,589,589,1,1,1,
589,590,1,590,1,589,236,236,423,542,542,473,1,814,375,546,
1,546,1,536,1,765,1,423,375,473,311,944,235,536,235,841,
805,612,612,1,1,1,1,64,88,1,1,1,1,88,1,64,1,1,236,236,
236,311,612,612,423,542,542,805,423,453,1,453,759,1,814,375,
812,546,877,546,841,350,1,453,1,453,1,1,759,1,88,1,142,1,
1,1,64,1,61,1,90,542,349,542,1,448,375,1061,292,448,1061,
764,613,613,1,1,375,716,764,542,1,375,939,542,527,1,448,1,
1,1,1,212,120,475,475,1,1,184,120,1,727,1,1,236,542,1,
453,236,236,311,453,423,620,620,805,1,1,423,542,805,542,877,
423,1,716,536,1,473,812,1,1,765,142,1,1,95,1,1,90,61,1,
90,1,61,542,448,1,542,349,542,1,769,1,527,813,1,1,375,
1061,448,292,1469,1061,527,302,809,612,612,761,1,1,1,475,
475,184,155,1,1,1,727,1,1,1,1,566,575,546,292,670,575,546,
1015,736,1015,1,1,311,542,703,670,825,311,566,542,736,977,
703,977,1,1,1,55,1,43,1,1,1,44,43,1,44,1,1,612,473,612,
703,612,453,869,1098,869,1,1,805,1,1457,999,995,805,999,1,
983,1,869,1,1,1,1054,355,1,1,1,1,1,324,1,1,244,1,119,
812,761,977,977,1,1,973,1,1,1,805,448,840,703,1450,620,620,
436,1472,869,1072,869,1,1,1,1,129,312,1,1,1,1,243,1,1,1,
204,236,542,1,546,1,536,820,1,1,236,236,473,311,944,423,
536,350,620,620,805,805,1,1,752,95,1,90,101,1,1,61,90,1,
1,1,64,542,612,1061,448,1,441,511,1,542,349,1,542,1,769,
809,302,1,448,1,448,1,1,1456,155,184,1,779,1,1,1,1,1,1,
1,727,977,546,575,566,566,721,1,546,292,566,670,825,546,736,
283,999,703,999,703,1,1,721,1,43,44,55,1,1,1,44,1,1,1,
44,1,1,973,1,1,1,620,448,869,703,1001,805,620,436,1072,869,
1457,869,1,1,1,1,1,243,1,1,1,1,312,1,1,1,128,812,536,1,
500,1,235,375,453,311,561,423,536,235,620,805,805,620,1,1,
1,1,105,777,1,1,1,1,146,1,1,1,1,620,1015,1,1,453,612,
612,703,1450,453,973,715,915,1076,840,1459,1,1,1,130,1,312,
288,1,1,124,243,1,1,1,281,613,894,1,1,809,999,999,1,1,
1509,770,1,915,1,915,1,1,1430,1,360,1,304,1,1,1,1,1,1,1,
265,868,1,453,761,600,703,1017,473,983,600,883,1459,869,1076,
1,1,1,1,1,244,1,1,1,206,324,1,1,1,1,1,773,1069,1424,746,
1069,1473,1096,1,894,1,1417,1,1,1,1,859,1,1,1,1,1,1,867,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,236,1,542,1,546,620,235,1,453,812,453,1,1,
773,101,90,61,141,1,1,64,1,1,1,1,88,612,542,1069,1061,1,
542,527,1,448,813,1,1,1,779,1,1,156,1,1,727,1,1,184,1,
120,999,1,1,1098,600,1,840,1,840,1,1,916,139,244,1,359,1,
1,123,1,1,1,1,313,1,546,999,542,566,575,566,575,1,1,746,
55,44,1,54,1,1,44,1,1,44,1,43,1,1,1,1,1084,1,1,1,1,1,
978,967,1,1,1,1,966,1,1,1,1,1,620,235,1,453,1,453,1,1,
513,1,777,1,179,1,1,1,1,1,1,1,146,1,976,1,883,1,1,1,1,
304,1,1,1,1,1,265,1,1,360,1,1,526,1,436,1,1,1,1,89,1,
1,1,1,1,59,1,1,59,1,1,620,999,620,1,1,1430,339,360,1,
304,1,1,1,1,1,1,1,265,612,977,1,1,1,262,1,1,1,1,1,243,
124,1,312,1,1,612,1,1,892,1,242,1,355,1,1,1,123,1,1,1,
324,1,1,1,369,280,129,1,1,1,312,1,1,243,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
862,1,1,1,1,1,1,1,1,1,475,1,1,1,1,608,787,1,1,1,1,1,
1,1,1,745,1,1,1,1,1,475,1,1,1,1,1,1,1,745,1,1,1,1,1,
787,1,608,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,223,223,350,562,562,1,1,767,353,535,1,535,
880,1,1,731,1,350,353,532,365,749,215,415,215,758,1,1,1,1,
756,1,1,1,62,1,1,60,1,92,62,102,1,1,223,223,223,365,1,1,
350,562,562,1,282,482,1,480,1,1,767,353,971,535,763,535,
758,301,861,1,1,437,1,1,1,1,62,1,98,60,1,1,102,1,96,1,
1,562,423,562,1,451,353,1015,382,1,1015,810,571,571,410,467,
353,823,842,551,413,311,878,551,1,1,1,1,1509,1072,1072,194,
164,570,570,769,164,164,194,164,814,546,546,223,562,1,437,
223,223,365,1,282,599,599,804,1,832,350,562,804,562,725,282,
861,712,437,1,1,861,832,1,725,98,1,1,96,1,1,1,96,60,98,
1,60,562,1,1,562,423,562,1,718,1,464,980,1089,1089,353,
1015,465,382,1472,1015,1,303,811,1,1,811,467,410,413,570,
570,164,194,164,546,546,814,769,194,164,164,1,569,535,382,
823,1,535,1088,811,1088,1,847,365,551,842,823,740,292,572,
551,806,1,1,1,848,1,1,1,1,76,1,79,1,74,114,70,1,74,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,861,811,1,1,830,1,938,1,1,1,
758,1,1,806,1419,1,1,399,1455,1,1,923,1,897,1,1,147,328,
1,1,1,1,256,237,391,309,220,223,562,1,535,1,482,971,1,1,
223,223,480,365,1,282,437,301,1,1,1,758,1,1,763,96,1,1,
102,1,1,60,98,1,1,62,1,562,1,1015,464,1,465,410,467,562,
423,980,562,413,718,811,303,1,1,1,1,1089,1089,1472,194,164,
546,814,546,164,164,194,164,570,570,769,1,535,1,1,1,732,1,
535,382,1,823,1,535,806,350,1,1,1,806,1,732,1,1,76,74,1,
1,74,1,1,79,1,76,79,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,844,379,1,412,450,
215,311,522,292,407,260,443,215,1,1,1,1,1050,1436,1050,99,
85,691,542,542,85,85,99,85,542,691,542,599,1088,1,1082,1,
571,571,811,1,379,856,1,938,1,1,1460,1,852,873,1,1,317,
364,1,1,153,1,1,1,338,348,571,852,1,880,810,1088,1088,873,
844,1460,1,1,1,1,856,1082,1,1,1,338,1,1,153,317,1,364,
348,1,1,1,895,1,532,842,610,842,1,522,948,610,1,1,1,1078,
1,1432,1,1,363,1,1,1,362,228,429,361,189,253,1,1089,756,
1072,1432,1,1072,1436,1043,750,897,1,1,910,1,1,1,872,1,1,
1,1,1,1,1,914,1,1,1,1,1509,1,848,1050,1050,1452,831,1,1,
1,991,1,1,1,1,989,1,1,1,984,1,1,989,1,1,1,223,1,562,1,
535,1,215,1,1,1,415,1,731,749,102,1,60,92,1,62,1,1,1,1,
1,62,571,562,1072,1015,1,551,451,1,1,878,467,410,413,814,
546,164,194,164,570,769,570,546,194,164,164,1088,1,1,1078,
610,1,1,1,948,1,895,1,189,253,362,429,228,1,1,1,1,1,363,
361,1,535,1,551,569,1,1,572,847,1,740,1,74,1,114,74,76,
79,1,1,1,1,70,1050,1,1,1,1,1,1,1,1,1,953,1,1,1,1,870,
1,1,1,1,1,1,1,215,830,1,1,443,450,412,407,542,691,85,99,
85,691,542,542,542,99,85,85,1,923,1,1,1,991,910,1,256,1,
1,1,328,147,237,1,1,1,331,1,399,1,1,1,831,750,1,80,1,52,
1,52,52,52,1,1,80,1,1,1,1,1,1,1,1419,391,309,1,256,1,
328,1,1,220,1,147,237,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1452,1043,1,1,
331,147,1,237,1,328,1,1,256,1,1,1089,1050,1,1,984,1,1,1,
1,1,1,1,989,989,1072,1,1,1,1,1,1,1,1,1,872,1,914,1,1,
870,1,1,1,1,1,1,953,1,1,570,1,1,1,805,570,841,542,1,1,
1,1,1,1,555,764,805,546,1,1,1,570,546,1,1,1,1,805,555,
764,542,1,1,1,1,841,805,570,1,1,1,1,570,764,770,546,570,
764,1,1,1,542,770,1,1,1,570,1,1,1,1,1,1,570,542,546,
1034,1200,1200,1200,1,1,1270,1200,1200,1293,1200,1293,1,1,
1311,1,1270,1270,1293,1200,1311,1200,1293,1200,1293,1293,1,1,
1506,1,1,1,1168,1,1,1139,1168,1,1168,1168,1139,1,1,1200,
1200,1200,1,1,1270,1200,1200,1293,1200,1293,1,1,1311,1,1270,
1270,1293,1200,1311,1200,1293,1200,1293,1293,1,1,1506,1,1,1,
1168,1,1,1139,1168,1,1168,1168,1139,1,1,1200,1200,1,1,1270,
1270,1270,1325,1270,1339,1339,1,1,1,1414,1270,1477,1270,1530,
1270,1325,1270,1477,1,1339,1339,1530,1,1,1,1,1,1,1237,1,1,
1237,1237,1237,1,1,1178,1217,1,1364,1270,1364,1384,1364,1,
1293,1,1,1,1270,1200,1293,1270,1506,1200,1217,1200,1529,1364,
1364,1364,1311,1311,1,1,1,1168,1,1168,1,1,1139,1139,1168,
1168,1,1217,1,1364,1270,1364,1384,1364,1,1293,1,1,1,1270,
1200,1293,1270,1506,1200,1217,1200,1529,1364,1364,1364,1311,
1311,1,1,1,1168,1,1168,1,1,1139,1139,1168,1168,1,1,1325,
1339,1293,1339,1293,1349,1325,1,1,1,1477,1325,1506,1339,1548,
1293,1339,1293,1542,1,1,1,1542,1,1,1,1,1,1,1248,1192,1,
1258,1272,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1270,1364,1,
1364,1,1325,1,1,1,1270,1270,1325,1414,1530,1270,1325,1270,
1529,1529,1529,1529,1,1530,1,1,1,1237,1,1,1,1,1237,1237,1,
1237,1,1200,1339,1200,1325,1,1,1339,1,1270,1414,1325,1270,
1339,1270,1477,1270,1,1477,1339,1339,1614,1614,1,1,1271,1155,
1,1155,1271,1,1271,1271,1155,1155,1,1,1178,1384,1217,1,1311,
1,1200,1270,1217,1270,1311,1200,1293,1200,1364,1529,1364,1364,
1,1506,1,1,1165,1139,1,1,1165,1,1165,1165,1,1139,1,1,1,
1349,1,1,1,1339,1325,1349,1477,1548,1293,1339,1293,1624,1610,
1562,1562,1,1542,1,1,1192,1248,1,1,1,1,1272,1258,1,1248,1,
1384,1217,1,1311,1,1200,1270,1217,1270,1311,1200,1293,1200,
1364,1529,1364,1364,1,1506,1,1,1165,1139,1,1,1165,1,1165,
1165,1,1139,1,1339,1,1,1,1325,1339,1339,1477,1542,1293,1349,
1293,1610,1624,1562,1562,1,1548,1,1,1,1272,1,1,1,1,1248,
1248,1192,1258,1,1,1371,1,1325,1477,1339,1339,1371,1293,1506,
1293,1,1542,1,1,1618,1,1,1,1327,1,1,1180,1282,1,1282,1327,
1180,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1530,1614,1542,1530,1614,1506,1618,1506,
1614,1,1569,1569,1,1,1,1,1,1,1,1,1,1,1482,1482,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1270,1,1270,1,1200,1339,1200,1,1477,1339,1339,1,1530,1,1,
1237,1237,1,1,1237,1,1,1,1,1237,1,1339,1270,1614,1200,1,
1200,1477,1,1339,1339,1339,1339,1,1,1155,1271,1,1271,1155,1,
1155,1155,1271,1271,1,1339,1,1,1325,1,1,1542,1,1,1,1548,1,
1,1248,1258,1,1192,1248,1,1,1,1,1272,1,1,1200,1339,1200,
1293,1293,1225,1225,1530,1,1,1,1237,1,1,1237,1237,1,1,1,
1237,1,1,1,1,1,1,1625,1,1,1,1,1,1,1482,1,1,1,1482,1,1,
1,1,1,1,1,1034,1293,1293,1,1,1311,1311,1,1,1139,1165,1,
1165,1139,1,1,1,1165,1165,1,1,1542,1,1,1,1371,1371,1,1,
1180,1282,1,1282,1180,1,1,1,1327,1327,1,1293,1293,1,1,1311,
1311,1,1,1139,1165,1,1165,1139,1,1,1,1165,1165,1,1529,1364,
1364,1,1625,1,1,1484,1252,1,1,1479,1,1,1302,1,1252,1,1364,
1364,1614,1,1,1,1,1302,1,1484,1,1,1252,1252,1479,1,1,1178,
1569,1,1,1,1282,1,1,1280,1280,1,1,1211,1282,1211,1,1569,1,
1,1,1282,1,1,1280,1280,1,1,1211,1282,1211,1,1614,1,1,1,
1482,1,1,1,1,1,1,1,1482,1,1,1,1,1,1,1482,1,1,1,1,1482,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1340,1,1437,1155,1,1,1,1,1155,1,1,1,1,1437,1340,1,
1,1,1,1,1,1,1,1,1,1,1,1,1340,1437,1,1,1155,1437,1,1,1,
1,1,1,1,1,1340,1,1,1,1,1,1,1155,1,1,1200,1200,1200,1,1,
1270,1200,1200,1293,1200,1293,1,1,1311,1,1270,1270,1293,1200,
1311,1200,1293,1200,1293,1293,1,1,1506,1,1,1,1168,1,1,1139,
1168,1,1168,1168,1139,1,1,1034,1200,1,1,1200,1200,1200,1293,
1270,1,1,1293,1,1,1270,1200,1293,1200,1506,1200,1293,1270,
1293,1,1,1293,1311,1,1311,1,1,1,1168,1168,1,1,1139,1139,
1168,1,1168,1200,1,1,1200,1200,1200,1293,1270,1,1,1293,1,1,
1270,1200,1293,1200,1506,1200,1293,1270,1293,1,1,1293,1311,1,
1311,1,1,1,1168,1168,1,1,1139,1139,1168,1,1168,1225,1225,
1270,1270,1270,1293,1270,1339,1,1339,1,1,1414,1270,1477,1270,
1530,1270,1293,1270,1477,1339,1,1339,1530,1,1,1,1,1,1,1237,
1,1,1237,1237,1237,1,1,1178,1339,1364,1364,1364,1339,1,1,1,
1,1,1529,1339,1562,1364,1569,1364,1364,1339,1562,1,1,1,1569,
1,1,1,1,1,1,1280,1211,1,1282,1280,1282,1,1211,1339,1364,
1364,1364,1339,1,1,1,1,1,1529,1339,1562,1364,1569,1364,1364,
1339,1562,1,1,1,1569,1,1,1,1,1,1,1280,1211,1,1282,1280,
1282,1,1211,1200,1200,1,1270,1,1,1325,1,1,1270,1270,1325,
1270,1530,1270,1477,1414,1339,1339,1,1477,1,1,1530,1,1,1,
1237,1,1,1,1237,1237,1,1,1237,1178,1364,1200,1217,1,1217,
1311,1,1364,1270,1384,1364,1311,1364,1529,1270,1,1293,1,1293,
1,1,1506,1,1168,1,1139,1,1168,1,1168,1168,1,1,1139,1364,
1200,1217,1,1217,1311,1,1364,1270,1384,1364,1311,1364,1529,
1270,1,1293,1,1293,1,1,1506,1,1168,1,1139,1,1168,1,1168,
1168,1,1,1139,1,1,1,1,1,1,1529,1477,1610,1529,1614,1529,
1529,1477,1624,1542,1,1542,1,1,1625,1,1302,1,1252,1,1,1,
1479,1484,1,1,1252,1325,1,1,1339,1,1270,1414,1325,1270,1339,
1270,1477,1270,1339,1477,1,1339,1614,1,1614,1,1251,1,1155,
1155,1251,1,1251,1251,1155,1,1155,1,1339,1,1,1325,1339,1339,
1293,1542,1293,1542,1477,1349,1325,1,1506,1,1,1548,1,1,1,
1272,1,1,1,1248,1248,1192,1,1258,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1371,1,1325,
1477,1339,1293,1371,1293,1542,1339,1349,1506,1,1325,1618,1,1,
1,1282,1,1,1180,1327,1,1327,1282,1180,1,1,1,1530,1614,1542,
1506,1614,1506,1625,1530,1548,1,1,1548,1,1,1,1,1,1,1,1,1,
1,1482,1482,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1270,1,1364,1,1364,1529,1270,1,1325,
1,1325,1,1,1530,1,1237,1,1237,1,1237,1,1,1,1,1,1237,1339,
1200,1614,1200,1,1270,1325,1,1,1325,1339,1,1339,1,1155,1,
1271,1271,1155,1,1155,1155,1271,1,1271,1,1,1,1624,1339,1,
1349,1,1349,1,1,1548,1,1248,1,1258,1192,1248,1,1,1,1,1,
1272,1,1178,1364,1200,1384,1217,1,1217,1311,1,1311,1,1139,1,
1165,1165,1139,1,1,1,1165,1,1165,1,1,1,1,1618,1,1,1,1,1,
1,1482,1,1,1,1482,1,1,1,1,1,1,1364,1200,1384,1217,1,1217,
1311,1,1311,1,1139,1,1165,1165,1139,1,1,1,1165,1,1165,1,
1610,1,1,1,1614,1,1,1,1252,1,1,1479,1252,1,1,1,1484,1,
1302,1325,1325,1,1,1530,1,1,1,1237,1,1,1237,1237,1,1,1,
1237,1,1,1339,1,1339,1,1,1542,1,1258,1,1248,1,1272,1,1,
1192,1,1,1248,1,1339,1371,1,1371,1,1,1,1327,1327,1,1,1180,
1180,1282,1,1282,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1542,
1,1,1,1258,1,1,1248,1272,1,1,1192,1248,1,1,1,1614,1,1,1,
1482,1,1,1,1,1,1,1,1482,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1482,1,1,1,1,1482,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1340,1,1437,1155,1,1,1,1,1,1,1,1,1,1,1,1,1155,1,1,
1,1,1437,1,1340,1,1,1,1,1340,1,1437,1,1155,1437,1,1,1,1,
1,1,1,1,1340,1,1,1,1,1,1,1,1155,1,1200,1178,1,1217,1200,
1200,1270,1217,1200,1364,1364,1364,1,1311,1270,1364,1529,1364,
1311,1270,1384,1364,1293,1,1293,1,1506,1,1,1168,1,1,1,1139,
1,1168,1168,1168,1139,1,1,1200,1,1,1270,1270,1270,1325,1270,
1,1339,1339,1357,1357,1414,1270,1477,1270,1506,1270,1325,1270,
1477,1339,1339,1,1506,1357,1357,1186,1186,1186,1186,1245,1186,
1186,1245,1245,1245,1186,1186,1,1217,1200,1200,1270,1217,1200,
1364,1364,1364,1,1311,1270,1364,1529,1364,1311,1270,1384,1364,
1293,1,1293,1,1506,1,1,1168,1,1,1,1139,1,1168,1168,1168,
1139,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1325,1293,1339,1339,
1293,1,1,1,1360,1,1477,1325,1542,1293,1522,1339,1339,1293,
1506,1349,1325,1,1563,1,1,1,1191,1,1,1251,1191,1,1257,1257,
1272,1208,1208,1200,1270,1,1200,1,1339,1339,1,1339,1270,1270,
1477,1270,1339,1414,1325,1270,1339,1339,1477,1,1,1614,1614,
1271,1,1155,1155,1,1,1271,1271,1271,1,1155,1155,1200,1,1324,
1293,1,1,1225,1225,1200,1270,1293,1200,1225,1270,1293,1200,1,
1293,1293,1,1649,1649,1649,1203,1203,1364,1364,1364,1203,1203,
1203,1203,1364,1364,1364,1339,1200,1293,1225,1225,1339,1,1270,
1414,1293,1270,1339,1270,1477,1270,1339,1477,1339,1,1,1614,
1614,1,1271,1155,1155,1,1271,1,1271,1271,1,1155,1155,1,1,1,
1,1,1357,1339,1325,1542,1293,1357,1477,1339,1293,1325,1349,
1506,1,1,1656,1656,1312,1226,1169,1169,1,1,1340,1340,1312,1,
1169,1169,1293,1,1,1225,1225,1200,1270,1293,1200,1225,1270,
1293,1200,1,1293,1293,1,1649,1649,1649,1203,1203,1364,1364,
1364,1203,1203,1203,1203,1364,1364,1364,1364,1364,1,1377,1477,
1529,1529,1529,1542,1477,1610,1529,1542,1624,1542,1,1,1628,
1628,1295,1,1280,1280,1,1,1295,1479,1479,1286,1286,1286,1178,
1387,1,1339,1529,1364,1364,1387,1339,1562,1364,1,1562,1,1,
1658,1,1,1,1366,1,1,1188,1366,1,1366,1366,1188,1,1,1387,1,
1339,1529,1364,1364,1387,1339,1562,1364,1,1562,1,1,1658,1,1,
1,1366,1,1,1188,1366,1,1366,1366,1188,1,1,1357,1339,1357,
1542,1311,1357,1506,1360,1311,1357,1,1522,1,1,1,1,1290,1,1,
1,1,1,1290,1290,1290,1,1,1,1339,1506,1377,1311,1357,1357,
1522,1311,1357,1522,1,1,1,1,1,1,1290,1,1,1,1290,1,1290,
1290,1,1,1,1270,1,1200,1,1270,1339,1200,1,1325,1325,1,1,
1614,1614,1271,1271,1155,1155,1,1271,1271,1,1,1,1155,1155,
1529,1364,1357,1270,1,1364,1325,1,1325,1,1506,1357,1357,1245,
1186,1186,1186,1245,1186,1245,1186,1186,1245,1186,1186,1364,1,
1,1624,1364,1,1610,1,1,1,1628,1628,1295,1479,1286,1286,1286,
1479,1295,1,1,1,1280,1280,1,1200,1,1178,1217,1384,1217,1,
1506,1,1,1168,1168,1,1,1139,1168,1168,1,1,1139,1,1,1357,1,
1,1,1360,1360,1,1,1,1,1290,1290,1,1,1,1290,1290,1,1,1,1,
1,1339,1200,1325,1325,1,1,1506,1357,1357,1186,1245,1166,1166,
1241,1245,1186,1186,1186,1241,1166,1166,1,1349,1,1349,1,1563,
1,1,1257,1191,1,1,1251,1191,1257,1,1,1272,1208,1208,1217,
1384,1217,1,1506,1,1,1168,1168,1,1,1139,1168,1168,1,1,1139,
1,1,1339,1339,1,1,1656,1656,1312,1312,1169,1169,1,1340,1340,
1,1226,1,1169,1169,1339,1,1563,1,1,1257,1,1208,1208,1272,1,
1257,1191,1191,1251,1,1,1,1563,1,1,1,1257,1,1,1251,1257,1,
1191,1191,1272,1208,1208,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1649,1649,1,1,1562,1562,1,1,1,1,1,1,1562,1562,1324,1,1,1,
1,1624,1,1,1,1,1624,1,1,1,1,1,1,1624,1,1,1,1,1624,1,1,
1186,1,1,1,1257,1194,1257,1186,1,1,1,1,1,1,1194,1257,1257,
1186,1,1,1,1178,1364,1,1,1,1,1529,1364,1364,1364,1,1,1,1,
1529,1364,1364,1,1,1,1,1529,1529,1529,1186,1186,1257,1,1,1,
1186,1257,1,1,1,1194,1,1,1,1,1,1,1364,1364,1178,1200,1,1,
1200,1200,1200,1293,1270,1,1,1293,1,1,1270,1200,1293,1200,
1506,1200,1293,1270,1293,1,1,1293,1311,1,1311,1,1,1,1168,
1168,1,1,1139,1139,1168,1,1168,1,1217,1200,1200,1270,1217,
1200,1364,1364,1364,1,1311,1270,1364,1529,1364,1311,1270,1384,
1364,1293,1,1293,1,1506,1,1,1168,1,1,1,1139,1,1168,1168,
1168,1139,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1293,1293,1339,
1339,1325,1,1,1,1,1,1477,1293,1542,1293,1542,1339,1339,1325,
1506,1,1395,1349,1548,1,1,1,1,1,1,1272,1,1,1248,1248,1258,
1,1192,1034,1200,1,1200,1,1,1293,1,1311,1200,1200,1293,1200,
1311,1270,1293,1270,1,1,1293,1293,1,1,1506,1168,1,1,1139,1,
1,1168,1168,1168,1,1,1139,1200,1,1200,1,1,1293,1,1311,1200,
1200,1293,1200,1311,1270,1293,1270,1,1,1293,1293,1,1,1506,
1168,1,1,1139,1,1,1168,1168,1168,1,1,1139,1339,1270,1225,
1225,1293,1,1,1270,1270,1293,1270,1530,1270,1477,1414,1339,1,
1339,1477,1,1,1530,1,1,1,1237,1,1,1,1237,1237,1,1,1237,1,
1,1,1,1,1371,1339,1293,1542,1293,1371,1477,1339,1325,1395,1,
1506,1349,1,1,1618,1327,1,1,1180,1,1,1282,1282,1327,1,1,
1180,1339,1339,1,1,1339,1270,1270,1477,1270,1339,1414,1325,
1270,1339,1,1477,1339,1614,1,1614,1251,1,1,1155,1155,1,1251,
1251,1251,1155,1,1155,1178,1364,1,1,1339,1364,1364,1364,1569,
1339,1562,1529,1,1,1,1562,1,1,1569,1211,1,1,1280,1,1,1,
1280,1282,1211,1,1282,1364,1,1,1339,1364,1364,1364,1569,1339,
1562,1529,1,1,1,1562,1,1,1569,1211,1,1,1280,1,1,1,1280,
1282,1211,1,1282,1,1,1477,1529,1529,1529,1614,1477,1610,1529,
1542,1,1542,1624,1625,1,1,1,1,1,1,1252,1,1302,1484,1479,
1252,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1530,1506,1625,1506,1614,1614,1542,1530,1548,
1,1,1548,1,1,1,1,1,1,1,1,1,1,1482,1482,1,1,1,1200,1,
1200,1,1270,1339,1270,1,1,1325,1325,1,1,1530,1237,1,1,1237,
1,1,1237,1,1,1,1,1237,1364,1178,1,1200,1,1364,1217,1,1217,
1384,1311,1,1311,1139,1,1,1168,1168,1,1139,1,1,1168,1,1168,
1364,1,1,1624,1529,1,1,1,1610,1,1,1614,1252,1,1,1484,1302,
1,1252,1,1,1,1,1479,1,1200,1,1364,1217,1,1217,1384,1311,1,
1311,1139,1,1,1168,1168,1,1139,1,1,1168,1,1168,1614,1,1,1,
1,1618,1,1,1,1,1482,1,1,1,1,1,1482,1,1,1,1,1,1339,1270,
1325,1,1,1325,1339,1,1339,1155,1,1,1251,1251,1,1155,1155,
1155,1251,1,1251,1,1349,1,1349,1,1548,1,1,1248,1,1,1,1272,
1,1248,1,1,1258,1,1192,1325,1,1325,1,1530,1,1,1237,1,1,1,
1237,1,1237,1,1,1237,1,1,1,1339,1339,1,1,1542,1258,1,1,
1248,1,1,1272,1,1192,1,1,1248,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1339,1371,1,1371,1,1,1,1282,1282,1,1,1180,1180,
1327,1,1327,1542,1,1,1258,1,1,1,1248,1,1272,1,1192,1248,1,
1,1,1614,1,1,1,1482,1,1,1,1,1,1,1,1482,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1482,1,1,1,1,1482,1,1,1,1,1,1,1,
1340,1437,1155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1155,1,1,1,1,1437,1,1340,1,1,1,1,1340,1,1437,1,1,
1,1,1,1,1155,1437,1,1,1,1340,1,1,1,1,1,1,1,1155,1,1217,
1,1364,1270,1364,1384,1364,1,1293,1,1,1,1270,1200,1293,1270,
1506,1200,1217,1200,1529,1364,1364,1364,1311,1311,1,1,1,1168,
1,1168,1,1,1139,1139,1168,1168,1,1,1293,1339,1293,1339,1325,
1,1395,1349,1,1,1477,1293,1506,1339,1563,1293,1339,1325,1542,
1,1,1,1522,1,1360,1,1,1,1191,1257,1208,1208,1272,1251,1257,
1,1191,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1200,1178,1,1364,1,1217,
1384,1,1,1200,1200,1217,1270,1506,1200,1293,1270,1364,1364,
1364,1529,1,1311,1311,1,1,1168,1168,1,1,1,1139,1139,1,1168,
1168,1200,1339,1270,1,1,1325,1357,1357,1270,1270,1325,1270,
1506,1270,1477,1414,1,1339,1339,1477,1357,1357,1506,1186,1186,
1186,1245,1186,1186,1186,1245,1245,1186,1186,1245,1,1364,1,
1217,1384,1,1,1200,1200,1217,1270,1506,1200,1293,1270,1364,
1364,1364,1529,1,1311,1311,1,1,1168,1168,1,1,1,1139,1139,1,
1168,1168,1,1,1349,1,1,1,1339,1293,1349,1477,1563,1293,1339,
1325,1624,1562,1562,1610,1,1522,1360,1208,1208,1257,1191,1,1,
1,1251,1272,1,1257,1191,1,1325,1,1357,1357,1270,1270,1325,
1414,1506,1270,1325,1270,1529,1529,1529,1529,1357,1506,1357,
1166,1166,1245,1186,1186,1166,1166,1241,1241,1186,1245,1186,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1339,1,1,1325,1293,1339,1339,1563,1293,1506,1477,
1,1,1,1542,1360,1,1522,1208,1208,1,1257,1191,1,1,1251,1272,
1191,1,1257,1,1,1325,1293,1339,1477,1563,1293,1349,1339,1610,
1562,1562,1624,1360,1522,1,1,1,1257,1,1191,1208,1208,1272,
1251,1191,1257,1,1324,1614,1649,1656,1614,1649,1649,1656,1614,
1628,1,1,1628,1,1,1,1,1,1,1,1,1,1,1624,1624,1,1,1,1614,
1649,1656,1614,1649,1649,1656,1614,1628,1,1,1628,1,1,1,1,1,
1,1,1,1,1,1624,1624,1,1,1,1200,1,1270,1,1200,1339,1270,1,
1339,1339,1477,1,1339,1339,1155,1155,1271,1271,1,1155,1155,1,
1,1,1271,1271,1,1200,1649,1324,1,1200,1293,1,1,1293,1225,
1225,1225,1364,1364,1203,1203,1203,1364,1364,1364,1364,1203,
1203,1203,1339,1,1,1395,1339,1,1,1,1542,1,1357,1357,1169,
1169,1312,1312,1226,1169,1169,1,1,1,1340,1340,1,1200,1339,
1270,1293,1225,1225,1293,1339,1,1339,1155,1155,1,1271,1271,
1155,1155,1,1,1271,1,1271,1649,1,1,1,1658,1658,1,1,1,1,
1562,1562,1,1,1,1562,1562,1,1,1,1,1,1,1200,1293,1,1,1293,
1225,1225,1225,1364,1364,1203,1203,1203,1364,1364,1364,1364,
1203,1203,1203,1,1542,1,1,1,1357,1357,1,1169,1169,1340,1,
1340,1169,1169,1,1,1312,1312,1226,1477,1339,1339,1,1339,1339,
1,1155,1155,1271,1,1271,1155,1155,1,1,1271,1271,1,1364,1364,
1529,1,1377,1542,1286,1286,1295,1479,1,1280,1280,1,1286,1,
1295,1479,1178,1364,1387,1,1387,1,1,1,1366,1366,1,1,1188,
1188,1366,1,1366,1364,1387,1,1387,1,1,1,1366,1366,1,1,1188,
1188,1366,1,1366,1542,1377,1,1286,1286,1295,1,1479,1280,1280,
1,1286,1479,1295,1,1357,1357,1,1,1290,1290,1,1,1,1,1,1,
1290,1290,1357,1,1,1,1290,1290,1,1,1,1,1290,1,1290,1,1,
1290,1,1290,1,1,1,1,1290,1290,1,1178,1,1,1,1364,1364,1529,
1364,1,1,1,1,1,1,1364,1364,1529,1364,1,1,1,1186,1186,1,1,
1,1,1257,1194,1257,1186,1,1,1,1,1257,1257,1194,1,1,1,1,
1194,1257,1257,1178,1364,1529,1,1,1,1364,1529,1,1,1,1529,1,
1,1,1,1,1,1186,1186,1186,1225,1217,1225,1293,1225,1217,1384,
1395,1384,1,1320,1293,1384,1562,1395,1320,1293,1395,1384,1318,
1,1318,1,1522,1,1,1172,1,1,1,1149,1,1172,1172,1172,1149,1,
1,1384,1293,1395,1395,1384,1,1318,1,1,1,1293,1217,1318,1293,
1522,1225,1225,1217,1562,1384,1395,1384,1320,1320,1,1,1,1172,
1,1172,1,1,1149,1149,1172,1172,1,1200,1364,1,1178,1,1293,1,
1,1311,1200,1200,1293,1270,1311,1270,1217,1200,1364,1364,1529,
1364,1,1506,1,1165,1,1139,1,1,1,1165,1165,1165,1,1139,1,
1270,1225,1200,1339,1,1339,1,1339,1270,1270,1477,1270,1339,
1414,1293,1270,1,1339,1477,1339,1614,1614,1,1271,1,1155,1,
1155,1,1271,1271,1271,1155,1155,1,1395,1364,1395,1293,1395,1,
1,1270,1270,1293,1414,1530,1270,1293,1270,1529,1529,1529,1529,
1,1530,1,1,1,1237,1,1,1,1,1237,1237,1,1237,1,1,1,1318,1,
1,1320,1225,1217,1318,1293,1320,1293,1225,1217,1395,1384,1562,
1384,1,1522,1,1172,1,1149,1,1,1,1172,1172,1172,1,1149,1,1,
1293,1,1,1311,1200,1200,1293,1270,1311,1270,1217,1200,1364,
1364,1529,1364,1,1506,1,1165,1,1139,1,1,1,1165,1165,1165,1,
1139,1,1364,1324,1,1,1339,1364,1364,1529,1569,1339,1384,1364,
1624,1649,1624,1649,1,1569,1,1,1,1280,1,1,1,1211,1282,1280,
1211,1282,1,1364,1,1,1477,1529,1529,1529,1614,1477,1562,1529,
1,1624,1,1624,1625,1,1,1302,1,1,1,1252,1,1,1479,1484,1252,
1,1,1,1,1339,1364,1364,1529,1569,1339,1384,1364,1624,1649,
1624,1649,1,1569,1,1,1,1280,1,1,1,1211,1282,1280,1211,1282,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1530,1506,1625,1530,1614,1614,1522,1506,1614,1569,1,
1569,1,1,1,1,1,1,1,1,1,1,1482,1482,1,1,1,1200,1,1270,1,
1270,1225,1200,1,1339,1477,1339,1,1530,1,1237,1,1237,1,1,1,
1237,1,1,1,1237,1,1364,1364,1,1200,1,1178,1293,1,1293,1,
1311,1311,1,1139,1,1168,1,1168,1,1139,1,1,1168,1168,1,1529,
1,1,1395,1364,1,1624,1,1624,1,1614,1,1252,1,1484,1,1302,1,
1252,1,1,1,1479,1,1,1270,1395,1364,1293,1395,1293,1395,1530,
1,1,1237,1,1,1,1237,1,1237,1,1,1237,1,1,1614,1,1,1,1,
1625,1,1,1,1,1482,1,1,1,1,1,1482,1,1,1,1,1,1225,1200,
1477,1339,1,1339,1339,1339,1,1155,1,1251,1,1251,1,1155,1155,
1155,1251,1251,1,1,1318,1,1318,1,1320,1320,1,1149,1,1172,1,
1172,1,1149,1,1,1172,1172,1,1293,1,1293,1,1311,1311,1,1139,
1,1168,1,1168,1,1139,1,1,1168,1168,1,1364,1529,1364,1,1625,
1,1484,1,1252,1,1,1,1479,1,1302,1,1252,1,1364,1324,1569,1,
1,1282,1,1211,1,1282,1,1280,1,1211,1280,1,1,1364,1614,1,1,
1,1,1,1,1479,1,1,1252,1252,1484,1302,1,1569,1,1,1282,1,
1211,1,1282,1,1280,1,1211,1280,1,1,1614,1,1,1,1482,1,1,1,
1,1,1,1,1482,1,1,1,1,1,1,1482,1,1,1,1,1482,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1340,1437,1155,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1155,1,1,1,1,1437,1340,1,1,1,1,1,1,
1,1,1,1,1,1,1,1340,1437,1,1,1,1,1,1,1,1155,1437,1,1,1,
1340,1,1,1,1,1,1,1155,1,1,1339,1364,1364,1364,1339,1,1,1,
1,1,1529,1339,1562,1364,1569,1364,1364,1339,1562,1,1,1,1569,
1,1,1,1,1,1,1280,1211,1,1282,1280,1282,1,1211,1,1293,1,
1217,1,1325,1349,1,1371,1293,1293,1506,1339,1371,1477,1339,
1325,1,1,1542,1,1,1,1618,1282,1,1,1180,1,1,1327,1327,1282,
1,1,1180,1364,1178,1,1,1,1,1,1387,1364,1339,1562,1364,1387,
1529,1364,1339,1,1,1562,1,1,1,1658,1366,1,1,1188,1,1,1366,
1366,1366,1,1,1188,1364,1293,1318,1395,1318,1,1,1529,1477,
1562,1529,1614,1529,1529,1477,1624,1,1624,1,1,1,1625,1,1,1,
1252,1,1302,1,1484,1479,1,1,1252,1,1,1,1,1,1387,1364,1339,
1562,1364,1387,1529,1364,1339,1,1,1562,1,1,1,1658,1366,1,1,
1188,1,1,1366,1366,1366,1,1,1188,1349,1395,1,1,1357,1293,
1325,1506,1339,1357,1477,1339,1293,1,1,1542,1,1656,1,1656,
1333,1,1,1169,1169,1222,1305,1305,1333,1169,1,1169,1,1384,1,
1,1542,1562,1562,1624,1656,1542,1624,1610,1,1,1,1,1,1,1638,
1,1,1,1334,1,1,1353,1612,1544,1307,1,1335,1,1,1,1624,1624,
1649,1649,1681,1624,1649,1624,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1626,1626,1,1,1,1,1,1542,1610,1562,1624,1635,1542,1624,
1562,1,1,1,1,1666,1,1,1,1,1,1,1283,1391,1,1572,1615,1283,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1614,1563,1658,1569,1628,1628,1569,1548,1635,1,1,
1,1,1,1,1,1,1,1,1,1315,1,1538,1544,1,1,1,1293,1,1364,1,
1529,1364,1293,1,1,1610,1,1,1,1625,1479,1,1,1252,1,1302,
1484,1,1,1,1,1252,1562,1,1,1293,1,1384,1349,1,1349,1,1522,
1,1360,1251,1,1,1191,1257,1208,1272,1208,1,1257,1,1191,1649,
1,1,1649,1562,1,1,1,1,1,1,1658,1508,1,1,1515,1515,1515,
1515,1,1,1,1,1508,1,1364,1324,1,1384,1,1384,1,1569,1,1,
1280,1,1,1,1280,1211,1282,1,1,1282,1,1211,1628,1,1,1,1,
1638,1,1,1,1,1544,1,1,1,1,1315,1538,1,1,1,1,1,1364,1293,
1610,1,1,1,1542,1,1377,1280,1,1,1259,1465,1286,1286,1286,
1280,1465,1,1259,1,1384,1,1384,1,1569,1,1,1280,1,1,1,1280,
1211,1282,1,1,1282,1,1211,1349,1,1349,1,1542,1,1,1272,1,1,
1,1248,1192,1258,1,1,1248,1,1,1,1624,1,1,1,1666,1570,1,1,
1283,1,1388,1617,1,1390,1,1,1283,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1656,1,1,1,1,1,1,1544,1307,1,1335,1334,
1612,1,1353,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1656,1,1,
1,1493,1,1,1,1,1,1,1,1493,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1616,1,1,1,1,1616,1,1,1,1,1,1,1306,1,1490,1280,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1169,1,
1,1,1,1482,1,1372,1,1,1,1,1543,1,1482,1208,1208,1306,1,1,
1,1286,1490,1,1,1,1,1,1,1,1,1,1,1,1169,1,1293,1,1,1384,
1,1349,1,1,1,1293,1293,1349,1477,1542,1339,1339,1325,1562,
1562,1624,1610,1,1548,1,1,1,1272,1,1,1,1,1248,1248,1,1258,
1192,1364,1364,1293,1,1,1,1377,1,1529,1477,1610,1529,1542,
1529,1529,1477,1,1542,1624,1542,1628,1628,1,1,1295,1280,1,
1280,1295,1,1479,1479,1286,1286,1286,1324,1,1,1384,1,1,1,
1364,1339,1384,1529,1569,1364,1364,1339,1649,1624,1649,1624,1,
1569,1,1,1211,1280,1,1,1,1,1280,1282,1,1282,1211,1,1,1384,
1,1,1,1364,1339,1384,1529,1569,1364,1364,1339,1649,1624,1649,
1624,1,1569,1,1,1211,1280,1,1,1,1,1280,1282,1,1282,1211,1,
1349,1,1360,1,1293,1325,1349,1477,1522,1339,1339,1293,1562,
1610,1624,1562,1,1563,1,1,1185,1251,1,1,1185,1,1254,1254,
1208,1272,1208,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1610,1542,1624,1624,1656,
1562,1562,1542,1,1,1,1,1638,1,1,1,1353,1,1,1334,1,1,1544,
1612,1335,1,1307,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1625,1656,1666,1625,1656,1658,
1658,1618,1658,1,1677,1638,1,1,1,1,1,1,1,1,1,1,1616,1616,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1293,1,1529,1,1364,1364,1293,1,1542,1624,1542,1,
1614,1,1,1252,1479,1,1,1252,1,1,1,1,1484,1302,1,1293,1656,
1,1,1217,1506,1,1325,1349,1357,1357,1,1,1169,1340,1,1340,
1169,1,1169,1169,1312,1312,1226,1624,1,1,1,1,1,1,1,1,1,
1635,1,1,1283,1570,1,1390,1283,1,1,1,1,1617,1388,1,1364,
1364,1293,1562,1318,1395,1318,1614,1,1,1,1252,1,1,1479,1252,
1,1,1,1484,1,1302,1,1,1,1,1666,1677,1,1,1,1,1,1493,1,1,
1,1493,1,1,1,1,1,1,1178,1,1562,1,1,1,1387,1387,1,1,1188,
1344,1,1344,1188,1,1,1,1352,1352,1231,1,1562,1,1,1,1387,
1387,1,1,1188,1344,1,1344,1188,1,1,1,1352,1352,1231,1506,
1349,1395,1,1371,1371,1,1,1180,1282,1,1282,1180,1,1,1,1327,
1327,1,1562,1649,1562,1,1658,1,1,1515,1508,1,1,1508,1,1,
1515,1,1515,1515,1,1384,1635,1,1,1,1,1388,1,1617,1,1,1283,
1283,1570,1,1390,1,1671,1,1,1,1378,1,1,1651,1378,1,1378,
1378,1633,1408,1408,1656,1,1,1,1335,1,1,1544,1334,1,1,1307,
1612,1353,1,1628,1,1,1,1544,1,1,1,1,1,1,1,1538,1315,1,1,
1,1,1,1544,1,1,1,1,1538,1,1315,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1372,1,1482,1169,1,1,1,
1,1280,1,1,1,1,1490,1398,1306,1,1,1,1,1,1,1,1,1,1,1,1,
1398,1490,1306,1,1169,1482,1,1,1,1,1,1,1,1,1543,1,1,1,1,
1,1,1286,1208,1208,1200,1,1200,1,1,1293,1,1311,1200,1200,
1293,1200,1311,1270,1293,1270,1,1,1293,1293,1,1,1506,1168,1,
1,1139,1,1,1168,1168,1168,1,1,1139,1,1364,1,1217,1384,1,1,
1200,1200,1217,1270,1506,1200,1293,1270,1364,1364,1364,1529,1,
1311,1311,1,1,1168,1168,1,1,1,1139,1139,1,1168,1168,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1293,1,1,1311,1200,1200,1293,1270,1311,1270,
1217,1200,1364,1364,1529,1364,1,1506,1,1165,1,1139,1,1,1,
1165,1165,1165,1,1139,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1339,1,1,1293,1293,
1339,1339,1548,1325,1506,1477,1,1,1,1542,1,1,1542,1192,1,1,
1248,1,1,1,1272,1258,1,1,1248,1,1,1293,1293,1339,1477,1548,
1325,1349,1339,1562,1562,1610,1624,1,1542,1,1,1,1248,1,1,1,
1192,1258,1272,1,1248,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1506,1506,1618,1530,1614,1614,
1542,1530,1569,1569,1,1614,1,1,1,1,1,1,1,1,1,1,1482,1482,
1,1,1,1034,1,1200,1,1200,1,1200,1,1,1293,1293,1,1311,1311,
1139,1,1168,1168,1,1,1139,1,1,1,1168,1168,1,1200,1,1200,1,
1200,1,1,1293,1293,1,1311,1311,1139,1,1168,1168,1,1,1139,1,
1,1,1168,1168,1339,1,1,1325,1339,1,1,1,1542,1,1371,1371,
1180,1,1327,1327,1,1,1180,1,1,1,1282,1282,1,1270,1339,1270,
1225,1225,1293,1293,1,1,1530,1237,1,1,1237,1,1,1237,1,1,1,
1,1237,1614,1,1,1,1,1625,1,1,1,1,1482,1,1,1,1,1,1482,1,
1,1,1,1,1339,1270,1339,1339,1,1477,1,1339,1339,1155,1,1251,
1251,1,1,1155,1155,1155,1,1251,1251,1,1,1,1542,1,1,1548,1,
1248,1,1272,1,1,1,1248,1,1,1,1258,1192,1339,1339,1477,1,1,
1530,1,1237,1,1237,1,1,1,1237,1,1,1,1237,1,1178,1364,1364,
1,1,1569,1282,1,1211,1282,1,1,1280,1,1211,1,1,1280,1364,
1364,1,1,1569,1282,1,1211,1282,1,1,1280,1,1211,1,1,1280,
1529,1,1,1614,1,1,1,1479,1,1,1,1252,1252,1,1302,1484,1,
1625,1,1484,1,1252,1,1,1,1479,1,1302,1,1252,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1614,1,1,1,1482,1,1,1,1,1,1,1,1482,
1,1,1482,1,1,1,1,1,1,1,1482,1,1,1,1,1,1,1340,1437,1155,
1,1,1,1,1,1,1,1,1,1,1,1,1,1155,1,1,1,1,1,1,1340,1437,
1,1,1,1,1,1,1437,1340,1,1,1,1,1,1,1,1,1,1,1,1,1,1155,
1437,1,1,1,1340,1,1,1,1,1,1,1,1,1155,1364,1200,1217,1,
1217,1311,1,1364,1270,1384,1364,1311,1364,1529,1270,1,1293,1,
1293,1,1,1506,1,1168,1,1139,1,1168,1,1168,1168,1,1,1139,1,
1,1,1,1,1387,1364,1339,1562,1364,1387,1529,1364,1339,1,1,
1562,1,1,1,1658,1366,1,1,1188,1,1,1366,1366,1366,1,1,1188,
1293,1,1,1225,1225,1200,1270,1293,1200,1225,1270,1293,1200,1,
1293,1293,1,1649,1649,1649,1203,1203,1364,1364,1364,1203,1203,
1203,1203,1364,1364,1364,1,1339,1,1360,1293,1339,1339,1293,
1522,1325,1542,1477,1,1395,1349,1506,1,1,1563,1191,1,1,1251,
1,1,1191,1257,1257,1208,1208,1272,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1357,1,1293,
1477,1339,1293,1357,1325,1542,1339,1,1506,1349,1395,1656,1656,
1,1,1340,1169,1,1169,1312,1226,1312,1340,1169,1169,1,1357,
1311,1357,1522,1311,1357,1506,1377,1339,1,1,1522,1357,1,1,1,
1290,1,1,1,1,1,1290,1290,1290,1,1,1,1311,1506,1360,1311,
1357,1357,1542,1339,1,1522,1,1357,1,1,1,1,1290,1,1,1,1290,
1,1290,1290,1,1,1,1200,1,1178,1,1364,1364,1200,1,1217,1384,
1217,1,1,1506,1168,1168,1,1139,1,1168,1168,1,1,1,1,1139,
1339,1200,1357,1270,1,1270,1,1,1325,1325,1357,1357,1506,1245,
1186,1186,1245,1186,1186,1245,1186,1186,1186,1186,1245,1,1,1,
1624,1339,1,1349,1,1349,1,1,1563,1191,1257,1208,1272,1208,
1257,1191,1,1,1,1,1251,1,1364,1364,1200,1,1217,1384,1217,1,
1,1506,1168,1168,1,1139,1,1168,1168,1,1,1,1,1139,1357,1,1,
1,1360,1360,1,1,1,1,1290,1290,1,1,1,1290,1290,1,1,1,1,1,
1529,1270,1,1325,1,1325,1357,1357,1506,1186,1245,1166,1241,
1166,1245,1186,1186,1186,1166,1166,1241,1,1,1,1610,1,1628,
1628,1,1479,1295,1280,1,1280,1295,1479,1,1,1286,1286,1286,1,
1325,1325,1,1614,1614,1,1271,1271,1155,1,1155,1271,1271,1,1,
1155,1155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1339,
1339,1,1,1563,1257,1,1208,1272,1208,1,1257,1191,1191,1,1,
1251,1339,1,1,1563,1,1257,1,1251,1,1257,1,1191,1191,1208,
1208,1272,1656,1656,1,1312,1312,1169,1,1169,1340,1340,1,1226,
1169,1169,1,1324,1649,1,1,1,1624,1,1,1,1,1,1,1,1624,1649,
1,1,1,1624,1,1,1,1,1,1,1,1624,1,1,1562,1,1562,1,1,1,1,
1562,1562,1,1186,1,1,1,1257,1194,1257,1186,1,1,1,1,1,1,
1194,1257,1257,1186,1,1,1,1364,1178,1,1,1,1,1364,1364,1529,
1364,1,1,1,1,1529,1529,1529,1,1,1,1,1364,1364,1529,1186,
1186,1257,1,1,1,1186,1257,1,1,1,1194,1,1,1,1,1,1,1178,
1364,1364,1,1,1384,1,1,1,1364,1339,1384,1529,1569,1364,1364,
1339,1649,1624,1649,1624,1,1569,1,1,1211,1280,1,1,1,1,1280,
1282,1,1282,1211,1384,1217,1,1311,1,1200,1270,1217,1270,1311,
1200,1293,1200,1364,1529,1364,1364,1,1506,1,1,1165,1139,1,1,
1165,1,1165,1165,1,1139,1,1225,1395,1,1,1217,1225,1225,1293,
1522,1217,1318,1293,1384,1395,1384,1562,1,1320,1320,1,1,1172,
1172,1,1,1,1149,1149,1,1172,1172,1225,1320,1,1384,1293,1395,
1395,1320,1384,1562,1293,1,1318,1,1318,1,1,1522,1,1172,1,
1149,1,1172,1,1172,1172,1,1,1149,1320,1,1217,1293,1225,1293,
1320,1217,1318,1225,1384,1562,1384,1395,1,1522,1,1,1172,1149,
1,1,1172,1,1172,1172,1,1149,1,1,1506,1614,1522,1530,1614,
1506,1625,1530,1569,1,1569,1614,1,1,1,1,1,1,1,1,1,1,1482,
1482,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1200,1,1364,1,1178,1364,1200,1,1293,1,1293,
1,1311,1311,1,1139,1165,1165,1,1139,1,1,1,1,1165,1165,1225,
1270,1614,1200,1,1270,1339,1,1339,1477,1,1339,1339,1,1155,
1271,1271,1,1155,1,1155,1155,1,1271,1271,1395,1,1,1395,1225,
1,1318,1,1318,1,1320,1320,1,1149,1172,1172,1,1149,1,1,1,1,
1172,1172,1,1364,1529,1270,1395,1293,1395,1293,1,1,1530,1,
1237,1,1237,1,1237,1,1,1,1,1,1237,1,1,1,1,1625,1,1,1,1,
1,1,1482,1,1,1,1482,1,1,1,1,1,1,1364,1200,1,1293,1,1293,
1,1311,1311,1,1139,1165,1165,1,1139,1,1,1,1,1165,1165,1,
1624,1,1624,1,1,1614,1,1,1252,1479,1,1,1252,1,1,1,1,1484,
1302,1339,1477,1339,1,1,1530,1,1,1237,1237,1,1,1237,1,1,1,
1,1237,1,1364,1324,1364,1,1,1569,1,1282,1,1280,1,1280,1,1,
1211,1,1211,1282,1364,1529,1,1,1614,1,1,1302,1484,1,1,1,
1252,1252,1,1,1479,1364,1,1,1569,1,1282,1,1280,1,1280,1,1,
1211,1,1211,1282,1,1625,1,1,1484,1252,1,1,1479,1,1,1302,1,
1252,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1614,1,1,1,1482,1,
1,1,1,1,1,1,1482,1,1,1482,1,1,1,1,1,1,1,1482,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1340,1,1437,1155,1,1,1,1155,1,1,
1,1,1,1,1340,1437,1,1,1,1,1,1,1437,1340,1,1,1,1,1,1,1,
1,1155,1437,1,1,1,1,1,1,1,1,1340,1,1,1,1,1,1,1,1,1155,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1562,1542,1624,1624,
1635,1610,1562,1542,1,1,1,1,1,1,1666,1391,1,1,1283,1,1,1,
1615,1572,1,1,1283,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1569,1563,1638,1614,1628,
1628,1569,1548,1671,1656,1,1635,1,1,1,1,1315,1,1,1,1,1,
1544,1538,1,1,1,1,1,1364,1,1364,1178,1,1,1,1562,1,1,1569,
1,1282,1211,1280,1,1,1,1280,1,1,1,1282,1211,1,1293,1,1293,
1,1217,1325,1,1506,1349,1,1522,1360,1272,1208,1257,1191,1,1,
1251,1,1208,1,1257,1191,1624,1,1,1,1,1,1,1,1,1,1656,1,
1335,1307,1612,1353,1,1,1334,1,1,1,1544,1,1,1529,1364,1293,
1395,1318,1562,1318,1,1,1625,1484,1302,1,1252,1,1,1479,1,1,
1,1,1252,1628,1,1,1,1,1658,1,1,1,1,1538,1315,1,1,1,1,
1544,1,1,1,1,1,1364,1293,1624,1542,1,1542,1,1542,1377,1286,
1286,1465,1259,1,1,1280,1280,1286,1,1465,1259,1,1,1,1562,1,
1,1569,1,1282,1211,1280,1,1,1,1280,1,1,1,1282,1211,1395,
1349,1506,1,1,1542,1,1258,1192,1248,1,1,1,1272,1,1,1,1248,
1,1,1649,1,1,1677,1677,1633,1408,1378,1378,1,1,1651,1,1408,
1,1378,1378,1562,1384,1,1,1638,1612,1,1307,1335,1,1,1544,1,
1353,1,1,1334,1562,1,1,1658,1,1515,1,1508,1,1,1,1508,1515,
1,1515,1515,1,1666,1,1572,1391,1283,1,1,1,1615,1,1,1,1283,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1656,1,1,1,1493,1,1,1,
1,1,1,1,1493,1,1,1616,1,1,1,1,1,1,1,1616,1,1208,1,1,1,
1,1,1490,1286,1,1,1,1,1,1,1,1306,1306,1208,1,1,1,1169,1,
1,1,1,1,1,1543,1482,1,1,1,1,1,1,1482,1372,1,1,1,1,1,1,
1,1,1,1,1,1,1,1280,1490,1,1,1,1,1,1,1,1,1,1,1,1,1169,
1339,1,1,1360,1293,1339,1339,1477,1522,1325,1349,1293,1562,
1624,1610,1562,1,1563,1,1185,1,1251,1,1,1,1185,1254,1254,
1208,1272,1208,1,1357,1,1293,1477,1339,1339,1357,1325,1506,
1293,1,1542,1,1,1656,1,1656,1222,1305,1,1169,1169,1333,1,
1333,1305,1169,1,1169,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1357,1311,1357,1522,1339,1357,
1506,1360,1311,1387,1,1542,1387,1,1,1,1286,1,1,1,1,1,1286,
1286,1286,1,1,1,1311,1506,1360,1339,1357,1357,1522,1311,1387,
1542,1,1387,1,1,1,1,1286,1,1,1,1286,1,1286,1286,1,1,1,
1200,1,1200,1,1200,1,1034,1,1293,1293,1,1,1506,1,1165,1165,
1139,1,1,1165,1165,1,1,1,1139,1,1339,1270,1357,1270,1,1200,
1339,1,1477,1339,1357,1506,1357,1241,1166,1245,1186,1186,1166,
1241,1166,1166,1186,1245,1186,1339,1,1,1395,1,1,1542,1,1,1,
1563,1,1185,1254,1272,1208,1208,1254,1185,1,1,1,1251,1,1,
1270,1339,1200,1225,1293,1293,1225,1614,1,1614,1251,1251,1,
1155,1155,1251,1251,1,1,1155,1,1155,1357,1,1,1,1377,1377,1,
1,1,1,1286,1286,1,1,1,1286,1286,1,1,1,1,1,1339,1200,1339,
1477,1,1339,1357,1506,1357,1166,1241,1241,1166,1166,1241,1166,
1166,1166,1166,1241,1166,1,1,1,1542,1,1,1563,1,1254,1185,
1251,1,1,1185,1254,1,1,1208,1272,1208,1,1293,1293,1,1,1506,
1,1165,1165,1139,1,1,1165,1165,1,1,1,1139,1,1364,1364,1178,
1,1658,1,1352,1352,1188,1,1,1344,1344,1,1231,1,1188,1,1529,
1364,1628,1,1628,1465,1,1286,1286,1286,1,1465,1259,1259,1280,
1,1280,1364,1628,1,1628,1,1465,1,1280,1280,1465,1,1259,1259,
1286,1286,1286,1,1658,1,1352,1352,1188,1,1,1344,1344,1,1231,
1,1188,1,1649,1324,1,1,1624,1,1,1,1,1,1,1,1624,1,1649,1,
1,1,1562,1562,1,1,1,1,1562,1,1562,1,1,1624,1,1,1,1,1,1,
1,1624,1,1166,1,1,1,1257,1230,1257,1166,1,1,1,1,1,1,1230,
1257,1257,1166,1,1,1,1364,1364,1,1,1,1,1529,1529,1529,1178,
1,1,1,1,1364,1529,1364,1,1,1,1,1364,1529,1364,1166,1166,
1257,1,1,1,1166,1257,1,1,1,1230,1,1,1,1,1,1,1364,1178,
1364,1364,1,1,1339,1364,1364,1364,1569,1339,1562,1529,1,1,1,
1562,1,1,1569,1211,1,1,1280,1,1,1,1280,1282,1211,1,1282,1,
1,1339,1364,1364,1529,1569,1339,1384,1364,1624,1649,1624,1649,
1,1569,1,1,1,1280,1,1,1,1211,1282,1280,1211,1282,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1618,1658,1658,1625,1656,1656,1666,1625,1638,1,1,1658,1,1,1,
1,1,1,1,1,1,1,1616,1616,1,1,1,1,1,1293,1,1217,1,1293,1,
1325,1349,1506,1,1371,1371,1180,1,1282,1282,1,1,1180,1,1,1,
1327,1327,1178,1364,1,1,1,1364,1,1,1,1562,1,1387,1387,1188,
1,1366,1366,1,1,1188,1,1,1,1366,1366,1364,1,1,1,1364,1,1,
1,1562,1,1387,1387,1188,1,1366,1366,1,1,1188,1,1,1,1366,
1366,1,1293,1624,1529,1318,1395,1318,1562,1,1,1614,1252,1,1,
1479,1,1,1252,1,1,1302,1,1484,1656,1,1,1,1,1666,1,1,1,1,
1493,1,1,1,1,1,1493,1,1,1,1,1,1,1293,1349,1395,1,1506,1,
1357,1357,1169,1,1333,1333,1,1,1169,1169,1169,1222,1305,1305,
1,1,1,1,1,1,1635,1,1283,1,1615,1,1,1,1283,1,1,1,1572,
1391,1542,1624,1542,1,1,1614,1,1252,1,1479,1,1,1,1252,1,1,
1302,1484,1,1,1384,1562,1,1,1656,1335,1,1,1544,1,1,1334,1,
1307,1,1353,1612,1,1649,1,1,1681,1,1,1,1626,1,1,1,1,1,1,
1,1626,1562,1,1,1635,1,1,1,1615,1,1,1,1283,1283,1391,1,
1572,1,1658,1,1515,1,1508,1,1,1,1508,1,1515,1515,1515,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1628,1,1,1,1544,1,1,1,1,1,
1315,1,1538,1,1,1544,1,1,1,1,1,1,1315,1538,1,1,1,1,1,1,
1372,1482,1169,1,1,1,1,1,1,1,1,1,1,1,1,1,1280,1,1,1,1,
1,1306,1,1490,1,1,1,1,1,1306,1490,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1169,1482,1,1,1,1543,1,1,1,1,1,1,1208,1208,1286,
1387,1,1339,1529,1364,1364,1387,1339,1562,1364,1,1562,1,1,
1658,1,1,1,1366,1,1,1188,1366,1,1366,1366,1188,1,1,1,1548,
1628,1569,1569,1628,1563,1658,1614,1,1,1,1635,1,1,1,1315,1,
1,1,1,1,1,1544,1538,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1293,1,1,1,1384,1562,1293,
1,1349,1,1349,1,1,1542,1192,1258,1,1248,1,1272,1,1,1,1,1,
1248,1364,1364,1628,1293,1,1529,1,1,1,1610,1377,1,1542,1286,
1286,1,1479,1295,1280,1,1280,1286,1295,1,1479,1324,1,1,1649,
1364,1,1384,1,1384,1,1,1569,1211,1282,1,1282,1211,1280,1,1,
1,1,1,1280,1,1,1649,1364,1,1384,1,1384,1,1,1569,1211,1282,
1,1282,1211,1280,1,1,1,1,1,1280,1,1,1,1,1638,1,1,1,1,1,
1315,1538,1,1,1,1544,1,1,1,1,1,1,1562,1293,1,1349,1,1349,
1360,1,1522,1208,1272,1,1254,1185,1251,1,1,1208,1185,1,1254,
1,1,1,1,1,1658,1,1,1515,1515,1,1,1508,1508,1,1,1,1515,1,
1515,1,1610,1,1,1625,1,1,1302,1484,1,1,1252,1479,1,1,1,
1252,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1624,
1,1,1656,1307,1,1,1612,1353,1,1,1334,1335,1,1,1544,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1666,1,1,1,1572,1,1,1283,
1615,1,1,1391,1283,1,1,1,1656,1,1,1,1616,1,1,1,1,1,1,1,
1616,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1493,1,1,1,1,
1493,1,1,1208,1,1,1,1306,1,1306,1208,1,1,1,1,1,1,1,1,
1490,1286,1,1,1,1,1,1,1,1,1,1,1,1,1169,1,1,1,1,1482,1,
1543,1,1,1,1,1372,1,1482,1,1280,1490,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1169,1,1,1548,1628,1569,1614,1628,1563,1638,
1569,1635,1,1656,1681,1,1,1,1,1,1,1,1,1,1315,1538,1544,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1293,1,1293,1,1217,1,1,1,1506,1349,1325,1,1542,1,
1,1272,1248,1,1,1258,1192,1,1,1,1248,1,1364,1529,1628,1293,
1,1364,1542,1,1542,1624,1377,1542,1,1,1280,1479,1,1295,1286,
1286,1286,1280,1295,1479,1,1364,1,1,1,1178,1,1562,1,1,1,
1569,1,1,1280,1282,1,1211,1282,1211,1,1,1,1280,1,1,1293,
1624,1364,1318,1562,1318,1395,1625,1,1,1,1479,1,1,1252,1484,
1302,1,1,1252,1,1,1,1,1,1,1658,1,1,1,1,1,1,1544,1,1,1,
1538,1315,1,1,1,1,1,1,1,1349,1506,1,1395,1360,1522,1,1,
1251,1254,1,1185,1272,1208,1208,1,1185,1254,1,1,1,1,1,1,1,
1656,1,1,1334,1544,1,1,1335,1307,1,1,1353,1612,1,1,1562,1,
1,1,1569,1,1,1280,1282,1,1211,1282,1211,1,1,1,1280,1,1562,
1384,1,1,1666,1,1,1617,1283,1,1,1570,1390,1,1388,1,1283,1,
1562,1649,1658,1,1,1,1,1515,1,1515,1,1515,1515,1508,1508,1,
1,1,1638,1,1,1,1544,1,1,1334,1612,1,1353,1,1335,1307,1,1,
1,1,1,1626,1,1,1,1626,1,1,1,1,1,1,1656,1,1,1,1616,1,1,
1,1,1,1,1,1616,1,1,1,1,1,1,1493,1,1,1,1,1493,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1306,1490,1280,1,1,1,1,1169,1,1,1,1,1482,1543,1,1,1,1,1,
1,1,1,1,1,1,1,1,1372,1482,1,1208,1286,1490,1,1,1,1208,
1306,1,1,1,1,1,1,1,1,1,1,1169,1,1,1614,1649,1656,1614,
1649,1649,1656,1614,1628,1,1,1628,1,1,1,1,1,1,1,1,1,1,
1624,1624,1,1,1,1,1,1311,1,1506,1,1311,1,1,1542,1371,1,1,
1,1482,1,1,1,1,1,1482,1,1,1,1,1,1,1,1324,1649,1,1,1,1,
1656,1,1,1,1,1624,1,1,1,1,1,1624,1,1,1,1,1,1569,1,1,1,
1569,1,1,1,1656,1,1,1,1493,1,1,1,1,1,1493,1,1,1,1,1,1,
1506,1,1311,1320,1,1522,1320,1,1,1,1482,1,1,1,1,1,1482,1,
1,1,1,1,1649,1,1,1,1,1656,1,1,1,1,1624,1,1,1,1,1,1624,
1,1,1,1,1,1658,1506,1563,1,1,1563,1,1,1,1562,1,1,1,1,1,
1562,1562,1562,1,1,1,1,1,1,1666,1,1,1,1,1616,1,1,1,1,1,
1616,1,1,1,1,1,1371,1,1542,1,1,1,1,1482,1,1,1,1,1,1482,
1,1,1,1,1,1,1569,1387,1,1,1,1538,1,1,1,1,1,1544,1,1315,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1569,1,1,1,
1,1,1,1,1,1,1,1493,1493,1,1,1,1,1,1,1538,1,1,1,1,1,
1544,1,1315,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1384,1610,1562,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1562,1610,1,1,1,1384,1,1,1,1,1,1,1,1,1,1506,1,1311,1,
1,1569,1311,1,1542,1,1371,1,1,1,1,1482,1,1,1,1482,1,1,1,
1,1,1,1658,1506,1649,1649,1,1506,1563,1,1,1563,1,1,1,1,
1562,1,1,1,1562,1,1562,1562,1,1,1,1,1,1,1,1,1,1666,1,1,
1,1,1,1,1616,1,1,1,1616,1,1,1,1,1,1,1,1,1569,1311,1320,
1522,1,1320,1,1,1,1,1482,1,1,1,1482,1,1,1,1,1,1,1324,1,
1,1,1656,1,1,1,1,1,1,1624,1,1,1,1624,1,1,1,1,1,1,1,1,
1,1656,1,1,1,1,1,1,1624,1,1,1,1624,1,1,1,1,1,1,1,1656,
1,1,1,1,1,1,1,1493,1,1,1,1493,1,1,1,1,1,1,1371,1542,1,
1,1,1,1,1,1482,1,1,1,1482,1,1,1,1,1,1,1569,1,1387,1,1,
1,1,1538,1,1,1,1544,1,1,1315,1,1,1,1,1569,1,1,1,1,1,1,
1,1,1,1,1493,1493,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1538,1,1,1,1544,1,1,1315,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1384,
1,1610,1562,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1562,1610,1,1,1,1,1,1,1,1,1384,1,1,1,
1,1,1,1,1,1,1,1200,1,1200,1,1200,1,1,1293,1293,1,1311,
1311,1139,1,1168,1168,1,1,1139,1,1,1,1168,1168,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1364,1364,
1200,1,1217,1384,1217,1,1,1506,1168,1168,1,1139,1,1168,1168,
1,1,1,1,1139,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1364,1200,1,1293,1,1293,1,1311,1311,1,1139,1165,1165,
1,1139,1,1,1,1,1165,1165,1,1,1,1562,1,1,1569,1,1282,1211,
1280,1,1,1,1280,1,1,1,1282,1211,1,1293,1293,1,1,1506,1,
1165,1165,1139,1,1,1165,1165,1,1,1,1139,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1339,1339,1,1,1548,1248,1,1192,
1258,1,1,1248,1,1,1,1,1272,1339,1,1,1548,1,1248,1,1272,1,
1248,1,1,1,1,1192,1258,1,1618,1,1327,1327,1180,1,1,1282,
1282,1,1,1,1180,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1614,1,
1,1,1482,1,1,1,1,1,1,1,1482,1,1,1482,1,1,1,1,1,1,1,
1482,1,1155,1,1,1,1437,1340,1,1,1,1,1,1,1,1,1340,1437,1,
1,1,1,1,1155,1,1,1,1,1,1,1340,1437,1,1,1,1,1,1,1437,
1340,1,1,1,1,1,1,1,1155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1155,1364,1,1,1,1364,1,1,1,1562,1,1387,1387,
1188,1,1366,1366,1,1,1188,1,1,1,1366,1366,1,1200,1,1364,
1217,1,1217,1384,1311,1,1311,1139,1,1,1168,1168,1,1139,1,1,
1168,1,1168,1649,1,1,1,1,1656,1,1,1,1,1624,1,1,1,1,1,
1624,1,1,1,1,1,1,1200,1293,1,1,1293,1225,1225,1225,1364,
1364,1203,1203,1203,1364,1364,1364,1364,1203,1203,1203,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1293,1,1293,1,1311,
1311,1,1139,1,1168,1,1168,1,1139,1,1,1168,1168,1,1,1339,
1339,1,1360,1522,1272,1208,1191,1257,1,1,1251,1,1208,1,1191,
1257,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1339,1357,1,
1357,1,1169,1,1340,1340,1169,1,1169,1169,1312,1226,1312,1522,
1360,1,1272,1208,1191,1,1257,1,1251,1,1208,1257,1191,1,1357,
1357,1,1,1290,1290,1,1,1,1,1,1,1290,1290,1357,1,1,1,1290,
1290,1,1,1,1,1290,1,1290,1,1,1290,1,1290,1,1,1,1,1290,
1290,1,1364,1,1,1,1529,1529,1529,1364,1,1,1,1,1,1,1364,
1529,1364,1178,1,1,1,1186,1186,1,1,1,1,1257,1194,1257,1186,
1,1,1,1,1257,1257,1194,1,1,1,1,1194,1257,1257,1364,1178,
1364,1,1,1,1364,1529,1,1,1,1364,1,1,1,1,1,1,1186,1186,
1186,1,1,1649,1364,1,1384,1,1384,1,1,1569,1211,1282,1,1282,
1211,1280,1,1,1,1,1,1280,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1681,1,1,1,1626,1,1,1,1,1,1,1,
1626,1,1,1562,1,1,1,1569,1,1,1280,1282,1,1211,1282,1211,1,
1,1,1280,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1624,1,1,1635,1283,1,1391,1572,1,1,1283,1,1,1,1,1615,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1638,1,1353,1612,1335,1,
1307,1544,1,1,1,1,1334,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1628,1,1,1,1538,1315,1,1,1,1,1,1,1544,1,1,1538,1,1315,1,
1,1,1,1,1544,1,1169,1,1,1,1482,1372,1,1,1,1,1,1,1,1,
1543,1482,1,1,1,1,1,1286,1208,1,1,1,1,1,1,1490,1208,1,1,
1,1,1,1490,1,1,1,1,1,1,1306,1306,1169,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1280,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1364,1200,1384,1217,1,1217,1311,1,
1311,1,1139,1,1165,1165,1139,1,1,1,1165,1,1165,1,1384,1,
1384,1,1569,1,1,1280,1,1,1,1280,1211,1282,1,1,1282,1,1211,
1217,1384,1217,1,1506,1,1,1168,1168,1,1,1139,1168,1168,1,1,
1139,1,1,1225,1395,1225,1,1,1522,1172,1172,1,1149,1,1172,
1172,1,1,1,1,1149,1225,1395,1320,1,1320,1149,1,1,1172,1172,
1,1149,1,1,1172,1,1172,1225,1320,1,1320,1,1149,1,1172,1172,
1149,1,1,1,1172,1,1172,1522,1,1,1172,1172,1,1,1149,1172,
1172,1,1,1149,1,1,1,1614,1,1,1,1482,1,1,1,1,1,1,1,1482,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1482,1,1,1,1,1482,
1,1,1155,1,1,1,1437,1340,1,1,1,1,1,1,1,1,1340,1437,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1155,1,1,1,1,1437,1,1340,1,1,
1,1,1340,1,1437,1155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1155,1,1,1,1,1656,1,1,1,1,1,1,1624,1,1,1,1624,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1658,1,1,1,1,1616,1,1,1,1,1,
1616,1,1,1,1,1,1,1,1,1,1,1616,1,1,1,1616,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1562,1,1,1,1610,1384,1,1,1,1,1,1,1,1,1384,1610,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1562,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1562,1,1,1,1387,1387,1,1,1188,1344,1,1344,1188,1,1,1,
1352,1352,1231,1293,1293,1,1,1311,1311,1,1,1139,1165,1,1165,
1139,1,1,1,1165,1165,1,1339,1,1339,1,1360,1522,1208,1272,
1185,1254,1,1251,1,1,1208,1,1185,1254,1,1339,1357,1,1357,
1169,1,1222,1305,1305,1,1169,1169,1169,1333,1,1333,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1522,1360,1,1208,1272,1185,1,
1254,1251,1,1,1208,1254,1185,1,1357,1357,1,1,1286,1286,1,1,
1,1,1,1,1286,1286,1357,1,1,1,1286,1286,1,1,1,1,1286,1,
1286,1,1,1286,1,1286,1,1,1,1,1286,1286,1,1364,1,1,1,1529,
1364,1364,1178,1,1,1,1,1,1,1529,1529,1529,1364,1,1,1,1166,
1166,1,1,1,1,1257,1230,1257,1166,1,1,1,1,1257,1257,1230,1,
1,1,1,1230,1257,1257,1364,1364,1529,1,1,1,1178,1364,1,1,1,
1364,1,1,1,1,1,1,1166,1166,1166,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1624,1,1,1638,1,1612,1353,1334,1,1,1,
1544,1,1,1,1335,1307,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1635,1,1,1,1283,1,1,1615,1283,1,1,1,1572,1391,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1628,1,1,1,1544,1,1,1,1,1,
1,1,1538,1315,1,1,1,1,1,1544,1,1,1,1,1538,1,1315,1,1,1,
1,1,1,1,1,1,1,1,1,1169,1,1,1,1482,1543,1,1,1,1,1,1,1,
1,1372,1482,1,1,1,1,1,1,1280,1,1,1,1,1490,1,1306,1,1,1,
1,1,1,1,1,1,1,1,1,1,1490,1306,1169,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1286,1208,1208,1339,1339,1,1,1618,1,1327,
1327,1180,1,1,1282,1282,1,1,1,1180,1,1339,1,1548,1,1,1248,
1,1192,1,1258,1,1248,1,1,1272,1,1,1,1548,1,1,1,1248,1,1,
1272,1248,1,1,1,1258,1192,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1614,1,1,1,1482,1,1,1,1,1,1,1,1482,1,1,1,1,1,1,
1482,1,1,1,1,1482,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1155,1,
1,1,1437,1340,1,1,1,1,1,1,1,1,1340,1437,1,1,1,1,1,1,
1155,1,1,1,1,1437,1340,1,1,1,1,1,1,1,1,1,1,1,1,1,1340,
1437,1,1155,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1155,1,
1,1364,1364,1,1,1569,1282,1,1211,1282,1,1,1280,1,1211,1,1,
1280,1364,1,1,1569,1,1282,1,1280,1,1280,1,1,1211,1,1211,
1282,1,1658,1,1352,1352,1188,1,1,1344,1344,1,1231,1,1188,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1656,1,1,1,1616,1,1,1,1,
1,1,1,1616,1,1,1493,1,1,1,1,1,1,1,1493,1,1286,1,1,1,
1490,1398,1,1208,1,1,1,1,1,1,1398,1490,1,1208,1,1,1,1169,
1,1,1,1,1,1,1372,1482,1,1,1,1,1,1,1482,1543,1,1,1,1,1,
1,1,1280,1,1306,1,1,1,1,1306,1,1,1,1,1,1,1,1,1,1,1,1,
1169,1364,1387,1,1387,1,1,1,1366,1366,1,1,1188,1188,1366,1,
1366,1569,1,1,1282,1,1211,1,1282,1,1280,1,1211,1280,1,1,1,
1628,1,1,1315,1538,1,1,1,1,1,1,1,1544,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1315,1,1538,1,1,1,1,1544,1,1,1,1,1,1,1,
1543,1482,1169,1,1,1,1,1,1,1,1,1,1,1,1,1,1208,1208,1,1,
1,1,1306,1,1306,1286,1,1,1,1,1490,1,1,1,1,1,1,1,1,1490,
1,1,1,1,1,1,1169,1482,1,1,1,1372,1,1,1,1,1,1,1,1280,1,
1569,1,1,1,1282,1,1,1280,1280,1,1,1211,1282,1211,1,1,1628,
1,1,1,1544,1,1,1,1,1,1,1315,1538,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1544,1,1,1,1,1538,1315,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1543,1,1482,1169,1,1,1,1,1,1,1,1,1,1,1,
1,1280,1,1,1,1,1490,1306,1,1,1,1,1,1,1306,1490,1,1169,
1482,1,1,1,1,1,1,1,1,1372,1,1,1,1,1,1,1208,1286,1208,
1656,1,1,1,1493,1,1,1,1,1,1,1,1493,1,1,1,1,1,1,1616,1,
1,1,1,1616,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1286,1,1,1,
1490,1,1,1208,1,1,1,1,1,1,1,1490,1,1208,1,1,1,1,1169,1,
1,1,1,1482,1372,1,1,1,1,1,1,1,1,1,1,1,1,1,1543,1482,1,
1280,1,1306,1,1,1,1,1306,1,1,1,1,1,1,1,1,1,1,1169,1,1,
1649,1,1,1,1624,1,1,1,1,1,1,1,1624,1,1,1624,1,1,1,1,1,
1,1,1624,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1562,1,1,1,1,1,1,1384,1610,1,1,1,1,1,1,1610,1384,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1562,1,1,1,1,1624,1,1,1,1,1624,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1562,1,1,
1,1,1610,1,1384,1,1,1,1,1384,1,1610,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1562,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1562,1,1,1,1,1610,1384,1,1,1,1,1,
1,1,1,1,1,1,1,1,1384,1610,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1562,1,1,1,1,1,1364,1364,1529,1364,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1364,
1529,1529,1,1,1,1364,1364,1,1,1,1364,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1364,1364,1364,1,1,1,1529,1529,1,1,1,1364,1,1,1,1,1,1,1,
1,1,1364,1,1,1,1,1529,1364,1364,1,1,1,1,1364,1364,1529,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1364,1529,1364,1,1,
1,1,1364,1529,1364,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1529,1364,1364,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1364,1364,1529,1364,1529,1,1,1,1364,1,1,1,1,1,1,1,1,1,
1364,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1364];

return List(orbitlengthspos,i->orbitlengthsset[i]);

#############################################################################
##
#E  orbitlengths.g . . . . . . . . . . . . . . . . . . . . . . . .  ends here