/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;

public class MavenLauncherConfigurationHandler
implements IMavenLauncherConfiguration {
    private String mainType;
    private String mainRealm;
    private LinkedHashMap<String, List<String>> realms = new LinkedHashMap();
    private List<String> curEntries;

    public void addArchiveEntry(String entry) {
        if (this.curEntries == null) {
            throw new IllegalStateException();
        }
        this.curEntries.add(entry);
    }

    public void forceArchiveEntry(String entry) {
        List<String> realm = this.realms.get(this.mainRealm);
        if (realm == null) {
            throw new IllegalStateException();
        }
        realm.add(0, entry);
    }

    public void addProjectEntry(IMavenProjectFacade facade) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder output = root.getFolder(facade.getOutputLocation());
        if (output.isAccessible()) {
            this.addArchiveEntry(output.getLocation().toFile().getAbsolutePath());
        }
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 1) {
                    IResource resource = root.findMember(cpe.getPath());
                    if (resource != null) {
                        this.addArchiveEntry(resource.getLocation().toOSString());
                    } else {
                        File file = cpe.getPath().toFile();
                        if (file.exists()) {
                            this.addArchiveEntry(file.getAbsolutePath());
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public void addRealm(String realm) {
        if (!this.realms.containsKey(realm)) {
            this.curEntries = new ArrayList<String>();
            this.realms.put(realm, this.curEntries);
        }
    }

    public void setMainType(String type, String realm) {
        this.mainType = type;
        this.mainRealm = realm;
    }

    public void save(OutputStream os) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
        out.write(NLS.bind((String)"main is {0} from {1}\n", (Object)this.mainType, (Object)this.mainRealm));
        for (Map.Entry<String, List<String>> realm : this.realms.entrySet()) {
            if ("]launcher".equals(realm.getKey())) continue;
            out.write(NLS.bind((String)"[{0}]\n", (Object)realm.getKey()));
            for (String entry : realm.getValue()) {
                out.write(NLS.bind((String)"load {0}\n", (Object)entry));
            }
        }
        out.flush();
    }

    public String getMainReal() {
        return this.mainRealm;
    }

    public List<String> getRealmEntries(String realm) {
        return this.realms.get(realm);
    }
}

