/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.handlers;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.wst.common.ui.internal.dialogs.SaveDirtyFilesDialog;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.XMLRefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.handlers.RefactoringHandler;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RenameRefactoringWizard;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Node;

public class RenameHandler
extends RefactoringHandler {
    protected Object doExecute(ISelection selection, XSDSchema schema) {
        return this.execute(selection, schema);
    }

    public Object execute(ISelection selection, XSDSchema schema) {
        if (selection != null) {
            Object selectedObject = ((StructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof XSDBaseAdapter) {
                selectedObject = ((XSDBaseAdapter)selectedObject).getTarget();
            }
            if (selectedObject instanceof XSDNamedComponent) {
                this.run(selection, schema, (XSDNamedComponent)selectedObject);
            } else if (selectedObject instanceof Node) {
                XSDConcreteComponent concreteComponent;
                Node node = (Node)selectedObject;
                if (schema != null && (concreteComponent = schema.getCorrespondingComponent(node)) instanceof XSDNamedComponent) {
                    this.run(selection, schema, (XSDNamedComponent)concreteComponent);
                }
            }
        }
        return null;
    }

    public void run(ISelection selection, XSDSchema schema, XSDNamedComponent selectedComponent) {
        boolean rc;
        if (selectedComponent.getName() == null) {
            selectedComponent.setName(new String());
        }
        if (selectedComponent.getSchema() == null && schema != null) {
            schema.updateElement(true);
        }
        if (!(rc = SaveDirtyFilesDialog.saveDirtyFiles())) {
            return;
        }
        XMLRefactoringComponent component = new XMLRefactoringComponent(selectedComponent, (IDOMElement)selectedComponent.getElement(), selectedComponent.getName(), selectedComponent.getTargetNamespace());
        RenameComponentProcessor processor = new RenameComponentProcessor(component, selectedComponent.getName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringWizardMessages.RenameComponentWizard_defaultPageTitle, RefactoringWizardMessages.RenameComponentWizard_inputPage_description, null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
        }
        catch (InterruptedException interruptedException) {}
    }
}

