/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.misc;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;

public class StringMatcher {
    protected String fPattern;
    protected int fLength;
    protected boolean fIgnoreWildCards;
    protected boolean fIgnoreCase;
    protected String[] patternWords;
    protected Word wholePatternWord;
    protected Word[] splittedPatternWords;
    protected static final char fSingleWildCard = '\u0000';

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.fIgnoreCase = ignoreCase;
        this.fIgnoreWildCards = ignoreWildCards;
        this.fPattern = pattern;
        this.fLength = pattern.length();
        this.parsePatternIntoWords();
        if (this.fIgnoreWildCards) {
            this.parseNoWildCards();
        } else {
            if (this.wholePatternWord != null) {
                this.wholePatternWord.parseWildcards();
            }
            if (this.splittedPatternWords != null && this.splittedPatternWords.length > 1) {
                Word[] wordArray = this.splittedPatternWords;
                int n = this.splittedPatternWords.length;
                int n2 = 0;
                while (n2 < n) {
                    Word word = wordArray[n2];
                    word.parseWildcards();
                    ++n2;
                }
            }
        }
    }

    public boolean match(String text) {
        if (text == null) {
            return false;
        }
        return this.match(text, 0, text.length());
    }

    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        int tlen = text.length();
        start = Math.max(0, start);
        end = Math.min(end, tlen);
        if (this.wholePatternWord != null && (this.wholePatternWord.match(text, start, end) || this.wholePatternWord.matchTextWord(text, start, end))) {
            return true;
        }
        if (this.splittedPatternWords != null && this.splittedPatternWords.length > 0) {
            Word[] wordArray = this.splittedPatternWords;
            int n = this.splittedPatternWords.length;
            int n2 = 0;
            while (n2 < n) {
                Word word = wordArray[n2];
                if (!word.match(text, start, end) && !word.matchTextWord(text, start, end)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private void parsePatternIntoWords() {
        String trimedPattern = this.fPattern.trim();
        if (!trimedPattern.isEmpty()) {
            this.wholePatternWord = new Word(trimedPattern);
            this.patternWords = trimedPattern.split("\\s+");
            if (this.patternWords.length > 1) {
                this.splittedPatternWords = new Word[this.patternWords.length];
                int i = 0;
                while (i < this.patternWords.length) {
                    String patternWord = this.patternWords[i];
                    if (!patternWord.endsWith("*")) {
                        patternWord = String.valueOf(patternWord) + '*';
                    }
                    this.splittedPatternWords[i] = new Word(patternWord);
                    ++i;
                }
            }
        }
    }

    private void parseNoWildCards() {
        this.wholePatternWord = new Word(this.fPattern, this.fLength, this.patternWords);
        this.wholePatternWord.bound = this.fLength;
        this.wholePatternWord.fragments = this.patternWords;
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.fLength;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(this.fPattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.fPattern, 0, this.fLength)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        while (plen-- > 0) {
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.fIgnoreWildCards && pchar == '\u0000' || pchar == tchar || this.fIgnoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.fIgnoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String[] getWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        BreakIterator iter = BreakIterator.getWordInstance();
        iter.setText(text);
        int i = iter.first();
        while (i != -1 && i < text.length()) {
            int j = iter.following(i);
            if (j == -1) {
                j = text.length();
            }
            if (Character.isLetterOrDigit(text.charAt(i))) {
                String word = text.substring(i, j);
                words.add(word);
            }
            i = j;
        }
        return words.toArray(new String[words.size()]);
    }

    public static class Position {
        int start;
        int end;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    class Word {
        private boolean hasTrailingStar = false;
        private boolean hasLeadingStar = false;
        private int bound = 0;
        private String[] fragments = null;
        private final String pattern;

        Word(String pattern) {
            this.pattern = pattern;
        }

        public Word(String pattern, int fLength, String[] wordsSplitted) {
            this(pattern);
            this.bound = fLength;
            this.fragments = wordsSplitted;
        }

        private void parseWildcards() {
            if (this.pattern.startsWith("*")) {
                this.hasLeadingStar = true;
            }
            if (this.pattern.endsWith("*") && this.pattern.length() > 1 && this.pattern.charAt(this.pattern.length() - 2) != '\\') {
                this.hasTrailingStar = true;
            }
            ArrayList<String> temp = new ArrayList<String>();
            int pos = 0;
            StringBuilder buf = new StringBuilder();
            block5: while (pos < this.pattern.length()) {
                char c = this.pattern.charAt(pos++);
                switch (c) {
                    case '\\': {
                        char next;
                        if (pos >= this.pattern.length()) {
                            buf.append(c);
                            break;
                        }
                        if ((next = this.pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                            buf.append(next);
                            break;
                        }
                        buf.append(c);
                        buf.append(next);
                        break;
                    }
                    case '*': {
                        if (buf.length() <= 0) continue block5;
                        temp.add(buf.toString());
                        this.bound += buf.length();
                        buf.setLength(0);
                        break;
                    }
                    case '?': {
                        buf.append('\u0000');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            if (buf.length() > 0) {
                temp.add(buf.toString());
                this.bound += buf.length();
            }
            this.fragments = temp.toArray(new String[temp.size()]);
        }

        /*
         * Unable to fully structure code
         */
        boolean match(String text, int start, int end) {
            found = true;
            if (StringMatcher.this.fIgnoreWildCards) {
                return end - start == this.pattern.length() && this.pattern.regionMatches(StringMatcher.this.fIgnoreCase, 0, text, start, this.pattern.length()) != false;
            }
            segments = null;
            segments = this.fragments;
            segCount = segments.length;
            if (segCount == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
                return true;
            }
            if (start == end) {
                return this.pattern.length() == 0;
            }
            if (this.pattern.length() == 0) {
                return start == end;
            }
            tCurPos = start;
            bound = end - this.bound;
            if (bound < 0) {
                return false;
            }
            i = 0;
            current = segments[i];
            segLength = current.length();
            if (!this.hasLeadingStar) {
                if (!StringMatcher.this.regExpRegionMatches(text, start, current, 0, segLength)) {
                    return false;
                }
                ++i;
                tCurPos += segLength;
            }
            if (segments.length != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl41
            return tCurPos == end;
lbl-1000:
            // 1 sources

            {
                current = segments[i];
                k = current.indexOf(0);
                if (k < 0) {
                    currentMatch = StringMatcher.this.textPosIn(text, tCurPos, end, current);
                    if (currentMatch < 0) {
                        found = false;
                    }
                } else {
                    currentMatch = StringMatcher.this.regExpPosIn(text, tCurPos, end, current);
                    if (currentMatch < 0) {
                        found = false;
                    }
                }
                if (!found) {
                    return false;
                }
                tCurPos = currentMatch + current.length();
                ++i;
lbl41:
                // 2 sources

                ** while (i < segCount && found)
            }
lbl42:
            // 1 sources

            if (!this.hasTrailingStar && tCurPos != end) {
                clen = current.length();
                return StringMatcher.this.regExpRegionMatches(text, end - clen, current, 0, clen) != false;
            }
            return i == segCount;
        }

        public boolean matchTextWord(String text, int start, int end) {
            String[] textWords = StringMatcher.getWords(text.substring(start, end));
            if (textWords.length == 0) {
                return this.pattern.isEmpty();
            }
            String[] stringArray = textWords;
            int n = textWords.length;
            int n2 = 0;
            while (n2 < n) {
                String subword = stringArray[n2];
                if (this.match(subword, 0, subword.length())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

