/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import java.net.URI;
import java.net.URL;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class Browsers {
    public static void openInDefaultBrowser(String url) {
        try {
            IWebBrowser defaultBrowser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            defaultBrowser.openURL(new URL(url));
        }
        catch (Throwable e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_OPEN_BROWSER_FAILED, (Throwable)e);
        }
    }

    public static void openInDefaultBrowser(URL url) {
        Browsers.openInDefaultBrowser(url.toExternalForm());
    }

    public static void openInExternalBrowser(String url) {
        try {
            IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            externalBrowser.openURL(new URL(url));
        }
        catch (Throwable throwable) {
            try {
                if (!Program.launch((String)url)) {
                    Browsers.openInDefaultBrowser(url);
                }
            }
            catch (Throwable e1) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_OPEN_BROWSER_FAILED, (Throwable)e1);
            }
        }
    }

    public static void openInExternalBrowser(@Nullable Object url) {
        if (url != null) {
            Browsers.openInExternalBrowser(url.toString());
        }
    }

    public static void openInExternalBrowser(URL url) {
        Browsers.openInExternalBrowser(url.toExternalForm());
    }

    private static boolean isValidUrl(String url) {
        try {
            URI uri = URI.create(url);
            uri.toURL();
            return true;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_URL_VALIDATION_FAILED, (Throwable)e, (Object[])new Object[]{url, e.getMessage()});
            return false;
        }
    }
}

