/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.views;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleLanguage;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleTerritory;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class OracleConnectionExtraPage
extends ConnectionPageAbstract {
    private Combo languageCombo;
    private Combo territoryCombo;
    private Text nlsDateFormat;
    private Button hideEmptySchemasCheckbox;
    private Button showDBAAlwaysCheckbox;
    private Button useDBAViewsCheckbox;
    private Button useRuleHint;

    public OracleConnectionExtraPage() {
        this.setTitle("Oracle properties");
        this.setDescription("Regional settings and performance");
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        Group sessionGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)"Session settings", (int)2, (int)32, (int)0);
        this.languageCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)"Language", (int)4);
        this.languageCombo.setToolTipText("Session language");
        this.languageCombo.add("Default");
        Enum[] enumArray = OracleLanguage.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            OracleLanguage language = enumArray[n2];
            this.languageCombo.add(language.getLanguage());
            ++n2;
        }
        this.languageCombo.setText("Default");
        this.territoryCombo = UIUtils.createLabelCombo((Composite)sessionGroup, (String)"Territory", (int)4);
        this.territoryCombo.setToolTipText("Session territory");
        this.territoryCombo.add("Default");
        enumArray = OracleTerritory.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum territory = enumArray[n2];
            this.territoryCombo.add(((OracleTerritory)territory).getTerritory());
            ++n2;
        }
        this.territoryCombo.setText("Default");
        this.nlsDateFormat = UIUtils.createLabelText((Composite)sessionGroup, (String)"NLS Date Format", (String)"");
        Group contentGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)"Content", (int)1, (int)32, (int)0);
        this.hideEmptySchemasCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)"Hide empty schemas", (boolean)true);
        this.hideEmptySchemasCheckbox.setToolTipText("Check existence of objects within schema and do not show empty schemas in tree. " + GeneralUtils.getDefaultLineSeparator() + "Enabled by default but it may cause performance problems on databases with very big number of objects.");
        this.showDBAAlwaysCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)"Always show DBA objects", (String)"Always shows DBA-related metadata objects in tree even if user do not has DBA role.", (boolean)false, (int)1);
        this.useDBAViewsCheckbox = UIUtils.createCheckbox((Composite)contentGroup, (String)"Always use DBA_* views", (String)"Use DBA_* views instead of ALL_* views wherever it is possible", (boolean)false, (int)1);
        contentGroup = UIUtils.createControlGroup((Composite)cfgGroup, (String)"Performance", (int)1, (int)32, (int)0);
        this.useRuleHint = UIUtils.createCheckbox((Composite)contentGroup, (String)"Use RULE hint for system catalog queries", (boolean)true);
        this.useRuleHint.setToolTipText("Adds RULE hint for some system catalog queries (like columns and constraints reading)." + GeneralUtils.getDefaultLineSeparator() + "It significantly increases performance on some Oracle databases (and decreases on others).");
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        Object checkSchemaContent;
        Object dateFormat;
        Object nlsTerritory;
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        Object nlsLanguage = providerProperties.get("@dbeaver-session-language@");
        if (nlsLanguage != null) {
            this.languageCombo.setText(nlsLanguage.toString());
        }
        if ((nlsTerritory = providerProperties.get("@dbeaver-session-territory@")) != null) {
            this.territoryCombo.setText(nlsTerritory.toString());
        }
        if ((dateFormat = providerProperties.get("@dbeaver-session-nls-date-format@")) != null) {
            this.nlsDateFormat.setText(dateFormat.toString());
        }
        if ((checkSchemaContent = providerProperties.get("@dbeaver-check-schema-content@")) != null) {
            this.hideEmptySchemasCheckbox.setSelection(CommonUtils.getBoolean(checkSchemaContent, (boolean)false));
        }
        this.showDBAAlwaysCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-show-dba@")), (boolean)false));
        this.useDBAViewsCheckbox.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-always-use-dba-views@")), (boolean)false));
        this.useRuleHint.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-use-rule-hint@")), (boolean)false));
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        if (!"Default".equals(this.languageCombo.getText())) {
            providerProperties.put("@dbeaver-session-language@", this.languageCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-language@");
        }
        if (!"Default".equals(this.territoryCombo.getText())) {
            providerProperties.put("@dbeaver-session-territory@", this.territoryCombo.getText());
        } else {
            providerProperties.remove("@dbeaver-session-territory@");
        }
        String dateFormat = this.nlsDateFormat.getText();
        if (!dateFormat.isEmpty()) {
            providerProperties.put("@dbeaver-session-nls-date-format@", dateFormat);
        } else {
            providerProperties.remove("@dbeaver-session-nls-date-format@");
        }
        providerProperties.put("@dbeaver-check-schema-content@", String.valueOf(this.hideEmptySchemasCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-show-dba@", String.valueOf(this.showDBAAlwaysCheckbox.getSelection()));
        providerProperties.put("@dbeaver-always-use-dba-views@", String.valueOf(this.useDBAViewsCheckbox.getSelection()));
        providerProperties.put("@dbeaver-use-rule-hint@", String.valueOf(this.useRuleHint.getSelection()));
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }
}

