/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablePhysical;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleTable
extends OracleTablePhysical
implements DBPScriptObject,
DBDPseudoAttributeContainer,
DBPImageProvider {
    private static final Log log = Log.getLog(OracleTable.class);
    private OracleDataType tableType;
    private String iotType;
    private String iotName;
    private boolean temporary;
    private boolean secondary;
    private boolean nested;
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public OracleTable(OracleSchema schema, String name) {
        super(schema, name);
    }

    public OracleTable(DBRProgressMonitor monitor, OracleSchema schema, ResultSet dbResult) {
        super(schema, dbResult);
        String typeOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE_OWNER");
        if (!CommonUtils.isEmpty((String)typeOwner)) {
            this.tableType = OracleDataType.resolveDataType(monitor, schema.getDataSource(), typeOwner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_TYPE"));
        }
        this.iotType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_TYPE");
        this.iotName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IOT_NAME");
        this.temporary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TEMPORARY", (String)"Y");
        this.secondary = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"SECONDARY", (String)"Y");
        this.nested = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"NESTED", (String)"Y");
        CommonUtils.isEmpty((String)this.iotName);
    }

    @Override
    public OracleTableBase.TableAdditionalInfo getAdditionalInfo() {
        return this.additionalInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=OracleTableBase.AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded && monitor != null) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    @Override
    protected String getTableTypeName() {
        return "TABLE";
    }

    public boolean isView() {
        return false;
    }

    @Property(viewable=false, order=5)
    public OracleDataType getTableType() {
        return this.tableType;
    }

    @Property(viewable=false, order=6)
    public String getIotType() {
        return this.iotType;
    }

    @Property(viewable=false, order=7)
    public String getIotName() {
        return this.iotName;
    }

    @Property(viewable=false, order=10)
    public boolean isTemporary() {
        return this.temporary;
    }

    @Property(viewable=false, order=11)
    public boolean isSecondary() {
        return this.secondary;
    }

    @Property(viewable=false, order=12)
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public OracleTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return super.getAttribute(monitor, attributeName);
    }

    @Nullable
    private OracleTableColumn getXMLColumn(DBRProgressMonitor monitor) throws DBException {
        for (OracleTableColumn col : CommonUtils.safeCollection(this.getAttributes(monitor))) {
            if (col.getDataType() != this.tableType) continue;
            return col;
        }
        return null;
    }

    @Override
    public Collection<OracleTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<OracleTableForeignKey> refs = new ArrayList<OracleTableForeignKey>();
        List allForeignKeys = ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), null);
        for (OracleTableForeignKey constraint : allForeignKeys) {
            if (constraint.getReferencedTable() != this) continue;
            refs.add(constraint);
        }
        return refs;
    }

    @Override
    @Association
    public Collection<OracleTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).foreignKeyCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).foreignKeyCache.clearObjectCache(this);
        return super.refreshObject(monitor);
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        if (CommonUtils.isEmpty((String)this.iotType) && ((OracleDataSource)this.getDataSource()).getContainer().getPreferenceStore().getBoolean("oracle.support.rowid")) {
            return new DBDPseudoAttribute[]{OracleConstants.PSEUDO_ATTR_ROWID};
        }
        return null;
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) {
        if (this.tableType != null && this.tableType.getName().equals("XMLTYPE")) {
            try {
                OracleTableColumn xmlColumn = this.getXMLColumn(monitor);
                if (xmlColumn != null) {
                    query.append("XMLType(").append(tableAlias).append(".").append(xmlColumn.getName()).append(".getClobval()) as ").append(xmlColumn.getName());
                    if (rowIdAttribute != null) {
                        query.append(",").append(rowIdAttribute.translateExpression(tableAlias));
                    }
                    return;
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
        }
        super.appendSelectSource(monitor, query, tableAlias, rowIdAttribute);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDDL(monitor, OracleDDLFormat.getCurrentFormat((OracleDataSource)this.getDataSource()), options);
    }

    @Nullable
    public DBPImage getObjectImage() {
        if (CommonUtils.isEmpty((String)this.iotType)) {
            return DBIcon.TREE_TABLE;
        }
        return DBIcon.TREE_TABLE_INDEX;
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SYS.ALL_TABLES WHERE OWNER=? AND TABLE_NAME=?");){
                    dbStat.setString(1, ((OracleSchema)this.getContainer()).getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.additionalInfo.pctFree = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_FREE");
                            this.additionalInfo.pctUsed = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_USED");
                            this.additionalInfo.iniTrans = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INI_TRANS");
                            this.additionalInfo.maxTrans = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAX_TRANS");
                            this.additionalInfo.initialExtent = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INITIAL_EXTENT");
                            this.additionalInfo.nextExtent = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NEXT_EXTENT");
                            this.additionalInfo.minExtents = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MIN_EXTENTS");
                            this.additionalInfo.maxExtents = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"MAX_EXTENTS");
                            this.additionalInfo.pctIncrease = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PCT_INCREASE");
                            this.additionalInfo.freelists = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FREELISTS");
                            this.additionalInfo.freelistGroups = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"FREELIST_GROUPS");
                            this.additionalInfo.blocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"BLOCKS");
                            this.additionalInfo.emptyBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"EMPTY_BLOCKS");
                            this.additionalInfo.avgSpace = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_SPACE");
                            this.additionalInfo.chainCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"CHAIN_CNT");
                            this.additionalInfo.avgRowLen = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_ROW_LEN");
                            this.additionalInfo.avgSpaceFreelistBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"AVG_SPACE_FREELIST_BLOCKS");
                            this.additionalInfo.numFreelistBlocks = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"NUM_FREELIST_BLOCKS");
                        } else {
                            log.warn((Object)("Cannot find table '" + this.getFullyQualifiedName(DBPEvaluationContext.UI) + "' metadata"));
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
    }

    public class AdditionalInfo
    extends OracleTableBase.TableAdditionalInfo {
        private int pctFree;
        private int pctUsed;
        private int iniTrans;
        private int maxTrans;
        private int initialExtent;
        private int nextExtent;
        private int minExtents;
        private int maxExtents;
        private int pctIncrease;
        private int freelists;
        private int freelistGroups;
        private int blocks;
        private int emptyBlocks;
        private int avgSpace;
        private int chainCount;
        private int avgRowLen;
        private int avgSpaceFreelistBlocks;
        private int numFreelistBlocks;

        @Property(category="Statistics", order=31)
        public int getPctFree() {
            return this.pctFree;
        }

        @Property(category="Statistics", order=32)
        public int getPctUsed() {
            return this.pctUsed;
        }

        @Property(category="Statistics", order=33)
        public int getIniTrans() {
            return this.iniTrans;
        }

        @Property(category="Statistics", order=34)
        public int getMaxTrans() {
            return this.maxTrans;
        }

        @Property(category="Statistics", order=35)
        public int getInitialExtent() {
            return this.initialExtent;
        }

        @Property(category="Statistics", order=36)
        public int getNextExtent() {
            return this.nextExtent;
        }

        @Property(category="Statistics", order=37)
        public int getMinExtents() {
            return this.minExtents;
        }

        @Property(category="Statistics", order=38)
        public int getMaxExtents() {
            return this.maxExtents;
        }

        @Property(category="Statistics", order=39)
        public int getPctIncrease() {
            return this.pctIncrease;
        }

        @Property(category="Statistics", order=40)
        public int getFreelists() {
            return this.freelists;
        }

        @Property(category="Statistics", order=41)
        public int getFreelistGroups() {
            return this.freelistGroups;
        }

        @Property(category="Statistics", order=42)
        public int getBlocks() {
            return this.blocks;
        }

        @Property(category="Statistics", order=43)
        public int getEmptyBlocks() {
            return this.emptyBlocks;
        }

        @Property(category="Statistics", order=44)
        public int getAvgSpace() {
            return this.avgSpace;
        }

        @Property(category="Statistics", order=45)
        public int getChainCount() {
            return this.chainCount;
        }

        @Property(category="Statistics", order=46)
        public int getAvgRowLen() {
            return this.avgRowLen;
        }

        @Property(category="Statistics", order=47)
        public int getAvgSpaceFreelistBlocks() {
            return this.avgSpaceFreelistBlocks;
        }

        @Property(category="Statistics", order=48)
        public int getNumFreelistBlocks() {
            return this.numFreelistBlocks;
        }
    }
}

