/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.sql.SQLException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class DBException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final DBPDataSource dataSource;
    private final boolean hasMessage;

    public DBException(String message) {
        super(message);
        this.dataSource = null;
        this.hasMessage = true;
    }

    public DBException(String message, Throwable cause) {
        super(message, cause);
        this.dataSource = null;
        this.hasMessage = message != null;
    }

    public DBException(Throwable cause, DBPDataSource dataSource) {
        super(cause instanceof SQLException ? DBException.makeMessage((SQLException)cause) : cause.getMessage(), cause);
        this.dataSource = dataSource;
        this.hasMessage = false;
    }

    public DBException(String message, Throwable cause, DBPDataSource dataSource) {
        super(message, cause);
        this.dataSource = dataSource;
        this.hasMessage = message != null;
    }

    public DBPDataSource getDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        Throwable cause = this.getCause();
        if (cause instanceof DBException) {
            return ((DBException)cause).getDataSource();
        }
        return null;
    }

    public boolean hasMessage() {
        return this.hasMessage;
    }

    public int getErrorCode() {
        Throwable cause = this.getCause();
        if (cause instanceof SQLException) {
            return ((SQLException)cause).getErrorCode();
        }
        if (cause instanceof DBException) {
            return ((DBException)cause).getErrorCode();
        }
        return -1;
    }

    public String getDatabaseState() {
        Throwable cause = this.getCause();
        if (cause instanceof SQLException) {
            return ((SQLException)cause).getSQLState();
        }
        if (cause instanceof DBException) {
            return ((DBException)cause).getDatabaseState();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBException) {
            if (obj == this) {
                return true;
            }
            Throwable ex1 = (Throwable)obj;
            Throwable ex2 = this;
            while (ex1 != null) {
                if (!CommonUtils.equalObjects((Object)ex1.getMessage(), (Object)ex2.getMessage())) {
                    return false;
                }
                ex1 = ex1.getCause();
                ex2 = ex2.getCause();
                if ((ex1 != null || ex2 == null) && (ex2 != null || ex1 == null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String makeMessage(SQLException ex) {
        StringBuilder msg = new StringBuilder(ModelMessages.common_error_sql);
        if (ex.getErrorCode() > 0) {
            msg.append(" [").append(ex.getErrorCode()).append("]");
        }
        if (!CommonUtils.isEmpty((String)ex.getSQLState())) {
            msg.append(" [").append(ex.getSQLState()).append("]");
        }
        if (!CommonUtils.isEmpty((String)ex.getMessage())) {
            msg.append(": ").append(SQLUtils.stripTransformations(ex.getMessage()));
        }
        return msg.toString();
    }
}

