/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeEnumerable;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;

public class FKGenerator
extends AbstractMockValueGenerator {
    private static final Log log = Log.getLog(FKGenerator.class);
    private static final int UNIQ_REF_RECORDS_LIMIT = 100000000;
    private static final int REF_RECORDS_LIMIT = 100000;
    private List<Object> refValues = null;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        super.init(container, attribute, properties);
        this.nullsPersent = 0;
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.refValues == null) {
            this.refValues = new ArrayList<Object>();
            List attributeReferrers = DBUtils.getAttributeReferrers((DBRProgressMonitor)monitor, (DBSEntityAttribute)((DBSEntityAttribute)this.attribute));
            DBSEntityReferrer fk = (DBSEntityReferrer)attributeReferrers.get(0);
            List references = fk.getAttributeReferences(monitor);
            DBSTableForeignKeyColumn column = null;
            for (DBSEntityAttributeRef ref : references) {
                if (!((DBPNamedObject)ref).getName().equals(this.attribute.getName())) continue;
                column = (DBSTableForeignKeyColumn)ref;
            }
            if (column == null) {
                throw new DBException("Can't find reference column for '" + this.attribute.getName() + "'");
            }
            int numberRefRecords = MockDataUtils.checkUnique(monitor, this.dbsEntity, this.attribute) == MockDataUtils.UNIQ_TYPE.SINGLE ? 100000000 : 100000;
            Collection<DBDLabelValuePair> values = this.readColumnValues(monitor, (DBSAttributeEnumerable)column.getReferencedColumn(), numberRefRecords);
            for (DBDLabelValuePair value : values) {
                this.refValues.add(value.getValue());
            }
        }
        if (this.refValues.isEmpty()) {
            return null;
        }
        return this.refValues.get(this.random.nextInt(this.refValues.size()));
    }
}

