/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.MockDataExecuteWizard;
import org.jkiss.dbeaver.ext.mockdata.MockDataMessages;
import org.jkiss.dbeaver.ext.mockdata.MockDataSettings;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.ext.mockdata.model.MockGeneratorDescriptor;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class MockDataWizardPageSettings
extends ActiveWizardPage<MockDataExecuteWizard> {
    private static final Log log = Log.getLog(MockDataWizardPageSettings.class);
    public static final int DEFAULT_NAME_COLUMN_WIDTH = 110;
    private MockDataSettings mockDataSettings;
    private CLabel noGeneratorInfoLabel;
    private Text entityNameText;
    private Button removeOldDataCheck;
    private Text rowsText;
    private Text batchSizeText;
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private TableViewer generatorsTableViewer;
    private DBSAttributeBase selectedAttribute;
    private boolean firstInit = true;
    private Combo generatorCombo;
    private Label generatorDescriptionLabel;
    private Link generatorDescriptionLink;
    private Font boldFont;
    private String generatorLinkUrl;
    private transient boolean loadingSettings;

    protected MockDataWizardPageSettings(MockDataSettings mockDataSettings) {
        super(MockDataMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setTitle(MockDataMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setDescription(MockDataMessages.tools_mockdata_wizard_page_settings_page_description);
        this.mockDataSettings = mockDataSettings;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.updateState();
            }
        };
        Composite entityPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2);
        this.entityNameText = UIUtils.createLabelText((Composite)entityPlaceholder, (String)MockDataMessages.tools_mockdata_wizard_page_settings_text_entity, (String)"", (int)8);
        GridData gd = new GridData(32);
        gd.widthHint = 230;
        gd.verticalIndent = 5;
        gd.horizontalIndent = 9;
        entityPlaceholder.setLayoutData((Object)gd);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)MockDataMessages.tools_mockdata_wizard_page_settings_group_settings, (int)4, (int)768, (int)0);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        settingsGroup.setLayoutData((Object)gd);
        this.removeOldDataCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MockDataMessages.tools_mockdata_wizard_page_settings_checkbox_remove_old_data, null, (boolean)this.mockDataSettings.isRemoveOldData(), (int)4);
        this.removeOldDataCheck.addSelectionListener((SelectionListener)changeListener);
        this.rowsText = UIUtils.createLabelText((Composite)settingsGroup, (String)MockDataMessages.tools_mockdata_wizard_page_settings_combo_rows, (String)String.valueOf(this.mockDataSettings.getRowsNumber()), (int)2048, (Object)new GridData(110, -1));
        this.rowsText.addSelectionListener((SelectionListener)changeListener);
        this.rowsText.addVerifyListener(UIUtils.getLongVerifyListener((Text)this.rowsText));
        this.rowsText.addModifyListener(e -> this.updateState());
        this.batchSizeText = UIUtils.createLabelText((Composite)settingsGroup, (String)MockDataMessages.tools_mockdata_wizard_page_settings_batch_size, (String)String.valueOf(this.mockDataSettings.getBatchSize()), (int)2048, (Object)new GridData(110, -1));
        this.batchSizeText.addSelectionListener((SelectionListener)changeListener);
        this.batchSizeText.addVerifyListener(UIUtils.getLongVerifyListener((Text)this.batchSizeText));
        this.batchSizeText.addModifyListener(e -> this.updateState());
        Group generatorsGroup = UIUtils.createControlGroup((Composite)composite, (String)MockDataMessages.tools_mockdata_wizard_page_settings_group_generators, (int)5, (int)1808, (int)0);
        GridData gd2 = new GridData(1808);
        gd2.verticalIndent = 5;
        generatorsGroup.setLayoutData((Object)gd2);
        Composite placeholder = UIUtils.createPlaceholder((Composite)generatorsGroup, (int)1);
        gd2 = new GridData(1040);
        gd2.widthHint = 250;
        placeholder.setLayoutData((Object)gd2);
        Button autoAssignButton = new Button(placeholder, 8);
        autoAssignButton.setText(MockDataMessages.tools_mockdata_wizard_page_settings_button_autoassign);
        autoAssignButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.OBJ_REFRESH));
        autoAssignButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UIUtils.confirmAction((Shell)MockDataWizardPageSettings.this.getShell(), (String)MockDataMessages.tools_mockdata_wizard_title, (String)MockDataMessages.tools_mockdata_wizard_page_settings_button_autoassign_confirm)) {
                    MockDataWizardPageSettings.this.autoAssignGenerators();
                }
            }
        });
        gd2 = new GridData(32);
        autoAssignButton.setLayoutData((Object)gd2);
        this.generatorsTableViewer = new TableViewer(placeholder, 67588);
        final Table table = this.generatorsTableViewer.getTable();
        gd2 = new GridData(1808);
        gd2.verticalIndent = 5;
        table.setLayoutData((Object)gd2);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.generatorsTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBSAttributeBase attribute = (DBSAttributeBase)cell.getElement();
                MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute);
                if (cell.getColumnIndex() == 0) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getTypeImage((DBSTypedObject)attribute)));
                    cell.setText(attribute.getName());
                    try {
                        if (MockDataUtils.checkUnique(MockDataWizardPageSettings.this.mockDataSettings.getMonitor(), MockDataWizardPageSettings.this.mockDataSettings.getEntity(), attribute) != null) {
                            cell.setFont(MockDataWizardPageSettings.this.boldFont);
                        }
                    }
                    catch (DBException e) {
                        log.error((Object)("Error checking the attribute '" + attribute.getName() + "' properties"), (Throwable)e);
                    }
                    if (attributeGeneratorProperties != null && attributeGeneratorProperties.isEmpty()) {
                        cell.setForeground(table.getDisplay().getSystemColor(3));
                        MockDataWizardPageSettings.this.noGeneratorInfoLabel.setVisible(true);
                    }
                } else if (attributeGeneratorProperties != null && !attributeGeneratorProperties.isEmpty()) {
                    MockGeneratorDescriptor selectedGenerator = attributeGeneratorProperties.getSelectedGenerator();
                    if (selectedGenerator == null) {
                        cell.setText(MockDataSettings.NO_GENERATOR_LABEL);
                    } else {
                        String label = selectedGenerator.getLabel();
                        cell.setText(label.trim());
                    }
                }
            }
        };
        TableViewerColumn attributeColumn = new TableViewerColumn(this.generatorsTableViewer, 16384);
        attributeColumn.setLabelProvider(labelProvider);
        attributeColumn.getColumn().setText(MockDataMessages.tools_mockdata_wizard_page_settings_generatorselector_attribute);
        TableViewerColumn generatorColumn = new TableViewerColumn(this.generatorsTableViewer, 16384);
        generatorColumn.setLabelProvider(labelProvider);
        TableColumn column = generatorColumn.getColumn();
        column.setText(MockDataMessages.tools_mockdata_wizard_page_settings_generatorselector_generator);
        generatorColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.generatorsTableViewer){

            protected CellEditor getCellEditor(Object element) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                MockDataSettings.AttributeGeneratorProperties attributeGenerators = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute);
                LinkedHashSet<String> generators = new LinkedHashSet<String>();
                generators.add(MockDataSettings.NO_GENERATOR_LABEL);
                if (attributeGenerators.isEmpty()) {
                    MockDataWizardPageSettings.this.noGeneratorInfoLabel.setVisible(true);
                    TextCellEditor textCellEditor = new TextCellEditor((Composite)MockDataWizardPageSettings.this.generatorsTableViewer.getTable());
                    textCellEditor.getControl().setEnabled(false);
                    return textCellEditor;
                }
                for (String generatorId : attributeGenerators.getGenerators()) {
                    MockGeneratorDescriptor generatorDescriptor;
                    if (CommonUtils.isEmpty((String)generatorId) || (generatorDescriptor = MockDataWizardPageSettings.this.mockDataSettings.getGeneratorDescriptor(generatorId)) == null) continue;
                    generators.add(generatorDescriptor.getLabel());
                }
                CustomComboBoxCellEditor customComboBoxCellEditor = new CustomComboBoxCellEditor((ColumnViewer)MockDataWizardPageSettings.this.generatorsTableViewer, (Composite)MockDataWizardPageSettings.this.generatorsTableViewer.getTable(), generators.toArray(new String[generators.size()]), 2056);
                return customComboBoxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                MockGeneratorDescriptor selectedGenerator = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute).getSelectedGenerator();
                if (selectedGenerator != null) {
                    return selectedGenerator.getLabel();
                }
                return MockDataSettings.NO_GENERATOR_LABEL;
            }

            protected void setValue(Object element, Object value) {
                DBSAttributeBase attribute = (DBSAttributeBase)element;
                MockDataWizardPageSettings.this.selectGenerator(attribute, (String)value);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.saveGeneratorProperties();
                DBSAttributeBase attribute = (DBSAttributeBase)e.item.getData();
                MockDataSettings.AttributeGeneratorProperties atrProps = MockDataWizardPageSettings.this.mockDataSettings.getAttributeGeneratorProperties(attribute);
                MockDataWizardPageSettings.this.reloadProperties(attribute, atrProps.getSelectedGenerator() == null ? null : atrProps.getSelectedGenerator().getId());
            }
        });
        placeholder = UIUtils.createPlaceholder((Composite)generatorsGroup, (int)1);
        placeholder.setLayoutData((Object)new GridData(1808));
        Composite labelCombo = UIUtils.createPlaceholder((Composite)placeholder, (int)5);
        gd2 = new GridData(768);
        labelCombo.setLayoutData((Object)gd2);
        this.generatorCombo = new Combo(labelCombo, 12);
        gd2 = new GridData();
        gd2.widthHint = UIUtils.getFontHeight((Control)this.generatorCombo) * 20;
        this.generatorCombo.setLayoutData((Object)gd2);
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.selectGenerator(MockDataWizardPageSettings.this.selectedAttribute, MockDataWizardPageSettings.this.generatorCombo.getText());
            }
        });
        Composite descriptionCombo = UIUtils.createPlaceholder((Composite)labelCombo, (int)2);
        gd2 = new GridData(800);
        descriptionCombo.setLayoutData((Object)gd2);
        this.generatorDescriptionLabel = new Label(descriptionCombo, 0);
        this.generatorDescriptionLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.generatorDescriptionLabel.setText("");
        gd2 = new GridData(800);
        gd2.horizontalIndent = 5;
        this.generatorDescriptionLabel.setLayoutData((Object)gd2);
        this.generatorDescriptionLink = UIUtils.createLink((Composite)descriptionCombo, (String)"", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CommonUtils.isEmpty((String)MockDataWizardPageSettings.this.generatorLinkUrl)) {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    try {
                        support.getExternalBrowser().openURL(new URL(MockDataWizardPageSettings.this.generatorLinkUrl));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        gd2 = new GridData(128);
        gd2.horizontalIndent = 5;
        this.generatorDescriptionLink.setLayoutData((Object)gd2);
        Button resetButton = new Button(labelCombo, 8);
        resetButton.setText(MockDataMessages.tools_mockdata_wizard_page_settings_button_reset);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object key : MockDataWizardPageSettings.this.propertySource.getProperties().keySet()) {
                    MockDataWizardPageSettings.this.propertySource.resetPropertyValueToDefault(key);
                }
                MockDataWizardPageSettings.this.propsEditor.loadProperties((DBPPropertySource)MockDataWizardPageSettings.this.propertySource);
                MockDataWizardPageSettings.this.generatorsTableViewer.refresh(true, true);
            }
        });
        gd2 = new GridData();
        gd2.horizontalIndent = 5;
        resetButton.setLayoutData((Object)gd2);
        this.propsEditor = new PropertyTreeViewer(placeholder, 2048);
        gd2 = new GridData(1808);
        gd2.verticalIndent = 5;
        this.propsEditor.getControl().setLayoutData((Object)gd2);
        this.noGeneratorInfoLabel = UIUtils.createInfoLabel((Composite)composite, (String)MockDataMessages.tools_mockdata_wizard_page_settings_button_info_notfound);
        gd2 = new GridData(32);
        gd2.horizontalSpan = 2;
        gd2.verticalIndent = 5;
        this.noGeneratorInfoLabel.setLayoutData((Object)gd2);
        this.noGeneratorInfoLabel.setVisible(false);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns((Table)table);
                UIUtils.maxTableColumnsWidth((Table)table);
                table.removeControlListener((ControlListener)this);
            }
        });
        this.setControl((Control)composite);
        this.boldFont = UIUtils.makeBoldFont((Font)this.generatorsTableViewer.getControl().getFont());
    }

    private void autoAssignGenerators() {
        Map<String, MockDataSettings.AttributeGeneratorProperties> attributeGenerators = this.mockDataSettings.getAttributeGenerators();
        for (String attrName : attributeGenerators.keySet()) {
            this.mockDataSettings.autoAssignGenerator(attributeGenerators.get(attrName));
        }
        this.generatorsTableViewer.refresh(true, true);
    }

    private void selectGenerator(DBSAttributeBase attribute, String generatorName) {
        if (CommonUtils.isEmpty((String)generatorName)) {
            return;
        }
        if (MockDataSettings.NO_GENERATOR_LABEL.equals(generatorName)) {
            this.reloadProperties(attribute, MockDataSettings.NO_GENERATOR_LABEL);
        } else {
            MockGeneratorDescriptor generatorForName = this.mockDataSettings.findGeneratorForName(attribute, generatorName);
            if (generatorForName != null) {
                this.saveGeneratorProperties();
                this.reloadProperties(attribute, generatorForName.getId());
            }
        }
        this.generatorsTableViewer.refresh(true, true);
    }

    public void activatePage() {
        if (this.firstInit) {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                    try {
                        this.firstInit = false;
                        MockDataExecuteWizard wizard = (MockDataExecuteWizard)this.getWizard();
                        this.mockDataSettings.init(monitor, wizard);
                        wizard.loadSettings();
                    }
                    catch (DBException ex) {
                        throw new InvocationTargetException(ex);
                    }
                });
            }
            catch (InvocationTargetException ex) {
                log.error((Object)"Error Mock Data Settings initialization", ex.getTargetException());
            }
            catch (InterruptedException e) {
                log.error((Object)"Mock Data Settings initialization interrupted", (Throwable)e);
            }
            this.loadingSettings = true;
            try {
                this.removeOldDataCheck.setSelection(this.mockDataSettings.isRemoveOldData());
                this.rowsText.setText(String.valueOf(this.mockDataSettings.getRowsNumber()));
                this.batchSizeText.setText(String.valueOf(this.mockDataSettings.getBatchSize()));
                this.generatorsTableViewer.setInput(this.mockDataSettings.getAttributes());
            }
            finally {
                this.loadingSettings = false;
            }
        }
        this.entityNameText.setText(DBUtils.getObjectFullName((DBPNamedObject)this.mockDataSettings.getEntity(), (DBPEvaluationContext)DBPEvaluationContext.DML));
        this.propsEditor.getControl().setFocus();
        Table table = this.generatorsTableViewer.getTable();
        if (table.getItemCount() > 0) {
            int selectedItemIndex = 0;
            TableItem selectedItem = null;
            String selectedAttribute = this.mockDataSettings.getSelectedAttribute();
            if (selectedAttribute != null) {
                int i = 0;
                while (i < table.getItemCount()) {
                    if (selectedAttribute.equals(table.getItem(i).getText())) {
                        selectedItemIndex = i;
                        selectedItem = table.getItem(i);
                        break;
                    }
                    ++i;
                }
            }
            table.select(selectedItemIndex);
            if (selectedItem != null) {
                table.showItem(selectedItem);
            }
            Event event = new Event();
            event.widget = table;
            event.display = table.getDisplay();
            event.item = table.getItem(selectedItemIndex);
            event.type = 13;
            table.notifyListeners(13, event);
        } else {
            this.noGeneratorInfoLabel.setText(MockDataMessages.tools_mockdata_wizard_page_settings_button_info_noattributes);
            this.noGeneratorInfoLabel.setVisible(true);
        }
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        this.saveGeneratorProperties();
    }

    public boolean isPageComplete() {
        return true;
    }

    public boolean validateProperties() {
        Map<String, MockDataSettings.AttributeGeneratorProperties> attributeGenerators = this.mockDataSettings.getAttributeGenerators();
        for (String attr : attributeGenerators.keySet()) {
            MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = attributeGenerators.get(attr);
            PropertySourceCustom generatorProperties = attributeGeneratorProperties.getGeneratorProperties();
            if (generatorProperties == null) continue;
            Map properties = generatorProperties.getPropertiesWithDefaults();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                if (value instanceof Integer && (Integer)value < 0) {
                    return false;
                }
                if (!(value instanceof Long) || (Long)value >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void updateState() {
        if (!this.loadingSettings) {
            this.mockDataSettings.setRemoveOldData(this.removeOldDataCheck.getSelection());
            this.mockDataSettings.setRowsNumber(CommonUtils.toLong((Object)this.rowsText.getText()));
            this.mockDataSettings.setBatchSize(CommonUtils.toInt((Object)this.batchSizeText.getText()));
        }
    }

    private void reloadProperties(DBSAttributeBase attribute, String generatorId) {
        MockGeneratorDescriptor newGenerator;
        MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties = this.mockDataSettings.getAttributeGeneratorProperties(attribute);
        MockGeneratorDescriptor currentGenerator = attributeGeneratorProperties.getSelectedGenerator();
        MockGeneratorDescriptor mockGeneratorDescriptor = newGenerator = generatorId == null || MockDataSettings.NO_GENERATOR_LABEL.equals(generatorId) ? null : attributeGeneratorProperties.getGenerator(generatorId);
        if (attribute == this.selectedAttribute && Objects.equals((Object)currentGenerator, (Object)newGenerator)) {
            return;
        }
        attributeGeneratorProperties.setSelectedGenerator(newGenerator);
        this.selectedAttribute = attribute;
        this.mockDataSettings.setSelectedAttribute(attribute.getName());
        this.propertySource = attributeGeneratorProperties.getGeneratorProperties();
        if (this.propertySource != null) {
            this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
            this.propsEditor.setExpandMode(PropertyTreeViewer.ExpandMode.FIRST);
            this.propsEditor.expandAll();
        } else {
            this.propsEditor.clearProperties();
        }
        UIUtils.asyncExec(() -> {
            ((Tree)this.propsEditor.getControl()).getColumn(0).setWidth(110);
            ((Tree)this.propsEditor.getControl()).getColumn(1).setWidth(this.propsEditor.getControl().getSize().x - 110 - 30);
        });
        ArrayList<String> generators = new ArrayList<String>();
        generators.add(MockDataSettings.NO_GENERATOR_LABEL);
        for (String genId : attributeGeneratorProperties.getGenerators()) {
            MockGeneratorDescriptor generatorDescriptor = this.mockDataSettings.getGeneratorDescriptor(genId);
            if (generatorDescriptor == null) continue;
            generators.add(generatorDescriptor.getLabel());
        }
        this.generatorDescriptionLink.setVisible(false);
        if (!generators.isEmpty()) {
            this.generatorCombo.setItems(generators.toArray(new String[generators.size()]));
            MockGeneratorDescriptor generatorDescriptor = this.mockDataSettings.getGeneratorDescriptor(generatorId);
            if (generatorDescriptor != null) {
                this.generatorCombo.setText(generatorDescriptor.getLabel());
                this.generatorDescriptionLabel.setText(generatorDescriptor.getDescription());
                if (!CommonUtils.isEmpty((String)generatorDescriptor.getLink())) {
                    this.generatorDescriptionLink.setText("<a>" + generatorDescriptor.getLink() + "</a>");
                    this.generatorLinkUrl = generatorDescriptor.getUrl();
                    this.generatorDescriptionLink.setVisible(true);
                }
            } else {
                this.generatorCombo.setText(MockDataSettings.NO_GENERATOR_LABEL);
                this.generatorDescriptionLabel.setText(MockDataSettings.NO_GENERATOR_LABEL);
                this.generatorDescriptionLink.setVisible(false);
            }
            this.generatorCombo.setEnabled(true);
        } else {
            this.generatorCombo.setItems(new String[]{MockDataSettings.NO_GENERATOR_LABEL, MockDataMessages.tools_mockdata_wizard_page_settings_notfound});
            this.generatorCombo.setText(MockDataMessages.tools_mockdata_wizard_page_settings_notfound);
            this.generatorCombo.setEnabled(false);
            this.generatorDescriptionLabel.setText("");
        }
        this.generatorDescriptionLink.getParent().layout();
    }

    private void saveGeneratorProperties() {
        MockDataSettings.AttributeGeneratorProperties attributeGeneratorProperties;
        MockGeneratorDescriptor selectedGenerator;
        if (this.selectedAttribute != null && (selectedGenerator = (attributeGeneratorProperties = this.mockDataSettings.getAttributeGeneratorProperties(this.selectedAttribute)).getSelectedGenerator()) != null) {
            attributeGeneratorProperties.putGeneratorProperties(selectedGenerator.getId(), this.propertySource);
        }
    }
}

