/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgrePlanNode;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PostgrePlanAnalyser
implements DBCPlan {
    private static final Log log = Log.getLog(PostgrePlanAnalyser.class);
    private boolean oldQuery;
    private String query;
    private List<DBCPlanNode> rootNodes;

    public PostgrePlanAnalyser(boolean oldQuery, String query) {
        this.oldQuery = oldQuery;
        this.query = query;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        if (this.oldQuery) {
            return "EXPLAIN VERBOSE " + this.query;
        }
        return "EXPLAIN (FORMAT XML, ANALYSE) " + this.query;
    }

    public Collection<DBCPlanNode> getPlanNodes() {
        return this.rootNodes;
    }

    public void explain(DBCSession session) throws DBCException {
        JDBCSession connection = (JDBCSession)session;
        boolean oldAutoCommit = false;
        try {
            try {
                oldAutoCommit = connection.getAutoCommit();
                if (oldAutoCommit) {
                    connection.setAutoCommit(false);
                }
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCPreparedStatement dbStat = connection.prepareStatement(this.getPlanQueryString());){
                    try {
                        Throwable throwable2 = null;
                        Object var8_13 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                SQLXML planXML = dbResult.getSQLXML(1);
                                this.parsePlan(session, planXML);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (XMLException e) {
                        throw new DBCException("Can't parse plan XML", (Throwable)e);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, session.getDataSource());
            }
        }
        finally {
            try {
                connection.rollback();
                if (oldAutoCommit) {
                    connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error closing plan analyser", (Throwable)e);
            }
        }
    }

    private void parsePlan(DBCSession session, SQLXML planXML) throws SQLException, XMLException {
        this.rootNodes = new ArrayList<DBCPlanNode>();
        Document planDocument = XMLUtils.parseDocument((InputStream)planXML.getBinaryStream());
        Element queryElement = XMLUtils.getChildElement((Element)planDocument.getDocumentElement(), (String)"Query");
        for (Element planElement : XMLUtils.getChildElementList((Element)queryElement, (String)"Plan")) {
            this.rootNodes.add(new PostgrePlanNode((PostgreDataSource)session.getDataSource(), null, planElement));
        }
    }
}

