/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public class PostgreSequence
extends PostgreTableBase
implements DBSSequence,
DBPQualifiedObject {
    private static final Log log = Log.getLog(PostgreSequence.class);
    private final AdditionalInfo additionalInfo = new AdditionalInfo();

    public PostgreSequence(PostgreSchema schema, JDBCResultSet dbResult) {
        super(schema, (ResultSet)dbResult);
    }

    public PostgreSequence(PostgreSchema catalog) {
        super(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence additional info");){
                block50: {
                    if (((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(10, 0)) {
                        Throwable throwable2 = null;
                        Object var6_12 = null;
                        try (JDBCPreparedStatement dbSeqStat = session.prepareStatement("SELECT * from pg_catalog.pg_sequences WHERE schemaname=? AND sequencename=?");){
                            dbSeqStat.setString(1, this.getSchema().getName());
                            dbSeqStat.setString(2, this.getName());
                            Throwable throwable3 = null;
                            Object var9_22 = null;
                            try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                                if (seqResults.next()) {
                                    this.additionalInfo.lastValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"last_value");
                                    this.additionalInfo.minValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"min_value");
                                    this.additionalInfo.maxValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"max_value");
                                    this.additionalInfo.incrementBy = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment_by");
                                    this.additionalInfo.cacheValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"cache_size");
                                    this.additionalInfo.isCycled = JDBCUtils.safeGetBoolean((ResultSet)seqResults, (String)"cycle");
                                }
                                break block50;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    Throwable throwable6 = null;
                    Object var6_14 = null;
                    try (JDBCPreparedStatement dbSeqStat = session.prepareStatement("SELECT * from " + this.getFullyQualifiedName(DBPEvaluationContext.DML));){
                        Throwable throwable7 = null;
                        Object var9_24 = null;
                        try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                            if (seqResults.next()) {
                                this.additionalInfo.lastValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"last_value");
                                this.additionalInfo.minValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"min_value");
                                this.additionalInfo.maxValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"max_value");
                                this.additionalInfo.incrementBy = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"increment_by");
                                this.additionalInfo.cacheValue = JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"cache_size");
                                this.additionalInfo.isCycled = JDBCUtils.safeGetBoolean((ResultSet)seqResults, (String)"is_cycled");
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable7 == null) {
                                throwable7 = throwable8;
                            } else if (throwable7 != throwable8) {
                                throwable7.addSuppressed(throwable8);
                            }
                            throw throwable7;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (throwable6 == null) {
                            throwable6 = throwable9;
                        } else if (throwable6 != throwable9) {
                            throwable6.addSuppressed(throwable9);
                        }
                        throw throwable6;
                    }
                }
                this.additionalInfo.loaded = true;
            }
            catch (Throwable throwable10) {
                if (throwable == null) {
                    throwable = throwable10;
                } else if (throwable != throwable10) {
                    throwable.addSuppressed(throwable10);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading sequence values", (Throwable)e);
        }
    }

    public Number getLastValue() {
        return this.additionalInfo.lastValue;
    }

    public Number getMinValue() {
        return this.additionalInfo.minValue;
    }

    public Number getMaxValue() {
        return this.additionalInfo.maxValue;
    }

    public Number getIncrementBy() {
        return this.additionalInfo.incrementBy;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.SEQUENCE;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        AdditionalInfo info = this.getAdditionalInfo(monitor);
        StringBuilder sql = new StringBuilder();
        sql.append("-- DROP SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(";\n\n");
        sql.append("CREATE SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        if (info.getIncrementBy() != null && info.getIncrementBy().longValue() > 0L) {
            sql.append("\n\tINCREMENT BY ").append(info.getIncrementBy());
        }
        if (info.getMinValue() != null && info.getMinValue().longValue() > 0L) {
            sql.append("\n\tMINVALUE ").append(info.getMinValue());
        } else {
            sql.append("\n\tNO MINVALUE");
        }
        if (info.getMaxValue() != null && info.getMaxValue().longValue() > 0L) {
            sql.append("\n\tMAXVALUE ").append(info.getMaxValue());
        } else {
            sql.append("\n\tNO MAXVALUE");
        }
        if (info.getLastValue() != null && info.getLastValue().longValue() > 0L) {
            sql.append("\n\tSTART ").append(info.getLastValue());
        }
        sql.append("\n\tCACHE ").append(info.getCacheValue()).append("\n\t").append(info.isCycled ? "" : "NO ").append("CYCLE").append(";");
        if (!CommonUtils.isEmpty((String)this.getDescription())) {
            sql.append("\nCOMMENT ON SEQUENCE ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())).append(";");
        }
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
        if (!actions.isEmpty()) {
            sql.append("\n\n");
            sql.append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[actions.size()]), (boolean)false));
        }
        return sql.toString();
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private Number lastValue;
        private Number minValue;
        private Number maxValue;
        private Number incrementBy;
        private Number cacheValue;
        private boolean isCycled;

        @Property(viewable=true, editable=true, updatable=false, order=10)
        public Number getLastValue() {
            return this.lastValue;
        }

        @Property(viewable=true, editable=true, updatable=false, order=11)
        public Number getMinValue() {
            return this.minValue;
        }

        @Property(viewable=true, editable=true, updatable=false, order=12)
        public Number getMaxValue() {
            return this.maxValue;
        }

        @Property(viewable=true, editable=true, updatable=false, order=13)
        public Number getIncrementBy() {
            return this.incrementBy;
        }

        @Property(viewable=true, editable=true, updatable=false, order=14)
        public Number getCacheValue() {
            return this.cacheValue;
        }

        @Property(viewable=true, editable=true, updatable=false, order=15)
        public boolean isCycled() {
            return this.isCycled;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<PostgreSequence> {
        public boolean isPropertyCached(PostgreSequence object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }
}

