/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.ProductBundleRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.CommonUtils;

public class DriverUtils {
    private static final Log log = Log.getLog(DriverUtils.class);
    public static final String ZIP_EXTRACT_DIR = "zip-cache";

    public static boolean isBetaVersion(@NotNull String versionInfo) {
        return versionInfo.contains("beta") || versionInfo.contains("alpha");
    }

    @Nullable
    public static String findLatestVersion(@NotNull Collection<String> allVersions) {
        String latest = null;
        for (String version : allVersions) {
            if (DriverUtils.isBetaVersion(version) || latest != null && DriverUtils.compareVersions(version, latest) <= 0) continue;
            latest = version;
        }
        if (latest == null) {
            for (String version : allVersions) {
                if (latest != null && DriverUtils.compareVersions(version, latest) <= 0) continue;
                latest = version;
            }
        }
        return latest;
    }

    public static int compareVersions(@NotNull String v1, @NotNull String v2) {
        StringTokenizer st1 = new StringTokenizer(v1, ".-_");
        StringTokenizer st2 = new StringTokenizer(v2, ".-_");
        while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
            String t1 = st1.nextToken();
            String t2 = st2.nextToken();
            try {
                int cmp = Integer.parseInt(t1) - Integer.parseInt(t2);
                if (cmp == 0) continue;
                return cmp;
            }
            catch (NumberFormatException e) {
                int cmp = t1.compareTo(t2);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        if (st1.hasMoreTokens()) {
            return 1;
        }
        if (st2.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    public static boolean matchesBundle(IConfigurationElement config) {
        String bundle = config.getAttribute("bundle");
        if (!CommonUtils.isEmpty((String)bundle)) {
            boolean hasBundle;
            boolean not = false;
            if (bundle.startsWith("!")) {
                not = true;
                bundle = bundle.substring(1);
            }
            if (!(hasBundle = ProductBundleRegistry.getInstance().hasBundle(bundle)) && !not || hasBundle && not) {
                return false;
            }
        }
        return true;
    }

    static void copyZipStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] writeBuffer = new byte[16384];
        int br = inputStream.read(writeBuffer);
        while (br != -1) {
            outputStream.write(writeBuffer, 0, br);
            br = inputStream.read(writeBuffer);
        }
        outputStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<File> extractZipArchives(List<File> files) {
        if (files.isEmpty()) {
            return files;
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        block16: for (File inputFile : files) {
            jarFiles.add(inputFile);
            if (!inputFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip")) continue;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream is = new FileInputStream(inputFile);){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (ZipInputStream zipStream = new ZipInputStream(is);){
                        ZipEntry zipEntry;
                        while ((zipEntry = zipStream.getNextEntry()) != null) {
                            try {
                                if (zipEntry.isDirectory()) continue;
                                String zipEntryName = zipEntry.getName();
                                if (zipEntryName.endsWith(".class")) continue block16;
                                if (!zipEntryName.endsWith(".jar") && !zipEntryName.endsWith(".zip")) continue;
                                DriverUtils.checkAndExtractEntry(inputFile, zipStream, zipEntry, jarFiles);
                            }
                            finally {
                                zipStream.closeEntry();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        }
                        if (throwable2 == throwable3) throw throwable2;
                        throwable2.addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error processing zip archive '" + inputFile.getName() + "': " + e.getMessage()));
            }
        }
        return jarFiles;
    }

    private static void checkAndExtractEntry(File sourceFile, InputStream zipStream, ZipEntry zipEntry, List<File> jarFiles) throws IOException {
        File localCacheDir;
        String sourceName = sourceFile.getName();
        if (sourceName.endsWith(".zip")) {
            sourceName = sourceName.substring(0, sourceName.length() - 4);
        }
        if (!(localCacheDir = new File(new File(DriverDescriptor.getCustomDriversHome(), ZIP_EXTRACT_DIR), sourceName)).exists() && !localCacheDir.mkdirs()) {
            throw new IOException("Can't create local cache folder '" + localCacheDir.getAbsolutePath() + "'");
        }
        File localFile = new File(localCacheDir, zipEntry.getName());
        jarFiles.add(localFile);
        if (localFile.exists()) {
            return;
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try (FileOutputStream os = new FileOutputStream(localFile);){
            DriverUtils.copyZipStream(zipStream, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<DBPDataSourceContainer> getUsedBy(DBPDriver driver, List<DBPDataSourceContainer> containers) {
        ArrayList<DBPDataSourceContainer> usedBy = new ArrayList<DBPDataSourceContainer>();
        for (DBPDataSourceContainer ds : containers) {
            if (ds.getDriver() != driver) continue;
            usedBy.add(ds);
        }
        return usedBy;
    }
}

