/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolScriptManager
extends SQLObjectEditor<ExasolScript, ExasolSchema> {
    public DBSObjectCache<ExasolSchema, ExasolScript> getObjectsCache(ExasolScript object) {
        return object.getContainer().scriptCache;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((ExasolScript)command.getObject()).getName())) {
            throw new DBException("Procedure name cannot be empty");
        }
    }

    protected ExasolScript createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, ExasolSchema parent, Object copyFrom) throws DBException {
        ExasolScript newScript = new ExasolScript(parent);
        newScript.setName("new_script");
        newScript.setObjectDefinitionText("CREATE OR REPLACE LUA SCRIPT new_script () RETURNS TABLE AS");
        return newScript;
    }

    private void createOrReplaceScriptQuery(List<DBEPersistAction> actions, ExasolScript script, Boolean replace) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Script", "OPEN SCHEMA " + script.getSchema().getName()));
        if (replace.booleanValue()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Script", "DROP SCRIPT " + script.getFullyQualifiedName(DBPEvaluationContext.DDL)));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Script: ", script.getSql(), true));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceScriptQuery(actions, (ExasolScript)command.getObject(), false);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Script", "DROP SCRIPT " + ((ExasolScript)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceScriptQuery(actionList, (ExasolScript)command.getObject(), true);
        }
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<ExasolScript, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Script", "COMMENT ON SCRIPT " + ((ExasolScript)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((ExasolScript)command.getObject()).getDescription())));
        }
    }
}

