/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol;

import java.sql.SQLException;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.sql.SQLRuleProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLFullLineRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLControlToken;

public class ExasolSQLDialect
extends JDBCSQLDialect
implements SQLRuleProvider {
    private static final Log LOG = Log.getLog(ExasolDataSource.class);
    public static final String[] EXEC_KEYWORDS = new String[0];

    public ExasolSQLDialect() {
        super("Exasol");
    }

    public void initDriverSettings(JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(dataSource, metaData);
        try {
            String[] stringArray = metaData.getSQLKeywords().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                this.addSQLKeyword(kw);
                ++n2;
            }
            this.addSQLKeyword("PRIORITY");
            this.addSQLKeyword("IDENTIFIED");
            this.addSQLKeyword("JDBC");
            this.addSQLKeyword("EXA");
            this.addSQLKeyword("KERBEROS");
            this.addSQLKeyword("LDAP");
        }
        catch (SQLException sQLException) {
            LOG.warn((Object)"Could not retrieve reserved keyword list from Exasol dictionary");
        }
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[0];
    }

    public void extendRules(@NotNull List<IRule> rules, @NotNull SQLRuleProvider.RulePosition position) {
        if (position == SQLRuleProvider.RulePosition.CONTROL) {
            SQLControlToken defineToken = new SQLControlToken((Object)new TextAttribute(UIUtils.getGlobalColor((String)"org.jkiss.dbeaver.sql.editor.color.command.foreground"), null, 1), "exasol.define");
            SQLFullLineRule defineRule = new SQLFullLineRule("define", (IToken)defineToken);
            rules.add((IRule)defineRule);
            SQLFullLineRule defineRule2 = new SQLFullLineRule("DEFINE", (IToken)defineToken);
            rules.add((IRule)defineRule2);
        }
    }
}

