/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.internal.impl;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGBaseController;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSessionInfo;
import org.jkiss.dbeaver.debug.DBGStackFrame;
import org.jkiss.dbeaver.debug.DBGVariable;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.jdbc.DBGJDBCSession;
import org.jkiss.dbeaver.ext.postgresql.debug.core.PostgreSqlDebugCore;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugAttachKind;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugBreakpointDescriptor;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugSessionInfo;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugStackFrame;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugVariable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class PostgreDebugSession
extends DBGJDBCSession {
    private final JDBCExecutionContext controllerConnection;
    private int functionOid = -1;
    private int sessionId = -1;
    private int localPortNumber = -1;
    private PostgreDebugAttachKind attachKind = PostgreDebugAttachKind.UNKNOWN;
    private DBGSessionInfo sessionInfo;
    private PostgreDebugBreakpointDescriptor bpGlobal;
    private volatile JDBCCallableStatement localStatement;
    private static final int LOCAL_WAIT = 50;
    private static final int LOCAL_TIMEOT = 50000;
    private static final String MAGIC_PORT = "PLDBGBREAK";
    private static final String SQL_CHECK_PLUGIN = "select 'Server version: ' || serverversionstr || '.\nProxy API version: ' ||  proxyapiver from pldbg_get_proxy_info()";
    private static final String SQL_ATTACH = "select pldbg_wait_for_target(?sessionid)";
    private static final String SQL_ATTACH_TO_PORT = "select pldbg_attach_to_port(?portnumber)";
    private static final String SQL_PREPARE_SLOT = " select pldbg_oid_debug(?objectid)";
    private static final String SQL_LISTEN = "select pldbg_create_listener() as sessionid";
    private static final String SQL_GET_SRC = "select pldbg_get_source(?sessionid,?oid)";
    private static final String SQL_GET_VARS = "select * from pldbg_get_variables(?sessionid)";
    private static final String SQL_SET_VAR = "select pldbg_deposit_value(?,?,?,?)";
    private static final String SQL_GET_STACK = "select * from pldbg_get_stack(?sessionid)";
    private static final String SQL_SELECT_FRAME = "select * from pldbg_select_frame(?sessionid,?frameno)";
    private static final String SQL_STEP_OVER = "select pldbg_step_over(?sessionid)";
    private static final String SQL_STEP_INTO = "select pldbg_step_into(?sessionid)";
    private static final String SQL_CONTINUE = "select pldbg_continue(?sessionid)";
    private static final String SQL_ABORT = "select pldbg_abort_target(?sessionid)";
    private static final String SQL_SET_GLOBAL_BREAKPOINT = "select pldbg_set_global_breakpoint(?sessionid, ?obj, ?line, ?target)";
    private static final String SQL_SET_BREAKPOINT = "select pldbg_set_breakpoint(?sessionid, ?obj, ?line)";
    private static final String SQL_DROP_BREAKPOINT = "select pldbg_drop_breakpoint(?sessionid, ?obj, ?line)";
    private static final String SQL_CURRENT_SESSION = "SELECT pid,usename,application_name,state,query\nFROM pg_stat_activity WHERE pid = pg_backend_pid()";
    private static final Log log = Log.getLog(PostgreDebugSession.class);

    PostgreDebugSession(DBRProgressMonitor monitor, DBGBaseController controller) throws DBGException {
        super(controller);
        log.debug((Object)"Creating controller session.");
        PostgreDataSource dataSource = (PostgreDataSource)controller.getDataSourceContainer().getDataSource();
        try {
            PostgreDatabase instance;
            log.debug((Object)"Controller session creating.");
            if (this.isGlobalSession(controller.getDebugConfiguration())) {
                instance = dataSource.getDefaultInstance();
            } else {
                PostgreProcedure function = PostgreSqlDebugCore.resolveFunction(monitor, controller.getDataSourceContainer(), controller.getDebugConfiguration());
                instance = function.getDatabase();
            }
            this.controllerConnection = (JDBCExecutionContext)instance.openIsolatedContext(monitor, "Debug controller session");
            log.debug((Object)"Debug controller session created.");
            JDBCDataSource src = (JDBCDataSource)this.controllerConnection.getDataSource();
            if (src instanceof PostgreDataSource) {
                PostgreDataSource pgSrc = (PostgreDataSource)src;
                log.debug((Object)String.format("Active user %s", instance.getActiveUser()));
                log.debug((Object)String.format("Active schema %s", instance.getActiveSchemaName()));
                if (pgSrc.getInfo() instanceof JDBCDataSourceInfo) {
                    JDBCDataSourceInfo JDBCinfo = (JDBCDataSourceInfo)pgSrc.getInfo();
                    log.debug((Object)"------------DATABASE DRIVER INFO---------------");
                    log.debug((Object)String.format("Database Product Name %s", JDBCinfo.getDatabaseProductName()));
                    log.debug((Object)String.format("Database Product Version %s", JDBCinfo.getDatabaseProductVersion()));
                    log.debug((Object)String.format("Database Version %s", JDBCinfo.getDatabaseVersion()));
                    log.debug((Object)String.format("Driver Name %s", JDBCinfo.getDriverName()));
                    log.debug((Object)String.format("Driver Version %s", JDBCinfo.getDriverVersion()));
                    log.debug((Object)"-----------------------------------------------");
                } else {
                    log.debug((Object)"No additional Driver info");
                }
            } else {
                log.debug((Object)"Unknown Driver version");
            }
        }
        catch (DBException e) {
            log.debug((Object)String.format("Error creating debug session %s", e.getMessage()));
            throw new DBGException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public JDBCExecutionContext getControllerConnection() {
        return this.controllerConnection;
    }

    /*
     * Unable to fully structure code
     */
    private PostgreDebugSessionInfo getSessionDescriptor(DBRProgressMonitor monitor, JDBCExecutionContext connection) throws DBGException {
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                session = connection.openSession(monitor, DBCExecutionPurpose.UTIL, "Read session info");
                try {
                    var6_9 = null;
                    var7_11 = null;
                    try {
                        stmt = session.createStatement();
                        try {
                            var9_14 = null;
                            var10_16 = null;
                            try {
                                rs = stmt.executeQuery("SELECT pid,usename,application_name,state,query\nFROM pg_stat_activity WHERE pid = pg_backend_pid()");
                                try {
                                    if (rs.next()) {
                                        pid = rs.getInt("pid");
                                        usename = rs.getString("usename");
                                        applicationName = rs.getString("application_name");
                                        state = rs.getString("state");
                                        query = rs.getString("query");
                                        v0 = new PostgreDebugSessionInfo(pid, usename, applicationName, state, query);
                                        while (true) {
                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                            if (session != null) {
                                                session.close();
                                            }
                                            return v0;
                                        }
                                    }
                                    throw new DBGException("Error getting session");
                                }
                                finally {
                                    if (rs == null) ** continue;
                                    rs.close();
                                }
                            }
                            catch (Throwable var10_17) {
                                if (var9_14 == null) {
                                    var9_14 = var10_17;
                                } else if (var9_14 != var10_17) {
                                    var9_14.addSuppressed(var10_17);
                                }
                                throw var9_14;
                            }
                        }
                        catch (Throwable var6_10) {
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw var6_10;
                        }
                    }
                    catch (Throwable var7_12) {
                        if (var6_9 == null) {
                            var6_9 = var7_12;
                        } else if (var6_9 != var7_12) {
                            var6_9.addSuppressed(var7_12);
                        }
                        throw var6_9;
                    }
                }
                catch (Throwable var3_4) {
                    if (session != null) {
                        session.close();
                    }
                    throw var3_4;
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        }
        catch (SQLException e) {
            throw new DBGException("SQL error", (Throwable)e);
        }
    }

    private boolean localPortRcv(SQLWarning warn) {
        if (warn != null) {
            String notice = warn.getMessage();
            log.debug((Object)"Start local port waiting....");
            while (notice != null) {
                if (notice.startsWith(MAGIC_PORT)) {
                    try {
                        this.localPortNumber = Integer.valueOf(notice.substring(MAGIC_PORT.length() + 1).trim());
                        log.debug((Object)String.format("Catch local port number %d", this.localPortNumber));
                    }
                    catch (Exception e) {
                        log.debug((Object)String.format("Error catching local port number %s", e.getMessage()));
                        return false;
                    }
                    return true;
                }
                notice = (warn = warn.getNextWarning()) == null ? null : warn.getMessage();
                log.debug((Object)String.format("Next warning %s", notice == null ? "[NULL]" : notice));
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int attachToPort(DBRProgressMonitor monitor) throws DBGException {
        String sql = SQL_ATTACH_TO_PORT.replaceAll("\\?portnumber", String.valueOf(this.localPortNumber));
        log.debug((Object)String.format("Attach to local port number %d", this.localPortNumber));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Attach to port");
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try {
                        JDBCStatement stmt = session.createStatement();
                        try {
                            Throwable throwable3 = null;
                            Object var10_16 = null;
                            try {
                                int attResult;
                                block22: {
                                    ResultSet rs = stmt.executeQuery(sql);
                                    if (rs.next()) {
                                        attResult = rs.getInt(1);
                                        log.debug((Object)String.format("Attached to local port %d", attResult));
                                        break block22;
                                    } else {
                                        log.debug((Object)"Error while attaching to port");
                                        throw new DBGException("Error while attaching to port");
                                    }
                                    finally {
                                        if (rs == null) break block22;
                                        rs.close();
                                    }
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                if (session == null) return attResult;
                                session.close();
                                return attResult;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (stmt == null) throw throwable5;
                            stmt.close();
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable7) {
                    if (session == null) throw throwable7;
                    session.close();
                    throw throwable7;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                    throw throwable;
                }
                if (throwable == throwable8) throw throwable;
                throwable.addSuppressed(throwable8);
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Error while attaching to port");
            throw new DBGException("Error attaching to port", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String createSlot(DBRProgressMonitor monitor, JDBCExecutionContext connection, PostgreProcedure function) throws DBGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitPortNumber() throws DBGException {
        int totalWait = 0;
        boolean hasStatement = false;
        log.debug((Object)String.format("Waiting for port number with timeout %d", 50000));
        while (totalWait < 50000) {
            try {
                JDBCCallableStatement statement = this.localStatement;
                if (statement != null) {
                    hasStatement = true;
                    if (this.localPortRcv(statement.getWarnings())) {
                        log.debug((Object)"Local port recived");
                        break;
                    }
                } else if (hasStatement) {
                    log.debug((Object)"Statement has been closed");
                    break;
                }
                Thread.sleep(50L);
                log.debug((Object)"Thread waked up");
            }
            catch (InterruptedException | SQLException e) {
                log.debug((Object)String.format("Error rcv port number %s", e.getMessage()));
                throw new DBGException("Error rcv port number", (Throwable)e);
            }
            totalWait += 50;
        }
        if (this.localPortNumber < 0) {
            log.debug((Object)String.format("Unable to rcv port number %d", this.localPortNumber));
            throw new DBGException("Unable to rcv port number");
        }
    }

    protected void runLocalProc(final JDBCExecutionContext connection, final PostgreProcedure function, final List<String> paramValues, final String name) throws DBGException {
        final List parameters = function.getInputParameters();
        log.debug((Object)"Run local proc");
        if (parameters.size() != paramValues.size()) {
            String unmatched = "Parameter value count (" + paramValues.size() + ") doesn't match actual function parameters (" + parameters.size() + ")";
            log.debug((Object)unmatched);
            throw new DBGException(unmatched);
        }
        AbstractJob job = new AbstractJob(name){

            /*
             * Unable to fully structure code
             */
            protected IStatus run(DBRProgressMonitor monitor) {
                block31: {
                    var2_2 = null;
                    var3_4 = null;
                    try {
                        session = connection.openSession(monitor, DBCExecutionPurpose.USER, "Run SQL command");
                        try {
                            try {
                                query = new StringBuilder();
                                query.append("{ CALL ").append(function.getFullyQualifiedName(DBPEvaluationContext.DML)).append("(");
                                i = 0;
                                while (i < parameters.size()) {
                                    if (i > 0) {
                                        query.append(",");
                                    }
                                    paramValue = (String)paramValues.get(i);
                                    query.append(paramValue);
                                    ++i;
                                }
                                query.append(") }");
                                PostgreDebugSession.access$3().debug((Object)String.format("Prepared local call %s", new Object[]{query}));
                                PostgreDebugSession.access$2(PostgreDebugSession.this, session.prepareCall(query.toString()));
                                PostgreDebugSession.access$1(PostgreDebugSession.this).execute();
                                PostgreDebugSession.access$3().debug((Object)"Local statement executed (ANHWIE)");
                                PostgreDebugSession.access$4(PostgreDebugSession.this, new DBGEvent((Object)this, 1, 4));
                            }
                            catch (Exception e) {
                                PostgreDebugSession.access$3().debug((Object)("Error execute local statement: " + e.getMessage()));
                                v0 = sqlState = e instanceof SQLException != false ? ((SQLException)e).getSQLState() : null;
                                if (!"57014".equals(sqlState)) {
                                    PostgreDebugSession.access$3().error((Object)name, (Throwable)e);
                                    var9_12 = DebugUtils.newErrorStatus((String)name, (Throwable)e);
                                    try {
                                        if (PostgreDebugSession.access$1(PostgreDebugSession.this) != null) {
                                            PostgreDebugSession.access$1(PostgreDebugSession.this).close();
                                            PostgreDebugSession.access$2(PostgreDebugSession.this, null);
                                        }
                                    }
                                    catch (Exception e1) {
                                        PostgreDebugSession.access$3().debug((Object)"Error clearing local statment");
                                        PostgreDebugSession.access$3().error((Object)e1);
                                    }
                                    connection.close();
                                    PostgreDebugSession.access$4(PostgreDebugSession.this, new DBGEvent((Object)this, 8, 32));
                                    if (session != null) {
                                        session.close();
                                    }
                                    return var9_12;
                                }
                                try {
                                    if (PostgreDebugSession.access$1(PostgreDebugSession.this) != null) {
                                        PostgreDebugSession.access$1(PostgreDebugSession.this).close();
                                        PostgreDebugSession.access$2(PostgreDebugSession.this, null);
                                    }
                                }
                                catch (Exception e1) {
                                    PostgreDebugSession.access$3().debug((Object)"Error clearing local statment");
                                    PostgreDebugSession.access$3().error((Object)e1);
                                }
                                connection.close();
                                PostgreDebugSession.access$4(PostgreDebugSession.this, new DBGEvent((Object)this, 8, 32));
                                break block31;
                            }
                        }
                        catch (Throwable var8_17) {
                            try {
                                if (PostgreDebugSession.access$1(PostgreDebugSession.this) != null) {
                                    PostgreDebugSession.access$1(PostgreDebugSession.this).close();
                                    PostgreDebugSession.access$2(PostgreDebugSession.this, null);
                                }
                            }
                            catch (Exception e1) {
                                PostgreDebugSession.access$3().debug((Object)"Error clearing local statment");
                                PostgreDebugSession.access$3().error((Object)e1);
                            }
                            connection.close();
                            PostgreDebugSession.access$4(PostgreDebugSession.this, new DBGEvent((Object)this, 8, 32));
                            throw var8_17;
                        }
                        ** try [egrp 8[TRYBLOCK] [5 : 539->572)] { 
lbl-1000:
                        // 1 sources

                        {
                            if (PostgreDebugSession.access$1(PostgreDebugSession.this) != null) {
                                PostgreDebugSession.access$1(PostgreDebugSession.this).close();
                                PostgreDebugSession.access$2(PostgreDebugSession.this, null);
                            }
                        }
lbl78:
                        // 1 sources

                        catch (Exception e1) {
                            PostgreDebugSession.access$3().debug((Object)"Error clearing local statment");
                            PostgreDebugSession.access$3().error((Object)e1);
                        }
                        connection.close();
                        PostgreDebugSession.access$4(PostgreDebugSession.this, new DBGEvent((Object)this, 8, 32));
                        break block31;
                        finally {
                            if (session != null) {
                                session.close();
                            }
                        }
                    }
                    catch (Throwable var3_5) {
                        if (var2_2 == null) {
                            var2_2 = var3_5;
                        } else if (var2_2 != var3_5) {
                            var2_2.addSuppressed(var3_5);
                        }
                        throw var2_2;
                    }
                }
                PostgreDebugSession.access$3().debug((Object)"Local statement executed");
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void attachLocal(DBRProgressMonitor monitor, PostgreProcedure function, List<String> parameters) throws DBGException {
        try {
            JDBCExecutionContext connection = (JDBCExecutionContext)this.controllerConnection.getOwnerInstance().openIsolatedContext(monitor, "Debug process session");
            log.debug((Object)"Attaching locally....");
            this.sessionInfo = this.getSessionDescriptor(monitor, connection);
            this.createSlot(monitor, connection, function);
            String taskName = "PostgreSQL Debug - Local session " + this.sessionInfo.getID();
            this.runLocalProc(connection, function, parameters, taskName);
            this.waitPortNumber();
            this.sessionId = this.attachToPort(monitor);
            log.debug((Object)String.format("Attached local session UD = %d", this.sessionId));
            this.getController().fireEvent(new DBGEvent((Object)this, 2, 32));
        }
        catch (DBException e) {
            throw new DBGException("Error opening debug session", (Throwable)e);
        }
    }

    private void attachGlobal(DBRProgressMonitor monitor, int oid, int targetPID) throws DBGException {
        block30: {
            log.debug((Object)"Attaching globally....");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Attach global");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement stmt = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (ResultSet rs = stmt.executeQuery(SQL_LISTEN);){
                            if (rs.next()) {
                                this.sessionId = rs.getInt("sessionid");
                                log.debug((Object)String.format("Global session ID %d", this.sessionId));
                                break block30;
                            }
                            log.debug((Object)"Unable to create debug instance");
                            throw new DBGException("Unable to create debug instance");
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBGException("SQL error", (Throwable)e);
            }
        }
        this.bpGlobal = new PostgreDebugBreakpointDescriptor(oid, -1L);
        this.addBreakpoint(monitor, this.bpGlobal);
        log.debug((Object)"Global breakpoint added");
        String sessionParam = String.valueOf(this.getSessionId());
        String taskName = "PostgreSQL Debug - Global session " + this.sessionInfo.getID();
        String sql = SQL_ATTACH.replaceAll("\\?sessionid", sessionParam);
        DBGEvent begin = new DBGEvent((Object)this, 1, 32);
        DBGEvent end = new DBGEvent((Object)this, 2, 16);
        this.runAsync(sql, taskName, begin, end);
        log.debug((Object)"Global session started");
    }

    public void attach(DBRProgressMonitor monitor, Map<String, Object> configuration) throws DBException {
        if (!this.checkDebugPlagin(monitor)) {
            throw new DBGException("PostgreSQL debug plugin is not installed on the server.\nRefer to this WIKI article for installation instructions:\nhttps://github.com/dbeaver/dbeaver/wiki/PGDebugger#installation");
        }
        log.debug((Object)"Attaching...");
        this.functionOid = CommonUtils.toInt((Object)configuration.get("PG.ATTR_FUNCTION_OID"));
        log.debug((Object)String.format("Function OID %d", this.functionOid));
        boolean global = this.isGlobalSession(configuration);
        if (global) {
            int processId = CommonUtils.toInt((Object)configuration.get("PG.ATTACH_PROCESS"));
            this.attachKind = PostgreDebugAttachKind.GLOBAL;
            this.attachGlobal(monitor, this.functionOid, processId);
            log.debug((Object)"Global attached");
        } else {
            this.attachKind = PostgreDebugAttachKind.LOCAL;
            PostgreProcedure function = PostgreSqlDebugCore.resolveFunction(monitor, ((JDBCDataSource)this.controllerConnection.getDataSource()).getContainer(), configuration);
            List parameterValues = (List)configuration.get("PG.ATTR_FUNCTION_PARAMETERS");
            this.attachLocal(monitor, function, parameterValues);
            log.debug((Object)"Local attached");
        }
    }

    private boolean isGlobalSession(Map<String, Object> configuration) {
        return "GLOBAL".equals(String.valueOf(configuration.get("PG.ATTR_ATTACH_KIND")));
    }

    private boolean checkDebugPlagin(DBRProgressMonitor monitor) {
        block13: {
            Throwable throwable = null;
            Object var3_5 = null;
            JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Check debug plugin installation");
            try {
                String version = (String)JDBCUtils.executeQuery((Connection)session, (String)SQL_CHECK_PLUGIN, (Object[])new Object[0]);
                log.debug((Object)("Debug plugin is installed:\n" + version));
                if (session == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.debug((Object)("Debug plugin not installed: " + e.getMessage()));
                        return false;
                    }
                }
            }
            session.close();
        }
        return true;
    }

    private void detachLocal(DBRProgressMonitor monitor, JDBCExecutionContext connection) throws DBGException {
        if (this.localStatement == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = connection.openSession(monitor, DBCExecutionPurpose.UTIL, "Abort local session");){
                JDBCUtils.executeQuery((Connection)session, (String)this.composeAbortCommand(), (Object[])new Object[0]);
                log.debug((Object)"Local detached");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to abort local session");
            log.error((Object)"Unable to abort local target", (Throwable)e);
        }
    }

    private void detachGlobal(DBRProgressMonitor monitor) throws DBGException {
        this.removeBreakpoint(monitor, this.bpGlobal);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Abort global session");){
                JDBCUtils.executeQuery((Connection)session, (String)this.composeAbortCommand(), (Object[])new Object[0]);
                log.debug((Object)"Global deattached");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Unable to abort global target", (Throwable)e);
        }
    }

    protected void doDetach(DBRProgressMonitor monitor) throws DBGException {
        switch (this.attachKind) {
            case GLOBAL: {
                this.detachGlobal(monitor);
                break;
            }
            case LOCAL: {
                this.detachLocal(monitor, this.getControllerConnection());
                break;
            }
        }
    }

    public DBGSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    protected String composeAddBreakpointCommand(DBGBreakpointDescriptor descriptor) {
        PostgreDebugBreakpointDescriptor bp = (PostgreDebugBreakpointDescriptor)descriptor;
        String sqlPattern = this.attachKind == PostgreDebugAttachKind.GLOBAL ? SQL_SET_GLOBAL_BREAKPOINT : SQL_SET_BREAKPOINT;
        String sqlCommand = sqlPattern.replaceAll("\\?sessionid", String.valueOf(this.getSessionId())).replaceAll("\\?obj", String.valueOf(this.functionOid)).replaceAll("\\?line", bp.isOnStart() ? "-1" : String.valueOf(bp.getLineNo())).replaceAll("\\?target", bp.isAll() ? "null" : String.valueOf(bp.getTargetId()));
        return sqlCommand;
    }

    protected String composeRemoveBreakpointCommand(DBGBreakpointDescriptor breakpointDescriptor) {
        PostgreDebugBreakpointDescriptor bp = (PostgreDebugBreakpointDescriptor)breakpointDescriptor;
        String sqlCommand = SQL_DROP_BREAKPOINT.replaceAll("\\?sessionid", String.valueOf(this.getSessionId())).replaceAll("\\?obj", String.valueOf(this.functionOid)).replaceAll("\\?line", bp.isOnStart() ? "-1" : String.valueOf(bp.getLineNo()));
        return sqlCommand;
    }

    public void execContinue() throws DBGException {
        log.debug((Object)"try continue for");
        this.execStep(SQL_CONTINUE, " continue for ", 1);
        log.debug((Object)"continue for realized");
    }

    public void execStepInto() throws DBGException {
        log.debug((Object)"try step into");
        this.execStep(SQL_STEP_INTO, " step into for ", 1);
        log.debug((Object)"step into realized");
    }

    public void execStepOver() throws DBGException {
        log.debug((Object)"try step over");
        this.execStep(SQL_STEP_OVER, " step over for ", 2);
        log.debug((Object)"step over realized");
    }

    public void execStepReturn() throws DBGException {
        log.debug((Object)"Exec return not implemented");
        throw new DBGException("Exec return not implemented");
    }

    public void resume() throws DBGException {
        log.debug((Object)"try continue execution");
        this.execContinue();
        log.debug((Object)"continue execution realized");
    }

    public void suspend() throws DBGException {
        throw new DBGException("Suspend not implemented");
    }

    public void execStep(String commandPattern, String nameParameter, int eventDetail) throws DBGException {
        String sql = commandPattern.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
        String taskName = String.valueOf(String.valueOf(this.sessionId)) + nameParameter + this.sessionInfo.getID();
        DBGEvent begin = new DBGEvent((Object)this, 1, eventDetail);
        DBGEvent end = new DBGEvent((Object)this, 2, eventDetail);
        this.runAsync(sql, taskName, begin, end);
    }

    protected String composeAbortCommand() {
        return SQL_ABORT.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
    }

    public List<DBGVariable<?>> getVariables(DBGStackFrame stack) throws DBGException {
        if (stack != null) {
            this.selectFrame(stack.getLevel());
        }
        log.debug((Object)"Get vars values");
        ArrayList vars = new ArrayList();
        String sql = SQL_GET_VARS.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Read debug variables");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        while (rs.next()) {
                            String name = rs.getString("name");
                            String varclass = rs.getString("varclass");
                            int linenumber = rs.getInt("linenumber");
                            boolean isunique = rs.getBoolean("isunique");
                            boolean isconst = rs.getBoolean("isconst");
                            boolean isnotnull = rs.getBoolean("isnotnull");
                            int dtype = rs.getInt("dtype");
                            String value = rs.getString("value");
                            PostgreDebugVariable var = new PostgreDebugVariable(name, varclass, linenumber, isunique, isconst, isnotnull, dtype, value);
                            vars.add(var);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Error getting vars: " + e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
        log.debug((Object)String.format("Return %d var(s)", vars.size()));
        return vars;
    }

    public void setVariableVal(DBGVariable<?> variable, Object value) throws DBGException {
        block22: {
            log.debug((Object)"Set var value");
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Set debug variable");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement stmt = session.prepareStatement(SQL_SET_VAR);){
                        if (variable instanceof PostgreDebugVariable) {
                            if (value instanceof String) {
                                PostgreDebugVariable var = (PostgreDebugVariable)variable;
                                stmt.setInt(1, this.sessionId);
                                stmt.setString(2, var.getName());
                                stmt.setInt(3, var.getLineNumber());
                                stmt.setString(4, (String)value);
                                stmt.execute();
                                log.debug((Object)"Var value set");
                                break block22;
                            }
                            log.debug((Object)"Incorrect variable value class");
                            throw new DBGException("Incorrect variable value class");
                        }
                        log.debug((Object)"Incorrect variable class");
                        throw new DBGException("Incorrect variable class");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.debug((Object)("Error setting var: " + e.getMessage()));
                throw new DBGException("SQL error", (Throwable)e);
            }
        }
    }

    public List<DBGStackFrame> getStack() throws DBGException {
        ArrayList<DBGStackFrame> stack = new ArrayList<DBGStackFrame>(1);
        log.debug((Object)"Get stack");
        String sql = SQL_GET_STACK.replaceAll("\\?sessionid", String.valueOf(this.getSessionId()));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Get debug stack frame");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        while (rs.next()) {
                            int level = rs.getInt("level");
                            String targetname = rs.getString("targetname");
                            int func = rs.getInt("func");
                            int linenumber = rs.getInt("linenumber");
                            String args = rs.getString("args");
                            PostgreDebugStackFrame frame = new PostgreDebugStackFrame(level, targetname, func, linenumber, args);
                            stack.add(frame);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Error loading stack frame: " + e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
        log.debug((Object)String.format("Return %d stack frame(s)", stack.size()));
        return stack;
    }

    public String getSource(DBGStackFrame stack) throws DBGException {
        log.debug((Object)"Get source");
        if (stack instanceof PostgreDebugStackFrame) {
            PostgreDebugStackFrame postgreStack = (PostgreDebugStackFrame)stack;
            String src = this.getSource(postgreStack.getOid());
            log.debug((Object)String.format("Return %d src char(s)", src.length()));
            return src;
        }
        String message = String.format("Unable to get source for stack %s", stack);
        throw new DBGException(message);
    }

    public String getSource(int OID) throws DBGException {
        ResultSet rs;
        JDBCStatement stmt;
        JDBCSession session;
        block39: {
            String string;
            block40: {
                log.debug((Object)"Get source for func OID in debug session");
                String sql = SQL_GET_SRC.replaceAll("\\?sessionid", String.valueOf(this.sessionId)).replaceAll("\\?oid", String.valueOf(OID));
                Throwable throwable = null;
                Object var4_6 = null;
                session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Get session source");
                Throwable throwable2 = null;
                Object var7_11 = null;
                stmt = session.createStatement();
                Throwable throwable3 = null;
                Object var10_16 = null;
                rs = stmt.executeQuery(sql);
                try {
                    if (!rs.next()) break block39;
                    String src = rs.getString(1);
                    log.debug((Object)String.format("Return %d src char(s)", src.length()));
                    string = src;
                    if (rs == null) break block40;
                }
                catch (Throwable throwable4) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable6) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                                throw throwable6;
                            }
                            catch (Throwable throwable7) {
                                try {
                                    if (throwable2 == null) {
                                        throwable2 = throwable7;
                                    } else if (throwable2 != throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable8) {
                                    try {
                                        if (session != null) {
                                            session.close();
                                        }
                                        throw throwable8;
                                    }
                                    catch (Throwable throwable9) {
                                        try {
                                            if (throwable == null) {
                                                throwable = throwable9;
                                            } else if (throwable != throwable9) {
                                                throwable.addSuppressed(throwable9);
                                            }
                                            throw throwable;
                                        }
                                        catch (SQLException e) {
                                            log.debug((Object)String.format("Unable to get source for OID %s", e.getMessage()));
                                            throw new DBGException("SQL error", (Throwable)e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (session != null) {
                session.close();
            }
            return string;
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (session != null) {
            session.close();
        }
        return null;
    }

    public void selectFrame(int frameNumber) throws DBGException {
        log.debug((Object)"Select frame");
        String sql = SQL_SELECT_FRAME.replaceAll("\\?sessionid", String.valueOf(this.sessionId)).replaceAll("\\?frameno", String.valueOf(frameNumber));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Select debug frame");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        if (!rs.next()) {
                            log.debug((Object)"Unable to select frame");
                            throw new DBGException("Unable to select frame");
                        }
                        log.debug((Object)"Frame selected");
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)String.format("Unable to select frame %s", e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
    }

    public String toString() {
        return "PostgreDebugSession " + (this.isWaiting() ? "WAITING" : "READY") + " [sessionId=" + this.sessionId + ", breakpoints=" + this.getBreakpoints() + "targetId=(" + this.sessionInfo.getID() + ") Session=(" + this.sessionInfo.toString() + ") " + "]";
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public boolean canStepInto() {
        return true;
    }

    public boolean canStepOver() {
        return true;
    }

    public boolean canStepReturn() {
        return true;
    }

    public boolean isAttached() {
        return this.sessionId > 0;
    }

    public boolean isDone() {
        switch (this.attachKind) {
            case GLOBAL: {
                return this.workerJob == null || this.workerJob.isFinished();
            }
            case LOCAL: {
                return this.sessionId > 0;
            }
        }
        return false;
    }

    public void closeSession(DBRProgressMonitor monitor) throws DBGException {
        if (!this.isAttached()) {
            return;
        }
        log.debug((Object)"Closing session.");
        try {
            super.closeSession(monitor);
            log.debug((Object)"Session closed.");
        }
        finally {
            if (this.controllerConnection != null) {
                IOUtils.close((Closeable)this.controllerConnection);
            }
        }
    }

    static /* synthetic */ JDBCCallableStatement access$1(PostgreDebugSession postgreDebugSession) {
        return postgreDebugSession.localStatement;
    }

    static /* synthetic */ void access$2(PostgreDebugSession postgreDebugSession, JDBCCallableStatement jDBCCallableStatement) {
        postgreDebugSession.localStatement = jDBCCallableStatement;
    }

    static /* synthetic */ Log access$3() {
        return log;
    }

    static /* synthetic */ void access$4(PostgreDebugSession postgreDebugSession, DBGEvent dBGEvent) {
        postgreDebugSession.fireEvent(dBGEvent);
    }
}

