/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

public class SQLPreferenceConstants {
    public static final String INSERT_SINGLE_PROPOSALS_AUTO = "SQLEditor.ContentAssistant.insert.single.proposal";
    public static final String ENABLE_AUTO_ACTIVATION = "SQLEditor.ContentAssistant.auto.activation.enable";
    public static final String ENABLE_KEYSTROKE_ACTIVATION = "SQLEditor.ContentAssistant.auto.keystrokes.activation";
    public static final String AUTO_ACTIVATION_DELAY = "SQLEditor.ContentAssistant.auto.activation.delay";
    public static final String PROPOSAL_INSERT_CASE = "SQLEditor.ContentAssistant.insert.case";
    public static final String PROPOSAL_REPLACE_WORD = "SQLEditor.ContentAssistant.replace.word";
    public static final String PROPOSAL_SORT_ALPHABETICALLY = "SQLEditor.ContentAssistant.proposals.sort.alphabetically";
    public static final String HIDE_DUPLICATE_PROPOSALS = "SQLEditor.ContentAssistant.hide.duplicates";
    public static final String PROPOSAL_SHORT_NAME = "SQLEditor.ContentAssistant.proposals.short.name";
    public static final String PROPOSAL_ALWAYS_FQ = "SQLEditor.ContentAssistant.proposals.long.name";
    public static final String INSERT_SPACE_AFTER_PROPOSALS = "SQLEditor.ContentAssistant.insert.space.after.proposal";
    public static final String USE_GLOBAL_ASSISTANT = "SQLEditor.ContentAssistant.use.global.search";
    public static final String PROPOSALS_MATCH_CONTAINS = "SQLEditor.ContentAssistant.matching.fuzzy";
    public static final String SHOW_COLUMN_PROCEDURES = "SQLEditor.ContentAssistant.show.column.procedures";
    public static final String SHOW_SERVER_HELP_TOPICS = "SQLEditor.ContentAssistant.show.helpTopics";
    public static final String MARK_OCCURRENCES_UNDER_CURSOR = "SQLEditor.markOccurrences";
    public static final String MARK_OCCURRENCES_FOR_SELECTION = "SQLEditor.markOccurrences.forSelection";
    public static final String FOLDING_ENABLED = "SQLEditor.Folding.enabled";
    public static final String AUTO_SAVE_ON_CLOSE = "SQLEditor.autoSaveOnClose";
    public static final String AUTO_SAVE_ON_EXECUTE = "SQLEditor.autoSaveOnExecute";
    public static final String SQLEDITOR_CLOSE_SINGLE_QUOTES = "SQLEditor.closeSingleQuotes";
    public static final String SQLEDITOR_CLOSE_DOUBLE_QUOTES = "SQLEditor.closeDoubleQuotes";
    public static final String SQLEDITOR_CLOSE_BRACKETS = "SQLEditor.closeBrackets";
    public static final String SQLEDITOR_CLOSE_COMMENTS = "SQLEditor.closeComments";
    public static final String SQLEDITOR_CLOSE_BEGIN_END = "SQLEditor.closeBeginEndStatement";
    public static final String MATCHING_BRACKETS = "SQLEditor.matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "AbstractTextEditor.Color.Foreground";
    public static final String RESET_CURSOR_ON_EXECUTE = "SQLEditor.resetCursorOnExecute";
    public static final String MAXIMIZE_EDITOR_ON_SCRIPT_EXECUTE = "SQLEditor.maxEditorOnScriptExecute";
    public static final int PROPOSAL_CASE_DEFAULT = 0;
    public static final int PROPOSAL_CASE_UPPER = 1;
    public static final int PROPOSAL_CASE_LOWER = 2;
    public static final String SQL_FORMAT_KEYWORD_CASE_AUTO = "SQLEditor.format.keywordCaseAuto";
    public static final String SQL_FORMAT_EXTRACT_FROM_SOURCE = "SQLEditor.format.extractFromSource";
    public static final String SQL_FORMAT_BOLD_KEYWORDS = "SQLEditor.format.boldKeywords";
    public static final String BEEP_ON_QUERY_END = "SQLEditor.beepOnQueryEnd";
    public static final String REFRESH_DEFAULTS_AFTER_EXECUTE = "SQLEditor.refreshDefaultsAfterExecute";
    public static final String CLEAR_OUTPUT_BEFORE_EXECUTE = "SQLEditor.clearOutputBeforeExecute";
    public static final String RESULT_SET_CLOSE_ON_ERROR = "SQLEditor.resultSet.closeOnError";
    public static final String RESULT_SET_ORIENTATION = "SQLEditor.resultSet.orientation";
    public static final String RESULTS_PANEL_RATIO = "SQLEditor.resultSet.ratio";
    public static final String SCRIPT_BIND_EMBEDDED_READ = "SQLEditor.script.bind.embedded.read";
    public static final String SCRIPT_BIND_EMBEDDED_WRITE = "SQLEditor.script.bind.embedded.write";
    public static final String SCRIPT_BIND_COMMENT_TYPE = "SQLEditor.script.bind.commentType";
    public static final String SCRIPT_DELETE_EMPTY = "script.delete.empty";
    public static final String SCRIPT_AUTO_FOLDERS = "script.auto.folders";
    public static final String SCRIPT_CREATE_CONNECTION_FOLDERS = "script.auto.connection.folders";
    public static final String SCRIPT_TITLE_PATTERN = "script.title.pattern";
    public static final String SCRIPT_COMMIT_TYPE = "script.commit.type";
    public static final String SCRIPT_COMMIT_LINES = "script.commit.lines";
    public static final String SCRIPT_ERROR_HANDLING = "script.error.handling";
    public static final String SCRIPT_FETCH_RESULT_SETS = "script.fetch.resultset";
    public static final String STATEMENT_INVALIDATE_BEFORE_EXECUTE = "statement.invalidate.before.execute";
    public static final String STATEMENT_TIMEOUT = "statement.timeout";
    public static final String EDITOR_SEPARATE_CONNECTION = "database.editor.separate.connection";
    public static final String EDITOR_CONNECT_ON_ACTIVATE = "database.editor.connect.on.activate";
    public static final String EDITOR_CONNECT_ON_EXECUTE = "database.editor.connect.on.execute";
    public static final String CONFIRM_DANGER_SQL = "dangerous_sql";
    public static final String CONFIRM_MASS_PARALLEL_SQL = "mass_parallel_sql";
    public static final String CONFIRM_RUNNING_QUERY_CLOSE = "close_running_query";

    public static enum EmptyScriptCloseBehavior {
        NOTHING("Do not delete"),
        DELETE_NEW("Delete only new scripts"),
        DELETE_ALWAYS("Delete always");

        private final String title;

        private EmptyScriptCloseBehavior(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public static EmptyScriptCloseBehavior getByTitle(String title) {
            EmptyScriptCloseBehavior[] emptyScriptCloseBehaviorArray = EmptyScriptCloseBehavior.values();
            int n = emptyScriptCloseBehaviorArray.length;
            int n2 = 0;
            while (n2 < n) {
                EmptyScriptCloseBehavior escb = emptyScriptCloseBehaviorArray[n2];
                if (escb.getTitle().equals(title)) {
                    return escb;
                }
                ++n2;
            }
            return NOTHING;
        }

        public static EmptyScriptCloseBehavior getByName(String name) {
            switch (name) {
                case "true": {
                    return DELETE_NEW;
                }
                case "false": {
                    return NOTHING;
                }
            }
            try {
                return EmptyScriptCloseBehavior.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return NOTHING;
            }
        }
    }
}

