"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function chunk(array, size) {
    var chunks = [];
    for (var index = 0, length_1 = array.length; index < length_1; index += size) {
        chunks.push(array.slice(index, index + size));
    }
    return chunks;
}
exports.chunk = chunk;
function getDeduplicatedUnion(array1, array2) {
    return removeDuplicates(array1.concat(array2));
}
exports.getDeduplicatedUnion = getDeduplicatedUnion;
function getDifference(array1, array2) {
    return array1.filter(function (value) { return !array2.includes(value); });
}
exports.getDifference = getDifference;
function getIntersection(array1, array2) {
    return array1.filter(function (value) { return array2.includes(value); });
}
exports.getIntersection = getIntersection;
function removeDuplicates(array) {
    return Array.from(new Set(array));
}
exports.removeDuplicates = removeDuplicates;
//# sourceMappingURL=ArrayUtil.js.map