'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _loadingView = require('./loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _remoteSelectorView = require('./remote-selector-view');

var _remoteSelectorView2 = _interopRequireDefault(_remoteSelectorView);

var _remoteContainer = require('../containers/remote-container');

var _remoteContainer2 = _interopRequireDefault(_remoteContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitHubTabView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GitHub', ref: this.props.rootHolder.setter },
      _react2.default.createElement(
        'div',
        { className: 'github-GitHub-content' },
        this.renderRemote()
      )
    );
  }

  renderRemote() {
    if (this.props.isLoading) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (this.props.currentRemote.isPresent()) {
      // Single, chosen or unambiguous remote
      return _react2.default.createElement(_remoteContainer2.default, {
        loginModel: this.props.loginModel,
        endpoint: this.props.currentRemote.getEndpoint(),

        remoteOperationObserver: this.props.remoteOperationObserver,
        pushInProgress: this.props.pushInProgress,
        workingDirectory: this.props.workingDirectory,
        workspace: this.props.workspace,
        remote: this.props.currentRemote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,

        onPushBranch: () => this.props.handlePushBranch(this.props.currentBranch, this.props.currentRemote)
      });
    }

    if (this.props.manyRemotesAvailable) {
      // No chosen remote, multiple remotes hosted on GitHub instances
      return _react2.default.createElement(_remoteSelectorView2.default, {
        remotes: this.props.remotes,
        currentBranch: this.props.currentBranch,
        selectRemote: this.props.handleRemoteSelect
      });
    }

    // No remotes available
    // TODO: display a view that lets you create a repository on GitHub
    return _react2.default.createElement(
      'div',
      { className: 'github-GitHub-noRemotes' },
      'This repository does not have any remotes hosted at GitHub.com.'
    );
  }
}
exports.default = GitHubTabView;
GitHubTabView.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes3.RefHolderPropType.isRequired,

  workingDirectory: _propTypes2.default.string.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  currentBranch: _propTypes3.BranchPropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  currentRemote: _propTypes3.RemotePropType.isRequired,
  manyRemotesAvailable: _propTypes2.default.bool.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,
  isLoading: _propTypes2.default.bool.isRequired,

  handlePushBranch: _propTypes2.default.func.isRequired,
  handleRemoteSelect: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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