'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _gitTabContainer = require('../containers/git-tab-container');

var _gitTabContainer2 = _interopRequireDefault(_gitTabContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitTabItem extends _react2.default.Component {

  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);

    this.refController = new _refHolder2.default();
  }

  render() {
    return _react2.default.createElement(_gitTabContainer2.default, _extends({
      controllerRef: this.refController
    }, this.props));
  }

  serialize() {
    return {
      deserializer: 'GitDockItem',
      uri: this.getURI()
    };
  }

  getTitle() {
    return 'Git';
  }

  getIconName() {
    return 'git-commit';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getURI() {
    return this.constructor.uriPattern;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  // Forwarded to the controller instance when one is present

  rememberLastFocus(...args) {
    return this.refController.map(c => c.rememberLastFocus(...args));
  }

  restoreFocus(...args) {
    return this.refController.map(c => c.restoreFocus(...args));
  }

  hasFocus(...args) {
    return this.refController.map(c => c.hasFocus(...args));
  }

  focus() {
    return this.refController.map(c => c.restoreFocus());
  }

  focusAndSelectStagingItem(...args) {
    return this.refController.map(c => c.focusAndSelectStagingItem(...args));
  }

  focusAndSelectCommitPreviewButton() {
    return this.refController.map(c => c.focusAndSelectCommitPreviewButton());
  }

  quietlySelectItem(...args) {
    return this.refController.map(c => c.quietlySelectItem(...args));
  }

  focusAndSelectRecentCommit() {
    return this.refController.map(c => c.focusAndSelectRecentCommit());
  }
}
exports.default = GitTabItem;
GitTabItem.propTypes = {
  repository: _propTypes2.default.object.isRequired
};
GitTabItem.uriPattern = 'atom-github://dock-item/git';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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