/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.image;

import com.sun.prism.Graphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundImage;
import com.sun.prism.image.Coords;

public class CompoundCoords {
    private int xImg0;
    private int xImg1;
    private int yImg0;
    private int yImg1;
    private Coords[] tileCoords;

    public CompoundCoords(CompoundImage t, Coords crd) {
        int xImg0 = CompoundCoords.find1(CompoundCoords.fastFloor(crd.u0), t.uSubdivision);
        int xImg1 = CompoundCoords.find2(CompoundCoords.fastCeil(crd.u1), t.uSubdivision);
        int yImg0 = CompoundCoords.find1(CompoundCoords.fastFloor(crd.v0), t.vSubdivision);
        int yImg1 = CompoundCoords.find2(CompoundCoords.fastCeil(crd.v1), t.vSubdivision);
        if (xImg0 < 0 || xImg1 < 0 || yImg0 < 0 || yImg1 < 0) {
            return;
        }
        this.xImg0 = xImg0;
        this.xImg1 = xImg1;
        this.yImg0 = yImg0;
        this.yImg1 = yImg1;
        this.tileCoords = new Coords[(xImg1 - xImg0 + 1) * (yImg1 - yImg0 + 1)];
        float[] xMedian = new float[xImg1 - xImg0];
        float[] yMedian = new float[yImg1 - yImg0];
        for (int x = xImg0; x < xImg1; ++x) {
            xMedian[x - xImg0] = crd.getX(t.uSubdivision[x + 1]);
        }
        for (int y = yImg0; y < yImg1; ++y) {
            yMedian[y - yImg0] = crd.getY(t.vSubdivision[y + 1]);
        }
        int idx = 0;
        for (int y = yImg0; y <= yImg1; ++y) {
            float v0 = (y == yImg0 ? crd.v0 : (float)t.vSubdivision[y]) - (float)t.v0[y];
            float v1 = (y == yImg1 ? crd.v1 : (float)t.vSubdivision[y + 1]) - (float)t.v0[y];
            float y0 = y == yImg0 ? crd.y0 : yMedian[y - yImg0 - 1];
            float y1 = y == yImg1 ? crd.y1 : yMedian[y - yImg0];
            for (int x = xImg0; x <= xImg1; ++x) {
                Coords segment = new Coords();
                segment.v0 = v0;
                segment.v1 = v1;
                segment.y0 = y0;
                segment.y1 = y1;
                segment.u0 = (x == xImg0 ? crd.u0 : (float)t.uSubdivision[x]) - (float)t.u0[x];
                segment.u1 = (x == xImg1 ? crd.u1 : (float)t.uSubdivision[x + 1]) - (float)t.u0[x];
                segment.x0 = x == xImg0 ? crd.x0 : xMedian[x - xImg0 - 1];
                segment.x1 = x == xImg1 ? crd.x1 : xMedian[x - xImg0];
                this.tileCoords[idx++] = segment;
            }
        }
    }

    public void draw(Graphics g, CompoundImage t, float xS, float yS) {
        if (this.tileCoords == null) {
            return;
        }
        ResourceFactory factory = g.getResourceFactory();
        int idx = 0;
        for (int y = this.yImg0; y <= this.yImg1; ++y) {
            for (int x = this.xImg0; x <= this.xImg1; ++x) {
                Texture tex = t.getTile(x, y, factory);
                this.tileCoords[idx++].draw(tex, g, xS, yS);
                tex.unlock();
            }
        }
    }

    private static int find1(int x, int[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] > x || x >= array[i + 1]) continue;
            return i;
        }
        return -1;
    }

    private static int find2(int x, int[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= x || x > array[i + 1]) continue;
            return i;
        }
        return -1;
    }

    private static int fastFloor(float x) {
        int ix = (int)x;
        return (float)ix <= x ? ix : ix - 1;
    }

    private static int fastCeil(float x) {
        int ix = (int)x;
        return (float)ix >= x ? ix : ix + 1;
    }
}

