/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.TextDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.MappedPropertyRule;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.betwixt.expression.MethodExpression;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextRule
extends MappedPropertyRule {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$betwixt$digester$TextRule == null ? (class$org$apache$commons$betwixt$digester$TextRule = TextRule.class$("org.apache.commons.betwixt.digester.TextRule")) : class$org$apache$commons$betwixt$digester$TextRule);
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$TextRule;

    public void begin(String name, String namespace, Attributes attributes) throws SAXException {
        TextDescriptor descriptor = new TextDescriptor();
        String value = attributes.getValue("value");
        String propertyName = attributes.getValue("property");
        String propertyType = attributes.getValue("type");
        if (value != null) {
            if (propertyName != null || propertyType != null) {
                throw new SAXException("You cannot specify attribute 'value' together with either  the 'property' or 'type' attributes");
            }
            descriptor.setTextExpression(new ConstantExpression(value));
        } else {
            String descriptorPropertyName;
            PropertyDescriptor propertyDescriptor;
            descriptor.setPropertyName(propertyName);
            Class beanClass = this.getBeanClass();
            descriptor.setPropertyType(this.getPropertyType(propertyType, beanClass, propertyName));
            if (beanClass != null && (propertyDescriptor = this.getPropertyDescriptor(beanClass, descriptorPropertyName = descriptor.getPropertyName())) != null) {
                Method readMethod = propertyDescriptor.getReadMethod();
                descriptor.setTextExpression(new MethodExpression(readMethod));
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod != null) {
                    descriptor.setUpdater(new MethodUpdater(writeMethod));
                }
                this.getProcessedPropertyNameSet().add(descriptorPropertyName);
            }
        }
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            ElementDescriptor elementDescriptor = beanInfo.getElementDescriptor();
            if (elementDescriptor != null) {
                elementDescriptor.addContentDescriptor(descriptor);
            }
        } else if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            parent.addContentDescriptor(descriptor);
        } else {
            throw new SAXException("Invalid use of <text>. It should be nested <text> nodes");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

