/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.thread;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.glsof.common.main.AbstractSearchBar;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class QueryThread
implements Runnable {
    private Map<String, Table> _tables = new LinkedHashMap<String, Table>();
    private TreeItem _queryTreeItem;
    private Composite _tablesContainer;
    private String[] _parsedOutput;
    private List<Boolean> _columnsViews;

    public QueryThread(TreeItem queryTreeItem, Composite tablesContainer, List<Boolean> columnsViews) {
        this._queryTreeItem = queryTreeItem;
        this._tablesContainer = tablesContainer;
        this._columnsViews = columnsViews;
    }

    @Override
    public void run() {
        boolean newItem = this._tables.get(this._parsedOutput[0]) == null;
        Table table = this.getTableForProcess(this._parsedOutput[0]);
        if (!table.isDisposed()) {
            this.fillTableRow(new TableItem(table, 0), this._parsedOutput);
        }
        if (newItem) {
            new TreeItem(this._queryTreeItem, 0).setText(this._parsedOutput[0]);
        }
    }

    void disposeAll() {
        for (Table table : this._tables.values()) {
            table.dispose();
        }
    }

    public Table getTableForProcess(String name) {
        Table table = this._tables.get(name);
        return table != null ? table : this.createNewTable(name);
    }

    private Table createNewTable(String name) {
        Table table = this.createTable();
        this._tables.put(name, table);
        return table;
    }

    private Table createTable() {
        Table table = new Table(this._tablesContainer, 0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        for (int i = 2; i < AbstractSearchBar.COLUMN_TITLE_TEXT.length; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(AbstractSearchBar.COLUMN_TITLE_TEXT[i]);
            if (!this._columnsViews.get(i - 2).booleanValue()) {
                column.setWidth(0);
                column.setResizable(false);
                continue;
            }
            column.pack();
        }
        return table;
    }

    private void fillTableRow(TableItem item, String[] parsedOutput) {
        for (int i = 1; i < parsedOutput.length; ++i) {
            item.setText(i - 1, parsedOutput[i]);
        }
    }

    public void setParsedOutput(String[] parsedOutput) {
        this._parsedOutput = parsedOutput;
    }

    public Map<String, Table> getTables() {
        return this._tables;
    }
}

