/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import java.util.LinkedList;
import java.util.List;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.model.FileDescriptorPreferences;
import net.sourceforge.glsof.queries.model.IDPreferences;
import net.sourceforge.glsof.queries.model.OtherPreferences;
import net.sourceforge.glsof.queries.model.Preferences;
import net.sourceforge.glsof.queries.model.Row;

public class QueriesLsofParametersMaker {
    private static final String COMMAND = "lsof -F +c0";

    public String getLsofParameters(List<Preferences> preferences, OtherPreferences otherPreferences) {
        StringBuffer sb = new StringBuffer();
        sb.append(COMMAND);
        for (Preferences page : preferences) {
            if (!page.isEnabled()) continue;
            String id = page.getId();
            if (id.equals(IDPreferences.DIRECTORY_ID)) {
                this.createDirectoryParameters(sb, page);
                continue;
            }
            if (id.equals(IDPreferences.FILE_DESCRIPTOR_ID)) {
                this.createFDParameters(sb, page);
                continue;
            }
            if (id.equals(IDPreferences.GENERIC_ID)) {
                this.createGenericParameters(sb, page);
                continue;
            }
            if (id.equals(IDPreferences.LOGIN_ID)) {
                this.createLoginParameters(sb, page);
                continue;
            }
            if (id.equals(IDPreferences.NETWORK_ID)) {
                this.createNetworkParameters(sb, page);
                continue;
            }
            if (id.equals("PGID")) {
                this.createPGIDParameters(sb, page);
                continue;
            }
            if (id.equals("PID")) {
                this.createPIDParameters(sb, page);
                continue;
            }
            if (!id.equals(IDPreferences.PROCESS_ID)) continue;
            this.createProcessParameters(sb, page);
        }
        this.createOtherParameters(sb, otherPreferences);
        return sb.toString();
    }

    private void createDirectoryParameters(StringBuffer sb, Preferences page) {
        for (List<String> row : this.extractTableRowsValues(page)) {
            sb.append(row.get(1).equals(Messages.YES) ? " +D " : " +d ");
            sb.append(row.get(0));
        }
    }

    private void createFDParameters(StringBuffer sb, Preferences page) {
        List<List<String>> tableRows = this.extractTableRowsValues(page);
        sb.append(" -d ");
        if (((FileDescriptorPreferences)page).isExcluded()) {
            this.appendFDs(tableRows, sb, "^", ",^");
        } else {
            this.appendFDs(tableRows, sb, "", ",");
        }
    }

    private void appendFDs(List<List<String>> tableRows, StringBuffer sb, String s, String sc) {
        sb.append(s).append(tableRows.get(0).get(0));
        for (int i = 1; i < tableRows.size(); ++i) {
            sb.append(sc).append(tableRows.get(i).get(0));
        }
    }

    private void createGenericParameters(StringBuffer sb, Preferences page) {
        List<List<String>> tableRows = this.extractTableRowsValues(page);
        sb.append(tableRows.get(0).get(0));
        for (int i = 1; i < tableRows.size(); ++i) {
            sb.append(" ").append(tableRows.get(i).get(0));
        }
    }

    private void createLoginParameters(StringBuffer sb, Preferences page) {
        this.createParametersWithExclusions(sb, page, " -u ");
    }

    private void createNetworkParameters(StringBuffer sb, Preferences page) {
        List<List<String>> tableRows = this.extractTableRowsValues(page);
        if (tableRows.size() > 0) {
            for (List<String> row : tableRows) {
                sb.append(" -i ");
                this.addOption(sb, "", row.get(3));
                this.addOption(sb, "", row.get(2));
                this.addOption(sb, "@", row.get(0));
                this.addOption(sb, ":", row.get(1));
            }
        } else {
            sb.append(" -i");
        }
    }

    private void addOption(StringBuffer sb, String opt, String value) {
        if (this.isNotEmpty(value)) {
            sb.append(opt).append(value);
        }
    }

    private boolean isNotEmpty(String value) {
        return value == null ? false : !value.equals("");
    }

    private void createOtherParameters(StringBuffer sb, OtherPreferences o) {
        if (o.isIdNumber()) {
            sb.append(" -l");
        }
        sb.append(o.isSize() ? " -s" : " -o");
        if (o.isAnd()) {
            sb.append(" -a");
        }
        if (o.isLinksFile()) {
            sb.append(" +L ").append(o.getLinksFileValue());
        }
        if (o.isIpFormat()) {
            sb.append(" -n");
        }
        if (o.isNfs()) {
            sb.append(" -N");
        }
        if (o.isPortNumbers()) {
            sb.append(" -P");
        }
        if (o.isDomainSocket()) {
            sb.append(" -U");
        }
        if (o.isTimeout()) {
            sb.append(" -S ").append(o.getTimeoutValue());
        }
        if (o.isAvoid()) {
            sb.append(" -b");
        }
    }

    private void createPGIDParameters(StringBuffer sb, Preferences page) {
        if (this.extractTableRowsValues(page).size() == 0) {
            sb.append(" -g ");
        } else {
            this.createParametersWithExclusions(sb, page, " -g ");
        }
    }

    private void createPIDParameters(StringBuffer sb, Preferences page) {
        this.createParametersWithExclusions(sb, page, " -p ");
    }

    private void createParametersWithExclusions(StringBuffer sb, Preferences page, String opt) {
        List<List<String>> tableRows = this.extractTableRowsValues(page);
        this.appendParametersWithExclusions(sb, tableRows, opt, 0);
        for (int i = 1; i < tableRows.size(); ++i) {
            this.appendParametersWithExclusions(sb, tableRows, ",", i);
        }
    }

    private void appendParametersWithExclusions(StringBuffer sb, List<List<String>> tableRows, String param, int i) {
        sb.append(param);
        if (tableRows.get(i).get(1).equals(Messages.YES)) {
            sb.append("^");
        }
        sb.append(tableRows.get(i).get(0));
    }

    private void createProcessParameters(StringBuffer sb, Preferences page) {
        List<List<String>> tableRows = this.extractTableRowsValues(page);
        for (List<String> row : tableRows) {
            sb.append(" -c ");
            if (row.get(1).equals(Messages.YES)) {
                sb.append("^");
            }
            sb.append(row.get(0));
        }
    }

    private List<List<String>> extractTableRowsValues(Preferences page) {
        List<Row> rows = page.getTableRows();
        LinkedList<List<String>> values = new LinkedList<List<String>>();
        for (Row row : rows) {
            values.add(row.getValues());
        }
        return values;
    }
}

