/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.dialogs.TextInputDialog;
import net.sourceforge.glsof.queries.editor.AbstractPreferencesUIPage;
import net.sourceforge.glsof.queries.model.FileDescriptorPreferences;
import net.sourceforge.glsof.queries.model.Preferences;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class FileDescriptorPreferencesUIPage
extends AbstractPreferencesUIPage {
    private Button _excludeButton;

    public FileDescriptorPreferencesUIPage(Preferences page, TextInputDialog dialog) {
        super(page, dialog);
    }

    @Override
    public Control createContents(Composite parent) {
        Composite mainContainer = this.buildPreferencePage(parent);
        this.createCheckButton(mainContainer);
        this.initPage();
        this.setEnabledWidgetsByActiveControl();
        return mainContainer;
    }

    private void createCheckButton(Composite mainContainer) {
        this.setExcludeButton(this.getCheckButtonFillHorizontalWithText(mainContainer, Messages.NLS("Exclude_all_FDs_above")));
        this.getExcludeButton().setSelection(((FileDescriptorPreferences)this.getPage()).isExcluded());
    }

    @Override
    protected void setEnabledWidgetsByActiveControl() {
        this.enabledWidgets();
        this.enableFileDescriptor();
    }

    @Override
    public void performOk() {
        ((FileDescriptorPreferences)this.getPage()).setExcluded(this.getExcludeButton().getSelection());
        this.saveBeforeToClose();
    }

    private void enableFileDescriptor() {
        this._excludeButton.setEnabled(this._activeButton.getSelection());
    }

    private Button getExcludeButton() {
        return this._excludeButton;
    }

    private void setExcludeButton(Button excludeButton) {
        this._excludeButton = excludeButton;
    }
}

