/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.dialogs;

import net.sourceforge.glsof.queries.dialogs.TextInputDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextsCombosInputDialog
extends TextInputDialog {
    private Text _address;
    private Text _port;
    private Combo _protocol;
    private Combo _version;

    public TextsCombosInputDialog(String dialogTitle, String[] columnsNames) {
        super(dialogTitle, new Point(450, 225), columnsNames);
    }

    @Override
    protected Composite createDialogControls(Composite composite) {
        this._address = this.createTextEntry(composite, this.getColumnsNames()[0]);
        this._port = this.createTextEntry(composite, this.getColumnsNames()[1]);
        this._protocol = this.createComboEntry(composite, this.getColumnsNames()[2], "", "TCP", "UDP");
        this._version = this.createComboEntry(composite, this.getColumnsNames()[3], "", "4", "6");
        return composite;
    }

    private Combo createComboEntry(Composite composite, String label, String ... items) {
        new Label(composite, 0).setText(label);
        Combo combo = new Combo(composite, 8);
        combo.setItems(items);
        combo.setLayoutData(new GridData(768));
        return combo;
    }

    @Override
    protected String[] getTableRowValues() {
        return new String[]{this._address.getText(), this._port.getText(), this._protocol.getText(), this._version.getText()};
    }

    @Override
    protected boolean areTableRowValuesFilled() {
        return !this.isStringEmpty(this._address.getText()) || !this.isStringEmpty(this._port.getText()) || !this.isStringEmpty(this._protocol.getText()) || !this.isStringEmpty(this._version.getText());
    }
}

