/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import net.sourceforge.glsof.queries.queries.Queries;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QueryTreeItemRenameListener
implements Listener {
    private final Queries _queries;

    public QueryTreeItemRenameListener(Queries queries) {
        this._queries = queries;
    }

    @Override
    public void handleEvent(Event event) {
        Tree tree = (Tree)event.widget;
        if (tree.getSelection().length == 0) {
            return;
        }
        final TreeItem item = tree.getSelection()[0];
        if (event.type == 8 && tree.getSelectionCount() == 1 && item.getParentItem() == null) {
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            final Text text = new Text(tree, 0);
            text.setText(item.getText());
            text.selectAll();
            text.setFocus();
            text.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    QueryTreeItemRenameListener.this._queries.renameQueryIfPossible(item, text.getText());
                    text.dispose();
                }
            });
            text.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 13: {
                            QueryTreeItemRenameListener.this._queries.renameQueryIfPossible(item, text.getText());
                            text.dispose();
                            break;
                        }
                        case 27: {
                            text.dispose();
                            break;
                        }
                    }
                }
            });
            editor.setEditor(text, item);
        }
    }
}

