/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import java.util.List;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.AbstractPopUpMenu;
import net.sourceforge.glsof.common.main.AbstractSearchBar;
import net.sourceforge.glsof.queries.queries.Queries;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class QueryTreeItemPopUpMenu
extends AbstractPopUpMenu {
    private final Queries _queries;

    public QueryTreeItemPopUpMenu(Queries queries, int x, int y) {
        this._queries = queries;
        this.createItemsPopUpMenu();
        this.setLifeCyclePopupMenu(x, y);
    }

    private void createItemsPopUpMenu() {
        this.editQuery();
        this.removeQuery();
        this.runQuery();
        this.separator();
        this.columns();
        this.stats();
    }

    private void editQuery() {
        this.initMenuItem(Messages.NLS("Edit_query"), new Listener(){

            @Override
            public void handleEvent(Event e) {
                QueryTreeItemPopUpMenu.this._queries.edit();
            }
        });
    }

    private void removeQuery() {
        this.initMenuItem(Messages.NLS("Remove_query"), new Listener(){

            @Override
            public void handleEvent(Event e) {
                QueryTreeItemPopUpMenu.this._queries.remove();
            }
        });
    }

    private void runQuery() {
        if (this._queries.isSelectedQueryRunning()) {
            this.initMenuItem(Messages.NLS("Stop_query"), new Listener(){

                @Override
                public void handleEvent(Event e) {
                    QueryTreeItemPopUpMenu.this._queries.stop();
                }
            });
        } else {
            this.initMenuItem(Messages.NLS("Run_query"), new Listener(){

                @Override
                public void handleEvent(Event e) {
                    QueryTreeItemPopUpMenu.this._queries.run();
                }
            });
        }
    }

    private void separator() {
        new MenuItem(this, 2);
    }

    private void columns() {
        MenuItem columns = new MenuItem(this, 64);
        columns.setText(Messages.NLS("Columns"));
        Menu subMenu = new Menu(Display.getCurrent().getActiveShell(), 4);
        columns.setMenu(subMenu);
        if (this._queries.isSelectedQueryReady()) {
            final List<Boolean> views = this._queries.getColumnsViews();
            for (int i = 2; i < AbstractSearchBar.COLUMN_TITLE_TEXT.length; ++i) {
                final MenuItem item = new MenuItem(subMenu, 32);
                item.setText(AbstractSearchBar.COLUMN_TITLE_TEXT[i]);
                item.setSelection(views.get(i - 2));
                item.setData(i - 2);
                item.addListener(13, new Listener(){

                    @Override
                    public void handleEvent(Event event) {
                        Integer index = (Integer)item.getData();
                        views.set(index, item.getSelection());
                        QueryTreeItemPopUpMenu.this._queries.setColumnsViews(views, index);
                    }
                });
            }
        } else {
            columns.setEnabled(false);
        }
    }

    private void stats() {
        MenuItem item = this.initMenuItem(Messages.NLS("Statistics"), new Listener(){

            @Override
            public void handleEvent(Event e) {
                QueryTreeItemPopUpMenu.this._queries.createStatistics();
            }
        });
        item.setEnabled(this._queries.isSelectedQueryReady());
    }

    private MenuItem initMenuItem(String itemName, Listener listener) {
        MenuItem item = new MenuItem(this, 8);
        item.setText(itemName);
        item.addListener(13, listener);
        return item;
    }
}

