/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.QueryTreeItemNewListener;
import net.sourceforge.glsof.queries.QueryTreeItemPopUpMenu;
import net.sourceforge.glsof.queries.QueryTreeItemRenameListener;
import net.sourceforge.glsof.queries.queries.Queries;
import net.sourceforge.glsof.queries.queries.QueriesUIConf;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class QueriesBuilder {
    private SashForm _vForm;
    private SashForm _hForm;
    private ToolItem _addItem;
    private ToolItem _colItem;
    private ToolItem _expItem;
    private Composite _statusBarContainer;
    private Queries _queries;

    QueriesBuilder(File dir, Composite mainContainer, QueriesUIConf conf) {
        Composite searchBarContainer = this.createSearchBarContainer(mainContainer);
        this._vForm = this.createSashForm(mainContainer, 512);
        this._hForm = this.createSashForm(this._vForm, 256);
        this._statusBarContainer = this.createStatusBarContainer(mainContainer);
        this._queries = new Queries(dir, this.createTree(this._hForm), searchBarContainer, this.createTablesContainer(this._hForm), this.createStatusBar(this._statusBarContainer));
        this._queries.createLogger(this._vForm, new ArrayList[]{conf.getLogStartColor(), conf.getLogStopColor(), conf.getLogErrColor()});
        this._queries.loadAllQueries();
        this._queries.getQueryTree().addListener(35, new Listener(){

            @Override
            public void handleEvent(Event event) {
                Tree tree = (Tree)event.widget;
                if (tree.getSelectionCount() == 0) {
                    return;
                }
                if (tree.getSelection()[0].getParentItem() == null) {
                    new QueryTreeItemPopUpMenu(QueriesBuilder.this._queries, event.x, event.y);
                }
                tree.deselectAll();
            }
        });
        this._queries.getQueryTree().addListener(8, new QueryTreeItemRenameListener(this._queries));
        this._queries.selectQuery();
        this._addItem.addListener(13, new QueryTreeItemNewListener(this._queries));
        this._expItem.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                QueriesBuilder.this._queries.expandAllQueries(true);
            }
        });
        this._colItem.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                QueriesBuilder.this._queries.expandAllQueries(false);
            }
        });
        this._hForm.setWeights(new int[]{conf.getQueriesTreeWidth(), conf.getQueriesTablesWidth()});
        this._vForm.setWeights(new int[]{conf.getQueriesHeight(), 0});
    }

    private Composite createSearchBarContainer(Composite mainContainer) {
        Composite searchContainer = new Composite(mainContainer, 0);
        searchContainer.setLayout(this.createGridLayoutWithoutMargins(6));
        searchContainer.setLayoutData(new GridData(768));
        return searchContainer;
    }

    private SashForm createSashForm(Composite parent, int type) {
        SashForm sashForm = new SashForm(parent, type);
        sashForm.setLayoutData(new GridData(1808));
        return sashForm;
    }

    private Composite createStatusBarContainer(Composite mainContainer) {
        Composite barContainer = new Composite(mainContainer, 0);
        barContainer.setLayout(this.createGridLayoutWithoutMargins(1));
        barContainer.setLayoutData(new GridData(768));
        return barContainer;
    }

    private Tree createTree(SashForm hForm) {
        Tree queryTree = new Tree(this.createTreeContainer(hForm), 770);
        queryTree.setLayoutData(new GridData(1808));
        return queryTree;
    }

    private Composite createTreeContainer(SashForm hForm) {
        Composite queryTreeContainer = new Composite(hForm, 0);
        queryTreeContainer.setLayout(this.createGridLayoutWithoutMargins(1));
        Composite treeContainer = new Composite(queryTreeContainer, 2048);
        GridLayout layout = this.createGridLayoutWithoutMargins(1);
        layout.verticalSpacing = 0;
        treeContainer.setLayout(layout);
        treeContainer.setLayoutData(new GridData(1808));
        this.createToolBar(treeContainer);
        return treeContainer;
    }

    private void createToolBar(Composite composite) {
        ToolBar toolBar = new ToolBar(composite, 0);
        toolBar.setLayoutData(new GridData(800));
        this._addItem = new ToolItem(toolBar, 8);
        this.createMenuItem(this._addItem, Messages.NLS("Add_query"), "/icons/gtk-new.png");
        this._expItem = new ToolItem(toolBar, 8);
        this.createMenuItem(this._expItem, Messages.NLS("Expand_all_the_queries"), "/icons/exp-all.png");
        this._colItem = new ToolItem(toolBar, 8);
        this.createMenuItem(this._colItem, Messages.NLS("Collapse_all_the_queries"), "/icons/col-all.png");
    }

    private void createMenuItem(ToolItem item, String toolTip, String path) {
        item.setToolTipText(toolTip);
        Image image = new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream(path));
        item.setImage(image);
        image.dispose();
    }

    private Composite createTablesContainer(SashForm hForm) {
        Composite queryTablesContainer = new Composite(hForm, 2048);
        queryTablesContainer.setLayout(new StackLayout());
        return queryTablesContainer;
    }

    private Label createStatusBar(Composite barContainer) {
        Label statusBar = new Label(barContainer, 2048);
        statusBar.setLayoutData(new GridData(800));
        return statusBar;
    }

    private GridLayout createGridLayoutWithoutMargins(int numColumns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public SashForm getVForm() {
        return this._vForm;
    }

    public SashForm getHForm() {
        return this._hForm;
    }

    public Queries getQueries() {
        return this._queries;
    }

    public Composite getStatusBarContainer() {
        return this._statusBarContainer;
    }
}

