/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.lsof;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;

public class LsofOutputParser
extends Observable {
    private static final String[] IDENTIFIERS_LIST = new String[]{"c", "p", "g", "R", "uL", "fal", "t", "dD", "os", "k", "iP", "Sn"};
    private String[] _buffer;
    private String _tmpFD;
    private boolean _parsedFD;
    private boolean _running;

    public LsofOutputParser(Observer observer) {
        this.addObserver(observer);
    }

    public void parse(BufferedReader bufferedReader) {
        this._buffer = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        this._parsedFD = false;
        try {
            String line;
            while (this._running && (line = bufferedReader.readLine()) != null) {
                char id = line.charAt(0);
                if (id == 'p') {
                    this.parseProcess(line);
                    continue;
                }
                if (id == 'f') {
                    this.parseFileDescriptor(line);
                    continue;
                }
                if (id == 'T') {
                    this.parseState(line);
                    continue;
                }
                this.parseExtraData(id, line);
            }
            this.endParsing();
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseProcess(String line) {
        if (this._parsedFD) {
            this._buffer[5] = this._tmpFD;
            this.notify(this._buffer);
        }
        this._buffer = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        this._buffer[1] = line.substring(1);
        this._parsedFD = false;
    }

    public void parseFileDescriptor(String line) {
        if (this._parsedFD) {
            this._buffer[5] = this._tmpFD;
            this.notify(this._buffer);
            String[] tmpBuffer = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
            System.arraycopy(this._buffer, 0, tmpBuffer, 0, 5);
            this._buffer = tmpBuffer;
        }
        this._tmpFD = line.substring(1);
        this._parsedFD = true;
    }

    private void endParsing() {
        this._buffer[5] = this._tmpFD;
        if (this._parsedFD) {
            this.notify(this._buffer);
        }
        this.notify(null);
    }

    private void notify(String[] buffer) {
        this.setChanged();
        this.notifyObservers(buffer);
    }

    public void parseExtraData(char id, String line) {
        int index = this.columnIdentifier(id);
        if (index != -1) {
            if (index == 5) {
                this._tmpFD = this._tmpFD + line.substring(1);
            } else {
                this._buffer[index] = line.substring(1);
            }
        }
    }

    public int columnIdentifier(char id) {
        for (int i = 0; i < IDENTIFIERS_LIST.length; ++i) {
            if (IDENTIFIERS_LIST[i].indexOf(id) == -1) continue;
            return i;
        }
        return -1;
    }

    public void parseState(String line) {
        this._buffer[11] = this._buffer[11] + " (" + line.substring(1) + ")";
    }

    public boolean isRunning() {
        return this._running;
    }

    public void setRunning(boolean running) {
        this._running = running;
    }
}

