/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.about;

import net.sourceforge.glsof.common.i18n.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractButtonsDialog {
    protected static final int CLOSE_ID = 0;
    public static final int OK_ID = 1;
    public static final int CANCEL_ID = 2;
    static final int CLIENT_ID = 1024;
    private final Shell _currentShell;
    private final Point _size;
    private final String _caption;
    private Shell _shell = null;
    private int _clicked_id;

    protected abstract Control createDialogArea(Composite var1);

    protected void buttonPressed(int buttonId) {
    }

    protected AbstractButtonsDialog(Shell shell, String caption) {
        this(shell, null, caption);
    }

    protected AbstractButtonsDialog(Shell shell, Point size, String caption) {
        this._currentShell = shell;
        this._size = size;
        this._caption = caption;
    }

    public int open() {
        if (this._shell == null || this._shell.isDisposed()) {
            this._shell = new Shell(this._currentShell, 67680);
            this._shell.setText(this._caption);
        }
        this.createContents();
        this._shell.pack();
        this.dialogCentre();
        if (this._size != null) {
            this._shell.setSize(this._size);
        }
        this._shell.open();
        Display display = this._shell.getDisplay();
        while (!this._shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this._clicked_id;
    }

    private void dialogCentre() {
        Rectangle shellBounds = this._currentShell.getBounds();
        Point dialogSize = this._size == null ? this._shell.getSize() : this._size;
        this._shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
    }

    private void createContents() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.numColumns = 1;
        this._shell.setLayout(gridLayout);
        Control control = this.createDialogArea(this._shell);
        Composite buttonBar = new Composite(this._shell, 0);
        GridLayout buttonBarLayout = new GridLayout(0, true);
        buttonBar.setLayout(buttonBarLayout);
        buttonBar.setLayoutData(new GridData(132));
        this.createButtonsForButtonBar(buttonBar);
        this._shell.setSize(control.getSize());
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 2, Messages.NLS("Cancel"));
        this.createButton(composite, 1, Messages.NLS("Ok"));
    }

    protected void createButton(Composite composite, final int id, String label) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        Button button = new Button(composite, 8);
        button.setText(label);
        button.setLayoutData(new GridData(4, 4, true, true));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AbstractButtonsDialog.this._clicked_id = id;
                AbstractButtonsDialog.this.buttonPressed(id);
            }
        });
    }

    protected void close() {
        this._shell.close();
    }

    protected Shell getShell() {
        return this._shell;
    }
}

