"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("@wireapp/commons");
var electron_1 = require("electron");
var fs = require("fs-extra");
var path = require("path");
var USER_DATA_DIR = electron_1.app.getPath('userData');
var LOG_DIR = path.join(USER_DATA_DIR, 'logs');
var logger = commons_1.LogFactory.getLogger(__filename, { logFilePath: path.join(LOG_DIR, 'electron.log') });
var clearStorage = function (session) {
    return new Promise(function (resolve) {
        return session.clearStorageData({}, function () {
            return session.clearCache(function () {
                session.flushStorageData();
                resolve();
            });
        });
    });
};
function deleteAccount(id, accountId, partitionId) {
    return __awaiter(this, void 0, void 0, function () {
        var webviewWebcontent, error_1, partitionDir, error_2, sessionFolder, error_3;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    webviewWebcontent = electron_1.webContents.fromId(id);
                    if (!webviewWebcontent) {
                        throw new Error("Unable to find webview content id \"" + id + "\"");
                    }
                    if (!webviewWebcontent.hostWebContents) {
                        throw new Error('Only a webview can have its storage wiped');
                    }
                    logger.log("Deleting session data for account \"" + accountId + "\"...");
                    return [4, clearStorage(webviewWebcontent.session)];
                case 1:
                    _a.sent();
                    logger.log("Deleted session data for account \"" + accountId + "\".");
                    return [3, 3];
                case 2:
                    error_1 = _a.sent();
                    logger.error("Failed to delete session data for account \"" + accountId + "\", reason: \"" + error_1.message + "\".");
                    return [3, 3];
                case 3:
                    if (!partitionId) return [3, 7];
                    _a.label = 4;
                case 4:
                    _a.trys.push([4, 6, , 7]);
                    if (!commons_1.ValidationUtil.isUUIDv4(partitionId)) {
                        throw new Error('Partition is not an UUID');
                    }
                    partitionDir = path.join(USER_DATA_DIR, 'Partitions', partitionId);
                    return [4, fs.remove(partitionDir)];
                case 5:
                    _a.sent();
                    logger.log("Deleted partition \"" + partitionId + "\" for account \"" + accountId + "\".");
                    return [3, 7];
                case 6:
                    error_2 = _a.sent();
                    logger.log("Unable to delete partition \"" + partitionId + "\" for account \"" + accountId + "\", reason: \"" + error_2.message + "\".");
                    return [3, 7];
                case 7:
                    _a.trys.push([7, 9, , 10]);
                    if (!commons_1.ValidationUtil.isUUIDv4(accountId)) {
                        throw new Error('Account is not an UUID');
                    }
                    sessionFolder = path.join(LOG_DIR, accountId);
                    return [4, fs.remove(sessionFolder)];
                case 8:
                    _a.sent();
                    logger.log("Deleted logs folder for account \"" + accountId + "\".");
                    return [3, 10];
                case 9:
                    error_3 = _a.sent();
                    logger.error("Failed to delete logs folder for account \"" + accountId + "\", reason: \"" + error_3.message + "\".");
                    return [3, 10];
                case 10: return [2];
            }
        });
    });
}
exports.deleteAccount = deleteAccount;
//# sourceMappingURL=LocalAccountDeletion.js.map