"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var minimist = require("minimist");
var path = require("path");
var environment = require("./environment");
var argv = minimist(process.argv.slice(1));
var addLinuxWorkarounds = function () {
    if (environment.platform.IS_LINUX) {
        if (environment.linuxDesktop.isUbuntuUnity ||
            environment.linuxDesktop.isPopOS ||
            environment.linuxDesktop.isGnome) {
            process.env.XDG_CURRENT_DESKTOP = 'Unity';
        }
        electron_1.app.disableHardwareAcceleration();
    }
};
exports.addLinuxWorkarounds = addLinuxWorkarounds;
var handlePortableFlags = function () {
    if (argv.portable || argv.user_data_dir) {
        var USER_PATH = argv.user_data_dir || path.join(process.env.APPIMAGE || process.execPath, '../Data');
        console.log("Saving user data to " + USER_PATH);
        electron_1.app.setPath('userData', USER_PATH);
    }
};
exports.handlePortableFlags = handlePortableFlags;
//# sourceMappingURL=appInit.js.map