"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const electron_1 = require("electron");
const electron_util_1 = require("electron-util");
let tray = null;
exports.default = {
    create: (win) => {
        if (electron_util_1.is.macos || tray) {
            return;
        }
        const iconPath = path.join(__dirname, '..', 'static', 'IconTray.png');
        const toggleWin = () => {
            if (win.isVisible()) {
                win.hide();
            }
            else {
                win.show();
            }
        };
        const contextMenu = electron_1.Menu.buildFromTemplate([
            {
                label: 'Toggle',
                click() {
                    toggleWin();
                }
            },
            {
                type: 'separator'
            },
            {
                role: 'quit'
            }
        ]);
        tray = new electron_1.Tray(iconPath);
        tray.setToolTip(`${electron_1.app.getName()}`);
        tray.setContextMenu(contextMenu);
        tray.on('click', toggleWin);
    },
    setBadge: (shouldDisplayUnread) => {
        if (electron_util_1.is.macos || !tray) {
            return;
        }
        const icon = shouldDisplayUnread ? 'IconTrayUnread.png' : 'IconTray.png';
        const iconPath = path.join(__dirname, '..', 'static', icon);
        tray.setImage(iconPath);
    }
};
//# sourceMappingURL=tray.js.map