/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */

'use strict';

var _require = require('./RelayStoreUtils'),
    ROOT_ID = _require.ROOT_ID,
    ROOT_TYPE = _require.ROOT_TYPE;

function normalizeRelayPayload(selector, payload, errors) {
  var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : { handleStrippedNulls: false };

  var source = new (require('./RelayInMemoryRecordSource'))();
  source.set(ROOT_ID, require('./RelayModernRecord').create(ROOT_ID, ROOT_TYPE));

  var _RelayResponseNormali = require('./RelayResponseNormalizer').normalize(source, selector, payload, options),
      fieldPayloads = _RelayResponseNormali.fieldPayloads,
      deferrableSelections = _RelayResponseNormali.deferrableSelections;

  return {
    errors: errors,
    fieldPayloads: fieldPayloads,
    deferrableSelections: deferrableSelections,
    source: source
  };
}

module.exports = normalizeRelayPayload;