(function() {
  var ButtonListTemplate, ButtonTemplate, DOMPurify, FatalMetaNotificationTemplate, MetaNotificationTemplate, NotificationElement, NotificationIssue, NotificationTemplate, TemplateHelper, UserUtilities, addSplitLinesToContainer, createDOMPurify, fs, marked, path, shell;

  createDOMPurify = require('dompurify');

  fs = require('fs-plus');

  path = require('path');

  marked = require('marked');

  shell = require('electron').shell;

  NotificationIssue = require('./notification-issue');

  TemplateHelper = require('./template-helper');

  UserUtilities = require('./user-utilities');

  DOMPurify = null;

  NotificationTemplate = "<div class=\"content\">\n  <div class=\"message item\"></div>\n  <div class=\"detail item\">\n    <div class=\"detail-content\"></div>\n    <a href=\"#\" class=\"stack-toggle\"></a>\n    <div class=\"stack-container\"></div>\n  </div>\n  <div class=\"meta item\"></div>\n</div>\n<div class=\"close icon icon-x\"></div>\n<div class=\"close-all btn btn-error\">Close All</div>";

  FatalMetaNotificationTemplate = "<div class=\"description fatal-notification\"></div>\n<div class=\"btn-toolbar\">\n  <a href=\"#\" class=\"btn-issue btn btn-error\"></a>\n  <a href=\"#\" class=\"btn-copy-report icon icon-clippy\" title=\"Copy error report to clipboard\"></a>\n</div>";

  MetaNotificationTemplate = "<div class=\"description\"></div>";

  ButtonListTemplate = "<div class=\"btn-toolbar\"></div>";

  ButtonTemplate = "<a href=\"#\" class=\"btn\"></a>";

  module.exports = NotificationElement = (function() {
    NotificationElement.prototype.animationDuration = 360;

    NotificationElement.prototype.visibilityDuration = 5000;

    NotificationElement.prototype.autohideTimeout = null;

    function NotificationElement(model, visibilityDuration) {
      this.model = model;
      this.visibilityDuration = visibilityDuration;
      this.fatalTemplate = TemplateHelper.create(FatalMetaNotificationTemplate);
      this.metaTemplate = TemplateHelper.create(MetaNotificationTemplate);
      this.buttonListTemplate = TemplateHelper.create(ButtonListTemplate);
      this.buttonTemplate = TemplateHelper.create(ButtonTemplate);
      this.element = document.createElement('atom-notification');
      if (this.model.getType() === 'fatal') {
        this.issue = new NotificationIssue(this.model);
      }
      this.renderPromise = this.render()["catch"](function(e) {
        console.error(e.message);
        return console.error(e.stack);
      });
      this.model.onDidDismiss((function(_this) {
        return function() {
          return _this.removeNotification();
        };
      })(this));
      if (!this.model.isDismissable()) {
        this.autohide();
        this.element.addEventListener('click', this.makeDismissable.bind(this), {
          once: true
        });
      }
      this.element.issue = this.issue;
      this.element.getRenderPromise = this.getRenderPromise.bind(this);
    }

    NotificationElement.prototype.getModel = function() {
      return this.model;
    };

    NotificationElement.prototype.getRenderPromise = function() {
      return this.renderPromise;
    };

    NotificationElement.prototype.render = function() {
      var buttonClass, closeAllButton, closeButton, description, detail, metaContainer, metaContent, notificationContainer, options, stack, stackContainer, stackToggle, toolbar;
      this.element.classList.add("" + (this.model.getType()));
      this.element.classList.add("icon", "icon-" + (this.model.getIcon()), "native-key-bindings");
      if (detail = this.model.getDetail()) {
        this.element.classList.add('has-detail');
      }
      if (this.model.isDismissable()) {
        this.element.classList.add('has-close');
      }
      if (this.model.getOptions().stack != null) {
        this.element.classList.add('has-stack');
      }
      this.element.setAttribute('tabindex', '-1');
      this.element.innerHTML = NotificationTemplate;
      options = this.model.getOptions();
      notificationContainer = this.element.querySelector('.message');
      if (DOMPurify === null) {
        DOMPurify = createDOMPurify();
      }
      notificationContainer.innerHTML = DOMPurify.sanitize(marked(this.model.getMessage()));
      if (detail = this.model.getDetail()) {
        addSplitLinesToContainer(this.element.querySelector('.detail-content'), detail);
        if (stack = options.stack) {
          stackToggle = this.element.querySelector('.stack-toggle');
          stackContainer = this.element.querySelector('.stack-container');
          addSplitLinesToContainer(stackContainer, stack);
          stackToggle.addEventListener('click', (function(_this) {
            return function(e) {
              return _this.handleStackTraceToggleClick(e, stackContainer);
            };
          })(this));
          this.handleStackTraceToggleClick({
            currentTarget: stackToggle
          }, stackContainer);
        }
      }
      if (metaContent = options.description) {
        this.element.classList.add('has-description');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.metaTemplate));
        description = this.element.querySelector('.description');
        description.innerHTML = marked(metaContent);
      }
      if (options.buttons && options.buttons.length > 0) {
        this.element.classList.add('has-buttons');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.buttonListTemplate));
        toolbar = this.element.querySelector('.btn-toolbar');
        buttonClass = this.model.getType();
        if (buttonClass === 'fatal') {
          buttonClass = 'error';
        }
        buttonClass = "btn-" + buttonClass;
        options.buttons.forEach((function(_this) {
          return function(button) {
            var buttonEl;
            toolbar.appendChild(TemplateHelper.render(_this.buttonTemplate));
            buttonEl = toolbar.childNodes[toolbar.childNodes.length - 1];
            buttonEl.textContent = button.text;
            buttonEl.classList.add(buttonClass);
            if (button.className != null) {
              buttonEl.classList.add.apply(buttonEl.classList, button.className.split(' '));
            }
            if (button.onDidClick != null) {
              return buttonEl.addEventListener('click', function(e) {
                return button.onDidClick.call(_this, e);
              });
            }
          };
        })(this));
      }
      closeButton = this.element.querySelector('.close');
      closeButton.addEventListener('click', (function(_this) {
        return function() {
          return _this.handleRemoveNotificationClick();
        };
      })(this));
      closeAllButton = this.element.querySelector('.close-all');
      closeAllButton.classList.add(this.getButtonClass());
      closeAllButton.addEventListener('click', (function(_this) {
        return function() {
          return _this.handleRemoveAllNotificationsClick();
        };
      })(this));
      if (this.model.getType() === 'fatal') {
        return this.renderFatalError();
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.renderFatalError = function() {
      var copyReportButton, fatalContainer, fatalNotification, issueButton, packageName, promises, repoUrl;
      repoUrl = this.issue.getRepoUrl();
      packageName = this.issue.getPackageName();
      fatalContainer = this.element.querySelector('.meta');
      fatalContainer.appendChild(TemplateHelper.render(this.fatalTemplate));
      fatalNotification = this.element.querySelector('.fatal-notification');
      issueButton = fatalContainer.querySelector('.btn-issue');
      copyReportButton = fatalContainer.querySelector('.btn-copy-report');
      atom.tooltips.add(copyReportButton, {
        title: copyReportButton.getAttribute('title')
      });
      copyReportButton.addEventListener('click', (function(_this) {
        return function(e) {
          e.preventDefault();
          return _this.issue.getIssueBody().then(function(issueBody) {
            return atom.clipboard.write(issueBody);
          });
        };
      })(this));
      if ((packageName != null) && (repoUrl != null)) {
        fatalNotification.innerHTML = "The error was thrown from the <a href=\"" + repoUrl + "\">" + packageName + " package</a>. ";
      } else if (packageName != null) {
        issueButton.remove();
        fatalNotification.textContent = "The error was thrown from the " + packageName + " package. ";
      } else {
        fatalNotification.textContent = "This is likely a bug in Atom. ";
      }
      if (issueButton.parentNode != null) {
        if ((packageName != null) && (repoUrl != null)) {
          issueButton.textContent = "Create issue on the " + packageName + " package";
        } else {
          issueButton.textContent = "Create issue on atom/atom";
        }
        promises = [];
        promises.push(this.issue.findSimilarIssues());
        promises.push(UserUtilities.checkAtomUpToDate());
        if (packageName != null) {
          promises.push(UserUtilities.checkPackageUpToDate(packageName));
        }
        return Promise.all(promises).then((function(_this) {
          return function(allData) {
            var atomCheck, issue, issues, packageCheck, packagePath, ref;
            issues = allData[0], atomCheck = allData[1], packageCheck = allData[2];
            if ((issues != null ? issues.open : void 0) || (issues != null ? issues.closed : void 0)) {
              issue = issues.open || issues.closed;
              issueButton.setAttribute('href', issue.html_url);
              issueButton.textContent = "View Issue";
              fatalNotification.innerHTML += " This issue has already been reported.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && !packageCheck.isCore) {
              issueButton.setAttribute('href', '#');
              issueButton.textContent = "Check for package updates";
              issueButton.addEventListener('click', function(e) {
                var command;
                e.preventDefault();
                command = 'settings-view:check-for-package-updates';
                return atom.commands.dispatch(atom.views.getView(atom.workspace), command);
              });
              fatalNotification.innerHTML += "<code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed;\n" + packageCheck.latestVersion + " latest.\nUpgrading to the latest version may fix this issue.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && packageCheck.isCore) {
              issueButton.remove();
              fatalNotification.innerHTML += "<br><br>\nLocally installed core Atom package <code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed locally;\n" + packageCheck.versionShippedWithAtom + " included with the version of Atom you're running.\nRemoving the locally installed version may fix this issue.";
              packagePath = (ref = atom.packages.getLoadedPackage(packageName)) != null ? ref.path : void 0;
              if (fs.isSymbolicLinkSync(packagePath)) {
                fatalNotification.innerHTML += "<br><br>\nUse: <code>apm unlink " + packagePath + "</code>";
              }
            } else if ((atomCheck != null) && !atomCheck.upToDate) {
              issueButton.remove();
              fatalNotification.innerHTML += "Atom is out of date: " + atomCheck.installedVersion + " installed;\n" + atomCheck.latestVersion + " latest.\nUpgrading to the <a href='https://github.com/atom/atom/releases/tag/v" + atomCheck.latestVersion + "'>latest version</a> may fix this issue.";
            } else {
              fatalNotification.innerHTML += " You can help by creating an issue. Please explain what actions triggered this error.";
              issueButton.addEventListener('click', function(e) {
                e.preventDefault();
                issueButton.classList.add('opening');
                return _this.issue.getIssueUrlForSystem().then(function(issueUrl) {
                  shell.openExternal(issueUrl);
                  return issueButton.classList.remove('opening');
                });
              });
            }
          };
        })(this));
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.makeDismissable = function() {
      if (!this.model.isDismissable()) {
        clearTimeout(this.autohideTimeout);
        this.model.options.dismissable = true;
        this.model.dismissed = false;
        return this.element.classList.add('has-close');
      }
    };

    NotificationElement.prototype.removeNotification = function() {
      if (!this.element.classList.contains('remove')) {
        this.element.classList.add('remove');
        return this.removeNotificationAfterTimeout();
      }
    };

    NotificationElement.prototype.handleRemoveNotificationClick = function() {
      this.removeNotification();
      return this.model.dismiss();
    };

    NotificationElement.prototype.handleRemoveAllNotificationsClick = function() {
      var i, len, notification, notifications;
      notifications = atom.notifications.getNotifications();
      for (i = 0, len = notifications.length; i < len; i++) {
        notification = notifications[i];
        atom.views.getView(notification).removeNotification();
        if (notification.isDismissable() && !notification.isDismissed()) {
          notification.dismiss();
        }
      }
    };

    NotificationElement.prototype.handleStackTraceToggleClick = function(e, container) {
      if (typeof e.preventDefault === "function") {
        e.preventDefault();
      }
      if (container.style.display === 'none') {
        e.currentTarget.innerHTML = '<span class="icon icon-dash"></span>Hide Stack Trace';
        return container.style.display = 'block';
      } else {
        e.currentTarget.innerHTML = '<span class="icon icon-plus"></span>Show Stack Trace';
        return container.style.display = 'none';
      }
    };

    NotificationElement.prototype.autohide = function() {
      return this.autohideTimeout = setTimeout((function(_this) {
        return function() {
          return _this.removeNotification();
        };
      })(this), this.visibilityDuration);
    };

    NotificationElement.prototype.removeNotificationAfterTimeout = function() {
      if (this.element === document.activeElement) {
        atom.workspace.getActivePane().activate();
      }
      return setTimeout((function(_this) {
        return function() {
          return _this.element.remove();
        };
      })(this), this.animationDuration);
    };

    NotificationElement.prototype.getButtonClass = function() {
      var type;
      type = "btn-" + (this.model.getType());
      if (type === 'btn-fatal') {
        return 'btn-error';
      } else {
        return type;
      }
    };

    return NotificationElement;

  })();

  addSplitLinesToContainer = function(container, content) {
    var div, i, len, line, ref;
    if (typeof content !== 'string') {
      content = content.toString();
    }
    ref = content.split('\n');
    for (i = 0, len = ref.length; i < len; i++) {
      line = ref[i];
      div = document.createElement('div');
      div.classList.add('line');
      div.textContent = line;
      container.appendChild(div);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
