'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();

    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions.default || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });
    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }
}

const OURS = exports.OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
const THEIRS = exports.THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
const BASE = exports.BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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