'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _reporterProxy = require('../reporter-proxy');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _keytarStrategy = require('../shared/keytar-strategy');

var _remoteController = require('../controllers/remote-controller');

var _remoteController2 = _interopRequireDefault(_remoteController);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _queryErrorView = require('../views/query-error-view');

var _queryErrorView2 = _interopRequireDefault(_queryErrorView);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class RemoteContainer extends _react2.default.Component {

  constructor(props) {
    super(props);

    (0, _helpers.autobind)(this, 'fetchToken', 'renderWithToken', 'renderWithResult', 'handleLogin', 'handleLogout');
  }

  fetchToken(loginModel) {
    return loginModel.getToken(this.props.endpoint.getLoginAccount());
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchToken },
      this.renderWithToken
    );
  }

  renderWithToken(token) {
    if (token === null) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (token === _keytarStrategy.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    if (token === _keytarStrategy.INSUFFICIENT) {
      return _react2.default.createElement(
        _githubLoginView2.default,
        { onLogin: this.handleLogin },
        _react2.default.createElement(
          'p',
          null,
          'Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one.'
        )
      );
    }

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.endpoint, token);
    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/remoteContainerQuery.graphql');

      if (node.hash && node.hash !== 'b83aa6c27c5d7e1c499badf2e6bfab6b') {
        console.error('The definition of \'remoteContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/remoteContainerQuery.graphql');
    });
    const variables = {
      owner: this.props.remote.getOwner(),
      name: this.props.remote.getRepo()
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: result => this.renderWithResult(result, token)
    });
  }

  renderWithResult({ error, props, retry }, token) {
    if (error) {
      return _react2.default.createElement(_queryErrorView2.default, {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    return _react2.default.createElement(_remoteController2.default, {
      endpoint: this.props.endpoint,
      token: token,

      repository: props.repository,

      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,

      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,

      onPushBranch: this.props.onPushBranch
    });
  }

  handleLogin(token) {
    (0, _reporterProxy.incrementCounter)('github-login');
    this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
  }

  handleLogout() {
    (0, _reporterProxy.incrementCounter)('github-logout');
    this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
  }
}
exports.default = RemoteContainer;
RemoteContainer.propTypes = {
  // Connection
  loginModel: _propTypes2.default.object.isRequired,
  endpoint: _propTypes3.EndpointPropType.isRequired,

  // Repository attributes
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  pushInProgress: _propTypes2.default.bool.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  workspace: _propTypes2.default.object.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,

  // Action methods
  onPushBranch: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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