'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

var _operationStateObserver = require('../models/operation-state-observer');

var _operationStateObserver2 = _interopRequireDefault(_operationStateObserver);

var _githubTabController = require('../controllers/github-tab-controller');

var _githubTabController2 = _interopRequireDefault(_githubTabController);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _remoteSet = require('../models/remote-set');

var _remoteSet2 = _interopRequireDefault(_remoteSet);

var _branchSet = require('../models/branch-set');

var _branchSet2 = _interopRequireDefault(_branchSet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitHubTabContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchRepositoryData', 'renderRepositoryData');

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.repository !== state.lastRepository) {
      return {
        lastRepository: props.repository,
        remoteOperationObserver: new _operationStateObserver2.default(props.repository, _operationStateObserver.PUSH, _operationStateObserver.PULL, _operationStateObserver.FETCH)
      };
    }

    return null;
  }

  fetchRepositoryData(repository) {
    return (0, _yubikiri2.default)({
      workingDirectory: repository.getWorkingDirectoryPath(),
      allRemotes: repository.getRemotes(),
      branches: repository.getBranches(),
      selectedRemoteName: repository.getConfig('atomGithub.currentRemote'),
      aheadCount: async query => {
        const branches = await query.branches;
        const currentBranch = branches.getHeadBranch();
        return repository.getAheadCount(currentBranch.getName());
      },
      pushInProgress: repository.getOperationStates().isPushInProgress()
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.repository, fetchData: this.fetchRepositoryData },
      this.renderRepositoryData
    );
  }

  renderRepositoryData(data) {
    if (!data || this.props.repository.isLoading()) {
      return _react2.default.createElement(_githubTabController2.default, _extends({}, this.props, {
        remoteOperationObserver: this.state.remoteOperationObserver,

        workingDirectory: '',
        allRemotes: new _remoteSet2.default(),
        branches: new _branchSet2.default(),
        aheadCount: 0,
        pushInProgress: false,
        isLoading: true
      }));
    }

    if (!this.props.repository.isPresent()) {
      // TODO include a better message here.
      return null;
    }

    return _react2.default.createElement(_githubTabController2.default, _extends({}, data, this.props, {
      remoteOperationObserver: this.state.remoteOperationObserver,
      isLoading: false
    }));
  }
}
exports.default = GitHubTabContainer;
GitHubTabContainer.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes3.RefHolderPropType.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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