'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _issueishListController = require('../controllers/issueish-list-controller');

var _issueishListController2 = _interopRequireDefault(_issueishListController);

var _createPullRequestTile = require('../views/create-pull-request-tile');

var _createPullRequestTile2 = _interopRequireDefault(_createPullRequestTile);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CurrentPullRequestContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');

    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();
    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }
    const push = head.getPush();
    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }
    const pushRemote = this.props.remotes.withName(push.getRemoteName());
    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/currentPullRequestContainerQuery.graphql');

      if (node.hash && node.hash !== 'ade50c0777277f2032b27dfced670a2d') {
        console.error('The definition of \'currentPullRequestContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/currentPullRequestContainerQuery.graphql');
    });
    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());

    return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({ isLoading: false }, this.controllerProps()));
  }

  renderQueryResult({ error, props, retry }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({ isLoading: false }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;

    return _react2.default.createElement(_issueishListController2.default, _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react2.default.createElement(_createPullRequestTile2.default, {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      emptyComponent: this.renderEmptyTile
    };
  }
}
exports.default = CurrentPullRequestContainer;
CurrentPullRequestContainer.propTypes = {
  // Relay payload
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }).isRequired,

  // Connection
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Search constraints
  limit: _propTypes2.default.number,

  // Repository model attributes
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  // Actions
  onOpenIssueish: _propTypes2.default.func.isRequired,
  onCreatePr: _propTypes2.default.func.isRequired
};
CurrentPullRequestContainer.defaultProps = {
  limit: 5
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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