'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _os = require('os');

var _os2 = _interopRequireDefault(_os);

var _helpers = require('./helpers');

var _asyncQueue = require('./async-queue');

var _asyncQueue2 = _interopRequireDefault(_asyncQueue);

var _gitShellOutStrategy = require('./git-shell-out-strategy');

var _gitShellOutStrategy2 = _interopRequireDefault(_gitShellOutStrategy);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  create(workingDir, options = {}) {
    return this.withStrategies([_gitShellOutStrategy2.default])(workingDir, options);
  },

  withStrategies(strategies) {
    return function createForStrategies(workingDir, options = {}) {
      const parallelism = options.parallelism || Math.max(3, _os2.default.cpus().length);
      const commandQueue = new _asyncQueue2.default({ parallelism });
      const strategyOptions = _extends({}, options, { queue: commandQueue });

      const strategyInstances = strategies.map(Strategy => new Strategy(workingDir, strategyOptions));
      return (0, _helpers.firstImplementer)(...strategyInstances);
    };
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbXBvc2l0ZS1naXQtc3RyYXRlZ3kuanMiXSwibmFtZXMiOlsiY3JlYXRlIiwid29ya2luZ0RpciIsIm9wdGlvbnMiLCJ3aXRoU3RyYXRlZ2llcyIsIkdpdFNoZWxsT3V0U3RyYXRlZ3kiLCJzdHJhdGVnaWVzIiwiY3JlYXRlRm9yU3RyYXRlZ2llcyIsInBhcmFsbGVsaXNtIiwiTWF0aCIsIm1heCIsIm9zIiwiY3B1cyIsImxlbmd0aCIsImNvbW1hbmRRdWV1ZSIsIkFzeW5jUXVldWUiLCJzdHJhdGVneU9wdGlvbnMiLCJxdWV1ZSIsInN0cmF0ZWd5SW5zdGFuY2VzIiwibWFwIiwiU3RyYXRlZ3kiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUE7Ozs7QUFFQTs7QUFDQTs7OztBQUNBOzs7Ozs7a0JBRWU7QUFDYkEsU0FBT0MsVUFBUCxFQUFtQkMsVUFBVSxFQUE3QixFQUFpQztBQUMvQixXQUFPLEtBQUtDLGNBQUwsQ0FBb0IsQ0FBQ0MsNkJBQUQsQ0FBcEIsRUFBMkNILFVBQTNDLEVBQXVEQyxPQUF2RCxDQUFQO0FBQ0QsR0FIWTs7QUFLYkMsaUJBQWVFLFVBQWYsRUFBMkI7QUFDekIsV0FBTyxTQUFTQyxtQkFBVCxDQUE2QkwsVUFBN0IsRUFBeUNDLFVBQVUsRUFBbkQsRUFBdUQ7QUFDNUQsWUFBTUssY0FBY0wsUUFBUUssV0FBUixJQUF1QkMsS0FBS0MsR0FBTCxDQUFTLENBQVQsRUFBWUMsYUFBR0MsSUFBSCxHQUFVQyxNQUF0QixDQUEzQztBQUNBLFlBQU1DLGVBQWUsSUFBSUMsb0JBQUosQ0FBZSxFQUFDUCxXQUFELEVBQWYsQ0FBckI7QUFDQSxZQUFNUSwrQkFBc0JiLE9BQXRCLElBQStCYyxPQUFPSCxZQUF0QyxHQUFOOztBQUVBLFlBQU1JLG9CQUFvQlosV0FBV2EsR0FBWCxDQUFlQyxZQUFZLElBQUlBLFFBQUosQ0FBYWxCLFVBQWIsRUFBeUJjLGVBQXpCLENBQTNCLENBQTFCO0FBQ0EsYUFBTywrQkFBaUIsR0FBR0UsaUJBQXBCLENBQVA7QUFDRCxLQVBEO0FBUUQ7QUFkWSxDIiwiZmlsZSI6ImNvbXBvc2l0ZS1naXQtc3RyYXRlZ3kuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgb3MgZnJvbSAnb3MnO1xuXG5pbXBvcnQge2ZpcnN0SW1wbGVtZW50ZXJ9IGZyb20gJy4vaGVscGVycyc7XG5pbXBvcnQgQXN5bmNRdWV1ZSBmcm9tICcuL2FzeW5jLXF1ZXVlJztcbmltcG9ydCBHaXRTaGVsbE91dFN0cmF0ZWd5IGZyb20gJy4vZ2l0LXNoZWxsLW91dC1zdHJhdGVneSc7XG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgY3JlYXRlKHdvcmtpbmdEaXIsIG9wdGlvbnMgPSB7fSkge1xuICAgIHJldHVybiB0aGlzLndpdGhTdHJhdGVnaWVzKFtHaXRTaGVsbE91dFN0cmF0ZWd5XSkod29ya2luZ0Rpciwgb3B0aW9ucyk7XG4gIH0sXG5cbiAgd2l0aFN0cmF0ZWdpZXMoc3RyYXRlZ2llcykge1xuICAgIHJldHVybiBmdW5jdGlvbiBjcmVhdGVGb3JTdHJhdGVnaWVzKHdvcmtpbmdEaXIsIG9wdGlvbnMgPSB7fSkge1xuICAgICAgY29uc3QgcGFyYWxsZWxpc20gPSBvcHRpb25zLnBhcmFsbGVsaXNtIHx8IE1hdGgubWF4KDMsIG9zLmNwdXMoKS5sZW5ndGgpO1xuICAgICAgY29uc3QgY29tbWFuZFF1ZXVlID0gbmV3IEFzeW5jUXVldWUoe3BhcmFsbGVsaXNtfSk7XG4gICAgICBjb25zdCBzdHJhdGVneU9wdGlvbnMgPSB7Li4ub3B0aW9ucywgcXVldWU6IGNvbW1hbmRRdWV1ZX07XG5cbiAgICAgIGNvbnN0IHN0cmF0ZWd5SW5zdGFuY2VzID0gc3RyYXRlZ2llcy5tYXAoU3RyYXRlZ3kgPT4gbmV3IFN0cmF0ZWd5KHdvcmtpbmdEaXIsIHN0cmF0ZWd5T3B0aW9ucykpO1xuICAgICAgcmV0dXJuIGZpcnN0SW1wbGVtZW50ZXIoLi4uc3RyYXRlZ3lJbnN0YW5jZXMpO1xuICAgIH07XG4gIH0sXG59O1xuIl19