Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var REBUILDING = 'rebuilding';
var REBUILD_FAILED = 'rebuild-failed';
var REBUILD_SUCCEEDED = 'rebuild-succeeded';

var IncompatiblePackagesComponent = (function () {
  function IncompatiblePackagesComponent(packageManager) {
    var _this = this;

    _classCallCheck(this, IncompatiblePackagesComponent);

    this.rebuildStatuses = new Map();
    this.rebuildFailureOutputs = new Map();
    this.rebuildInProgress = false;
    this.rebuiltPackageCount = 0;
    this.packageManager = packageManager;
    this.loaded = false;
    _etch2['default'].initialize(this);

    if (this.packageManager.getActivePackages().length > 0) {
      this.populateIncompatiblePackages();
    } else {
      global.setImmediate(this.populateIncompatiblePackages.bind(this));
    }

    this.element.addEventListener('click', function (event) {
      if (event.target === _this.refs.rebuildButton) {
        _this.rebuildIncompatiblePackages();
      } else if (event.target === _this.refs.reloadButton) {
        atom.reload();
      } else if (event.target.classList.contains('view-settings')) {
        atom.workspace.open('atom://config/packages/' + event.target['package'].name);
      }
    });
  }

  _createClass(IncompatiblePackagesComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      if (!this.loaded) {
        return _etch2['default'].dom(
          'div',
          { className: 'incompatible-packages padded' },
          'Loading...'
        );
      }

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-packages padded native-key-bindings', tabIndex: '-1' },
        this.renderHeading(),
        this.renderIncompatiblePackageList()
      );
    }
  }, {
    key: 'renderHeading',
    value: function renderHeading() {
      if (this.incompatiblePackages.length > 0) {
        if (this.rebuiltPackageCount > 0) {
          var alertClass = this.rebuiltPackageCount === this.incompatiblePackages.length ? 'alert-success icon-check' : 'alert-warning icon-bug';

          return _etch2['default'].dom(
            'div',
            { className: 'alert icon ' + alertClass },
            this.rebuiltPackageCount,
            ' of ',
            this.incompatiblePackages.length,
            ' packages were rebuilt successfully. Reload Atom to activate them.',
            _etch2['default'].dom(
              'button',
              { ref: 'reloadButton', className: 'btn pull-right' },
              'Reload Atom'
            )
          );
        } else {
          return _etch2['default'].dom(
            'div',
            { className: 'alert alert-danger icon icon-bug' },
            'Some installed packages could not be loaded because they contain native modules that were compiled for an earlier version of Atom.',
            _etch2['default'].dom(
              'button',
              { ref: 'rebuildButton', className: 'btn pull-right', disabled: this.rebuildInProgress },
              'Rebuild Packages'
            )
          );
        }
      } else {
        return _etch2['default'].dom(
          'div',
          { className: 'alert alert-success icon icon-check' },
          'None of your packages contain incompatible native modules.'
        );
      }
    }
  }, {
    key: 'renderIncompatiblePackageList',
    value: function renderIncompatiblePackageList() {
      return _etch2['default'].dom(
        'div',
        null,
        this.incompatiblePackages.map(this.renderIncompatiblePackage.bind(this))
      );
    }
  }, {
    key: 'renderIncompatiblePackage',
    value: function renderIncompatiblePackage(pack) {
      var rebuildStatus = this.rebuildStatuses.get(pack);

      return _etch2['default'].dom(
        'div',
        { className: 'incompatible-package' },
        this.renderRebuildStatusIndicator(rebuildStatus),
        _etch2['default'].dom(
          'button',
          { className: 'btn view-settings icon icon-gear pull-right', 'package': pack },
          'Package Settings'
        ),
        _etch2['default'].dom(
          'h4',
          { className: 'heading' },
          pack.name,
          ' ',
          pack.metadata.version
        ),
        rebuildStatus ? this.renderRebuildOutput(pack) : this.renderIncompatibleModules(pack)
      );
    }
  }, {
    key: 'renderRebuildStatusIndicator',
    value: function renderRebuildStatusIndicator(rebuildStatus) {
      if (rebuildStatus === REBUILDING) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-info pull-right icon icon-gear' },
          'Rebuilding'
        );
      } else if (rebuildStatus === REBUILD_SUCCEEDED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-success pull-right icon icon-check' },
          'Rebuild Succeeded'
        );
      } else if (rebuildStatus === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'div',
          { className: 'badge badge-error pull-right icon icon-x' },
          'Rebuild Failed'
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderRebuildOutput',
    value: function renderRebuildOutput(pack) {
      if (this.rebuildStatuses.get(pack) === REBUILD_FAILED) {
        return _etch2['default'].dom(
          'pre',
          null,
          this.rebuildFailureOutputs.get(pack)
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIncompatibleModules',
    value: function renderIncompatibleModules(pack) {
      return _etch2['default'].dom(
        'ul',
        null,
        pack.incompatibleModules.map(function (nativeModule) {
          return _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom(
              'div',
              { className: 'icon icon-file-binary' },
              nativeModule.name,
              '@',
              nativeModule.version || 'unknown',
              ' – ',
              _etch2['default'].dom(
                'span',
                { className: 'text-warning' },
                nativeModule.error
              )
            )
          );
        })
      );
    }
  }, {
    key: 'populateIncompatiblePackages',
    value: function populateIncompatiblePackages() {
      this.incompatiblePackages = this.packageManager.getLoadedPackages().filter(function (pack) {
        return !pack.isCompatible();
      });

      for (var pack of this.incompatiblePackages) {
        var buildFailureOutput = pack.getBuildFailureOutput();
        if (buildFailureOutput) {
          this.setPackageStatus(pack, REBUILD_FAILED);
          this.setRebuildFailureOutput(pack, buildFailureOutput);
        }
      }

      this.loaded = true;
      _etch2['default'].update(this);
    }
  }, {
    key: 'rebuildIncompatiblePackages',
    value: _asyncToGenerator(function* () {
      this.rebuildInProgress = true;
      var rebuiltPackageCount = 0;
      for (var pack of this.incompatiblePackages) {
        this.setPackageStatus(pack, REBUILDING);

        var _ref = yield pack.rebuild();

        var code = _ref.code;
        var stderr = _ref.stderr;

        if (code === 0) {
          this.setPackageStatus(pack, REBUILD_SUCCEEDED);
          rebuiltPackageCount++;
        } else {
          this.setRebuildFailureOutput(pack, stderr);
          this.setPackageStatus(pack, REBUILD_FAILED);
        }
      }
      this.rebuildInProgress = false;
      this.rebuiltPackageCount = rebuiltPackageCount;
      _etch2['default'].update(this);
    })
  }, {
    key: 'setPackageStatus',
    value: function setPackageStatus(pack, status) {
      this.rebuildStatuses.set(pack, status);
      _etch2['default'].update(this);
    }
  }, {
    key: 'setRebuildFailureOutput',
    value: function setRebuildFailureOutput(pack, output) {
      this.rebuildFailureOutputs.set(pack, output);
      _etch2['default'].update(this);
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Incompatible Packages';
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return _viewUri2['default'];
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'package';
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return { deserializer: 'IncompatiblePackagesComponent' };
    }
  }]);

  return IncompatiblePackagesComponent;
})();

exports['default'] = IncompatiblePackagesComponent;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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