Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _atom = require('atom');

'use babel';

var GoToLineView = (function () {
  function GoToLineView() {
    var _this = this;

    _classCallCheck(this, GoToLineView);

    this.miniEditor = new _atom.TextEditor({ mini: true });
    this.miniEditor.element.addEventListener('blur', this.close.bind(this));

    this.message = document.createElement('div');
    this.message.classList.add('message');

    this.element = document.createElement('div');
    this.element.classList.add('go-to-line');
    this.element.appendChild(this.miniEditor.element);
    this.element.appendChild(this.message);

    this.panel = atom.workspace.addModalPanel({
      item: this,
      visible: false
    });
    atom.commands.add('atom-text-editor', 'go-to-line:toggle', function () {
      _this.toggle();
      return false;
    });
    atom.commands.add(this.miniEditor.element, 'core:confirm', function () {
      _this.navigate();
    });
    atom.commands.add(this.miniEditor.element, 'core:cancel', function () {
      _this.close();
    });
    this.miniEditor.onWillInsertText(function (arg) {
      if (arg.text.match(/[^0-9:]/)) {
        arg.cancel();
      }
    });
    this.miniEditor.onDidChange(function () {
      _this.navigate({ keepOpen: true });
    });
  }

  _createClass(GoToLineView, [{
    key: 'toggle',
    value: function toggle() {
      this.panel.isVisible() ? this.close() : this.open();
    }
  }, {
    key: 'close',
    value: function close() {
      if (!this.panel.isVisible()) return;
      this.miniEditor.setText('');
      this.panel.hide();
      if (this.miniEditor.element.hasFocus()) {
        this.restoreFocus();
      }
    }
  }, {
    key: 'navigate',
    value: function navigate() {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var lineNumber = this.miniEditor.getText();
      var editor = atom.workspace.getActiveTextEditor();
      if (!options.keepOpen) {
        this.close();
      }
      if (!editor || !lineNumber.length) return;

      var currentRow = editor.getCursorBufferPosition().row;
      var rowLineNumber = lineNumber.split(/:+/)[0] || '';
      var row = rowLineNumber.length > 0 ? parseInt(rowLineNumber) - 1 : currentRow;
      var columnLineNumber = lineNumber.split(/:+/)[1] || '';
      var column = columnLineNumber.length > 0 ? parseInt(columnLineNumber) - 1 : -1;

      var position = new _atom.Point(row, column);
      editor.setCursorBufferPosition(position);
      editor.unfoldBufferRow(row);
      if (column < 0) {
        editor.moveToFirstCharacterOfLine();
      }
      editor.scrollToBufferPosition(position, {
        center: true
      });
    }
  }, {
    key: 'storeFocusedElement',
    value: function storeFocusedElement() {
      this.previouslyFocusedElement = document.activeElement;
      return this.previouslyFocusedElement;
    }
  }, {
    key: 'restoreFocus',
    value: function restoreFocus() {
      if (this.previouslyFocusedElement && this.previouslyFocusedElement.parentElement) {
        return this.previouslyFocusedElement.focus();
      }
      atom.views.getView(atom.workspace).focus();
    }
  }, {
    key: 'open',
    value: function open() {
      if (this.panel.isVisible() || !atom.workspace.getActiveTextEditor()) return;
      this.storeFocusedElement();
      this.panel.show();
      this.message.textContent = 'Enter a <row> or <row>:<column> to go there. Examples: "3" for row 3 or "2:7" for row 2 and column 7';
      this.miniEditor.element.focus();
    }
  }]);

  return GoToLineView;
})();

exports['default'] = {
  activate: function activate() {
    return new GoToLineView();
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzUuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9nby10by1saW5lL2xpYi9nby10by1saW5lLXZpZXcuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7b0JBRWtDLE1BQU07O0FBRnhDLFdBQVcsQ0FBQTs7SUFJTCxZQUFZO0FBQ0osV0FEUixZQUFZLEdBQ0Q7OzswQkFEWCxZQUFZOztBQUVkLFFBQUksQ0FBQyxVQUFVLEdBQUcscUJBQWUsRUFBRSxJQUFJLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQTtBQUNoRCxRQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTs7QUFFdkUsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQzVDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxTQUFTLENBQUMsQ0FBQTs7QUFFckMsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFBO0FBQzVDLFFBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxZQUFZLENBQUMsQ0FBQTtBQUN4QyxRQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFBO0FBQ2pELFFBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQTs7QUFFdEMsUUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztBQUN4QyxVQUFJLEVBQUUsSUFBSTtBQUNWLGFBQU8sRUFBRSxLQUFLO0tBQ2YsQ0FBQyxDQUFBO0FBQ0YsUUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLEVBQUUsbUJBQW1CLEVBQUUsWUFBTTtBQUMvRCxZQUFLLE1BQU0sRUFBRSxDQUFBO0FBQ2IsYUFBTyxLQUFLLENBQUE7S0FDYixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxjQUFjLEVBQUUsWUFBTTtBQUMvRCxZQUFLLFFBQVEsRUFBRSxDQUFBO0tBQ2hCLENBQUMsQ0FBQTtBQUNGLFFBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxFQUFFLGFBQWEsRUFBRSxZQUFNO0FBQzlELFlBQUssS0FBSyxFQUFFLENBQUE7S0FDYixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLFVBQUMsR0FBRyxFQUFLO0FBQ3hDLFVBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLEVBQUU7QUFDN0IsV0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFBO09BQ2I7S0FDRixDQUFDLENBQUE7QUFDRixRQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxZQUFNO0FBQ2hDLFlBQUssUUFBUSxDQUFDLEVBQUMsUUFBUSxFQUFFLElBQUksRUFBQyxDQUFDLENBQUE7S0FDaEMsQ0FBQyxDQUFBO0dBQ0g7O2VBbkNHLFlBQVk7O1dBcUNULGtCQUFHO0FBQ1IsVUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLEVBQUUsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFBO0tBQ3BEOzs7V0FFSyxpQkFBRztBQUNQLFVBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsRUFBRSxFQUFFLE9BQU07QUFDbkMsVUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUE7QUFDM0IsVUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUNqQixVQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxFQUFFO0FBQ3RDLFlBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQTtPQUNwQjtLQUNGOzs7V0FFUSxvQkFBZTtVQUFkLE9BQU8seURBQUcsRUFBRTs7QUFDcEIsVUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUM1QyxVQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDbkQsVUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUU7QUFDckIsWUFBSSxDQUFDLEtBQUssRUFBRSxDQUFBO09BQ2I7QUFDRCxVQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sRUFBRSxPQUFNOztBQUV6QyxVQUFNLFVBQVUsR0FBRyxNQUFNLENBQUMsdUJBQXVCLEVBQUUsQ0FBQyxHQUFHLENBQUE7QUFDdkQsVUFBTSxhQUFhLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUE7QUFDckQsVUFBTSxHQUFHLEdBQUcsYUFBYSxDQUFDLE1BQU0sR0FBRyxDQUFDLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsR0FBRyxVQUFVLENBQUE7QUFDL0UsVUFBTSxnQkFBZ0IsR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQTtBQUN4RCxVQUFNLE1BQU0sR0FBRyxnQkFBZ0IsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQTs7QUFFaEYsVUFBTSxRQUFRLEdBQUcsZ0JBQVUsR0FBRyxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQ3ZDLFlBQU0sQ0FBQyx1QkFBdUIsQ0FBQyxRQUFRLENBQUMsQ0FBQTtBQUN4QyxZQUFNLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFBO0FBQzNCLFVBQUksTUFBTSxHQUFHLENBQUMsRUFBRTtBQUNkLGNBQU0sQ0FBQywwQkFBMEIsRUFBRSxDQUFBO09BQ3BDO0FBQ0QsWUFBTSxDQUFDLHNCQUFzQixDQUFDLFFBQVEsRUFBRTtBQUN0QyxjQUFNLEVBQUUsSUFBSTtPQUNiLENBQUMsQ0FBQTtLQUNIOzs7V0FFbUIsK0JBQUc7QUFDckIsVUFBSSxDQUFDLHdCQUF3QixHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUE7QUFDdEQsYUFBTyxJQUFJLENBQUMsd0JBQXdCLENBQUE7S0FDckM7OztXQUVZLHdCQUFHO0FBQ2QsVUFBSSxJQUFJLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLHdCQUF3QixDQUFDLGFBQWEsRUFBRTtBQUNoRixlQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtPQUM3QztBQUNELFVBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtLQUMzQzs7O1dBRUksZ0JBQUc7QUFDTixVQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLEVBQUUsT0FBTTtBQUMzRSxVQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtBQUMxQixVQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFBO0FBQ2pCLFVBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxHQUFHLHNHQUFzRyxDQUFBO0FBQ2pJLFVBQUksQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFBO0tBQ2hDOzs7U0E3RkcsWUFBWTs7O3FCQWdHSDtBQUNiLFVBQVEsRUFBQyxvQkFBRztBQUNWLFdBQU8sSUFBSSxZQUFZLEVBQUUsQ0FBQTtHQUMxQjtDQUNGIiwiZmlsZSI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzUuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9nby10by1saW5lL2xpYi9nby10by1saW5lLXZpZXcuanMiLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIGJhYmVsJ1xuXG5pbXBvcnQgeyBQb2ludCwgVGV4dEVkaXRvciB9IGZyb20gJ2F0b20nXG5cbmNsYXNzIEdvVG9MaW5lVmlldyB7XG4gIGNvbnN0cnVjdG9yICgpIHtcbiAgICB0aGlzLm1pbmlFZGl0b3IgPSBuZXcgVGV4dEVkaXRvcih7IG1pbmk6IHRydWUgfSlcbiAgICB0aGlzLm1pbmlFZGl0b3IuZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKCdibHVyJywgdGhpcy5jbG9zZS5iaW5kKHRoaXMpKVxuXG4gICAgdGhpcy5tZXNzYWdlID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZGl2JylcbiAgICB0aGlzLm1lc3NhZ2UuY2xhc3NMaXN0LmFkZCgnbWVzc2FnZScpXG5cbiAgICB0aGlzLmVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKVxuICAgIHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdnby10by1saW5lJylcbiAgICB0aGlzLmVsZW1lbnQuYXBwZW5kQ2hpbGQodGhpcy5taW5pRWRpdG9yLmVsZW1lbnQpXG4gICAgdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKHRoaXMubWVzc2FnZSlcblxuICAgIHRoaXMucGFuZWwgPSBhdG9tLndvcmtzcGFjZS5hZGRNb2RhbFBhbmVsKHtcbiAgICAgIGl0ZW06IHRoaXMsXG4gICAgICB2aXNpYmxlOiBmYWxzZVxuICAgIH0pXG4gICAgYXRvbS5jb21tYW5kcy5hZGQoJ2F0b20tdGV4dC1lZGl0b3InLCAnZ28tdG8tbGluZTp0b2dnbGUnLCAoKSA9PiB7XG4gICAgICB0aGlzLnRvZ2dsZSgpXG4gICAgICByZXR1cm4gZmFsc2VcbiAgICB9KVxuICAgIGF0b20uY29tbWFuZHMuYWRkKHRoaXMubWluaUVkaXRvci5lbGVtZW50LCAnY29yZTpjb25maXJtJywgKCkgPT4ge1xuICAgICAgdGhpcy5uYXZpZ2F0ZSgpXG4gICAgfSlcbiAgICBhdG9tLmNvbW1hbmRzLmFkZCh0aGlzLm1pbmlFZGl0b3IuZWxlbWVudCwgJ2NvcmU6Y2FuY2VsJywgKCkgPT4ge1xuICAgICAgdGhpcy5jbG9zZSgpXG4gICAgfSlcbiAgICB0aGlzLm1pbmlFZGl0b3Iub25XaWxsSW5zZXJ0VGV4dCgoYXJnKSA9PiB7XG4gICAgICBpZiAoYXJnLnRleHQubWF0Y2goL1teMC05Ol0vKSkge1xuICAgICAgICBhcmcuY2FuY2VsKClcbiAgICAgIH1cbiAgICB9KVxuICAgIHRoaXMubWluaUVkaXRvci5vbkRpZENoYW5nZSgoKSA9PiB7XG4gICAgICB0aGlzLm5hdmlnYXRlKHtrZWVwT3BlbjogdHJ1ZX0pXG4gICAgfSlcbiAgfVxuXG4gIHRvZ2dsZSAoKSB7XG4gICAgdGhpcy5wYW5lbC5pc1Zpc2libGUoKSA/IHRoaXMuY2xvc2UoKSA6IHRoaXMub3BlbigpXG4gIH1cblxuICBjbG9zZSAoKSB7XG4gICAgaWYgKCF0aGlzLnBhbmVsLmlzVmlzaWJsZSgpKSByZXR1cm5cbiAgICB0aGlzLm1pbmlFZGl0b3Iuc2V0VGV4dCgnJylcbiAgICB0aGlzLnBhbmVsLmhpZGUoKVxuICAgIGlmICh0aGlzLm1pbmlFZGl0b3IuZWxlbWVudC5oYXNGb2N1cygpKSB7XG4gICAgICB0aGlzLnJlc3RvcmVGb2N1cygpXG4gICAgfVxuICB9XG5cbiAgbmF2aWdhdGUgKG9wdGlvbnMgPSB7fSkge1xuICAgIGNvbnN0IGxpbmVOdW1iZXIgPSB0aGlzLm1pbmlFZGl0b3IuZ2V0VGV4dCgpXG4gICAgY29uc3QgZWRpdG9yID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpXG4gICAgaWYgKCFvcHRpb25zLmtlZXBPcGVuKSB7XG4gICAgICB0aGlzLmNsb3NlKClcbiAgICB9XG4gICAgaWYgKCFlZGl0b3IgfHwgIWxpbmVOdW1iZXIubGVuZ3RoKSByZXR1cm5cblxuICAgIGNvbnN0IGN1cnJlbnRSb3cgPSBlZGl0b3IuZ2V0Q3Vyc29yQnVmZmVyUG9zaXRpb24oKS5yb3dcbiAgICBjb25zdCByb3dMaW5lTnVtYmVyID0gbGluZU51bWJlci5zcGxpdCgvOisvKVswXSB8fCAnJ1xuICAgIGNvbnN0IHJvdyA9IHJvd0xpbmVOdW1iZXIubGVuZ3RoID4gMCA/IHBhcnNlSW50KHJvd0xpbmVOdW1iZXIpIC0gMSA6IGN1cnJlbnRSb3dcbiAgICBjb25zdCBjb2x1bW5MaW5lTnVtYmVyID0gbGluZU51bWJlci5zcGxpdCgvOisvKVsxXSB8fCAnJ1xuICAgIGNvbnN0IGNvbHVtbiA9IGNvbHVtbkxpbmVOdW1iZXIubGVuZ3RoID4gMCA/IHBhcnNlSW50KGNvbHVtbkxpbmVOdW1iZXIpIC0gMSA6IC0xXG5cbiAgICBjb25zdCBwb3NpdGlvbiA9IG5ldyBQb2ludChyb3csIGNvbHVtbilcbiAgICBlZGl0b3Iuc2V0Q3Vyc29yQnVmZmVyUG9zaXRpb24ocG9zaXRpb24pXG4gICAgZWRpdG9yLnVuZm9sZEJ1ZmZlclJvdyhyb3cpXG4gICAgaWYgKGNvbHVtbiA8IDApIHtcbiAgICAgIGVkaXRvci5tb3ZlVG9GaXJzdENoYXJhY3Rlck9mTGluZSgpXG4gICAgfVxuICAgIGVkaXRvci5zY3JvbGxUb0J1ZmZlclBvc2l0aW9uKHBvc2l0aW9uLCB7XG4gICAgICBjZW50ZXI6IHRydWVcbiAgICB9KVxuICB9XG5cbiAgc3RvcmVGb2N1c2VkRWxlbWVudCAoKSB7XG4gICAgdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQgPSBkb2N1bWVudC5hY3RpdmVFbGVtZW50XG4gICAgcmV0dXJuIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50XG4gIH1cblxuICByZXN0b3JlRm9jdXMgKCkge1xuICAgIGlmICh0aGlzLnByZXZpb3VzbHlGb2N1c2VkRWxlbWVudCAmJiB0aGlzLnByZXZpb3VzbHlGb2N1c2VkRWxlbWVudC5wYXJlbnRFbGVtZW50KSB7XG4gICAgICByZXR1cm4gdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQuZm9jdXMoKVxuICAgIH1cbiAgICBhdG9tLnZpZXdzLmdldFZpZXcoYXRvbS53b3Jrc3BhY2UpLmZvY3VzKClcbiAgfVxuXG4gIG9wZW4gKCkge1xuICAgIGlmICh0aGlzLnBhbmVsLmlzVmlzaWJsZSgpIHx8ICFhdG9tLndvcmtzcGFjZS5nZXRBY3RpdmVUZXh0RWRpdG9yKCkpIHJldHVyblxuICAgIHRoaXMuc3RvcmVGb2N1c2VkRWxlbWVudCgpXG4gICAgdGhpcy5wYW5lbC5zaG93KClcbiAgICB0aGlzLm1lc3NhZ2UudGV4dENvbnRlbnQgPSAnRW50ZXIgYSA8cm93PiBvciA8cm93Pjo8Y29sdW1uPiB0byBnbyB0aGVyZS4gRXhhbXBsZXM6IFwiM1wiIGZvciByb3cgMyBvciBcIjI6N1wiIGZvciByb3cgMiBhbmQgY29sdW1uIDcnXG4gICAgdGhpcy5taW5pRWRpdG9yLmVsZW1lbnQuZm9jdXMoKVxuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgYWN0aXZhdGUgKCkge1xuICAgIHJldHVybiBuZXcgR29Ub0xpbmVWaWV3KClcbiAgfVxufVxuIl19