'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCrossReferencedEventView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _issueishBadge = require('../../views/issueish-badge');

var _issueishBadge2 = _interopRequireDefault(_issueishBadge);

var _issueishLink = require('../../views/issueish-link');

var _issueishLink2 = _interopRequireDefault(_issueishLink);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCrossReferencedEventView extends _react2.default.Component {

  render() {
    const xref = this.props.item;
    const repo = xref.source.repository;
    const repoLabel = `${repo.owner.login}/${repo.name}`;
    return _react2.default.createElement(
      'div',
      { className: 'cross-referenced-event' },
      _react2.default.createElement(
        'div',
        { className: 'cross-referenced-event-label' },
        _react2.default.createElement(
          'span',
          { className: 'cross-referenced-event-label-title' },
          xref.source.title
        ),
        _react2.default.createElement(
          _issueishLink2.default,
          { url: xref.source.url, className: 'cross-referenced-event-label-number' },
          this.getIssueishNumberDisplay(xref)
        )
      ),
      repo.isPrivate ? _react2.default.createElement(
        'div',
        { className: 'cross-referenced-event-private' },
        _react2.default.createElement(_octicon2.default, { icon: 'lock', title: `Only people who can see ${repoLabel} will see this reference.` })
      ) : '',
      _react2.default.createElement(
        'div',
        { className: 'cross-referenced-event-state' },
        _react2.default.createElement(_issueishBadge2.default, { type: xref.source.__typename, state: xref.source.issueState || xref.source.prState })
      )
    );
  }

  getIssueishNumberDisplay(xref) {
    const { source } = xref;
    if (!xref.isCrossRepository) {
      return `#${source.number}`;
    } else {
      const { repository } = source;
      return `${repository.owner.login}/${repository.name}#${source.number}`;
    }
  }

}

exports.BareCrossReferencedEventView = BareCrossReferencedEventView;
BareCrossReferencedEventView.propTypes = {
  item: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    isCrossRepository: _propTypes2.default.bool.isRequired,
    source: _propTypes2.default.shape({
      __typename: _propTypes2.default.oneOf(['Issue', 'PullRequest']).isRequired,
      number: _propTypes2.default.number.isRequired,
      title: _propTypes2.default.string.isRequired,
      url: _propTypes2.default.string.isRequired,
      issueState: _propTypes2.default.oneOf(['OPEN', 'CLOSED']),
      prState: _propTypes2.default.oneOf(['OPEN', 'CLOSED', 'MERGED']),
      repository: _propTypes2.default.shape({
        name: _propTypes2.default.string.isRequired,
        isPrivate: _propTypes2.default.bool.isRequired,
        owner: _propTypes2.default.shape({
          login: _propTypes2.default.string.isRequired
        }).isRequired
      }).isRequired
    }).isRequired
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCrossReferencedEventView, {
  item: function () {
    const node = require('./__generated__/crossReferencedEventView_item.graphql');

    if (node.hash && node.hash !== 'b90b8c9f0acee56516e7413263cf7f51') {
      console.error('The definition of \'crossReferencedEventView_item\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/crossReferencedEventView_item.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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