'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BareCommitsView = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

var _commitView = require('./commit-view');

var _commitView2 = _interopRequireDefault(_commitView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class BareCommitsView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'timeline-item commits' },
      this.renderSummary(),
      this.renderCommits()
    );
  }

  renderSummary() {
    if (this.props.nodes.length > 1) {
      const namesString = this.calculateNames(this.props.nodes);
      return _react2.default.createElement(
        'div',
        { className: 'info-row' },
        _react2.default.createElement(_octicon2.default, { className: 'pre-timeline-item-icon', icon: 'repo-push' }),
        _react2.default.createElement(
          'span',
          { className: 'comment-message-header' },
          namesString,
          ' added some commits...'
        )
      );
    } else {
      return null;
    }
  }

  renderCommits() {
    return this.props.nodes.map(node => {
      return _react2.default.createElement(_commitView2.default, { key: node.id,
        commit: node,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

  calculateNames(commits) {
    let names = new Set();
    commits.forEach(commit => {
      let name = null;
      if (commit.author.user) {
        name = commit.author.user.login;
      } else if (commit.author.name) {
        name = commit.author.name;
      }

      if (name && !names.has(name)) {
        names.add(name);
      }
    });

    names = Array.from(names);
    if (names.length === 1) {
      return names[0];
    } else if (names.length === 2) {
      return `${names[0]} and ${names[1]}`;
    } else if (names.length > 2) {
      return `${names[0]}, ${names[1]}, and others`;
    } else {
      return 'Someone';
    }
  }
}

exports.BareCommitsView = BareCommitsView;
BareCommitsView.propTypes = {
  nodes: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    author: _propTypes2.default.shape({
      name: _propTypes2.default.string,
      user: _propTypes2.default.shape({
        login: _propTypes2.default.string.isRequired
      })
    }).isRequired
  }).isRequired).isRequired,
  onBranch: _propTypes2.default.bool.isRequired,
  openCommit: _propTypes2.default.func.isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(BareCommitsView, {
  nodes: function () {
    const node = require('./__generated__/commitsView_nodes.graphql');

    if (node.hash && node.hash !== 'e01f34cd74aa6d007049d5b421abe1ec') {
      console.error('The definition of \'commitsView_nodes\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/commitsView_nodes.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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